﻿#Requires -RunAsAdministrator

# Gibt es ein Laufwerk (PSDrive) zum Zugriff auf HKCR?
if(-not (Get-PSDrive HKCR -ErrorAction SilentlyContinue)) {
  # Wenn nicht, anlegen.
  New-PSDrive -Name HKCR -PSProvider Registry -Root HKEY_CLASSES_ROOT | Out-Null
}

# Alle Schlüssel ohne Einträge mit Namen nach dem Muster HKCR\.xyz\ShellNew ...
$keys = Get-Item HKCR:\.*\ShellNew | ? ValueCount -EQ 0
# ... und HKCR\.xyz\Irgendwas\ShellNew
$keys += Get-Item HKCR:\.*\*\ShellNew | ? ValueCount -EQ 0
if($keys.Count -ne 0) {
  "{0} überflüssige ShellNew-Schlüssel werden entfernt ..." -f $keys.Count
  $keys | % { Remove-Item $_.PSPath }
}
"Erledigt."
