#!/usr/bin/perl -wT

use CGI qw(:standard);

########
# CGI.pm in der einfachsten Version benutzen
# Parameter in das Array @field; letztes Element ist gedrueckter Button
########

$field[0] = param('name');
$field[1] = param('vorname');
$field[2] = param('adresse');
$field[3] = param('plz');
$field[4] = param('stadt');
$field[5] = param('telefon');
$field[6] = param('fax');
$field[7] = param('mobil');
$field[8] = param('email');
$field[9] = param('url');

if(param('add'))
{
  $field[10] = param('add');
}
elsif(param('search'))
{
  $field[10] = param('search');
}
elsif(param('all'))
{
  $field[10] = param('all');
}

#####
# "hinzufuegen" gedrueckt? Leere Felder durch "keine Angabe" ersetzen,
# letztes Element der Liste ("hinzufuegen") abtrennen.
# Als Trenner ;; verwenden; ist beliebig, muss aber eindeutig sein.
# Datei zum Anhaengen oeffnen, neuen Eintrag mit Newline hinzufuegen.
# Datei zu. Eintrag an Unterfunktion add_webpage() geben.
#####

if(param('add'))
{
  foreach(@field)
  {
    if ($_ eq "")
    {
      $_ = "keine Angabe";
    }
  }

  pop @field;
  $newentry = join(';;', @field);
  open (DATEI, ">>/tmp/adressen.txt") || die "Die Datei konnte nicht geffnet werden\n";
  print DATEI "$newentry\n";
  close DATEI;
  add_webpage(@field);
}

###########
# Alle Eintraege anzeigen?
# Datei zum Lesen oeffnen, als Matrix einlesen:
# Zeile fuer Zeile, pro Zeile Element fuer Element.
# Matrix an Unterfunktion all_webpage() uebergeben.
###########

if (param('all'))
{
  open (DATEI, "</tmp/adressen.txt") || die "Die Datei konnte nicht geffnet werden\n";
  @datei = <DATEI>;
  foreach(@datei)
  {
    push @all, [ split(/;;/, $_) ];
  }
  close DATEI;
  all_webpage(@all);
}


#######
# Wenn eine Suche aktiviert wird:
# Wir werfen erstmal das "Eintrag suchen" in $field[10] raus.
# Leere Hash-Paare werden ebenfalls nicht benoetigt.
# Datei zum lesen oeffen und eine Daten-Matrix als Array of Array erstellen:
# Elemente sind Referenzen auf die gesplitteten Elemente der jeweiligen Zeile.
# Felder mit Eintrag suchen; in der Spalte zu dem Feld nach den Daten suchen.
# Zeile merken, in der ein Eintrag gefunden wurde, und eine neue Matrix machen.
# An Unterfunktion search_webpage uebergeben, die daraus HTML macht.
#######

if (param('search'))
{
  pop @field;
  foreach(@field)
  {
    if($_ eq "")
    {
      $_ = undef;
    }
  }

  open (DATEI, "</tmp/adressen.txt") || die "Die Datei konnte nicht geffnet werden!\n";
  my @datei = <DATEI>;            
  close DATEI;
  
  foreach (@datei)
  {
    chomp;
    push @matrix, [ split(/;;/, $_) ];
  }
  
  for($i=0; $i<@field; $i++)
  {
    if ($field[$i])
    {
      $index = $i;
      foreach $ref (@matrix)
      {
        if ($ref->[$index] =~ /$field[$index]/)
        {
          push @entry, [ @{$ref} ];
        }
      }
    }
  }
  if (@entry)
  {
    search_webpage(@entry);
  }
  else
  {
    error_page("Leider wurde kein Eintrag gefunden!");
  }
}


##########
# Webseite fuer die Suche: Nimmt Eintraege aus @_ an
# Durchlaeuft in zwei foreach-Schleifen die Matrix:
# Erste Liste ergibt jeweils die <TR>-Tags,
# Referenzen auf die "Unterliste" ergeben jeweils die <TD>-Tags
# WWW- und EMail-Adressen werden dynamisch als Links gesetzt.
##########

sub search_webpage
{
  my @eintraege = @_;

  head_page();
  print "<H4>Sie suchen ein bestimmtes Schaf:</H4>\n";
  print "</CENTER><BR><TABLE CELLPADDING=\"5\" BGCOLOR=\"#00ccbb\">\n";

  foreach $ref (@eintraege)
  {
    print "<TR>";
    if ($ref->[8] ne "keine Angabe")
    {
      $ref->[8] = "<A HREF=\"mailto:$ref->[8]\">$ref->[8]</A>";
    }
    if ($ref->[9] ne "keine Angabe")
    {
      $ref->[9] = "<A HREF=\"http://$ref->[9]\">$ref->[9]</A>";
    }

    foreach $i (@eintraege)
    {
      if ($_)
      {
        print "<TD NOWRAP><FONT SIZE=\"-1\">$_</FONT></TD>";
      }
    }

    foreach (@{$ref})
    {
      print "<TD NOWRAP><FONT SIZE=\"-1\">$_</FONT></TD>";
    }
    print "</TR>";
  }

  print "</TABLE>>BR><BR>\n";
  foot_page();
}

##########
# Erzeugt eine Tabelle mit allen Eintraegen
##########

sub all_webpage
{
  my @eintraege = @_;

  head_page();
  print "Wir zeigen Ihnen alle Ihre Sch&auml;fchen vereint:</H4>\n";
  print "</CENTER><BR><TABLE CELLPADDING=\"5\" BGCOLOR=\"#00ccbb\">\n";

  foreach $ref (@eintraege)
  {
    chomp @$ref;
    print "<TR>";
    if ($ref->[8] ne "keine Angabe")
    {
      $ref->[8] = "<A HREF=\"mailto:$ref->[8]\">$ref->[8]</A>";
    }
    if ($ref->[9] ne "keine Angabe")
    {
      $ref->[9] = "<A HREF=\"http://$ref->[9]\">$ref->[9]</A>";
    }
    foreach (@{$ref})
    {
      print "<TD NOWRAP><FONT SIZE=\"-1\">$_</FONT></TD>";
    }
    print "</TR>";
  }

  print "</TR></TABLE><BR><BR>\n";
  foot_page();
}


##########
# Zeigt den just angehaengten Eintrag auf einer HTML-Seite
##########

sub add_webpage
{
  my @eintraege = @_;

  head_page();
  print "<H4>Folgendes Schaf wurde Ihrer Herde hinzugef&uuml;gt:</H4>\n";
  print "</CENTER><BR><TABLE CELLPADDING=\"5\" BGCOLOR=\"#00ccbb\"><TR>\n";
  foreach (@eintraege)
  {
    print "<TD NOWRAP><FONT SIZE=\"-1\">$_</FONT></TD>";
  }
  print "</TR></TABLE><BR><BR>\n";
  foot_page();
}


############
# Seitenkopf als Unterfunktion
############

sub head_page
{
print "Content-type: text/html \n\n";
print <<Begin;
<HTML><HEAD><TITLE>Adressdatenbank</TITLE></HEAD>
<BODY BGCOLOR="#dddddd" TEXT="#093e79" LINK="#008844" VLINK="#008844">
<BR><CENTER><H2>Alle meine Sch&auml;fchen</H2>
Begin
}

##########
# Seitenfuss als Unterfunktion
# ACHTUNG, URL Anpassen!
##########

sub foot_page
{
print <<End;
<CENTER><B>[</B><A HREF="/adressen.html">Bitte zur&uuml;ck!</A>
<B>]</B></CENTER><BR><CENTER><H4>Vielen Dank!</H4></CENTER>
</BODY>
</HTML>
End
}


sub error_page
{
$error = $_[0];

head_page();

print <<Page;
<CENTER>
<B>$error</B>
</CENTER>
<BR>
<BR>
Page
foot_page();
}
