/**********************************/
/* Punkt (Hook-DLL)               */
/* Kai-Uwe Mrkor                  */
/* 1998                           */
/**********************************/

#include <windows.h>

HHOOK   hPunktHook;   /* Handle auf die Hook-Funktion */

/*****************/
/* Hook-Funktion */
/*****************/
LRESULT CALLBACK PunktHook(int nCode, WPARAM wParam, LPARAM lParam)
{
	HWND    hwnd;
	LPARAM  scancode;

	static int count = 0;

	if (nCode==HC_ACTION)
	{
		if (wParam==VK_DECIMAL)
		{
			count++;

			scancode=OemKeyScan('.')<<16;/* Scancode vom Punkt ermitteln */
			lParam &= 0xFF00FFFF;        /* durch Maskieren aus einem */
			lParam |= scancode;          /* Komma einen Punkt machen */
			wParam =  190;

			hwnd=GetFocus();             /* Fenster-Handle besorgen */
			if (hwnd==NULL)              /* etwa eine DOS-Box ?     */
				hwnd=GetForegroundWindow();/* dann geht diese Methode */

			if ((lParam & 0x8000000) == 0x0)
				PostMessage(hwnd,WM_KEYDOWN,wParam,lParam);

			if ((lParam & 0x8000000) == 0x80000000)
				PostMessage(hwnd,WM_KEYUP,wParam,lParam);

			return 1;
		}
	}

	return CallNextHookEx(hPunktHook, nCode, wParam, lParam);
}

/**************************************/
/* Initialisierung der HOOK-Funktion */
/**************************************/
void DLLInit(HINSTANCE hDLL, BOOL install)
{
	HOOKPROC  lpPunktHook;

	if (install==TRUE)
	{
		lpPunktHook = (HOOKPROC)GetProcAddress(hDLL, "PunktHook");
		hPunktHook = SetWindowsHookEx(WH_KEYBOARD, lpPunktHook, hDLL, 0);
	}
	else
		UnhookWindowsHookEx(hPunktHook);
}
