' ICONS.VBS (c) Tobias Weltner & c't
' Individuelle Ordnericons (fr Win98/IE4)

' Zugang zu Systemkomponenten herstellen
set args = Wscript.Arguments				' bergebene Argumente
set WSHShell = CreateObject("WScript.Shell")		' 
set fs = CreateObject("Scripting.FileSystemObject")	' Dateisystem-Befehle

if args.Count=0 then
	ordnername = InputBox("Geben Sie den Pfadnamen des Ordners ein, dem Sie ein neues Icon geben mchten!")
else
	ordnername = args(0)
end if

' Windows-Ordner ermitteln
win = WSHShell.ExpandEnvironmentStrings("%WINDIR%") + "\"
frage1 = "Wie heit der Pfadname der Icon-Bibliothek?"
frage2 = "Wie lautet die Kennzahl des Icons?"
iconfile = InputBox(frage1,,win + "PROGMAN.EXE")
iconnumber = InputBox(frage2,,0)

' speziell angepate DESKTOP.INI generieren und in Ordner legen
OrdnerIcon ordnername, iconfile, iconnumber	


sub OrdnerIcon(ordner, icon, nr)
	'existiert der Ordner berhaupt?
	if not fs.FolderExists(ordner) then
		MsgBox ordner & " existiert nicht.", vbExclamation
		exit sub
	end if

	' DESKTOP.INI-Datei fr den Ordner anlegen	
	ini = ordner + "\desktop.ini"
	set ausgabe = fs.CreateTextFile(ini, vbTrue)

	' Icon-Informationen in DESKTOP.INI schreiben:
	ausgabe.WriteLine "[.ShellClassInfo]"
	ausgabe.WriteLine "IconFile=" + iconfile
	ausgabe.WriteLine "IconIndex=" + iconnumber
	ausgabe.close

	' Attribute des Ordners setzen
	set ordner = fs.GetFolder(ordner)
	attribute = ordner.Attributes
	attributeoff = attribute and not (4+8+16+64+128)
	attributeon = attribute and not (8+16+64+128) or 4
	ordner.attributes = attributeoff
	info = "Neue Icons werden erst nach Aktualisierung des Explorers sichtbar." + vbCr
	info = info + "Dazu bitte eine freie Stelle des Desktops anklicken und dann" + vbCr
	info = info + "auf [F5] drcken."
	MsgBox info, vbInformation
	ordner.attributes = attributeon
end sub
