' FEHLER.VBS (c) Tobias Weltner & c't
' markiert fehlerhafte Zeile in einem Skript

' Verbindung zu System-ActiveX-Modulen herstellen
set WSHShell = CreateObject("WScript.Shell")		' fr Run-Befehl
set fs = CreateObject("Scripting.FileSystemObject")	' fr Dateisystem
set args = WScript.Arguments				' fr Argumente

'wurde der Name eines Skripts bergeben?
if args.count=0 then
	datei = InputBox("Wie heit die Skriptdatei, in der ein Fehler auftrat?")
else
	datei = args(0)
end if
if not fs.FileExists(datei) then
	MsgBox datei & " existiert nicht!", vbExclamation
	WScript.Quit
end if


zeilenr=AskNumber		' welche Zeile markieren?

' Markierungsstring definieren
markierung = string(20, "x") + " FEHLERHAFTE ZEILE "
markierung = markierung + string(20, "x")

'Skriptdatei ffnen...
set einlesen = fs.OpenTextFile(datei)
ok=vbFalse
neu = ""	' enthlt den neuen Skripttext mit Markierung
'... und zeilenweise einlesen.
do until einlesen.atEndOfStream
	if einlesen.Line = zeilenr then
		' angegebene Zeile gefunden: Markierung einfgen
		neu = neu + "'" + markierung + vbNewLine
		neu = neu +  einlesen.ReadLine +  vbNewLine
		neu = neu + "'" + markierung + vbNewLine
		ok=vbTrue	' Zeile wirklich gefunden!
	else
		' normale Zeile: falls alte Markierung, entfernen
		gelesen = einlesen.ReadLine
		if len(gelesen)=len(markierung)+1 then
			if not gelesen="'" + markierung then
				neu = neu + gelesen + vbNewLine
			end if
		else
			neu = neu + gelesen + vbNewLine
		end if
	end if
loop
einlesen.close

if not ok and not zeilenr=0 then
	' angegebene Zeilennummer existiert nicht!
	MsgBox "Zeile " & zeilenr & " gibt es im Programm nicht!", vbExclamation
	WScript.Quit
end if

' Skriptdatei lschen und mit neuem Inhalt erneut schreiben
set einlesen = fs.CreateTextFile(datei, vbTrue)
einlesen.Write neu
einlesen.close

' falls Zeilen-Nr=0, dann nur alte Markierungen entfernen und Meldung
if zeilenr=0 then
	MsgBox "Zeilenmarkierungen wurden aus Skript entfernt!", vbInformation
else
	' ansonsten das Skript im Editor ffnen:
	WSHShell.Run "NOTEPAD.EXE " + datei
end if

function AskNumber
	'fragt nach einer Zahl grer/gleich 0
	AskNumber=-1
	do while AskNumber<0
		if assist then MsgBox "Bitte geben Sie eine Zeilennummer grer	gleich 0 ein! 0 entfernt Zeilenmarkierungen wieder!", vbInformation
		assist=vbTrue
		frage = "Zeilennummer eingeben, in der der Fehler passiert ist, " + vbCr
		frage = frage + "oder 0, um bestehende Zeilenmarkierungen zu entfernen!"
		zeile = InputBox(frage)
		if isNumeric(zeile) then AskNumber=Cint(zeile)
		if zeile="" then
			MsgBox "Abbruch!", vbExclamation
			WScript.Quit
		end if
	loop
end function