' SCHRIFTEN.VBS (c) Tobias Weltner & c't
' gibt Schriftprobe der installierten Schriften aus

'Kontakt zu ActiveX-Komponenten herstellen
set WSHShell = CreateObject("WScript.Shell")		' fr Run-Befehl
set fs = CreateObject("Scripting.FileSystemObject")	' fr Dateisystem

schriftarten = GetFonts		'liefert Liste der installierten Schriften
Konzentrieren			'entfernt Schriftfamilien
Sortieren			'sortiert alphabetisch
Schriftprobe			'generiert die HTML-Schriftprobe

sub Sortieren
	Melde "Sortiere Schriften..."
	for x=0 to ubound(schriftarten) 
		for y=x to ubound(schriftarten)
			if schriftarten(x)>schriftarten(y) then
				temp = schriftarten(x)
				schriftarten(x) = schriftarten(y)
				schriftarten(y) = temp
			end if
		next
	next
end sub

sub Konzentrieren
	Melde "konzentriere auf Schriftschnitte..."
	' Schriftfamilien-Attribute, die ausgeblendet sein sollen:
	familien = "extra bold,bolditalic,italic,bold,light,fett,kursiv,oblique,normal"
	familien = Split(familien,",")

	for x=0 to ubound(schriftarten)
		for y=0 to ubound(familien)
			if Instr(lcase(schriftarten(x)), familien(y))>0 then
				' berflssige Font-Familie: lschen!
				schriftarten(x)=""
				exit for
			end if
		next
	next
end sub

sub Schriftprobe
	Melde "Schriftprobe generieren..."
	probe = "C:\schriften.htm"
	probetext = InputBox("Bitte Probetext eingeben!", "Probetext", "ABCDabcd 1234 Schriftprobe")
	probesize = InputBox("Bitte Schriftgre der Probe festlegen!", "Gre", "25")
	if isNumeric(probesize) then
		' gltige Grenangabe eingegeben
		probesize = CInt(probesize)
	else
		' Vorgabe verwenden
		probesize=25
	end if

	set ausgabe = fs.CreateTextFile(probe, vbTrue)
	for each schrift in schriftarten
		if schrift<>"" then
			if probetext="" then
				zusatztext = schrift
			else
				Print ausgabe, "Schriftart " + schrift + "<BR>"
			end if
			probezeile = "<p style=" + chr(34) + "font-family: " + schrift + "; font-size: " & probesize & "pt" + chr(34) + ">" + probetext + zusatztext + "</p><hr>"
			Print ausgabe, probezeile
		end if
	next
	WSHShell.Run probe
end sub

function GetFonts
	Melde "Stelle Schriften aus der Registry zusammen. Geduld..."
	' Schriftenliste aus der Registry auslesen
	tempdatei = "C:\SCHRIFT.TXT"
	key = " HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\Fonts"
	WSHShell.Run "REGEDIT.EXE /E " + tempdatei + key,0,vbTrue

	' Schriftenliste auswerten
	set eingabe = fs.OpenTextFile(tempdatei)
	do until eingabe.atEndOfStream
		gelesen = eingabe.ReadLine
		if len(gelesen)>1 then
			if left(gelesen,1) = chr(34) then
				' Zeile enthlt eine Schrift...
				schrift = Split(gelesen, "=")
				name = replace(schrift(0),chr(34), "")
				position = InStr(name, "(")

				' Schrifttyp feststellen...
				if position>0 then
					typ = mid(name, position+1)
					typ = lcase(left(typ, len(typ)-1))
					name = left(name, position-1)
				else
					typ="truetype"
				end if

				if typ="truetype" then
					GetFonts = GetFonts + name + ";"
				end if
			end if
		end if
	loop
	eingabe.close
	fs.DeleteFile tempdatei, vbTrue

	GetFonts = Split(left(GetFonts, len(GetFonts)-1), ";")
end function

function Melde(was)
	' Meldung fr 1 Sekunde anzeigen:
	WSHShell.Popup was, 1
end function

sub Print(obj, txt)
	obj.WriteLine txt + "<BR>"
end sub

