REM MovieMaker-Script fr Corel PHOTO-PAINT8
REM (c) 1999 Alex Vakulenko + Jan Steenbuck

DECLARE SUB ParsePath(File$)                                   'Routinen,
DECLARE SUB ParsePattern                                   'Variablen und
DECLARE FUNCTION MakeFile$(Num&)                              'Funktionen
DECLARE SUB MakeMovie                                        'deklarieren
GLOBAL Pattern$,First&,Last&,PatPrefix$,PatSuffix$,PatLen&
Pattern=""
First=0
Last=0

BEGIN DIALOG OBJECT Main 200, 78, "MovieMaker", SUB MainHandler
   GROUPBOX  5, 4, 190, 49, .GroupBox1, "Dateiauswahl"     'Script-Haupt-
   TEXT  12, 16, 25, 8, .Text1, "&Muster:"                        'dialog
   TEXTBOX  41, 14, 105, 13, .Pattern
   PUSHBUTTON  149, 14, 40, 14, .Browse, "&Suchen..."
   TEXT  12, 35, 53, 8, .Text2, "&Erste Datei:"
   SPINCONTROL  66, 33, 30, 12, .First
   TEXT  103, 35, 52, 8, .Text3, "&Letzte Datei:"
   SPINCONTROL  157, 33, 30, 12, .Last
   PUSHBUTTON  6, 58, 46, 14, .Create, "&Ausfhren"
   CANCELBUTTON  63, 58, 46, 14, .Cancel
END DIALOG

Main.First.SetMinRange 0
Main.Last.SetMinRange 0

SUB MainHandler(BYVAL CtrlID%, BYVAL Event%)
SELECT CASE Event                                'Dateimuster feststellen
   CASE 0                                           'bei maueller Eingabe
      Main.Pattern.SetText Pattern
      Main.First.SetValue First
      Main.Last.SetValue Last
   CASE 1
      SELECT CASE CtrlID
         CASE Main.First.GetID()
            First=Main.First.GetValue()
            if First>Last then
               Main.Last.SetValue First
            else
               Main.Last.SetValue Last
            endif
               Main.Last.SetMinRange First
         CASE Main.Last.GetID()
            Last=Main.Last.GetValue()
      END SELECT
   CASE 2
      SELECT CASE CtrlID
         CASE Main.Browse.GetID()
            File$=GETFILEBOX("Alle Dateien|*.*", "Datei whlen...")
            if File<>"" then                     'Dateimuster feststellen
               ParsePath File             'in Standard-Dateiauswahldialog
               Main.First.SetValue First
               Main.Last.SetValue Last
               Main.Last.SetMinRange First
               Main.Pattern.SetText Pattern
             endif
         CASE Main.Create.GetID()
            Pattern$=ltrim(rtrim(Main.Pattern.GetText()))
            if Pattern="" then                 'Keine Dateiangabe, Fehler
               MessageBox "Kein Muster angegeben","Error",16
            else	
               ParsePattern
               if PatLen=0 then
                  if MessageBox("Das Dateimuster enthlt kein '#'-Zeichen."+CHR(13)+ \\
                                "Trotzdem weitermachen?","Warnung",36)=6 then Main.CloseDialog 1
               else
                  Main.CloseDialog 1
               endif
            endif
      END SELECT
END SELECT
END SUB
BEGIN DIALOG OBJECT Progr 200, 34, "Erzeuge Film", SUB ProgrHandler
   TEXT  5, 6, 36, 8, .Text1, "Hinzufgen:"          'Verarbeitungsdialog
   TEXT  44, 6, 150, 8, .File, ""
END DIALOG
SUB ProgrHandler(BYVAL CtrlID%, BYVAL Event%)
if Event=0 then
   MakeMovie
   Progr.CloseDialog 2
endif
END SUB

if Dialog(Main)=2 then stop
Dialog Progr
stop

SUB ParsePath(File$)
   ext%=0
   num%=0
   i%=len(File)
   while i>0 and ext=0
      if mid(File,i,1)="." then ext=i
      i=i-1
   wend
   FilePat$=File
   if ext>0 then
      exts$=mid(File,ext)
      FilePat=left(File,ext-1)
   endif
   i=len(FilePat)
   while i>0 and num=0
      if mid(FilePat,i,1)<"0" or mid(FilePat,i,1)>"9" then num=i+1
      i=i-1
   wend
   if i=0 then num=1
   Pattern=left(FilePat,num-1)
   First=val(mid(FilePat,num))
   Last=First
   if num>0 and num<>ext then
      for i=1 to ext-num
         Pattern=Pattern+"#"
      next i
   endif
   if ext>0 then Pattern=Pattern+mid(File,ext)
   ParsePattern
   if num>0 and num<>ext then
      do
         Last=Last+1
         s$=MakeFile(Last)
      loop until FileAttr(s$)=0
      Last=Last-1
   endif
END Sub
FUNCTION MakeFile$(Num&)
   if PatLen=0 then
      s$=PatPrefix
   else
      nm$=ltrim(str(Num))
      if len(nm)<PatLen then nm$=right("00000000000000000000"+nm,PatLen)
      s$=PatPrefix+nm+PatSuffix
   endif
   MakeFile=s$
END FUNCTION
SUB ParsePattern
   f&=0
   l&=0
   i%=len(Pattern)
   while i>0 and f=0
      if l=0 then
         if mid(Pattern,i,1)="#" then l=i
      else
         if mid(Pattern,i,1)<>"#" then f=i+1
      endif
      i=i-1
   wend
   if l<>0 and f=0 then f=1
   if f=0 then
      PatPrefix$=Pattern
      PatSuffix$=""
      PatLen=0
   else
      PatPrefix$=left$(Pattern,f-1)
      PatSuffix$=mid(Pattern,l+1)
      PatLen=l-f+1
   endif
END SUB
SUB MakeMovie
ON ERROR RESUME NEXT
WITHOBJECT "CorelPhotoPaint.Automation.8"
   IF ERRNUM<>0 then                                    'Fehlerbehandlung
      MessageBox "Kann Corel PHOTO-PAINT 8 nicht starten.","Schwerwiegender Fehler",16
      ERRNUM=0
      EXIT SUB
   ENDIF
   ON ERROR EXIT
   s$=MakeFile(First)
   if FileAttr(s$)=0 then
      MessageBox "Kann Datei nicht ffnen: '"+s$+"'.","Fehler",16
   else
      Progr.File.SetText s$
      .FileOpen s$, 0, 0, 0, 0, 0, 1, 1
      .MovieCreate
      fr&=1
      if First<>Last then
         for i&=First+1 to Last
            s$=MakeFile(i)
            Progr.File.SetText s$
            if FileAttr(s$)=0 then
               if MessageBox("Kann Datei nicht finden: '"+s$+"'. Weiter?","Fehler",20)=7 then exit for
            else
               .MovieInsertFile s, 0, 0, 0, 0, 0, fr, FALSE
               fr=fr+1
            endif
         next i
      endif
   endif
END WITHOBJECT
END SUB
