DECLARE SUB ShellExecute LIB "shell32" (BYVAL hWnd&,BYVAL Operation&,BYVAL File$,BYVAL Parameters&,BYVAL Directory&,BYVAL Show&) ALIAS "ShellExecuteA"
DECLARE SUB Init
DECLARE FUNCTION GetCount(BYVAL Path$) as long
DECLARE SUB SetCounter
DECLARE SUB ProcessFile(BYVAL FileName$,BYVAL Index&)
DECLARE FUNCTION ConvertUnit#(v#,Src&,Dest&)
DECLARE SUB ConvertToMicrons
DECLARE SUB ReadValues
DECLARE SUB SetUnits
DECLARE SUB SetValues
DECLARE SUB CountTiles
DECLARE FUNCTION GetFld$(fld$)

#define DRAWOBJECT "CorelDRAW.Automation.8"
#define MICRON 4

GLOBAL Src$,DefSrc$,Path$,Total&,Current&,FileName$
GLOBAL Abort as boolean
GLOBAL Units$(3),ShortUnits$(3),UnitSystem&(4),SizeX#,SizeY#,SpaceX#
GLOBAL SpaceY#,MarginX#,MarginY#,SizeXMicro&,SizeYMicro&,Caption&
GLOBAL SpaceXMicro&,SpaceYMicro&,MarginXMicro&,MarginYMicro&,CountX&
GLOBAL CountY&,PageX&,PageY&,BoundingBox&,Unit&,ThumbMarginTop&
GLOBAL ThumbMarginBottom&,ThumbMarginLeft&,ThumbMarginRight&

Units$(1)="Inch"
Units$(2)="Millimeter"
ShortUnits$(1)="in"
ShortUnits$(2)="mm"
UnitSystem(1)=1
UnitSystem(2)=2
UnitSystem(4)=7

DefSrc$="*.*"
Src$=DefSrc$
Abort=false
SizeX#=35
SizeY#=35
SpaceX#=5
SpaceY#=5
MarginX#=5
MarginY#=5
ThumbMarginTop&=5000 ' Thumbnail bounding box offset (0.5 mm)
ThumbMarginBottom&=5000
ThumbMarginLeft&=5000
ThumbMarginRight&=5000
BoundingBox&=1
Caption&=1
Unit&=2

BEGIN DIALOG OBJECT MainDialog 273, 140, "Thumbnailer", SUB MainDlgProc
	TEXT  5, 6, 55, 8, .Text1, "&Quelldateien:"
	TEXTBOX  67, 4, 109, 13, .Source
	PUSHBUTTON  221, 4, 48, 14, .OK, "OK"
	CANCELBUTTON  221, 24, 48, 14, .Cancel
	PUSHBUTTON  179, 5, 36, 14, .Browse, "&Suchen..."
	GROUPBOX  6, 22, 92, 45, .GroupBox1, "Thumbnail-Gre"
	TEXT  11, 35, 10, 8, .Text2, "&X:"
	SPINCONTROL  22, 33, 46, 12, .SizeX
	TEXT  71, 35, 15, 8, .SizeXUnit, "mm"
	TEXT  11, 51, 10, 8, .Text3, "&Y:"
	SPINCONTROL  22, 49, 46, 12, .SizeY
	TEXT  71, 51, 15, 8, .SizeYUnit, "mm"
	GROUPBOX  5, 71, 92, 45, .GroupBox2, "Thumbnail-Abstand"
	TEXT  11, 84, 10, 8, .Text4, "X:"
	SPINCONTROL  22, 82, 46, 12, .SpaceX
	TEXT  71, 84, 15, 8, .SpaceYUnit, "mm"
	TEXT  11, 100, 10, 8, .Text5, "Y:"
	SPINCONTROL  22, 98, 46, 12, .SpaceY
	TEXT  71, 100, 15, 8, .SpaceXUnit, "mm"
	GROUPBOX  103, 22, 112, 64, .GroupBox3, "Seitenlayout"
	TEXT  110, 35, 33, 8, .Text6, "Rand &H:"
	SPINCONTROL  145, 33, 46, 12, .MarginX
	TEXT  195, 35, 15, 8, .MarginXUnit, "mm"
	TEXT  110, 51, 33, 8, .Text7, "Rand &V:"
	SPINCONTROL  145, 49, 46, 12, .MarginY
	TEXT  195, 51, 15, 8, .MarginYUnit, "mm"
	TEXT  110, 71, 80, 8, .Text14, "Aktuelles Layout:"
	TEXT  170, 71, 40, 8, .Layout, "3 x 5"
	CHECKBOX  111, 91, 100, 10, .BoundingBox, "&Umgebendes Rechteck"
	CHECKBOX  111, 105, 100, 10, .Caption, "&Dateinamen hinzufgen"
	TEXT  6, 123, 32, 8, .Text16, "&Einheiten:"
	DDLISTBOX  42, 121, 55, 42, .Units
END DIALOG

BEGIN DIALOG OBJECT ProgressDialog 205, 77, "Arbeite...", SUB ProgressProc
	TEXT  6, 6, 37, 8, .Text1, "Verarbeite:"
	TEXT  47, 6, 150, 8, .FileName, "FileName"
	PROGRESS 5, 37, 195, 8, .Progress
	TEXT  78, 25, 50, 8, .Counter, "1 von 1000"
	CANCELBUTTON  82, 54, 40, 14, .Cancel
END DIALOG

SUB MainDlgProc(BYVAL ControlID%, BYVAL EventCode%)
SELECT CASE EventCode
	CASE 0 'Init
		Init
 	CASE 1 ' Text boxes, Spinners
 		SELECT CASE ControlID
				CASE MainDialog.SizeX.GetID(),MainDialog.SizeY.GetID(), \\
					MainDialog.SpaceX.GetID(),MainDialog.SpaceY.GetID(), \\
					MainDialog.MarginX.GetID(),MainDialog.MarginY.GetID()
					CountTiles
 		END SELECT
	CASE 2 ' Buttons, list boxes
		SELECT CASE ControlID
  			CASE MainDialog.OK.GETID()
				Src$=MainDialog.Source.GETTEXT()
				IF Src="" THEN 
					MessageBox "Bitte whlen Sie die Quelldateien aus.","Error",16
				ELSE
					DIALOG ProgressDialog
				ENDIF
			CASE MainDialog.Browse.GETID()
				tx$=MainDialog.Source.GETTEXT()
				fld$=GETFOLDER(GetFld(tx))
				IF fld<>"" THEN
					if right(fld,1)<>"\" then fld=fld+"\"
					tx$=MainDialog.Source.GETTEXT()
					tx$=MID(tx,LEN(GetFld(tx))+1)
					if tx$="" then tx$="*.*"
					fld=fld+tx
					MainDialog.Source.SETTEXT fld
				ENDIF
			CASE MainDialog.Units.GetID()
				NewUnit&=MainDialog.Units.GetSelect()
				ReadValues
				SizeX=ConvertUnit(SizeX,Unit,NewUnit)
				SizeY=ConvertUnit(SizeY,Unit,NewUnit)
				SpaceX=ConvertUnit(SpaceX,Unit,NewUnit)
				SpaceY=ConvertUnit(SpaceY,Unit,NewUnit)
				MarginX=ConvertUnit(MarginX,Unit,NewUnit)
				MarginY=ConvertUnit(MarginY,Unit,NewUnit)
				Unit=NewUnit
				SetValues
				SetUnits
		END SELECT
	END SELECT
END SUB

SUB Init
	SetValues
	CountTiles
	MainDialog.Source.SetText Src$
END SUB

WITH MainDialog
	.SizeX.SetDoubleMode TRUE
	.SizeX.SetPrecision 2
	.SizeX.SetMinRange 0.01
	.SizeX.SetIncrement 0.1
	.SizeY.SetDoubleMode TRUE
	.SizeY.SetPrecision 2
	.SizeY.SetMinRange 0.01
	.SizeY.SetIncrement 0.1
	.SpaceX.SetDoubleMode TRUE
	.SpaceX.SetPrecision 2
	.SpaceX.SetMinRange 0
	.SpaceX.SetIncrement 0.1
	.SpaceY.SetDoubleMode TRUE
	.SpaceY.SetPrecision 2
	.SpaceY.SetMinRange 0
	.SpaceY.SetIncrement 0.1
	.MarginX.SetDoubleMode TRUE
	.MarginX.SetPrecision 2
	.MarginX.SetMinRange 0
	.MarginX.SetIncrement 0.1
	.MarginY.SetDoubleMode TRUE
	.MarginY.SetPrecision 2
	.MarginY.SetMinRange 0
	.MarginY.SetIncrement 0.1
	.BoundingBox.SetThreeState FALSE
	.Caption.SetThreeState FALSE
	.Units.SetArray Units
	.Units.SetSelect Unit
END WITH
ON ERROR RESUME NEXT
ERRNUM=0
WITHOBJECT DRAWOBJECT
	.GetPageSize PageX,PageY
END WITHOBJECT
ON ERROR EXIT
IF ERRNUM<>0 THEN
	MessageBox "Erstellen Sie ein leeres CorelDRAW!-Dokument, bevor Sie dieses Script ausfhren!","Erro",16
ELSE
	DIALOG MainDialog
ENDIF
STOP

SUB ProgressProc(BYVAL CtrlID%, BYVAL Event%)
SELECT CASE Event
	CASE 0
		ProgressDialog.FileName.SETTEXT "Zhle Dateien. Bitte warten..."
		ProgressDialog.Counter.SETVISIBLE FALSE
		ProgressDialog.Progress.SETVISIBLE FALSE
		ProgressDialog.Cancel.SETVISIBLE FALSE
		ProgressDialog.Counter.SETSTYLE 64
		Total=GetCount(Src$)
		IF Total=0 THEN
			MessageBox "Keine Dateien gefunden, die den Vorgaben entsprechen!","Warning",16
			ProgressDialog.CloseDialog 1
		ELSE
			SetCounter
			ProgressDialog.Progress.SETMAXRANGE Total
			ProgressDialog.Progress.SETMINRANGE 0
			ProgressDialog.Progress.SETINCREMENT 1
			ProgressDialog.Progress.SETVALUE 0
			ProgressDialog.Counter.SETVISIBLE TRUE
			ProgressDialog.Progress.SETVISIBLE TRUE
			ProgressDialog.Cancel.SETVISIBLE TRUE
			Path$=GetFld(Src$)'left(Src$,i)
			ProgressDialog.SETTIMER 10
			FileName$=FINDFIRSTFOLDER(Src$,167)
			Current=0
		ENDIF
	CASE 5
		IF FileName$="" OR Abort THEN
			ProgressDialog.CloseDialog 1
		ELSE
			Current=Current+1
			ProgressDialog.FileName.SETTEXT FileName$
			SetCounter
			CALL ProcessFile FileName$,Current-1
			ProgressDialog.Progress.STEP
			FileName$=FINDNEXTFOLDER()
		endif		
END SELECT
END SUB


'=========================== Count files matching the mask =======================
FUNCTION GetCount(BYVAL Path$) as long
c&=0
s$=FINDFIRSTFOLDER(Path$,167)
DO WHILE s$<>""
	c=c+1
	s$=FINDNEXTFOLDER()
LOOP
GetCount=c
END Function

'=========================== Update Progress dialog file counter =======================
SUB SetCounter
	ProgressDialog.Counter.SETTEXT STR(Current)+" of "+STR(Total)
END SUB

REM =======================================================
REM This subroutine is called for each file to be processed
REM FileName$ - full name of the file being processed
REM Put any functionality into this subroutine
REM =======================================================

SUB ProcessFile(BYVAL FileName$,BYVAL Index&)
WITHOBJECT DRAWOBJECT
	Start&=Index MOD (CountX*CountY)
	tx&=Start MOD CountX
	ty&=Start\CountX
	IF tx=0 AND ty=0 AND Index<>0 THEN .InsertPages FALSE,1
	x&=-PageX\2+MarginXMicro+tx*(SizeXMicro+SpaceXMicro)
	y&=PageY\2-MarginXMicro-ty*(SizeYMicro+SpaceYMicro)
	IF BoundingBox Then .CreateRectangle y+ThumbMarginTop,x-ThumbMarginLeft,y-SizeYMicro-ThumbMarginBottom,x+SizeXMicro+ThumbMarginRight,0
	.UnselectAll
	ON ERROR RESUME NEXT
		.FileImport Path$+FileName$
		.GetSize sx&,sy&
	ON ERROR EXIT
	IF ERRNUM<>0 THEN
		.BeginDrawCurve x,y
		.DrawCurveLineTo x+SizeXMicro, y-SizeYMicro
		.EndDrawCurve
		.BeginDrawCurve x+SizeXMicro,y
		.DrawCurveLineTo x, y-SizeYMicro
		.EndDrawCurve
	ELSE
		IF sx*(SizeYMicro/sy)>SizeXMicro THEN
			sy=sy*(SizeXMicro/sx)
			sx=SizeXMicro
		ELSE
			sx=sx*(SizeYMicro/sy)
			sy=SizeYMicro
		ENDIF
		.SetSize sx,sy
		.SetReferencePoint 3
		.SetPosition x+(SizeXMicro-sx)\2,y-(SizeYMicro-sy)\2
	END IF
	IF Caption THEN
		.CreateArtisticText FileName$,x+SizeXMicro\2,y-SizeYMicro-SpaceYMicro\2
		.SetCharacterAttributes 0, 0, "Arial", 7, 100, 0, 0, 0, 0, 0, 1000, 1000, 2
	END IF
		
END WITHOBJECT
END SUB

FUNCTION ConvertUnit#(v#,Src&,Dest&)
	vv#=v
	IF Src=2 then vv=vv/10
	vv#=LengthConvert(UnitSystem(Src),UnitSystem(Dest),vv#)
	if Dest=2 then vv=vv*10
	ConvertUnit=vv
END FUNCTION

SUB ConvertToMicrons
	ReadValues
	SizeXMicro&=ConvertUnit(SizeX,Unit,MICRON)
	SizeYMicro&=ConvertUnit(SizeY,Unit,MICRON)
	SpaceXMicro&=ConvertUnit(SpaceX,Unit,MICRON)
	SpaceYMicro&=ConvertUnit(SpaceY,Unit,MICRON)
	MarginXMicro&=ConvertUnit(MarginX,Unit,MICRON)
	MarginYMicro&=ConvertUnit(MarginY,Unit,MICRON)
END SUB

SUB ReadValues
	WITH MainDialog
		SizeX=.SizeX.GetValue()
		SizeY=.SizeY.GetValue()
		SpaceX=.SpaceX.GetValue()
		SpaceY=.SpaceY.GetValue()
		MarginX=.MarginX.GetValue()
		MarginY=.MarginY.GetValue()
		Caption=.Caption.GetValue()
		BoundingBox=.BoundingBox.GetValue()
	END WITH
END SUB

SUB SetUnits
	WITH MainDialog
		.SizeXUnit.SetText ShortUnits(Unit)
		.SizeYUnit.SetText ShortUnits(Unit)
		.SpaceXUnit.SetText ShortUnits(Unit)
		.SpaceYUnit.SetText ShortUnits(Unit)
		.MarginXUnit.SetText ShortUnits(Unit)
		.MarginYUnit.SetText ShortUnits(Unit)
	END WITH
END SUB

SUB SetValues
	WITH MainDialog
		.SizeX.SetValue SizeX
		.SizeY.SetValue SizeY
		.SpaceX.SetValue SpaceX
		.SpaceY.SetValue SpaceY
		.MarginX.SetValue MarginX
		.MarginY.SetValue MarginY
		.Caption.SetValue Caption
		.BoundingBox.SetValue BoundingBox
	END WITH
END SUB

SUB CountTiles
	ConvertToMicrons
	dx&=SizeXMicro+SpaceXMicro
	dy&=SizeYMicro+SpaceYMicro
	CountX=1
	CountY=1
	IF dx=0 OR dy=0 THEN
		MainDialog.Layout.SetText "<Error>"
		MainDialog.OK.Enable FALSE
	ELSE
		CountX=(PageX-2*MarginXMicro+SpaceXMicro)\dx
		CountY=(PageY-2*MarginYMicro+SpaceYMicro)\dy
		MainDialog.Layout.SetText (CountX & " x " & CountY)
		MainDialog.OK.Enable TRUE
	ENDIF
END SUB

FUNCTION GetFld$(fld$)
	FOR i%=LEN(fld$) TO 1 STEP -1
		if instr("/\",mid(fld$,i,1)) then EXIT FOR
	NEXT i
	GetFld=LEFT(fld,i)
END FUNCTION
