REM KONVERT.VBS REM (c) Tobias Weltner & c't

REM Hier legen Sie fest, was konvertiert werden soll:
REM -------------------------------------------------
originaltyp = "tif"
originalordner = "c:\temp"
zieltyp = "awd"
zielordner = "C:\test"
REM -------------------------------------------------

select case lcase(zieltyp)
	case "tif"
		typ = 1
	case "awd"
		typ = 2
	case "bmp"
		typ = 3
	case else
		fehler
end select

counter = 0 	' Anzahl konvertierter Dateien
bad = 0		' Anzahl Fehlschlge


Set fs = CreateObject("Scripting.FileSystemObject")
Set App = CreateObject("Imaging.Application")

' Toolbars ausblenden
App.ImagingToolBarVisible=false
App.ScanToolBarVisible=false
App.StatusBarVisible=false
App.ToolBarVisible=false
App.Edit = false
App.FitTo(1)

Set Img = App.CreateImageViewerObject(1)

set ordner = fs.GetFolder(originalordner)
for each datei in ordner.files
	extension = lcase(fs.GetExtensionName(datei.path))
	if extension = lcase(originaltyp) then
		konvert datei.path, datei.name
	end if
next

App.Quit	' Imaging-Tool schlieen

MsgBox "Es wurden " & counter & " Grafiken konvertiert. Bei " & bad & " Grafiken kam es zu Fehlern!", vbInformation

sub konvert(datei, name)
REM Versucht, eine Datei zu ffnen, konvertieren, speichern:	
	on error resume next

	echtername = zielordner + "\" + left(name, InstrRev(name, "."))
	neuername = echtername + zieltyp

	Img.Open datei, True, 1
	if err.Number=0 then
		DoStuff
		Img.SaveAs neuername, CInt(typ)
		if err.Number=0 then
			counter = counter + 1
		else
			bad = bad + 1
			Err.Clear
		end if
	else
		Err.Clear
		bad = bad + 1
	end if
end sub

sub fehler
	MsgBox zieltyp & " ist kein untersttzter Dateityp!"
	WScript.Quit
end sub

sub DoStuff
REM Hier legen Sie fest, wie konvertiert werden soll:
REM -------------------------------------------------
	Img.Pages(1).ImageResolutionX=20	' X-Auflsung in DPI
	Img.Pages(1).ImageResolutionY=20	' Y-Auflsung in DPI
	Img.Pages(1).Flip			' stellt das Bild auf den Kopf
	Img.Pages(1).RotateRight		' dreht Bild um 90 Grad nach rechts
	Img.Pages(1).RotateLeft			' dreht Bild um 90 Grad nach links
REM -------------------------------------------------
end sub
