unit Frameedit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, Mask, ExtCtrls;

type
  TFrameEditForm = class(TForm)
    GroupBoxFrameedit: TGroupBox;
    EditFramedefinition: TEdit;
    Label1: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    CheckBoxResize: TCheckBox;
    RadioGroupRollmodus: TRadioGroup;
    CheckBoxFramekante: TCheckBox;
    MaskEditRandRL: TMaskEdit;
    MaskEditRandOU: TMaskEdit;
    UpDownRandRL: TUpDown;
    UpDownRandOU: TUpDown;
    ButtonDefinieren: TButton;
    ButtonAbbruch: TButton;
    ButtonOk: TButton;
    Panel1: TPanel;
    Label3: TLabel;
    EditURL: TEdit;
    ButtonURLBrowser: TButton;
    ButtonNurDatei: TButton;
    Panel2: TPanel;
    Label2: TLabel;
    EditName: TEdit;
    procedure ButtonURLBrowserClick(Sender: TObject);
    procedure ButtonDefinierenClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure ButtonNurDateiClick(Sender: TObject);
    procedure ButtonOkClick(Sender: TObject);
  private
    { Private-Deklarationen }
    function getArg (Argname: String): String;
  public
    { Public-Deklarationen }
  end;

var
  FrameEditForm: TFrameEditForm;

implementation

uses SDateimanager, SmallLittleFrame, HyperlinkForm;

{$R *.DFM}

procedure TFrameEditForm.ButtonURLBrowserClick(Sender: TObject);
VAR mr:     TModalResult;
begin
  WITH TDateiManagerForm.ECreate (Self, FALSE, TRUE,
    'Framequelle suchen', 'Als Frame eintragen', EditURL.Text, '',
    LRFrame.Konfig.DateiFilterIndex, TRUE, TRUE, FALSE, FALSE) DO BEGIN
    mr := ShowModal;
    IF mr = mrOk THEN BEGIN
      EditURL.Text := Dateiauswahl;
    END (* IF mrOk *);
    Release;
  END (* WITH *);
end;

procedure TFrameEditForm.ButtonDefinierenClick(Sender: TObject);
VAR  defstr:  String;
begin
  defstr := '';
  IF EditName.Text <> '' THEN BEGIN
    defstr := 'name="' + EditName.Text + '" ';
  END (* IF *);
  IF EditURL.Text <> '' THEN BEGIN
    defstr := defstr + 'src="' + EditURL.TExt + '" ';
  END (* IF *);
  IF CheckBoxResize.checked THEN BEGIN
    defstr := defstr + 'noresize ';
  END (* IF *);
  CASE RadioGroupRollmodus.ItemIndex OF
    1: defstr := defstr + 'scrolling="yes" ';
    2: defstr := defstr + 'scrolling="no" ';
  END (* CASE *);
  IF NOT CheckBoxFramekante.checked THEN BEGIN
    defstr := defstr + 'frameborder="0" ';
  END (* IF *);
  defstr := defstr + 'marginwidth="' + maskeditRandRL.Text + '" ';
  defstr := defstr + 'marginheight="' + maskeditRandOU.Text + '"';
  EditFramedefinition.Text := defstr;
end;

function TFrameEditForm.getArg (Argname: String): String;
VAR argpos:   Integer;
    i:        Integer;
    arg:      String;
BEGIN
  Result := '';
  WITH EditFramedefinition DO BEGIN
    argpos := upPos (Argname, Text);
//showMessage ('getArg ' + Token + ', ' + IntToStr (argpos));
    IF argpos > 0 THEN BEGIN
      i := argpos + 1;
      WHILE (Text [i] <> '"') AND (i < Length (Text)) DO
        INC (i);
      IF Text [i] = '"' THEN BEGIN
        INC (i); arg := '';
        WHILE (Text [i] <> '"') AND (i <= Length (Text)) DO BEGIN
          arg := arg + Text [i]; INC (i);
        END (* WHILE *);
        IF Text [i] <> '"' THEN showMessage ('Bei Argument von ' + Argname +
                                             ' fehlt schliessendes "');
        Result := arg;
      END (* IF Text [i] *);
    END (* IF argpos > 0 *);
  END (* WITH *);
END (* getArg *);

procedure TFrameEditForm.FormActivate(Sender: TObject);
VAR  arg:     String;
begin
  IF EditFramedefinition.Text <> '' THEN WITH EditFramedefinition DO BEGIN
    EditName.Text := getArg ('name');
    EditURL.Text := getArg ('src');
    CheckboxResize.checked :=  upPos ('noresize', Text) > 0;
    arg := getArg ('scrolling');
    IF arg <> '' THEN BEGIN
      IF arg = 'auto' THEN RadioGroupRollmodus.ItemIndex := 0
      ELSE IF arg = 'yes' THEN RadioGroupRollmodus.ItemIndex := 1
      ELSE IF arg = 'no' THEN RadioGroupRollmodus.ItemIndex := 2;
    END (* IF arg *);

    arg := getArg ('frameborder');
    CheckBoxFramekante.checked := (arg = '1') OR (arg = '');;

    arg := getArg ('marginwidth');
    IF arg <> '' THEN maskEditRandRL.Text := arg;
    arg := getArg ('marginheight');
    IF arg <> '' THEN maskEditRandOU.Text := arg;
  END (* WITH *)
  ELSE showMessage ('EditFramedefinition leer');
end;

procedure TFrameEditForm.ButtonNurDateiClick(Sender: TObject);
begin
  EditURL.Text := ExtractFileName (EditURL.Text); 
end;


procedure TFrameEditForm.ButtonOkClick(Sender: TObject);
begin
  ButtonDefinierenClick (Sender);
end;

end.
