unit IExplorer;

(* 01. 11. 1997 *)
(* 25. 11. 1998 *)

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  OleCtrls, Menus, {IEPOPObjects_TLB,} StdCtrls, ExtCtrls,
  Buttons, ComCtrls, ToolWin, SHDocVw_TLB, ActiveX;

type
  TIExplorerForm = class(TForm)
    MainMenuIExplorer: TMainMenu;
    Hilfe: TMenuItem;
    WebBrowser1: TWebBrowser;
    Panel1: TPanel;
    Label1: TLabel;
    ComboBoxURL: TComboBox;
    Merkliste1: TMenuItem;
    N1: TMenuItem;
    SpeedButtonBrowse: TSpeedButton;
    SpeedButtonRefresh: TSpeedButton;
    SpeedButtonBack: TSpeedButton;
    SpeedButtonForward: TSpeedButton;
    SpeedButtonStop: TSpeedButton;
    Datei1: TMenuItem;
    Dateiladen1: TMenuItem;
    InMerkliste1: TMenuItem;
    StatusPanel: TPanel;
    N2: TMenuItem;
    Drucken1: TMenuItem;
    Dateispeichern1: TMenuItem;
    Dateispeichernunter1: TMenuItem;
    Druckvorschau1: TMenuItem;
    Einstellungen1: TMenuItem;
    Statusbar1: TMenuItem;
    Menubar1: TMenuItem;
    Toolbar1: TMenuItem;
    PopupMenuIExplorer: TPopupMenu;
    Datei2: TMenuItem;
    HTMLDateiladen1: TMenuItem;
    Quelltexteditieren2: TMenuItem;
    Dateispeichern2: TMenuItem;
    Dateispeichernunter2: TMenuItem;
    Drucken2: TMenuItem;
    Druckvorschau2: TMenuItem;
    Merkliste2: TMenuItem;
    InMerkliste2: TMenuItem;
    N3: TMenuItem;
    AusMerklisteloeschen1: TMenuItem;
    SpeedButtonWebbrowser: TSpeedButton;
    SpeedButtonMail: TSpeedButton;
    Mailer1: TMenuItem;
    N4: TMenuItem;
    SpeedButtonGoHome: TSpeedButton;
    SpeedButtonGoSearch: TSpeedButton;
    About1: TMenuItem;
    Hilfe1: TMenuItem;
    Druckerdialog1: TMenuItem;
    Druckerdialog2: TMenuItem;
    PanelProgressbar: TPanel;
    LabelLoadProzent: TLabel;
    ProgressBarLoadpage: TProgressBar;
    PanelStatus: TPanel;
    SpeedButtonPrint: TSpeedButton;
    N5: TMenuItem;
    OnlineOffline1: TMenuItem;
    PopupMenuURLCombo: TPopupMenu;
    Ausschneiden1: TMenuItem;
    Kopieren1: TMenuItem;
    Einfuegen1: TMenuItem;
    Loeschen1: TMenuItem;
    N6: TMenuItem;
    Allesauswaehlen1: TMenuItem;
    Bookmarks2: TMenuItem;
    Adressbuch1: TMenuItem;
    Tools1: TMenuItem;
    Bookmarks1: TMenuItem;
    Adressbuch2: TMenuItem;
    N7: TMenuItem;
    Magic1: TMenuItem;
    Quelltextanzeigen1: TMenuItem;
    N8: TMenuItem;
    TheaterModus1: TMenuItem;
    N9: TMenuItem;
    Edit1: TMenuItem;
    Quelltexteditieren1: TMenuItem;
    MerklisteEditieren1: TMenuItem;
    Bookmarkseditieren1: TMenuItem;
    Adressbucheditieren1: TMenuItem;
    Merklisteneuladen1: TMenuItem;
    Merklisteanzeigen1: TMenuItem;
    Merklisteanzeigen2: TMenuItem;
    SpeedButtonMerkliste: TSpeedButton;
    SpeedButtonOnOffline: TSpeedButton;
    SaveHomepage: TMenuItem;
    Invisible1: TMenuItem;
    N10: TMenuItem;
    Ansicht1: TMenuItem;
    Schnellschaltleiste1: TMenuItem;
    Statusleiste1: TMenuItem;
    Menueleiste1: TMenuItem;
    Ansicht2: TMenuItem;
    Menueleiste2: TMenuItem;
    Statusleiste2: TMenuItem;
    Schnellschaltleiste2: TMenuItem;
    Panorama1: TMenuItem;
    Panorama2: TMenuItem;
    N11: TMenuItem;
    Sitzungspeichern1: TMenuItem;
    Sitzungladen1: TMenuItem;
    N12: TMenuItem;
    Eventsanzeigen1: TMenuItem;
    Befehletesten1: TMenuItem;
    N13: TMenuItem;
    Suchen1: TMenuItem;
    Quelltextdarstellen1: TMenuItem;
    SpeedButtonFind: TSpeedButton;
    SpeedButtonInternetoptionen: TSpeedButton;
    N14: TMenuItem;
    Sitzungspeichern2: TMenuItem;
    Sitzungladen2: TMenuItem;
    N15: TMenuItem;
    InternetOptionen1: TMenuItem;
    SpeedButtonGoSLRE: TSpeedButton;
    procedure ButtonLoadClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure GeheZuMerker(Sender: TObject);
    procedure SpeedButtonRefreshClick(Sender: TObject);
    procedure SpeedButtonBackClick(Sender: TObject);
    procedure SpeedButtonForwardClick(Sender: TObject);
    procedure SpeedButtonStopClick(Sender: TObject);
    procedure Dateiladen1Click(Sender: TObject);
    procedure InMerkliste1Click(Sender: TObject);
    procedure WebBrowser1DownloadBegin(Sender: TObject);
    procedure WebBrowser1DocumentComplete(Sender: TObject;
      pDisp: IDispatch; var URL: OleVariant);
    procedure WebBrowser1DownloadComplete(Sender: TObject);
    procedure Drucken1Click(Sender: TObject);
    procedure Quelltexteditieren1Click(Sender: TObject);
    procedure Dateispeichern1Click(Sender: TObject);
    procedure Dateispeichernunter1Click(Sender: TObject);
    procedure Druckvorschau1Click(Sender: TObject);
    procedure ComboBoxURLKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure AusMerklisteloeschen1Click(Sender: TObject);
    procedure SpeedButtonWebbrowserClick(Sender: TObject);
    procedure SpeedButtonMailClick(Sender: TObject);
    procedure Mailer1Click(Sender: TObject);
    procedure WebBrowser1ProgressChange(Sender: TObject; Progress,
      ProgressMax: Integer);
    procedure SpeedButtonGoHomeClick(Sender: TObject);
    procedure SpeedButtonGoSearchClick(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure Hilfe1Click(Sender: TObject);
    procedure WebBrowser1CommandStateChange(Sender: TObject;
      Command: Integer; Enable: WordBool);
    procedure Druckerdialog1Click(Sender: TObject);
    procedure WebBrowser1StatusTextChange(Sender: TObject;
      const Text: WideString);
    procedure WebBrowser1TitleChange(Sender: TObject;
      const Text: WideString);
    procedure OnlineOffline1Click(Sender: TObject);
    procedure WebBrowser1NavigateComplete2(Sender: TObject;
      pDisp: IDispatch; var URL: OleVariant);
    procedure Ausschneiden1Click(Sender: TObject);
    procedure Kopieren1Click(Sender: TObject);
    procedure Einfuegen1Click(Sender: TObject);
    procedure Bookmarks2Click(Sender: TObject);
    procedure Adressbuch1Click(Sender: TObject);
    procedure Bookmarks1Click(Sender: TObject);
    procedure Adressbuch2Click(Sender: TObject);
    procedure Magic1Click(Sender: TObject);
    procedure QuelltextTestClick(Sender: TObject);
    procedure Offlineschalten1Click(Sender: TObject);
    procedure TheaterModus1Click(Sender: TObject);
    procedure MerklisteEditieren1Click(Sender: TObject);
    procedure Bookmarkseditieren1Click(Sender: TObject);
    procedure Adressbucheditieren1Click(Sender: TObject);
    procedure Merklisteneuladen1Click(Sender: TObject);
    procedure Merklisteanzeigen1Click(Sender: TObject);
    procedure WebBrowser1PropertyChange(Sender: TObject;
      const szProperty: WideString);
    procedure SpeedButtonOnOfflineClick(Sender: TObject);
    procedure Datei1Click(Sender: TObject);
    procedure SaveHomepageClick(Sender: TObject);
    procedure Invisible1Click(Sender: TObject);
    procedure Schnellschaltleiste1Click(Sender: TObject);
    procedure Statusleiste1Click(Sender: TObject);
    procedure Menueleiste1Click(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure Panorama1Click(Sender: TObject);
    procedure Ansicht2Click(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
//    procedure Quelltextanzeigen1Click(Sender: TObject);
    procedure Sitzungspeichern1Click(Sender: TObject);
    procedure Sitzungladen1Click(Sender: TObject);
    procedure Eventsanzeigen1Click(Sender: TObject);
    procedure WebBrowser1BeforeNavigate2(Sender: TObject; pDisp: IDispatch;
      var URL, Flags, TargetFrameName, PostData, Headers: OleVariant;
      var Cancel: WordBool);
    procedure WebBrowser1Quit(Sender: TObject);
    procedure Tools1Click(Sender: TObject);
    procedure Befehletesten1Click(Sender: TObject);
    procedure Suchen1Click(Sender: TObject);
    procedure InternetOptionen1Click(Sender: TObject);
    procedure Quelltextdarstellen1Click(Sender: TObject);
    procedure WebBrowser1NewWindow2(Sender: TObject; var ppDisp: IDispatch;
      var Cancel: WordBool);
    procedure FormActivate(Sender: TObject);
    procedure FormDeactivate(Sender: TObject);
    procedure SpeedButtonGoSLREClick(Sender: TObject);
  private
    { Private-Deklarationen }
    EventsAnzeigen: BOOLEAN;
    MailerName: String;
    BookName:   String;
    AdressName: String;
    Dateiname:  String;
    HomeName:   String;
    SLREName:   String;
    Pfad:       String;
    OnlineBit:  TBitMap;
    OfflineBit: TBitMap;
    FEventProtokoll: TForm;
    FBefehlsProtokoll: TForm;

    FOleInPlaceActiveObject: IOleInPlaceActiveObject;

    Procedure MyMessageHandler (Var Msg: TMsg; Var Handled: Boolean);
    procedure InvokeOleCMD (Value1, Value2: Integer);
    procedure NewWindow(Sender: TObject; const URL: WideString; Flags: Integer;
      const TargetFrameName: WideString; var PostData: OleVariant;
      const Headers: WideString; var Processed: WordBool);

    function readEProt: TForm;
    procedure writeEProt (p: TForm);
    function readBProt: TForm;
    procedure writeBProt (p: TForm);
//    function SelectWindow: OleVariant;
    procedure EventProt (s: String);
    procedure ExecWB2 (nCmdID: Integer; CONST vaIn: OleVariant;
                       VAR vaOut: OleVariant);
  public
    { Public-Deklarationen }
    Merkliste: TStringList;
    SourceEditor: TForm;
    property EventProtokoll: TForm read readEProt write writeEProt;
    property BefehlsProtokoll: TForm read readBProt write writeBProt;
    function cleanLocation (l: String): String;
  end;

var
  IExplorerForm: TIExplorerForm;

implementation

uses SLREdit, SmallLittleFrame, SDateimanager, comobj, MyFmxUtils, Clipbrd,
  StringForm;
{$R *.DFM}

CONST CMaxMerker = 500;

TYPE
  eSaveException = class (Exception)
  END (* eSaveException *);

function TIExplorerForm.readEProt: TForm;
begin
  Result := FEventProtokoll;
end (* readProt *);

procedure TIExplorerForm.writeEProt (p: TForm);
begin
  FEventProtokoll := p;
  EventsAnzeigen := p <> NIL;
end (* writeProt *);

function TIExplorerForm.readBProt: TForm;
begin
  Result := FBefehlsProtokoll;
end (* readProt *);

procedure TIExplorerForm.writeBProt (p: TForm);
begin
  FBefehlsProtokoll := p;
end (* writeProt *);

function NoParam: OleVariant; (* Useful function for optional parameters *)
begin
  TVarData (Result).VType := varError;
  TVarData (Result).VError := DISP_E_PARAMNOTFOUND;
end (* NoParam *);

CONST navOpenInNewWindow = 1;
      navNoHistory =       2;
      navNoReadFromCache = 4;
      navNoWriteToCache =  8;

procedure TIExplorerForm.ButtonLoadClick(Sender: TObject);
VAR Flags, TargetFrameName, PostData, Headers: OleVariant;
begin
  Flags := 0; //NoParam;
  TargetFrameName := 0; //NoParam;
  PostData := 0; //NoParam;
  Headers := 0; //NoParam;
//  Flags := navNoReadFromCache;
  TRY
    WebBrowser1.Navigate (ComboBoxURL.Text, Flags, TargetFrameName, PostData, Headers);
  EXCEPT
    showMessage ('Kann Adresse oder Datei "' + ComboBoxURL.Text + '" nicht finden!' +
      crlf + 'Lokale Dateien mssen zur Anzeige gespeichert werden!');
  END;
end;

procedure TIExplorerForm.FormCreate(Sender: TObject);
VAR  MailerFile: TextFile;
     BookFile:   TextFile;
     AdressFile: TextFile;
     HomeFile:   TextFile;
     Flags, TargetFrameName, PostData, Headers: OleVariant;
begin
//  Web_V1 := TWebBrowser_V1.Create (Self);
//  Web_V1 := TWebBrowser_V1 (WebBrowser1);
//  Web_V1.OnNewWindow := NewWindow;
  Caption := 'SLRE Webbrowser mit MS Internet Explorer';
  MerkListe := TStringList.Create;
  MerkListe.Sorted := TRUE;
  IF FileExists (ChangeFileExt (Application.Exename, '.BOK')) THEN BEGIN
    MerkListe.LoadFromFile (ChangeFileExt (Application.Exename, '.BOK'));
  END (* IF *);
  IF FileExists (ChangeFileExt (Application.Exename, '.MAI')) THEN BEGIN
    AssignFile (MailerFile, ChangeFileExt (Application.Exename, '.MAI'));
    Reset (MailerFile);
    Read (MailerFile, MailerName);
    CloseFile (MailerFile);
  END
  ELSE BEGIN
    MailerName := '';
  END (* IF *);

  IF FileExists (ChangeFileExt (Application.Exename, '.BOO')) THEN BEGIN
    AssignFile (BookFile, ChangeFileExt (Application.Exename, '.BOO'));
    Reset (BookFile);
    Read (BookFile, BookName);
    CloseFile (BookFile);
  END
  ELSE BEGIN
    BookName := '';
  END (* IF *);

  IF FileExists (ChangeFileExt (Application.Exename, '.ADR')) THEN BEGIN
    AssignFile (AdressFile, ChangeFileExt (Application.Exename, '.ADR'));
    Reset (AdressFile);
    Read (AdressFile, AdressName);
    CloseFile (AdressFile);
  END
  ELSE BEGIN
    AdressName := '';
  END (* IF *);
  OfflineBit := TBitmap.Create;
  OnlineBit := TBitmap.Create;
  IF FileExists (ExtractFilePath (Application.Exename) + 'LED2OFF.BMP') THEN
    OfflineBit.LoadFromFile (ExtractFilePath (Application.Exename) + 'LED2OFF.BMP');
  IF FileExists (ExtractFilePath (Application.Exename) + 'LED2ON.BMP') THEN
    OnlineBit.LoadFromFile (ExtractFilePath (Application.Exename) + 'LED2ON.BMP');
  IF WebBrowser1.Offline THEN SpeedButtonOnOffline.Glyph := OfflineBit
  ELSE SpeedButtonOnOffline.Glyph := OnlineBit;

  SourceEditor := NIL;
  FBefehlsProtokoll := NIL; FEventProtokoll := NIL;

  Flags := 0; //NoParam;
  TargetFrameName := 0; //NoParam;
  PostData := 0; //NoParam;
  Headers := 0; //NoParam;
  WebBrowser1.Navigate ('about:blank', Flags, TargetFrameName, PostData, Headers);

{  while Webbrowser1.ReadyState <> READYSTATE_COMPLETE DO
    while PeekMessage(Msg, 0, 0, 0, pm_Remove) do begin
      TranslateMessage(Msg);
      DispatchMessage(Msg);
    end;
}
//  LRFrame.warte (1000);

  IF FileExists (ChangeFileExt (Application.Exename, '.HOME')) THEN BEGIN
    AssignFile (HomeFile, ChangeFileExt (Application.Exename, '.HOME'));
    Reset (HomeFile);
    Read (HomeFile, HomeName);
//    ComboBoxURL.Text := HomeName;
    CloseFile (HomeFile);
  END
  ELSE BEGIN
    HomeName := 'http://home.t-online.de/home/Johannes.Leckebusch/homepage.htm';
  END;
  IF FileExists (ChangeFileExt (Application.Exename, '.SLRE')) THEN BEGIN
    AssignFile (HomeFile, ChangeFileExt (Application.Exename, '.SLRE'));
    Reset (HomeFile);
    Read (HomeFile, SLREName);
//    ComboBoxURL.Text := HomeName;
    CloseFile (HomeFile);
  END
  ELSE BEGIN
    SLREName := 'http://home.t-online.de/home/Johannes9.Leckebusch/slre.htm';
  END;

end (* FormCreate *);

procedure TIExplorerForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
VAR  MailerFile: TextFile;
     BookFile:   TextFile;
     AdressFile: TextFile;
begin
  MerkListe.SaveToFile (ChangeFileExt (Application.ExeName, '.BOK'));
  MerkListe.Free;

  IF MailerName <> '' THEN BEGIN
    AssignFile (MailerFile, ChangeFileExt (Application.Exename, '.MAI'));
    Rewrite (MailerFile);
    Write (MailerFile, MailerName);
    CloseFile (MailerFile);
  END (* IF *);

  IF BookName <> '' THEN BEGIN
    AssignFile (BookFile, ChangeFileExt (Application.Exename, '.BOO'));
    Rewrite (BookFile);
    Write (BookFile, BookName);
    CloseFile (BookFile);
  END (* IF *);

  IF AdressName <> '' THEN BEGIN
    AssignFile (AdressFile, ChangeFileExt (Application.Exename, '.ADR'));
    Rewrite (AdressFile);
    Write (AdressFile, AdressName);
    CloseFile (AdressFile);
  END (* IF *);
{$IFDEF Explorer}
  IF LRFrame.MyExplorer = SELF THEN LRFrame.MyExplorer := NIL;
  IF SourceEditor <> NIL THEN WITH SourceEditor AS TEditForm DO Hypertext := NIL;
  IF FEventProtokoll <> NIL THEN WITH EventProtokoll AS TEditForm DO HypertextP := NIL;
  IF FBefehlsProtokoll <> NIL THEN WITH BefehlsProtokoll AS TEditForm DO HypertextB := NIL;
{$ENDIF}
end (* FormClose *);

procedure TIExplorerForm.GeheZuMerker(Sender: TObject);
VAR Ole:  OleVariant;
begin
  WITH Sender AS TMenuItem DO BEGIN
    Ole := 0;
    WebBrowser1.Navigate (Caption, Ole, Ole, Ole, Ole);
  END (* WITH *);
end;

CONST Refresh_Normal =     0;
      Refresh_IfExpired =  1;
      Refresh_Completely = 3;

procedure TIExplorerForm.SpeedButtonRefreshClick(Sender: TObject);
VAR level: OleVariant;
begin
  TRY
    level := Refresh_Completely;
//    WebBrowser1.Refresh;
    WebBrowser1.Refresh2 (level);
  EXCEPT
    ON EOleException DO showMessage ('Nichts nachzuladen');
  END;
end;

procedure TIExplorerForm.SpeedButtonBackClick(Sender: TObject);
begin
  TRY
    WebBrowser1.GoBack;
  EXCEPT
    ON EOleException DO showMessage ('Kann nicht zurckgehen');
  END;
end;

procedure TIExplorerForm.SpeedButtonForwardClick(Sender: TObject);
begin
  TRY
    WebBrowser1.GoForward;
  EXCEPT
    ON EOleException DO showMessage ('Kann nicht vorwrtsgehen');
  END;
end;

procedure TIExplorerForm.SpeedButtonStopClick(Sender: TObject);
begin
  WebBrowser1.Stop;
end;

procedure TIExplorerForm.Dateiladen1Click(Sender: TObject);
VAR FileN:  String;
    mr:     TModalResult;
    DatMan: TDateiManagerForm;
begin
  DatMan := TDateiManagerForm.ECreate (Self, FALSE, TRUE, 'HTML-Datei laden', 'In Webbrowser laden', '',
             '*.HTM', LRFrame.Konfig.DateifilterIndex, TRUE, TRUE, FALSE, FALSE);
  WITH DatMan AS TDateiManagerForm DO BEGIN
    mr := ShowModal;
    IF mr = mrOk THEN BEGIN
      FileN := DateiAuswahl;
      IF (Length (FileN) > 2) AND (FileN [2] = ':') THEN
        FileN [2] := '|';
        ComboBoxURL.Text := ('file:///' + FileN);
        ButtonLoadClick (Sender);
    END (* IF mrOk *);
    Release;
  END (* WITH *);
end (* Dateiladen1Click *);

procedure TIExplorerForm.InMerkliste1Click(Sender: TObject);
VAR Index: Integer;
begin
  WITH MerkListe DO BEGIN
    Index := IndexOf (ComboBoxURL.Text);
    IF Index <> -1 THEN Delete (Index);
    IF Count >= CMaxMerker THEN Delete (Count - 1);
    Add (ComboBoxURL.Text);
  END (* WITH *);
end (* InMerkliste1Click *);

procedure TIExplorerForm.WebBrowser1DownloadBegin(Sender: TObject);
begin
  IF EventsAnzeigen THEN
    EventProt ('OnDownloadBegin');
  SpeedButtonFind.Enabled := FALSE;
  SpeedButtonInternetOptionen.Enabled := FALSE;
  SpeedButtonStop.Enabled := TRUE;
  SpeedButtonRefresh.Enabled := TRUE;
end;

function TIExplorerForm.cleanLocation (l: String): String;
// Explorer gibt z. B. Blanks in Dateinamen als %20 an!
// sollte noch so gendert werden, da auch andere Zeichen ersetzt werden?
VAR  i:    Integer;
begin
  i := pos ('%', l);
  WHILE i > 0 DO BEGIN
    Delete (l, i, 3);
    Insert (' ',  l, i);
    i := pos ('%', l);
  END (* WHILE *);
  Result := l;
end (* cleanLocation *);

procedure TIExplorerForm.WebBrowser1DocumentComplete(Sender: TObject;
  pDisp: IDispatch; var URL: OleVariant);
VAR location: String;
begin
  IF EventsAnzeigen THEN
    EventProt ('OnDocumentComplete: "' + URL + '"');
  location := cleanLocation (WebBrowser1.LocationURL);
  ComboBoxURL.Text := location;
end (* WebBrowser1DocumentComplete *);

procedure TIExplorerForm.WebBrowser1DownloadComplete(Sender: TObject);
begin
  IF EventsAnzeigen THEN
    EventProt ('OnDownloadComplete');
  SpeedButtonStop.Enabled := FALSE;
  SpeedButtonFind.Enabled := TRUE;
  SpeedButtonInternetOptionen.Enabled := TRUE;
end;

function stripURL (CONST url: String): String;
VAR i:    INTEGER;
BEGIN
  IF pos ('file:', url) = 1 THEN BEGIN
    Result := Copy (url, Length ('file:') + 4, Length (url));
  END ELSE IF pos ('http:', url) = 1 THEN BEGIN
    Result := Copy (url, Length ('http:') + 3, Length (url));
  END
  ELSE Result := url;
  FOR i := 1 TO Length (Result) DO
    IF Result [i] = '/' THEN Result [i] := '\';
END (* stripURL *);

procedure TIExplorerForm.Quelltexteditieren1Click(Sender: TObject);
begin
  IF NOT (pos ('file:', cleanLocation (Webbrowser1.LocationURL)) = 1)
    THEN BEGIN
      try
// Lassen wir dem Benutzer die Wahl, wo die HTML-Datei abgelegt werden soll
        DateiSpeichernunter1Click (Sender);
        // Legt Dateiname an!
  //     DateiSpeichern1Click (Sender);
      except
        on eSaveException do begin
          showMessage ('Kann HTML-Seite "' + Webbrowser1.LocationURL +
                       '" nicht speichern');
          Exit;
        end (* on *);
      end (* try *);
    END
    ELSE Dateiname := stripURL (cleanLocation (Webbrowser1.LocationURL));

  IF SourceEditor = NIL THEN BEGIN
    SourceEditor := TEditForm.Create (LRFrame);
{$IFDEF Explorer}
    WITH SourceEditor AS TEditForm DO Hypertext := Self;
{$ENDIF}
  END;

  WITH SourceEditor AS TEditForm DO BEGIN
    with Editor do begin
      PfadName := Dateiname;
// showMessage ('Quelltext editieren: ' + PfadName);
      NeuOeffnen1Click (Sender);
      Caption := PfadName;
      Modified := FALSE;

    END (* with Editor *);
    BringToFront;
  END (* WITH *);
  LRFrame.BringToFront;
end (* QuelltextEditieren *);

procedure TIExplorerForm.Dateispeichern1Click(Sender: TObject);
VAR  pvaIn, pvaOut: OleVariant;
     eQuery:        OLECMDF;
begin
  pvaIn := 0; pvaOut := 0;
  WITH WebBrowser1 DO BEGIN
    try
// Prfen, ob der Befehl momentan ausfhrbar ist
      eQuery := QueryStatusWB (OLECMDID_SAVE);
      IF eQuery = OLECMDF_ENABLED THEN
        ExecWB (OLECMDID_SAVE, OLECMDEXECOPT_DODEFAULT, pvaIn, pvaOut)
      ELSE showMessage ('Kann nichts speichern');
    except
      showMessage ('Fehler beim Speichern');
    end (* try *);
  END (* WITH *);
end (* Dateispeichern *);

procedure TIExplorerForm.Dateispeichernunter1Click(Sender: TObject);
VAR  pvaIn, pvaOut:     OleVariant;
     eQuery:            OLECMDF;
     mr:                TModalResult;
     DatMan:            TDateiManagerForm;
     WideName:          WideString; //PWideChar;
begin
  pvaIn := 0; pvaOut := 0;
  WITH WebBrowser1 DO BEGIN
    try
// Prfen, ob der Befehl momentan ausfhrbar ist
      eQuery := QueryStatusWB (OLECMDID_SAVE);
      IF eQuery = OLECMDF_ENABLED THEN BEGIN
//        ExecWB (OLECMDID_SAVEAS, OLECMDEXECOPT_PROMPTUSER, pvaIn, pvaOut);
//        Dateiname := pvaOut;
//showMessage (Dateiname);
        Dateiname := stripURL (cleanLocation (Webbrowser1.LocationURL));
// Wir mssen den Webpfad http://xxx.yyy.zzz. usw. entfernen,
// brauchen aber das aktuelle Plattenverzeichnis, unter dem die
// Seite abgespeichert wurde:
        getdir (0, pfad);
        Dateiname :=  pfad + '\' + ExtractFileName (Dateiname);
        DatMan := TDateiManagerForm.ECreate (Self, FALSE, TRUE, 'Als HTML-Doc speichern',
                  'Dokument speichern', Dateiname,
                   '*.HTM', LRFrame.Konfig.DateifilterIndex, FALSE, FALSE, TRUE, TRUE);
        WITH DatMan AS TDateiManagerForm DO BEGIN
          mr := ShowModal;
          IF mr = mrOk THEN BEGIN
            Dateiname := DateiAuswahl;
          END (* IF mrOk *);
          Release;
        END (* WITH *);

//showMessage ('Datei speichern unter: ' + Dateiname);

       WideName := Dateiname;
       (WebBrowser1.Document as IPersistFile).Save (PWideChar (WideName), TRUE);
      END
      ELSE BEGIN
        raise eSaveException.Create ('Kann keine Webdatei speichern');
      END (* ELSE *);
    except
      on eSaveException do begin
        raise;
      end;
    end (* try *);
  END (* WITH *);
//  WebBrowser1.ExecWB (OLECMDID_SAVEAS, OLECMDEXECOPT_DODEFAULT, pvaIn, pvaOut);
end;

procedure TIExplorerForm.Druckvorschau1Click(Sender: TObject);
//VAR  pvaIn, pvaOut: OleVariant;
//     eQuery:        OLECMDF;
begin
  InvokeOleCMD (OLECMDID_PRINTPREVIEW, OLECMDEXECOPT_DODEFAULT);

{  pvaIn := 0 (*NoParam*); pvaOut := 0 (*NoParam*);
//  WebBrowser1.ExecWB (OLECMDID_PRINTPREVIEW, OLECMDEXECOPT_DODEFAULT, pvaIn, pvaOut);
  WITH WebBrowser1 DO BEGIN
    try
// Prfen, ob der Befehl momentan ausfhrbar ist
      eQuery := QueryStatusWB (OLECMDID_PRINTPREVIEW);
      IF eQuery = OLECMDF_ENABLED THEN
        ExecWB (OLECMDID_PRINTPREVIEW, OLECMDEXECOPT_DODEFAULT, pvaIn, pvaOut)
      ELSE showMessage ('Druckvorschau nicht mglich');
    except
      showMessage ('Fehler bei Druckvorschau');
    end (* try *);
  END (* WITH *);

//  WebBrowser1.ExecWB (OLECMDID_PRINTPREVIEW, OLECMDEXECOPT_DONTPROMPTUSER, pvaIn, pvaOut);
}
end;

procedure TIExplorerForm.ComboBoxURLKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_Return then BEGIN
    IF ComboBoxURL.text = '' THEN EXIT;
    if ComboBoxURL.Items.IndexOf (ComboBoxURL.Text) = -1 then
      ComboBoxURL.Items.Insert (0, ComboBoxURL.Text);
    ButtonLoadClick (Sender);
  END (* IF *);
end;

procedure TIExplorerForm.AusMerklisteloeschen1Click(Sender: TObject);
VAR Index: Integer;
begin
  WITH MerkListe DO BEGIN
    Index := IndexOf (ComboBoxURL.Text);
    IF Index <> -1 THEN Delete (Index);
  END (* WITH *);
end;

procedure TIExplorerForm.SpeedButtonWebbrowserClick(Sender: TObject);
begin
  WITH TIExplorerForm.Create (Self) DO BEGIN
      ComboBoxURL.text := SELF.ComboBoxURL.text;
      ButtonLoadClick (Sender);
      WindowState := wsNormal; BringToFront;
  END (* WITH *)
end;

procedure TIExplorerForm.SpeedButtonMailClick(Sender: TObject);
begin
  IF MailerName = '' THEN Mailer1Click (Sender);
  IF MailerName <> '' THEN ExecuteFile (MailerName, '', '', SW_SHOW);
end;

procedure TIExplorerForm.Mailer1Click(Sender: TObject);
VAR mr:     TModalResult;
    DatMan: TDateiManagerForm;
begin
  DatMan := TDateiManagerForm.ECreate (Self, FALSE, TRUE, 'Mailprogramm suchen',
            'Als Mailprogramm eintragen', MailerName, '*.EXE',
             LRFrame.Konfig.DateifilterIndex, TRUE, TRUE, FALSE, FALSE);
  WITH DatMan AS TDateiManagerForm DO BEGIN
    mr := ShowModal;
    IF mr = mrOk THEN BEGIN
      MailerName := ComboBoxDateiauswahlHistory.Text;
    END (* IF mrOk *);
    Release;
  END (* WITH *);
end;

procedure TIExplorerForm.WebBrowser1ProgressChange(Sender: TObject;
  Progress, ProgressMax: Integer);
VAR Prozent: Integer;
begin
  IF EventsAnzeigen THEN BEGIN
    IF ProgressMax <> 0 THEN Prozent := Progress * 100 DIV ProgressMax
    ELSE Prozent := 0;
    EventProt ('OnProgressChange: Progress = ' + IntToStr (Progress) +
               ', Max: ' + IntToStr (ProgressMax) + ', ' + IntToStr (Prozent) + '%');
  END (* IF *);
  IF ProgressMax = 0 THEN BEGIN
    LabelLoadProzent.Caption := '';
    ProgressBarLoadpage.Visible := FALSE;
  END
  ELSE BEGIN
    LabelLoadProzent.Caption := IntToStr ((Progress * 100) DIV ProgressMax) + '% ';
    ProgressBarLoadpage.Visible := TRUE;
  END;
  ProgressBarLoadpage.Max := ProgressMax;
  ProgressBarLoadpage.Position := Progress;
end;

procedure TIExplorerForm.SpeedButtonGoHomeClick(Sender: TObject);
begin
//  WebBrowser1.GoHome;
  ComboBoxURL.Text := HomeName;
  ButtonLoadClick (Sender);
end;

procedure TIExplorerForm.SpeedButtonGoSearchClick(Sender: TObject);
begin
  WebBrowser1.GoSearch;
end;

procedure TIExplorerForm.About1Click(Sender: TObject);
begin
//  WebBrowser1.ShowAboutBox;
  showMessage ('Dies ist ein SLRE-Fenster mit eingebettetem MS-Internet-Webbrowser');
end;

procedure TIExplorerForm.Hilfe1Click(Sender: TObject);
VAR HelpCtx:  Integer;
    Helpfile: String;
    Member:   String;
begin
{  Member := ''; //'TWebBrowser';
  WebBrowser1.GetHelpContext (Member, HelpCtx, Helpfile);
  showMessage (Helpfile);
}
  showMessage ('Hier soll noch eine Hypertext-Hilfe eingebaut werden');
end;

procedure TIExplorerForm.WebBrowser1CommandStateChange(Sender: TObject;
  Command: Integer; Enable: WordBool);
VAR bol: String;
begin
  IF EventsAnzeigen THEN BEGIN
    IF Enable THEN bol := 'TRUE' ELSE bol := 'FALSE';
    EventProt ('OnCommandStateChange: ' + IntToStr (Command) + ' = ' + bol);
  END (* IF *);
  CASE Command OF
    CSC_NAVIGATEFORWARD: SpeedButtonForward.Enabled := Enable;
    CSC_NAVIGATEBACK: SpeedButtonBack.Enabled := Enable;
  END (* CASE *);
end;

procedure TIExplorerForm.InvokeOleCMD (Value1, Value2: Integer);
(* bermittelt von Henri Fournier in Borland.Public.Delphi.Internet *)
VAR CmdTarget:        IOleCommandTarget;
    vaIn, vaOut:      OleVariant;
begin
  WITH WebBrowser1 DO BEGIN
    IF Document <> NIL THEN
      TRY
        Document.QueryInterface (IOleCommandTarget, CmdTarget);
        IF CmdTarget <> NIL THEN
          TRY
            CmdTarget.Exec (PGuid (NIL), Value1, Value2, VaIn, VaOut);
          FINALLY
            CmdTarget._Release;
          END (* TRY *);
      EXCEPT
        // Nothing
      END (* TRY *);
  END (* WITH *);
end (* InvokeOleCMD *);

procedure TIExplorerForm.Drucken1Click(Sender: TObject);
begin
  InvokeOleCMD (OLECMDID_PRINT, OLECMDEXECOPT_DONTPROMPTUSER);
end;

procedure TIExplorerForm.Druckerdialog1Click(Sender: TObject);
{VAR eQuery:           OLECMDF;
    Question:         OLEVariant;
    nothing:          OLEVariant;
}
begin
  InvokeOleCMD (OLECMDID_PRINT, OLECMDEXECOPT_PROMPTUSER);

// Der folgende Code ergibt einen Fehler, wenn der Benutzer im Dialogfenster
// auf "Abbrechen" klickt
{  Question := ''; // 'Bereit zum Drucken?';
  nothing := '';
  WITH WebBrowser1 DO BEGIN
    try
// Prfen, ob der Befehl momentan ausfhrbar ist
      eQuery := ControlInterface.QueryStatusWB (OLECMDID_PRINT);
      if eQuery = OLECMDF_ENABLED then
        ControlInterface.ExecWB (OLECMDID_PRINT, OLECMDEXECOPT_PROMPTUSER,
                nothing, Question)
      else showMessage ('Kann nichts drucken!');
    except
      showMessage ('Fehler beim Drucken');
    end (* try *);
  END (* WITH *);
}
end;

procedure TIExplorerForm.WebBrowser1StatusTextChange(Sender: TObject;
  const Text: WideString);
begin
  IF EventsAnzeigen THEN
    WITH Webbrowser1 DO BEGIN
      EventProt ('OnStatusTextChange "' + Text + '"'
      + crlf + '  Location Name: "' + LocationName + '"'
      + crlf + '  Location URL: "' + LocationURL + '"'
//      + crlf + 'Name: "' + Name + '"'
//      + crlf + 'Path: "' + Path + '"'
      );
    END (* WITH *);
  IF Text <> '' THEN PanelStatus.Caption := Text;
end;

procedure TIExplorerForm.WebBrowser1TitleChange(Sender: TObject;
  const Text: WideString);
begin
  IF EventsAnzeigen THEN
    EventProt ('OnTitleChange "' + Text + '"');
  Caption := Text;
end;

procedure TIExplorerForm.OnlineOffline1Click(Sender: TObject);
begin
  WebBrowser1.Offline := NOT WebBrowser1.Offline;
  IF WebBrowser1.Offline THEN SpeedButtonOnOffline.Glyph := OfflineBit
  ELSE SpeedButtonOnOffline.Glyph := OnlineBit;
end;

procedure TIExplorerForm.WebBrowser1NavigateComplete2(Sender: TObject;
  pDisp: IDispatch; var URL: OleVariant);
begin
  IF EventsAnzeigen THEN
    EventProt ('OnNavigateComplete2: "' + URL + '"');
//  if ComboBoxURL.Items.IndexOf (URL) = -1 then
    ComboBoxURL.Items.Insert (0, URL);
end;

procedure TIExplorerForm.Ausschneiden1Click(Sender: TObject);
VAR Clip: TClipboard;
begin
  Clip := Clipboard;
//  Clip.SetTextBuf (PChar (ComboBoxURL.Text));
  Clip.AsText := ComboBoxURL.Text;
  ComboBoxURL.Text := '';
end;

procedure TIExplorerForm.Kopieren1Click(Sender: TObject);
VAR Clip: TClipboard;
begin
  Clip := Clipboard;
//  Clip.SetTextBuf (PChar (ComboBoxURL.Text));
  Clip.AsText := ComboBoxURL.Text;
end;

procedure TIExplorerForm.Einfuegen1Click(Sender: TObject);
VAR Clip: TClipboard;
begin
  Clip := Clipboard;
  ComboBoxURL.Text := Clip.AsText;
end;

procedure TIExplorerForm.Bookmarks2Click(Sender: TObject);
VAR mr:     TModalResult;
    DatMan: TDateiManagerForm;
begin
  DatMan := TDateiManagerForm.ECreate (Self, FALSE, TRUE, 'Bookfile suchen',
            'Als Bookfile eintragen', BookName, '*.BOK',
             LRFrame.Konfig.DateifilterIndex, TRUE, TRUE, FALSE, FALSE);
  WITH DatMan AS TDateiManagerForm DO BEGIN
    mr := ShowModal;
    IF mr = mrOk THEN BEGIN
      BookName := ComboBoxDateiauswahlHistory.Text;
//showMessage (BookName);
    END (* IF mrOk *);
    Release;
  END (* WITH *);
end;

procedure TIExplorerForm.Adressbuch1Click(Sender: TObject);
VAR mr:     TModalResult;
    DatMan: TDateiManagerForm;
begin
  DatMan := TDateiManagerForm.ECreate (Self, FALSE, TRUE, 'Adressbuch suchen',
            'Als Adressbuch eintragen', AdressName, '*.ADR',
             LRFrame.Konfig.DateifilterIndex, TRUE, TRUE, FALSE, FALSE);
  WITH DatMan AS TDateiManagerForm DO BEGIN
    mr := ShowModal;
    IF mr = mrOk THEN BEGIN
      AdressName := ComboBoxDateiauswahlHistory.Text;
    END (* IF mrOk *);
    Release;
  END (* WITH *);
end;

procedure TIExplorerForm.Bookmarks1Click(Sender: TObject);
begin
  IF BookName = '' THEN EXIT;
  WITH TIExplorerForm.Create (Self) DO BEGIN
    BookName := SELF.BookName;
    AdressName := SELF.AdressName;
    MailerName := SELF.MailerName;
//showMessage (BookName);
      ComboBoxURL.text := BookName;
      ButtonLoadClick (Sender);
      BringToFront;
  END (* WITH *)
end;

procedure TIExplorerForm.Adressbuch2Click(Sender: TObject);
begin
  IF AdressName = '' THEN EXIT;
  WITH TIExplorerForm.Create (Self) DO BEGIN
    BookName := SELF.BookName;
    AdressName := SELF.AdressName;
    MailerName := SELF.MailerName;
//showMessage (AdressName);
      ComboBoxURL.text := AdressName;
      ButtonLoadClick (Sender);
      BringToFront;
  END (* WITH *)
end;

procedure TIExplorerForm.Magic1Click(Sender: TObject);
VAR doc: Olevariant;
    nix, name: Olevariant;
    blankfile: String;
    msg:       TMsg;
begin
  nix := 0; name := 'new.html';
//  Webbrowser1.ExecWB (OLECMDID_OPEN, OLECMDEXECOPT_PROMPTUSER, nix, nix);
  blankfile := 'about:blank';
  try
    Webbrowser1.Navigate (blankfile, nix, nix, nix, nix);
  except
    showMessage ('Kann leeres Dokument nicht anlegen');
    exit;
  end;
//  IF Webbrowser1.Document = NIL THEN exit;
// Warten, bis der Webbrowser fertig ist:
  while Webbrowser1.ReadyState <> READYSTATE_COMPLETE DO
    while PeekMessage(Msg, 0, 0, 0, pm_Remove) do begin
      TranslateMessage(Msg);
      DispatchMessage(Msg);
    end;

  try
    doc := Webbrowser1.Document;
    doc.Open;
    doc.Writeln ('<HTML>');
    doc.WriteLn ('<head>');
    doc.WriteLn ('<title>Testseite</title>');
    doc.WriteLn ('</head>');
    doc.WriteLn ('<BODY>');
    doc.WriteLn ('<P> Was man hier nicht alles anstellen kann!');
    doc.WriteLn ('</BODY');
    doc.WriteLn ('</HTML>');
  finally
    doc.Close;
  end;
end;

{procedure TForm1.MemLoadClick(Sender: TObject);
var
   v : variant;
begin
   Document := WebBrowser.Document as IHtmlDocument2;
   if (assigned(Document)) then begin
      v := VarArrayCreate([0, 0], varVariant);
      v[0] := '<html><head><title>Hello World</title></head><body>Start me
up</body></html>';
      Document.Write(PSafeArray(TVarData(v).VArray));
      Document.Close;
   end;
end;}

procedure TIExplorerForm.QuelltextTestClick(Sender: TObject);
VAR doc:   OleVariant; //IHtmlDocument2; //OleVariant;
    textr: OleVariant;
    html:  OleVariant;
    i:     Integer;
    v:     variant;
begin
{  doc := Webbrowser1.Document as IHtmlDocument2;
   if (assigned (doc)) then begin
      v := VarArrayCreate([0, 0], varVariant);
      v[0] := '<html><head><title>Hello World</title></head><body>Start me up</body></html>';
      doc.Write (PSafeArray(TVarData(v).VArray));
//      doc.Write (v);
      doc.Close;
   end;}
{Exit;
  WITH Webbrowser1.Document as IHTMLDocument2 DO BEGIN
//    clear;
//    open (
    showMessage ('Start');
    textr := '<html>'; writeLn (textr);
    textr := '<body>'; writeLn (textr);
    textr := 'Dies ist ein Text'; writeLn (textr);
    textr := '</body>'; writeLn (textr);
    textr := '</html>'; writeLn (textr);
    showMessage ('close: ');
    close;
}
{    html := all;
//    IF html <> NIL THEN BEGIN
      IF html.length <> 0 THEN
        FOR i := 0 TO html.length - 1 DO BEGIN
          showMessage (html [i].tagName);
        END (* FOR *)
      ELSE
        showMessage (html.tagName);
//    END
//    ELSE showMessage ('Nix gefunden');

  END;
}
  showMessage (doc.title);
//  showMessage (doc.all.text);
  Exit;
//  showMessage (doc.all);
//  showMessage (IntToStr (VarType (doc)));
//  showMessage (IntToStr (VarType (doc.all)));
{  showMessage (IntToStr (doc.all.length));
  FOR i := 0 TO doc.all.length-1 DO BEGIN
    html := doc.all [i];
    showMessage (IntToStr (i));
    showMessage (doc.all (i).tagName);
    showMessage (IntToStr (VarType (html)));
    showMessage (html.tagname);

//    showMessage (doc.all.tagname [i]); // Methode wird nicht untersttzt
  END (* FOR *);
}
{  html := doc.all.item ('body');
//  IF html <> 0 THEN BEGIN
    IF html.length <> 0 THEN
      FOR i := 0 TO html.length - 1 DO BEGIN
        showMessage (html [i].tagName);
      END (* FOR *)
    ELSE
      showMessage (html.tagName);
  END
  ELSE showMessage ('Nix gefunden');}
//  showMessage (IntToStr (VarType (html)));
//  showMessage (doc.all('0').html); // "nicht implementiert"
//  textr := doc.body.createTextRange ('html');
//  showMessage (textr.htmltext);
//  showMessage (doc.all ('html')); //"nicht implementiert"
end;

procedure TIExplorerForm.Offlineschalten1Click(Sender: TObject);
begin
  WebBrowser1.Offline := WordBool (TRUE); //NOT WebBrowser1.Offline;
  IF WebBrowser1.Offline THEN SpeedButtonOnOffline.Glyph := OfflineBit
  ELSE SpeedButtonOnOffline.Glyph := OnlineBit;
end;

procedure TIExplorerForm.TheaterModus1Click(Sender: TObject);
begin
  Webbrowser1.TheaterMode := WordBool (TRUE);
end;

procedure TIExplorerForm.MerklisteEditieren1Click(Sender: TObject);
VAR Merkeditor: TEditform;
begin
  Merkeditor := TEditForm.Create (Self);
  WITH Merkeditor, Merkeditor.Editor DO BEGIN
    Pfadname := ChangeFileExt (Application.Exename, '.bok');
    Caption := PfadName;
    Lines := Merkliste;
    Modified := FALSE;
    SendMessage (Editor.Handle, EM_ScrollCaret, 0, 0);
  END (* WITH *);
end;

procedure TIExplorerForm.Bookmarkseditieren1Click(Sender: TObject);
VAR BookmarkEditor: TEditForm;
begin
  BookmarkEditor := TEditForm.Create (Self);
  WITH BookmarkEditor, BookmarkEditor.Editor DO BEGIN
    Pfadname := BookName;
    NeuOeffnen1Click (Sender);
    Caption := PfadName;
  END (* WITH *);
end;

procedure TIExplorerForm.Adressbucheditieren1Click(Sender: TObject);
VAR AdressEditor: TEditForm;
begin
  AdressEditor := TEditForm.Create (Self);
  WITH AdressEditor, AdressEditor.Editor DO BEGIN
    Pfadname := AdressName;
    NeuOeffnen1Click (Sender);
    Caption := PfadName;
  END (* WITH *);
end;

procedure TIExplorerForm.Merklisteneuladen1Click(Sender: TObject);
VAR mr: TModalResult;
begin
  WITH TDateiManagerForm.ECreate (Self, FALSE, TRUE,
    'Merkliste suchen', 'In Merkliste laden', ChangeFileExt (Application.Exename, '.bok'),
    '*.BOK', LRFrame.Konfig.DateiFilterIndex,
    TRUE, TRUE, FALSE, FALSE) DO BEGIN
    mr := ShowModal;
//showMessage ('Modalresult: ' + IntToStr (mr));    
    IF mr = mrOk THEN BEGIN
//showMessage ('Merkliste laden: "' + Dateiauswahl + '"');
      MerkListe.LoadFromFile (Dateiauswahl);
    END (* IF mrOk *);
    Release;
  END (* WITH *);
end;

procedure TIExplorerForm.Merklisteanzeigen1Click(Sender: TObject);
VAR  mr:   TModalResult;
     Ole:  OleVariant;
begin
  WITH TStringDialog.ECreate (Self, 'Merkliste', 'URL whlen',
                              ChangeFileExt (Application.Exename, '.BOK'),
                              Merkliste, 0, TRUE, TRUE, FALSE, FALSE, FALSE) DO BEGIN
    mr := ShowModal;
    IF mr = mrOk THEN BEGIN
      Merkliste := Liste;
      Ole := 0;
      ComboBoxURL.Text := Auswahl;
      WebBrowser1.Navigate (Auswahl, Ole, Ole, Ole, Ole);
    END (* IF mrOk *)
    ELSE IF mr = mrYes THEN
      Merkliste := Liste;
    Release;
  END (* WITH *);
end (* Merklisteanzeigen1Click *);


procedure TIExplorerForm.WebBrowser1PropertyChange(Sender: TObject;
  const szProperty: WideString);
begin
  IF EventsAnzeigen THEN BEGIN
    EventProt ('OnPropertyChange: "' + szProperty + '"');
  END (* IF *);
  IF WebBrowser1.Offline THEN SpeedButtonOnOffline.Glyph := OfflineBit
  ELSE SpeedButtonOnOffline.Glyph := OnlineBit;
end;

procedure TIExplorerForm.SpeedButtonOnOfflineClick(Sender: TObject);
begin
  WebBrowser1.Offline := NOT WebBrowser1.Offline;
  IF WebBrowser1.Offline THEN SpeedButtonOnOffline.Glyph := OfflineBit
  ELSE SpeedButtonOnOffline.Glyph := OnlineBit;
end;

procedure TIExplorerForm.Datei1Click(Sender: TObject);
begin
  OnlineOffline1.Checked := WebBrowser1.Offline;
end;

procedure TIExplorerForm.SaveHomepageClick(Sender: TObject);
VAR hp:     TextFile;
    hpname: String;
begin
  hpname := ChangeFileExt (Application.ExeName, '.home');
  AssignFile (hp, hpname);
  Rewrite (hp);
  Write (hp, ComboBoxURL.Text);
  CloseFile (hp);
end;

procedure TIExplorerForm.Invisible1Click(Sender: TObject);
begin
  TOleControl (Webbrowser1).Visible := NOT
    TOleControl (Webbrowser1).Visible;
end;

procedure TIExplorerForm.Schnellschaltleiste1Click(Sender: TObject);
begin
  Panel1.Visible := NOT Panel1.Visible;
end;

procedure TIExplorerForm.Statusleiste1Click(Sender: TObject);
begin
  StatusPanel.Visible := NOT StatusPanel.Visible;
end;

procedure TIExplorerForm.Menueleiste1Click(Sender: TObject);
begin
  IF Menu = NIL THEN Menu := MainMenuIExplorer
  ELSE Menu := NIL;
end;

procedure TIExplorerForm.FormKeyPress(Sender: TObject; var Key: Char);
Const Esc = #27;
begin
  IF Key = Esc THEN BEGIN
    Menu := MainMenuIExplorer;
    Panel1.Visible := TRUE;
    StatusPanel.Visible := TRUE;
  END;
end;

procedure TIExplorerForm.Panorama1Click(Sender: TObject);
begin
  Menu := NIL;
  Panel1.Visible := FALSE;
  StatusPanel.Visible := FALSE;
end;

procedure TIExplorerForm.Ansicht2Click(Sender: TObject);
begin
  Schnellschaltleiste1.checked := Panel1.Visible;
  Schnellschaltleiste2.checked := Panel1.Visible;
  Statusleiste1.checked := StatusPanel.Visible;
  Statusleiste2.checked := StatusPanel.Visible;
  Menueleiste1.checked := Menu <> NIL;
  Menueleiste2.checked := Menu <> NIL;
end;

procedure TIExplorerForm.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  IF Menu = NIL THEN BEGIN
    Menu := MainMenuIExplorer;
    Panel1.Visible := TRUE;
    StatusPanel.Visible := TRUE;
    CanClose := FALSE;
  END;
end;

(* function TIExplorerForm.SelectWindow: OleVariant;
var
  FrameSelForm: TFrameSelForm;
  Document: OleVariant;
  I: OleVariant;
begin
  try
    Document := WebBrowser1.Document;
    FrameSelForm := TFrameSelForm.Create(Self,Document);
    if FrameSelForm.ShowModal = mrOK then
    begin
      I := FrameSelForm.DocComboBox.ItemIndex;
      if I = 0 then
        Result := Document.script.top {return top script window using dispinterface}
      else
      begin
        Dec(I);
        Result := Document.Frames.Item(I)
      end
    end
    else
      Result := Unassigned
  finally
    FrameSelForm.Free
  end
end;
*)

(*procedure TIExplorerForm.Quelltextanzeigen1Click(Sender: TObject);
var
  TextRange: OleVariant;
  Window:    OleVariant;
  I: integer;
  NumRead: integer;
  Start: integer;
  CharCnt: integer;
  S: string;
begin
  Window := SelectWindow;
  if VarIsEmpty(Window) then
    Exit;

  try
    TextRange := Window.document.body.createTextRange; {create text range object}

    S := TextRange.htmlText; {get html text}
    AdjustLineBreaks(S); {fix cr/lf}
    NumRead := Length(S); {get number of chars read in from property}
    I := 1;
    Start := 1;
    CharCnt := 0;

    IF SourceEditor = NIL THEN BEGIN
      SourceEditor := TEditForm.Create (LRFrame);
  {$IFDEF Explorer}
      WITH SourceEditor AS TEditForm DO Hypertext := Self;
  {$ENDIF}
    END;

  WITH SourceEditor AS TEditForm DO BEGIN

    while I < NumRead do {render on rich edit control}
    begin
      if (S[I] = cr) or (CharCnt > 4095) then {eol reached or char limit}
      begin
        Editor.Lines.Add(Copy(S,Start,CharCnt));
        if S[I] = cr then
          Inc(I); {skip cr}
        Start := I+1; {set start for next starting char}
        CharCnt := 0 {reset for next chunk}
      end;
      Inc(I); {set for next char}
      Inc(CharCnt) {accumulate char count}
    end;
    if CharCnt > 0 then
      Editor.Lines.Add(Copy(S,Start,CharCnt));

  END { WITH SourceEditor };

  except
  end
end;
*)

procedure TIExplorerForm.Sitzungspeichern1Click(Sender: TObject);
VAR mr: TModalResult;
begin
  WITH TDateiManagerForm.ECreate (Self, FALSE, TRUE,
    'Sitzung speichern', 'Liste speichern', ChangeFileExt (Application.Exename, '.ses'),
    '*.SES', LRFrame.Konfig.DateiFilterIndex,
    FALSE, FALSE, TRUE, TRUE) DO BEGIN
    mr := ShowModal;
    IF mr = mrOk THEN BEGIN
      ComboBoxURL.Items.SaveToFile (Dateiauswahl);
    END (* IF mrOk *);
    Release;
  END (* WITH *);
end;

procedure TIExplorerForm.Sitzungladen1Click(Sender: TObject);
VAR mr: TModalResult;
begin
  WITH TDateiManagerForm.ECreate (Self, FALSE, TRUE,
    'Sitzung laden', 'Liste laden', ChangeFileExt (Application.Exename, '.ses'),
    '*.SES', LRFrame.Konfig.DateiFilterIndex,
    TRUE, TRUE, FALSE, FALSE) DO BEGIN
    mr := ShowModal;
    IF mr = mrOk THEN BEGIN
      ComboBoxURL.Items.LoadFromFile (Dateiauswahl);
    END (* IF mrOk *);
    Release;
  END (* WITH *);
end;

procedure TIExplorerForm.Eventsanzeigen1Click(Sender: TObject);
begin
  EventsAnzeigen := NOT EventsAnzeigen;
  IF (EventsAnzeigen) AND (FEventProtokoll = NIL) THEN BEGIN
    EventProtokoll := TEditForm.Create (LRFrame);
    WITH EventProtokoll AS TEditForm DO BEGIN
{$IFDEF Explorer}
      HypertextP := Self;
{$ENDIF}
      AutoSave := FALSE;
    END (* WITH *);
  END;
end;

procedure TIExplorerForm.WebBrowser1BeforeNavigate2(Sender: TObject;
  pDisp: IDispatch; var URL, Flags, TargetFrameName, PostData,
  Headers: OleVariant; var Cancel: WordBool);
VAR sURL, sTargetFrameName: String;
    sPostData, sHeaders:    String;
//    iFlags:                 Integer;
// Doc says: Flags reserved for future use
begin
//    sURL := URL;
//  Web_V1.Navigate (sURL, Flags, TargetFrameName, PostData, Headers);
//  Flags := navNoReadFromCache;
  IF EventsAnzeigen THEN BEGIN
//    WITH URL AS String DO sURL := URL;
//    WITH TargetFrameName AS String DO sTargetFrameName := TargetFrameName;
//    iFlags := Flags;
    sURL := URL;
    sTargetFrameName := TargetFrameName;
    sPostData := PostData; sHeaders := Headers;
// showMessage ('BeforeNavigate2: ' + URL);
    EventProt ('OnBeforeNavigate2 URL: "' + sURL +
//               '", Flags: (' + IntToStr (iFlags) +
               '", Target: "' + sTargetFrameName +
               '", Post: "' + sPostData +
               '", Headers: "' + sHeaders + '"');
  END;
end;

procedure TIExplorerForm.WebBrowser1Quit(Sender: TObject);
begin
  IF EventsAnzeigen THEN
    EventProt ('OnPropertyChange');
end;

procedure TIExplorerForm.EventProt (s: String);
begin
  IF FEventProtokoll <> NIL THEN
    WITH FEventProtokoll AS TEditForm, Editor DO BEGIN
      Lines.Append (s);
    END (* WITH *);
end;

procedure TIExplorerForm.Tools1Click(Sender: TObject);
begin
  EventsAnzeigen1.Checked := EventsAnzeigen;
end;

{$O-}
procedure TIExplorerForm.Befehletesten1Click(Sender: TObject);
VAR CMD:         OLECMDID;
    CMDF:        OLECMDF;
    s:           String;
begin
  IF FBefehlsProtokoll = NIL THEN BEGIN
    FBefehlsProtokoll := TEditForm.Create (LRFrame);
    WITH FBefehlsProtokoll AS TEditForm, Editor DO BEGIN
      AutoSave := FALSE;
{$IFDEF Explorer}
      Hypertextb := Self;
{$ENDIF}      
    END (* WITH *);
  END;
  WITH WebBrowser1 DO BEGIN

    WITH FBefehlsProtokoll AS TEditForm, Editor DO BEGIN
      Lines.Clear;
      FOR CMD := {OLECMDID_PRINT} OLECMDID_OPEN TO OLECMDID_PREREFRESH DO BEGIN
        CMDF := QueryStatusWB (CMD);

        CASE CMD OF
          OLECMDID_OPEN:                  s := 'OPEN';
          OLECMDID_NEW:                   s := 'NEW';
          OLECMDID_SAVE:                  s := 'SAVE';
          OLECMDID_SAVEAS:                s := 'SAVEAS';
          OLECMDID_SAVECOPYAS:            s := 'SAVECOPYAS';
          OLECMDID_PRINT:                 s := 'PRINT';
          OLECMDID_PRINTPREVIEW:          s := 'PRINTPREVIEW';
          OLECMDID_PAGESETUP:             s := 'PAGESETUP';
          OLECMDID_SPELL:                 s := 'SPELL';
          OLECMDID_PROPERTIES:            s := 'PROPERTIES';
          OLECMDID_CUT:                   s := 'CUT';
          OLECMDID_COPY:                  s := 'COPY';
          OLECMDID_PASTE:                 s := 'PASTE';
          OLECMDID_PASTESPECIAL:          s := 'PASTESPECIAL';
          OLECMDID_UNDO:                  s := 'UNDO';
          OLECMDID_REDO:                  s := 'REDO';
          OLECMDID_SELECTALL:             s := 'SELECTALL';
          OLECMDID_CLEARSELECTION:        s := 'CLEARSELECTION';
          OLECMDID_ZOOM:                  s := 'ZOOM';
          OLECMDID_GETZOOMRANGE:          s := 'GETZOOMRANGE';
          OLECMDID_UPDATECOMMANDS:        s := 'UPDATECOMMANDS';
          OLECMDID_REFRESH:               s := 'REFRESH';
          OLECMDID_STOP:                  s := 'STOP';
          OLECMDID_HIDETOOLBARS:          s := 'HIDETOOLBARS';
          OLECMDID_SETPROGRESSMAX:        s := 'SETPROGRESSMAX';
          OLECMDID_SETPROGRESSPOS:        s := 'SETPROGRESSPOS';
          OLECMDID_SETPROGRESSTEXT:       s := 'SETPROGRESSTEXT';
          OLECMDID_SETTITLE:              s := 'SETTITLE';
          OLECMDID_SETDOWNLOADSTATE:      s := 'SETDOWNLOADSTATE';
          OLECMDID_STOPDOWNLOAD:          s := 'STOPDOWNLOAD';
          OLECMDID_ONTOOLBARACTIVATED:    s := 'ONTOOLBARACTIVATED';
          OLECMDID_FIND:                  s := 'FIND';
          OLECMDID_DELETE:                s := 'DELETE';
          OLECMDID_HTTPEQUIV:             s := 'HTTPEQUIV';
          OLECMDID_HTTPEQUIV_DONE:        s := 'HTTPEQUIV_DONE';
          OLECMDID_ENABLE_INTERACTION:    s := 'ENABLE_INTERACTION';
          OLECMDID_ONUNLOAD:              s := 'ONUNLOAD';
          OLECMDID_PROPERTYBAG2:          s := 'PROPERTYBAG2';
          OLECMDID_PREREFRESH:            s := 'PREREFRESH';
        END (* CASE *);

        s := 'OLECMDID: ' + s + ' = [';
//        s := s + IntToStr (CMDF);
        IF (OLECMDF_SUPPORTED AND CMDF) <> 0 THEN s := s + 'SUPPORTED ';
        IF (OLECMDF_ENABLED   AND CMDF) <> 0 THEN   s := s + 'ENABLED ';
        IF (OLECMDF_LATCHED   AND CMDF) <> 0 THEN   s := s + 'LATCHED ';
        IF (OLECMDF_NINCHED   AND CMDF) <> 0 THEN   s := s + 'NINCHED ';

        s := s + ']';
        Lines.Append (s);
        CMDF := QueryStatusWB (-1); // Hm - mu seltsamerweise sein,
                                    // sonst keine wiederholte Abfrage mglich
      END (* FOR *);
    END (* WITH *);
  END (* WITH *);
end;
{$O+}

procedure TIExplorerForm.ExecWB2 (nCmdID: Integer; CONST vaIn: OleVariant;
                       VAR vaOut: OleVariant);
CONST  CGID_WebBrowser: TGUID = '{ed016940-bd5b-11cf-ba4e-00c04fd70816}';
VAR    CmdTarget:       IOleCommandTarget;
       PtrGUID:         PGUID;
begin
//  showMessage ('ExecWB2');
  NEW (PtrGUID);
  PtrGUID^ := CGID_WebBrowser;

  WITH WebBrowser1 DO
    IF Document <> NIL THEN
      TRY
        Document.QueryInterface (IOleCommandTarget, CmdTarget);
        IF CmdTarget <> NIL THEN BEGIN
//          showMessage ('CmdTarget.Exec');
          CmdTarget.Exec (PtrGUID, nCmdID, OLECMDEXECOPT_PROMPTUSER {0}, vaIn, vaOut);
        END
        ELSE showMessage ('CmdTarget = NIL');
      Except
        showMessage ('Irgendwas ist schiefgegangen');
        // Nichts
      End (* Try *)
    ELSE
      showMessage ('Kein Dokument');
  Dispose (PtrGUID);
end;

CONST  OLECMDID_FIND = 1;
       OLECMDID_VIEWSOURCE = 2;
       OLECMDID_OPTIONS = 3;

procedure TIExplorerForm.Suchen1Click(Sender: TObject);
VAR wbNull: OleVariant;
begin
//  showMessage ('Suchen');
  wbNull := NULL;
  ExecWB2 (OLECMDID_FIND, wbNull, wbNull);
end;

procedure TIExplorerForm.InternetOptionen1Click(Sender: TObject);
VAR wbNull: OleVariant;
begin
  wbNull := NULL;
  ExecWB2 (OLECMDID_OPTIONS, wbNull, wbNull);
end;

procedure TIExplorerForm.Quelltextdarstellen1Click(Sender: TObject);
VAR wbNull: OleVariant;
begin
  wbNull := NULL;
  ExecWB2 (OLECMDID_VIEWSOURCE, wbNull, wbNull);
end;

procedure TIExplorerForm.NewWindow(Sender: TObject; const URL: WideString; Flags: Integer;
      const TargetFrameName: WideString; var PostData: OleVariant;
      const Headers: WideString; var Processed: WordBool);
//VAR lFlags, lTargetFrameName, lPostData, lHeaders: OleVariant;
begin
//  lFlags := 0; //NoParam;
//  lTargetFrameName := 0; //NoParam;
//  lPostData := 0; //NoParam;
//  lHeaders := 0; //NoParam;
//  Processed := TRUE;
showMessage ('NewWindow: ' + URL);
//  WebBrowser1.Navigate (URL, lFlags, lTargetFrameName, lPostData, lHeaders);
end;

procedure TIExplorerForm.WebBrowser1NewWindow2(Sender: TObject;
  var ppDisp: IDispatch; var Cancel: WordBool);
begin
  IF EventsAnzeigen THEN
    EventProt ('NewWindow2');
{  showMessage ('NewWindow2');
  Cancel := TRUE;
  WITH TIExplorerForm.Create (Self) DO BEGIN
//      ComboBoxURL.text := SELF.ComboBoxURL.text;
//      ButtonLoadClick (Sender);
      BringToFront;
  END (* WITH *)
}
end;

Procedure TIExplorerForm.MyMessageHandler (Var Msg: TMsg; Var Handled: Boolean);
Var
   iOIPAO: IOleInPlaceActiveObject;
   Dispatch: IDispatch;
Begin
   If Webbrowser1 = NIL Then Begin
      Handled := false;
   End
   Else Begin
(*     If (Msg.Message = WM_RBUTTONDOWN) or (Msg.Message = WM_RBUTTONUP)
      Then {disable context menu}
           Handled:=true
      Else Begin *)
         Handled := IsDialogMessage (Webbrowser1.Handle, Msg);

         If Handled and (not Webbrowser1.Busy) Then Begin
            If FOleInPlaceActiveObject = NIL Then Begin
               Dispatch := Webbrowser1.Application_;
               If Dispatch <> NIL Then Begin
                  Dispatch.QueryInterface (IOleInPlaceActiveObject, iOIPAO);
                  If iOIPAO <> NIL
                  Then FOleInPlaceActiveObject := iOIPAO;
               End (* IF Dispatch <> NIL *)
            End (* IF FOleInPlaceActiveObject = NIL *);

            If FOleInPlaceActiveObject <> NIL
            Then If ((Msg.Message = WM_KEYDOWN) or (Msg.Message = WM_KEYUP)) and
                    ((Msg.wParam = VK_BACK) or (Msg.wParam = VK_LEFT) or
                     (Msg.wParam = VK_RIGHT))
                 Then {don't pass on Backspace, Left or Right arrows}
                 Else FOleInPlaceActiveObject.TranslateAccelerator (Msg);
         End (* IF Handled and not busy *);
      (* End {ELSE}; *)
   End (* ELSE *);
End (* MyMessageHandler *);

procedure TIExplorerForm.FormActivate(Sender: TObject);
begin
  Application.OnMessage := MyMessageHandler;
end;

procedure TIExplorerForm.FormDeactivate(Sender: TObject);
begin
   Application.OnMessage := NIL;
end;


procedure TIExplorerForm.SpeedButtonGoSLREClick(Sender: TObject);
begin
  ComboBoxURL.Text := SLREName;
  ButtonLoadClick (Sender);
end;

initialization
  OleInitialize (nil);
finalization
  OleUninitialize;
end.
