// Begonnen: April 99
// Stand: 02. 11. 99
// Version: 0.24

//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#include <values.h>
#include <math.h>
#pragma hdrstop

#include <vcl\clipbrd.hpp>
#include <vcl\printers.hpp>
#include "CLREdit.h"
#include "CLRFrame.h"
#include <vcl\printers.hpp>
#include <vector>
#include <stdio.h>
#include "Filter.hpp"
#include "GlobalEinstellungen.h"
//---------------------------------------------------------------------------
//#pragma link "PageSetupDlg"
#pragma resource "*.dfm"
TEditForm *EditForm;
//---------------------------------------------------------------------------
__fastcall TEditForm::TEditForm(TComponent* Owner)
	: TForm(Owner)
{
  Pfad = VorgabeDateiName;
  CursInsert = true;
//  SetupRuler();
  CursorDaten (this);
}
//---------------------------------------------------------------------------
void __fastcall TEditForm::SetRow (long Value){
  long sel;
  Value -= Value;
  if (Value < 0) Value = 0;
  sel = Editor->Perform (EM_LINEINDEX, Value, 0);
  if (sel < 0) sel = 0;
  Editor->SelStart = sel;
  FRow = sel;
}
//---------------------------------------------------------------------------
void __fastcall TEditForm::SetColumn (long Value){
  long sel;
  long row;
  Value--;
  if (Value < 0) Value = 0;
  row = GetRow () -1;
  FColumn = Editor->Perform (EM_LINELENGTH, Editor->Perform (EM_LINEINDEX, row, 0), 0);
  if (FColumn > Value) FColumn = Value; // Cursor kann nicht hinter Zeilenende stehen
  sel = Editor->Perform (EM_LINEINDEX, row, 0) + FColumn;
  Editor->SelStart = sel;
}
//---------------------------------------------------------------------------
long __fastcall TEditForm::GetRow (){
  return Editor->Perform (EM_LINEFROMCHAR, Editor->SelStart, 0) + 1;
}
//---------------------------------------------------------------------------
long __fastcall TEditForm::GetColumn (){
  return Editor->SelStart - Editor->Perform (EM_LINEINDEX, GetRow() -1, 0) + 1;
}
//---------------------------------------------------------------------------
char* __fastcall TEditForm::GetCString ()
{
  return Editor->Lines->Strings [Row - 1].c_str ();
}
//---------------------------------------------------------------------------
void __fastcall TEditForm::SetCString (char* s)
{
 Editor->Lines->Strings [Row - 1] = s;
}
//---------------------------------------------------------------------------
void __fastcall TEditForm::CloseEditor1Click(TObject *Sender)
{
  FrameForm->CloseProgram1Click (Sender); // Beenden des Rahmenformulars aufrufen
}
//---------------------------------------------------------------------------
void __fastcall TEditForm::New2Click(TObject *Sender)
{
  FrameForm->New1Click (Sender); // Behandlungsroutine des Rahmenformulars aufrufen
}
//---------------------------------------------------------------------------
void __fastcall TEditForm::Close2Click(TObject *Sender)
{
  Close ();
}
//---------------------------------------------------------------------------
void __fastcall TEditForm::FormClose(TObject *Sender, TCloseAction &Action)
{
  Action = caFree; // Fenster beim Schlieen freigeben
}
//---------------------------------------------------------------------------
void __fastcall TEditForm::Left1Click(TObject *Sender)
{
  Left1->Checked = false; // alle Hkchen entfernen
  Right1->Checked = false; //
  Center1->Checked = false;

  // Umwandeln von Sender auf den abgeleiteten Typ TMenuItem
  static_cast <TMenuItem *> (Sender)->Checked = true;

  if (Left1->Checked) // Textausrichtung dem Men entsprechend setzen
    Editor->Paragraph->Alignment = taLeftJustify;
  else if (Right1->Checked)
    Editor->Paragraph->Alignment = taRightJustify;
  else if (Center1->Checked)
    Editor->Paragraph->Alignment = taCenter;
}
//---------------------------------------------------------------------------
void __fastcall TEditForm::WordWrap1Click(TObject *Sender)
{
  Editor->WordWrap = !Editor->WordWrap; // Umschalten des Zeilenumbruchs
  if (Editor->WordWrap)
    Editor->ScrollBars = ssVertical; // Bei Zeilenumbruch nur vertikale Bildlaufleiste
  else
    Editor->ScrollBars = ssBoth; // ohne Umbruch werden beide bentigt
  WordWrap1->Checked = Editor->WordWrap;
}
//---------------------------------------------------------------------------
void __fastcall TEditForm::SelectAll1Click(TObject *Sender)
{
  Editor->SelectAll (); // ganzen Text im Editor auswhlen
}
//---------------------------------------------------------------------------
void __fastcall TEditForm::Cut1Click(TObject *Sender)
{
  Editor->CutToClipboard ();
}
//---------------------------------------------------------------------------
void __fastcall TEditForm::Copy1Click(TObject *Sender)
{
  Editor->CopyToClipboard ();
}
//---------------------------------------------------------------------------
void __fastcall TEditForm::Paste1Click(TObject *Sender)
{
  Editor->PasteFromClipboard ();
}
//---------------------------------------------------------------------------
void __fastcall TEditForm::Delete1Click(TObject *Sender)
{
  Editor->ClearSelection ();
}
//---------------------------------------------------------------------------
void __fastcall TEditForm::Edit1Click(TObject *Sender)
{
  bool HasSelection;
  Paste2->Enabled = Clipboard ()->HasFormat (CF_TEXT);
  Paste1->Enabled = Clipboard ()->HasFormat (CF_TEXT);
  HasSelection = Editor->SelLength > 0;
  Cut2->Enabled = HasSelection;
  Cut1->Enabled = HasSelection;
  Copy2->Enabled = HasSelection;
  Copy1->Enabled = HasSelection;
  Delete2->Enabled = HasSelection;
  Delete1->Enabled = HasSelection;
}
//---------------------------------------------------------------------------
void __fastcall TEditForm::Font1Click(TObject *Sender)
{
  FontDialog1->Font->Assign (Editor->SelAttributes);
  if (FontDialog1->Execute ())
    Editor->SelAttributes->Assign (FontDialog1->Font);
}
//---------------------------------------------------------------------------
void __fastcall TEditForm::Open2Click(TObject *Sender)
{
  FrameForm->Open1Click (Sender);
}
//---------------------------------------------------------------------------
AnsiString __fastcall TEditForm::GetNameAtCursor ()
{
  int   index;
  index = Editor->SelStart + 1;
  if (index > Editor->Text.Length ())
    index = Editor->Text.Length ();
// SelStart ist 0 based, Text ist 1 based
  while ((Editor->Text [index] != ' ') &&
         (Editor->Text [index] != '"') &&
         (Editor->Text [index] != '(') &&
         (Editor->Text [index] != 0x0d) &&
         (Editor->Text [index] != 0x0a) &&
         (index > 0)
         ){
    index--; if (index < 1) break;
  };
  Editor->SelStart = index;
  if (index < Editor->Text.Length ()) index ++;
  while ((Editor->Text [index] != ' ') &&
         (Editor->Text [index] != '"') &&
         (Editor->Text [index] != ')') &&
         (Editor->Text [index] != ',') &&
         (Editor->Text [index] != 0x0d) &&
         (Editor->Text [index] != 0x0a) &&
         (Editor->Text [index] != 0x00) &&
         (index <= Editor->Text.Length ())
         ){
    index++; if (index > Editor->Text.Length ()) break;
  }; // while
  Editor->SelLength = index - Editor->SelStart - 1;
  return Editor->SelText;
}
//---------------------------------------------------------------------------
void __fastcall TEditForm::Oeffnen (const AnsiString FileName) {
  Pfad = FileName;
  Editor->PlainText = (AnsiUpperCase (ExtractFileExt (Pfad)) != ".RTF");
  Editor->Lines->LoadFromFile (Pfad);
  Editor->SelStart = 0;
//  Caption = ExtractFileName (Pfad);
  Caption = Pfad;
  Editor->Modified = false;
}
//---------------------------------------------------------------------------
void __fastcall TEditForm::Save1Click(TObject *Sender)
{
  AnsiString BackupDateiName;
  AnsiString BackupErweiterung = ".BAK";
  if (Pfad == VorgabeDateiName)		// Wenn die Datei noch keinen Namen hat ..
    SaveAs1Click (Sender);	// ... einen auswhlen.
  else {
    BackupDateiName = ChangeFileExt (Pfad, BackupErweiterung);
    DeleteFile (BackupDateiName.c_str ());
    RenameFile (Pfad, BackupDateiName);
    Editor->PlainText = (AnsiUpperCase (ExtractFileExt (Pfad)) != ".RTF");
    Editor->Lines->SaveToFile (Pfad); // Benannte Datei speichern und ...
    Editor->Modified = false; 		  // ... das Attribut Modified zurcksetzen

    // History-Liste updaten:

    int Index;

    // Feststellen, ob Datei schon verzeichnet:
    Index = FrameForm->HistoryListe->IndexOf (Pfad);
    // Falls ja, entfernen, um sie nach vorne zu bringen:
    if (Index != -1) FrameForm->HistoryListe->Delete (Index);
    // History-Liste krzen, falls sie MaxHistory (noch) bersteigt:
    // ...
    // Aktuelle Datei an erster Stelle einfgen:
    if (FrameForm->Konfig.MaxHistory > 0)
      FrameForm->HistoryListe->Insert (0, Pfad);
  } // else
  CursorDaten (this);
} // Speichern1Click
//---------------------------------------------------------------------------
void __fastcall TEditForm::SaveAs1Click(TObject *Sender)
{
  if (FrameForm->DateiFilter != "")
    DateiSpeichernDialog->Filter = FrameForm->DateiFilter;
  if (ExtractFilePath (Pfad) == "")
    Pfad = ExpandFileName (Pfad);
  DateiSpeichernDialog->FileName = Pfad;
  if (DateiSpeichernDialog->Execute ()) {
    Pfad = DateiSpeichernDialog->FileName;
//  Caption = ExtractFileName (Pfad);
  Caption = Pfad;
    Save1Click (Sender);
  }
}
//---------------------------------------------------------------------------
void __fastcall TEditForm::SetupPrinter1Click(TObject *Sender)
{
  PrinterSetupDialog1->Execute ();
  // Dialogfeld "Druckereinrichtung" ausfhren
}
//---------------------------------------------------------------------------

int twip = 1440;
float cZMM = 25.4;
float fontfact = 1;

void __fastcall TEditForm::calculatePrint (TVPageOffsets* FPageOffsets,
                                           TFormatRange* fr,
                                           int* xOffset, int* yOffset,
                                      //Gerteeinheiten (device units)
                                           RECT* pageRect,
                                           RECT* rendRect,
                                           int* cursPage)
{
   Screen->Cursor = crHourGlass;
// Vom Benutzer in mm eingestellte Rnder in Twips umrechnen
   int oLeftMargin = FrameForm->Konfig.LeftMargin * twip / cZMM;
   int oRightMargin = FrameForm->Konfig.RightMargin * twip / cZMM;
   int oTopMargin = FrameForm->Konfig.TopMargin * twip / cZMM;
   int oBottomMargin = FrameForm->Konfig.BottomMargin * twip / cZMM;
// Gre der bedruckbaren Seite in Drucker-Gerteeinheiten
// (printer device units) ermitteln
    int wPage = ::GetDeviceCaps (Printer()->Handle, PHYSICALWIDTH);
    int hPage = ::GetDeviceCaps (Printer()->Handle, PHYSICALHEIGHT);
// Gerteeinheiten pro Zoll (inch) auf dem Drucker ermitteln
    int xPPI = ::GetDeviceCaps (Printer()->Handle, LOGPIXELSX);
    int yPPI = ::GetDeviceCaps (Printer()->Handle, LOGPIXELSY);
// Seitengre aus Gerteeinheiten in Twips konvertieren
    int wTwips = ::MulDiv (wPage, twip, xPPI);
    int hTwips = ::MulDiv (hPage, twip, yPPI);
// Seitengre in Twips speichern
    pageRect->left = pageRect->top = 0;
    pageRect->right = wTwips;
    pageRect->bottom = hTwips;
// Ausgaberechteck (rendering rectangle) in Twips berechnen
    rendRect->left = rendRect->top = 0;
    rendRect->right = pageRect->right - oLeftMargin - oRightMargin;
    rendRect->bottom = pageRect->bottom - oTopMargin - oBottomMargin;

// typedef std::vector<TPageOffsets> TVPageOffsets;
// In CLREdit.h erfolgt die Deklaration einer STL- (Standard Template
// Library) Vektor-Klasse. Sie wird dazu verwendet, um Informationen
// ber jede zu druckende Seite zu speichern, und zwar die Offset-
// Werte fr das erste und letzte Zeichen, das auf diese Seite
// gedruckt wird. Neben diesen Informationen ber jede einzelne Seite
// liefert die Struktur die Gesamtzahl der Seiten, die beim Ausdruck
// entsteht.
// Definition einer einzelnen Seite, deren Anfangsoffset auf Null
// gesetzt wird:
    TPageOffsets po;
    po.Start = 0;
// Definition und Initialisierung einer TFormatRange-Struktur.
// Wir verwenden die Defition aus RichEdit.h. Diese Struktur wird
// an TRichEdit bergeben mit dem Auftrag, so viel Text als mglich
// zu formatieren, so da er - angefangen beim Offset chrg.cpMin und
// endend mit chrg.cpMax - auf die durch TFormatRange.rc festgelegte
// Seite pat.
// Wir weisen die RichEdit-Komponente an, mit dem Anfang des Textes
// (cpMin = 0) anzufangen und so viel Text als mglich (cpMax = -1)
// zu drucken. Auerdem soll die Ausgabe auf den Drucker erfolgen
    fr->hdc = Printer()->Handle;
    fr->hdcTarget = Printer()->Handle;
    fr->chrg.cpMin = po.Start;
    fr->chrg.cpMax = -1;
// Um zu erkennen, wann die letzte Seite aufbereitet wurde, mssen
// wir feststellen, wieviel Text die Komponente enthlt:
    int lastOffset =
      ::SendMessage (Editor->Handle, WM_GETTEXTLENGTH, 0, 0);
// Zur Vorsicht wird der Formatierpuffer gelscht:
    ::SendMessage (Editor->Handle, EM_FORMATRANGE,
      (WPARAM) 0, (LPARAM) 0);

    ::SaveDC (fr->hdc);
    ::SetMapMode (fr->hdc, MM_TEXT);
    *xOffset = -::GetDeviceCaps (Printer()->Handle, PHYSICALOFFSETX);
    *yOffset = -::GetDeviceCaps (Printer()->Handle, PHYSICALOFFSETY);
    *xOffset += ::MulDiv (oLeftMargin, xPPI, twip);
    *yOffset += ::MulDiv (oTopMargin, yPPI, twip);
    ::SetViewportOrgEx (fr->hdc, *xOffset, *yOffset, NULL);

    *cursPage = 1;
// Nun wird eine Tabelle mit Eintrgen fr jede zu druckende Seite
// erzeugt
    do {
      fr->rc = *rendRect;
      fr->rcPage = *pageRect;
      po.Start = fr->chrg.cpMin;
      fr->chrg.cpMin = ::SendMessage (Editor->Handle, EM_FORMATRANGE,
                                     (WPARAM) 0, (LPARAM) fr);
      po.End = fr->chrg.cpMin - 1;
      FPageOffsets->push_back (po);
      if ((Editor->SelStart > fr->chrg.cpMin))
        *cursPage = FPageOffsets->size() + 1;
    } while (fr->chrg.cpMin != -1 && fr->chrg.cpMin < lastOffset);
    ::SendMessage (Editor->Handle, EM_FORMATRANGE, (WPARAM) 0,
                  (LPARAM) 0);
    ::RestoreDC (fr->hdc, -1);
   Screen->Cursor = crDefault;
} // calculatePrint

//-------------------------------------------------------------------

void __fastcall TEditForm::Printerdialog1Click(TObject *Sender)
{
  FrameForm->doPrintDialog = true;
  Print1Click (Sender);
}

//-------------------------------------------------------------------
void __fastcall TEditForm::Print1Click(TObject *Sender)
{
  TVPageOffsets FPageOffsets;
  TFormatRange fr;
  int xOffset; int yOffset; int cursPage;
  RECT pageRect;
  RECT rendRect;

  calculatePrint (&FPageOffsets, &fr, &xOffset, &yOffset, &pageRect,
                  &rendRect, &cursPage);

// Bestimme die Anzahl der zu druckenden Seiten, Kopien bzw.
// Seitenbereiche
  int pageCount =               FPageOffsets.size();
  int copies =                  1;
  int totalPages =              FPageOffsets.size();
  PrintDialog1->MinPage =       1;
  PrintDialog1->MaxPage =       pageCount;
  PrintDialog1->FromPage =      1;
  PrintDialog1->ToPage =        pageCount;

  PrintDialog1->Options.Clear();
  PrintDialog1->Options << poPageNums << poWarning;

  if (Editor->SelLength > 0){
    PrintDialog1->Options << poSelection;
    PrintDialog1->PrintRange = prSelection;
  }
  else{
    PrintDialog1->PrintRange = prAllPages;
  }

  bool                  doPrint = false;
//  bool                  doPrintrange = false;
  bool                  doCopies = false;
  bool                  firstPage = true;
  int                   currPage = 0;
  int                   startPage = 0;

  int i = 1;
  for (i = 1; i <= copies; i++){
    if ((doCopies) || (FrameForm->doPrintDialog &&
        PrintDialog1->Execute ())){
      if (!doCopies){
        copies = PrintDialog1->Copies;
        if (copies > 1) doCopies = true;
      }
      if (PrintDialog1->PrintRange == prSelection){
        TEditForm *RangeWindow = new TEditForm(FrameForm);
        Editor->CopyToClipboard();
        RangeWindow->Editor->PasteFromClipboard();
        RangeWindow->Editor->Modified = false;
        RangeWindow->Pfad = "Block aus: " + Pfad;
        FrameForm->doPrintDialog = false;
        RangeWindow->Print1Click (RangeWindow);
        RangeWindow->Close();
        continue;
      }
      while (Printer()->Printing);
      doPrint = true;
// Druckparameter neu berechnen, falls der Benutzer nderungen
// vorgenommen hat
      FPageOffsets.erase (FPageOffsets.begin(), FPageOffsets.end());
      calculatePrint (&FPageOffsets, &fr, &xOffset, &yOffset,
                      &pageRect, &rendRect, &cursPage);

      Printer()->Title = Pfad;
      Printer()->BeginDoc();
      fr.hdc = Printer()->Handle;
      fr.hdcTarget = Printer()->Handle;
      ::SaveDC (fr.hdc);

      startPage = 0;
      fr.chrg.cpMin = 0;
      fr.chrg.cpMax = -1;

// Falls ein Seitenbereich gedruckt werden soll ...
      if (PrintDialog1->PrintRange == prPageNums) {
        pageCount = PrintDialog1->ToPage;
        ::SetViewportOrgEx (fr.hdc, xOffset, yOffset, NULL);
        while (startPage < PrintDialog1->FromPage - 1){
          fr.rc = rendRect;
          fr.rcPage = pageRect;

          fr.chrg.cpMin = ::SendMessage (Editor->Handle,
             EM_FORMATRANGE, (WPARAM) 0, (LPARAM) &fr);
          fr.chrg.cpMax = -1;
          startPage++;
          ::SendMessage (Editor->Handle, EM_FORMATRANGE,
                        (WPARAM) 0, (LPARAM) 0);
        }
      }
      else
        pageCount = FPageOffsets.size(); // kann neu berechnet sein!
    } // if PrintDialog1->Execute
    else
      pageCount = FPageOffsets.size(); // kann neu berechnet sein!

    totalPages = FPageOffsets.size();

    if (doPrint || !FrameForm->doPrintDialog){
      if (!FrameForm->doPrintDialog){
        Printer()->Title = Pfad;
        Printer()->BeginDoc();
        fr.hdc = Printer()->Handle;
        fr.hdcTarget = Printer()->Handle;
        ::SaveDC (fr.hdc);
        startPage = 0;
        fr.chrg.cpMin = 0;
        fr.chrg.cpMax = -1;
      }

// Ermittle Anzahl Pixel in Y-Richtung pro Zoll des Druckers
      int printerVertUnitsPerInch =
        ::GetDeviceCaps (Printer()->Handle, LOGPIXELSY);

      int oLeftHeader = xOffset;

      int oTopHeader =
        - GetDeviceCaps (Printer()->Handle, PHYSICALOFFSETY);
// Rechne den vom Benutzer eingestellten oberen Rand in
// Gerteeinheiten um
      int oHeaderMargin =
        ((float) FrameForm->Konfig.HeaderMargin *
         printerVertUnitsPerInch) / cZMM;
      oTopHeader = oTopHeader + oHeaderMargin;
      if (oTopHeader < 0) oTopHeader = 0;

// Das ist die Hhe des bedruckbaren Seitenbereiches in
// Millimetern (!), abzglich einer Sicherheitsreserve
      int ph = GetDeviceCaps (Printer()->Handle, VERTSIZE) - 1;
// Wir rechnen das in Gerteeinheiten um -
      ph = (((float)ph * printerVertUnitsPerInch) / cZMM);
// Rechne den vom Benutzer eingestellten unteren Rand in
// Gerteeinheiten um
      int oFooterMargin =
        ((float) FrameForm->Konfig.FooterMargin *
         printerVertUnitsPerInch) / cZMM;
      int FontOffset = MulDiv (FrameForm->DefaultFont->Size,
        printerVertUnitsPerInch, 72);
// Ermittle den unteren Seitenrand aus physikalischer Seitenhhe
// (= Blattlnge) minus physikalischen Y-Offset:
      int oBottomFooter = GetDeviceCaps (Printer()->Handle,
        PHYSICALHEIGHT) - GetDeviceCaps (Printer()->Handle,
        PHYSICALOFFSETY);
// Ziehe davon den eingestellten unteren Rand ab:
      oBottomFooter = oBottomFooter - oFooterMargin
// und die Schrifthhe:
        - FontOffset;
//      oBottomFooter = ph - FontOffset;
      if (oBottomFooter + FontOffset > ph) oBottomFooter =
         ph - FontOffset;

      firstPage = true;
      currPage = startPage;

      do {
        if (firstPage){
          firstPage = false;
        }
        else Printer()->NewPage();
// NewPage() setzt bei manchen Druckertreibern den Viewport-Offset
// auf 0,0, aber offenbar nicht bei allen!
// Fr die Ausgabe Printer()->Canvas->Textout (Header, Footer):
// mu der Viewport-Offset auf (0, 0) gesetzt werden:
        ::SetViewportOrgEx (fr.hdc, 0, 0, NULL);

        AnsiString header = "";
        header = FrameForm->Konfig.PrintHeader;
        int pathpos = AnsiPos ("$", header);
        if (pathpos > 0) {
          header.Delete (pathpos, 1);
          header.Insert (Pfad, pathpos);
        }
        int pagepos = AnsiPos ("@", header);
        if (pagepos > 0) {
          header.Delete (pagepos, 1);
          header.Insert (AnsiString (currPage + 1), pagepos);
        }
        pagepos = AnsiPos ("#", header);
        if (pagepos > 0) {
          header.Delete (pagepos, 1);
          header.Insert (AnsiString (totalPages), pagepos);
        }

        AnsiString footer = "";
        footer = FrameForm->Konfig.PrintFooter;
        pathpos = AnsiPos ("$", footer);
        if (pathpos > 0) {
          footer.Delete (pathpos, 1);
          footer.Insert (Pfad, pathpos);
        }
        pagepos = AnsiPos ("@", footer);
        if (pagepos > 0) {
          footer.Delete (pagepos, 1);
          footer.Insert (AnsiString (currPage + 1), pagepos);
        }
        pagepos = AnsiPos ("#", footer);
        if (pagepos > 0) {
          footer.Delete (pagepos, 1);
          footer.Insert (AnsiString (totalPages), pagepos);
        }

        Printer()->Canvas->Font = FrameForm->DefaultFont;
        Printer()->Canvas->TextOut (oLeftHeader, oTopHeader, header);
        Printer()->Canvas->TextOut
          (oLeftHeader, oBottomFooter, footer);

        ::SetViewportOrgEx (fr.hdc, xOffset, yOffset, NULL);

        fr.rc = rendRect;
        fr.rcPage = pageRect;

        fr.chrg.cpMin = ::SendMessage (Editor->Handle, EM_FORMATRANGE,
                                      (WPARAM) 1, (LPARAM) &fr);
        fr.chrg.cpMax = -1;
      } while (++currPage < pageCount);

      ::RestoreDC (fr.hdc, -1);
      Printer()->EndDoc();

      ::SendMessage (Editor->Handle, EM_FORMATRANGE, (WPARAM) 0,
                    (LPARAM) 0);
    } // if (doPrint || !doPrintDialog)
    FPageOffsets.erase (FPageOffsets.begin(), FPageOffsets.end());
  } // for copies
  FrameForm->doPrintDialog = false;
} // TEditForm::Print1Click(TObject *Sender)
//---------------------------------------------------------------------------

void __fastcall TEditForm::FormCloseQuery(TObject *Sender, bool &CanClose)
{
  char SWarnungText [250];
  sprintf (SWarnungText, "nderungen in %s speichern?", Pfad.c_str());
  if (Editor->Modified){
    if (FrameForm->Konfig.AutoSaveKonfig) {
      Save1Click (this);
      return;
    } // if AutoSaveKonfig
    switch (MessageBox (Handle, SWarnungText, "Besttigung", MB_YESNOCANCEL)){
    case IDYES:
      if (Pfad == VorgabeDateiName)
        SaveAs1Click (Sender);
      else
        Save1Click (this);
      break;
    case IDCANCEL:
      CanClose = false; break;
    } // switch
  } // if
}
//---------------------------------------------------------------------------

/*
Virtual-Key Codes

The following table shows the symbolic constant names, hexadecimal values, and keyboard equivalents for the virtual-key codes used by the Microsoft Windows operating system. The codes are listed in numeric order.

Symbolic constant name	Value (hexadecimal)	Mouse or keyboard equivalent
VK_LBUTTON	01	Left mouse button
VK_RBUTTON	02	Right mouse button
VK_CANCEL	03	Control-break processing
VK_MBUTTON	04	Middle mouse button (three-button mouse)
  	05-07	Undefined
VK_BACK	08	BACKSPACE key
VK_TAB	09	TAB key
  	0A-0B	Undefined
VK_CLEAR	0C	CLEAR key 
VK_RETURN	0D	ENTER key 
  	0E-0F	Undefined 
VK_SHIFT	10	SHIFT key 
VK_CONTROL	11	CTRL key
VK_MENU	12	ALT key
VK_PAUSE	13	PAUSE key 
VK_CAPITAL	14	CAPS LOCK key 
  	15-19	Reserved for Kanji systems 
  	1A	Undefined
VK_ESCAPE	1B	ESC key 
  	1C-1F	Reserved for Kanji systems 
VK_SPACE	20	SPACEBAR
VK_PRIOR	21	PAGE UP key 
VK_NEXT	22	PAGE DOWN key
VK_END	23	END key 
VK_HOME	24	HOME key 
VK_LEFT	25	LEFT ARROW key 
VK_UP	26	UP ARROW key 
VK_RIGHT	27	RIGHT ARROW key 
VK_DOWN	28	DOWN ARROW key 
VK_SELECT	29	SELECT key 
  	2A	Original equipment manufacturer (OEM) specific
VK_EXECUTE	2B	EXECUTE key 
VK_SNAPSHOT	2C	PRINT SCREEN key for Windows 3.0 and later 
VK_INSERT	2D	INS key 
VK_DELETE	2E	DEL key 
VK_HELP	2F	HELP key
VK_0	30	0 key
VK_1	31	1 key
VK_2	32	2 key 
VK_3	33	3 key 
VK_4	34	4 key
VK_5	35	5 key 
VK_6	36	6 key 
VK_7	37	7 key 
VK_8	38	8 key 
VK_9	39	9 key 
  	3A-40	Undefined
VK_A	41	A key 
VK_B	42	B key 
VK_C	43	C key 
VK_D	44	D key 
VK_E	45	E key 
VK_F	46	F key 
VK_G	47	G key 
VK_H	48	H key
VK_I	49	I key 
VK_J	4A	J key 
VK_K	4B	K key
VK_L	4C	L key
VK_M	4D	M key
VK_N	4E	N key
VK_O	4F	O key 
VK_P	50	P key 
VK_Q	51	Q key 
VK_R	52	R key 
VK_S	53	S key 
VK_T	54	T key 
VK_U	55	U key 
VK_V	56	V key 
VK_W	57	W key 
VK_X	58	X key
VK_Y	59	Y key 
VK_Z	5A	Z key 
VK_LWIN	5B	Left Windows key (Microsoft Natural Keyboard) 
VK_RWIN	5C	Right Windows key (Microsoft Natural Keyboard) 
VK_APPS	5D	Applications key (Microsoft Natural Keyboard) 
  	5E-5F	Undefined 
VK_NUMPAD0	60	Numeric keypad 0 key
VK_NUMPAD1	61	Numeric keypad 1 key
VK_NUMPAD2	62	Numeric keypad 2 key 
VK_NUMPAD3	63	Numeric keypad 3 key
VK_NUMPAD4	64	Numeric keypad 4 key
VK_NUMPAD5	65	Numeric keypad 5 key
VK_NUMPAD6	66	Numeric keypad 6 key 
VK_NUMPAD7	67	Numeric keypad 7 key 
VK_NUMPAD8	68	Numeric keypad 8 key 
VK_NUMPAD9	69	Numeric keypad 9 key 
VK_MULTIPLY	6A	Multiply key 
VK_ADD	6B	Add key 
VK_SEPARATOR	6C	Separator key
VK_SUBTRACT	6D	Subtract key 
VK_DECIMAL	6E	Decimal key 
VK_DIVIDE	6F	Divide key 
VK_F1	70	F1 key 
VK_F2	71	F2 key
VK_F3	72	F3 key 
VK_F4	73	F4 key 
VK_F5	74	F5 key
VK_F6	75	F6 key 
VK_F7	76	F7 key 
VK_F8	77	F8 key
VK_F9	78	F9 key 
VK_F10	79	F10 key
VK_F11	7A	F11 key 
VK_F12	7B	F12 key
VK_F13	7C	F13 key
VK_F14	7D	F14 key 
VK_F15	7E	F15 key 
VK_F16	7F	F16 key 
VK_F17	80H	F17 key
VK_F18	81H	F18 key
VK_F19	82H	F19 key
VK_F20	83H	F20 key
VK_F21	84H	F21 key
VK_F22	85H	F22 key
VK_F23	86H	F23 key
VK_F24	87H	F24 key
  	88-8F	Unassigned
VK_NUMLOCK	90	NUM LOCK key
VK_SCROLL	91	SCROLL LOCK key
  	92-B9	Unassigned
  	BA-C0	OEM specific
  	C1-DA	Unassigned
  	DB-E4	OEM specific
  	E5	Unassigned
  	E6	OEM specific
  	E7-E8	Unassigned
  	E9-F5	OEM specific
VK_ATTN	F6	Attn key
VK_CRSEL	F7	CrSel key
VK_EXSEL	F8	ExSel key
VK_EREOF	F9	Erase EOF key
VK_PLAY	FA	Play key
VK_ZOOM	FB	Zoom key
VK_NONAME	FC	Reserved for future use.
VK_PA1	FD	PA1 key
VK_OEM_CLEAR	FE	Clear key
*/

#define VK_A 0x41
#define VK_Z 0x5A
#define VK_0 0x30
#define VK_9 0x39

void __fastcall TEditForm::EditorKeyDown(TObject *Sender, WORD &Key,
	TShiftState Shift)
{
//ShowMessage ("Keycode: " + AnsiString (Key));
//ShowMessage ("Key: " + AnsiString (FrameForm->lastKey) + ", KeyData: " + AnsiString (FrameForm->lastKeyData));

//if (GetKeyState (VK_SHIFT) & 1) ShowMessage ("Shift!");
//if (GetKeyState (VK_CONTROL) & 1) ShowMessage ("Control!");
//if (GetKeyState (VK_MENU) & 1) ShowMessage ("Alt!");
//if (GetKeyState (VK_NUMLOCK) & 1) ShowMessage ("Numlock!");
//if (GetKeyState (VK_SCROLL) & 1) ShowMessage ("Scrolllock!");
//if (GetKeyState (VK_CAPITAL) & 1) ShowMessage ("Capslock!");

  TShiftState leer;
  TShiftState Alt;
  Alt << ssAlt;
  if ((Shift == leer) && (Key == VK_INSERT)) {
      CursInsert = !CursInsert;
      CursorDaten (Sender);
  }
  else if (Shift == Alt)
    switch (Key){
      case VK_UP:       SendMessage (Editor->Handle, EM_SCROLL, SB_LINEUP, 0); break;
      case VK_DOWN:     SendMessage (Editor->Handle, EM_SCROLL, SB_LINEDOWN, 0); break;
    }
//  else Tastaturauswertung (Sender, Key, Shift);
  if (!(((Key >= VK_0) && (Key <= VK_9)) || ((Key >= VK_A) && (Key <= VK_Z)) ||
      (Key >= 0x92) || (Key == VK_SPACE))) noChar = true;
  else noChar = false;
  if ((Key == VK_RETURN) && backwards) {
    if (Column == 1) {
      Column = Editor->Lines->Strings [Row - 1].Length () + 1;
//      ShowMessage ("Column: " + AnsiString (Column));
//      virtualSelStart = Editor->SelStart - 1;
    }
  }
  else {
    if (backwards && !noChar) {
        Editor->SelStart = virtualSelStart;
    };
    virtualSelStart = Editor->SelStart;
  } // else
}
//---------------------------------------------------------------------------
void __fastcall TEditForm::EditorKeyUp(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
  if (backwards && !noChar) {
      Editor->SelStart = virtualSelStart;
  }
  else virtualSelStart = Editor->SelStart;
}
//---------------------------------------------------------------------------
void __fastcall TEditForm::Status ()
 { CursorDaten (this);}
//---------------------------------------------------------------------------
void __fastcall TEditForm::SetupRuler(void)
{    int iCtr = 1;
     char sTmp[201];
     while (iCtr < 200) {
       sTmp[iCtr] = 9;
       iCtr++;
       sTmp[iCtr] = '|';
       iCtr++;
     }
     Ruler->Caption = (AnsiString)sTmp;
}
//---------------------------------------------------------------------------

const float     RulerAdj = 4.0/3.0;
const int       GutterWid = 6;

void __fastcall TEditForm::CursorDaten(TObject *Sender)
{
    char sizebuf [6];
    FrameForm->FUpdating = TRUE;

//------------ Ruler --------------------------------------------------------

    FirstInd->Left = int (Editor->Paragraph->FirstIndent * RulerAdj) - 4 + GutterWid;
    Leftind->Left = int ((Editor->Paragraph->LeftIndent +
      Editor->Paragraph->FirstIndent) * RulerAdj) - 4 + GutterWid;
    RightInd->Left = Ruler->ClientWidth - 6 - int (
      (Editor->Paragraph->RightIndent + GutterWid) * RulerAdj);

//------------ Statusline ---------------------------------------------------

    char status [200] = "";
    unsigned char Zch = 0;
    unsigned char Zchp = 0;
    AnsiString  mod;
    if ((Editor->GetTextLen() > 0) && (Editor->SelStart > 0)) Zch = Editor->Text [Editor->SelStart];
    else Zch = 0;

    if (Zch > 32) Zchp = Zch; else Zchp = 32;

    if (CursInsert)
      mod = "Einf";
    else
      mod = "ber";

    StatusBar1->Panels->Items [0]->Text = AnsiString (Column) + ":" + AnsiString (Row);

    if (Zch != 0){
      sprintf (status, "%c %u %Xh",
                 Zchp, Zch, Zch);
      StatusBar1->Panels->Items [1]->Text = status;
    }
    else StatusBar1->Panels->Items [1]->Text = "";

    StatusBar1->Panels->Items [2]->Text = mod + " " + AnsiString (Editor->SelStart);

    StatusBar1->Panels->Items [3]->Text = "Text " + AnsiString (Editor->GetTextLen());

    StatusBar1->Panels->Items [4]->Text = "Block " + AnsiString (Editor->SelLength);


    if (Editor->Modified){
      StatusBar1->Panels->Items [6]->Text = "Verndert"; //strcpy (stat, "Verndert");
    }
    else{
      StatusBar1->Panels->Items [6]->Text = "Gesichert"; //strcpy (stat, "Gesichert");
    }
    if (Active && (Editor->Lines->Count > 0)){
      FrameForm->FontName->Text = Editor->SelAttributes->Name;
      FrameForm->FontSize->Text = itoa (Editor->SelAttributes->Size, sizebuf, 10);
      FrameForm->SpeedButtonBold->Down = Editor->SelAttributes->Style.Contains (fsBold);
      FrameForm->SpeedButtonItalic->Down = Editor->SelAttributes->Style.Contains (fsItalic);
      FrameForm->SpeedButtonUnderline->Down = Editor->SelAttributes->Style.Contains (fsUnderline);
      FrameForm->SpeedButtonBullets->Down = bool (Editor->Paragraph->Numbering);
      FrameForm->SpeedButtonProtect->Down = Editor->SelAttributes->Protected;
      switch ((int)Editor->Paragraph->Alignment) {
        case 0: FrameForm->SpeedButtonLeft->Down = TRUE; break;
        case 1: FrameForm->SpeedButtonCenter->Down = TRUE; break;
        case 2: FrameForm->SpeedButtonRight->Down = TRUE; break;
      }

    };

// Determine Number of Pages:

    if (cursChanged && (FrameForm->lastUserinput < FrameForm->Konfig.saveIntervall)){
        StatusBar1->Panels->Items [5]->Text = "Seite ---/---";
        TVPageOffsets FPageOffsets;
        TFormatRange fr;
        int xOffset; int yOffset; int cursPage;
        RECT pageRect;
        RECT rendRect;

        calculatePrint (&FPageOffsets, &fr, &xOffset, &yOffset, &pageRect, &rendRect, &cursPage);

      //  Determine the actual number of pages to be printed:
        int pageCount = FPageOffsets.size();
        StatusBar1->Panels->Items [5]->Text = "Seite " + AnsiString (cursPage) +
                  "/" + AnsiString (pageCount);
        cursChanged = false;
    }

    FrameForm->FUpdating = FALSE;

    FrameForm->lastUserinput = FrameForm->Konfig.saveIntervall; // BrowserBackup;
} // Cursordaten
//---------------------------------------------------------------------------
void __fastcall TEditForm::FormPaint(TObject *Sender)
{
  CursorDaten (this);
}
//---------------------------------------------------------------------------
void __fastcall TEditForm::Find1Click(TObject *Sender)
{
  if (FrameForm->FindDialog1->FindTextA == "" || Editor->SelLength > 0){
    if (Editor->SelLength == 0) FrameForm->FindDialog1->FindTextA = GetNameAtCursor ();
    else FrameForm->FindDialog1->FindTextA = Editor->SelText;
  }
  FrameForm->FindDialog1->Execute ();
}
//---------------------------------------------------------------------------
void __fastcall TEditForm::Replace1Click(TObject *Sender)
{
  FrameForm->ReplaceDialog1->Execute ();
}
//---------------------------------------------------------------------------
void __fastcall TEditForm::FormResize(TObject *Sender)
{
  if (!Visible) return;
  if (WindowState != wsMinimized) FrameForm->DefaultWindow.ChildWin = WindowState;
  FrameForm->DefaultWindow.ChildTop = Top;
  FrameForm->DefaultWindow.ChildLeft = Left;
  FrameForm->DefaultWindow.ChildHeight = Height;
  FrameForm->DefaultWindow.ChildWidth = Width;

  CursorDaten (Sender);
}
//---------------------------------------------------------------------------
void __fastcall TEditForm::FormCreate(TObject *Sender)
{

  if (EditorMainMenu->Items->Count > 0)
    FrameForm->LoadMenu (EditorMainMenu->Items, "EditorMainMenu");
  if (EditorPopupMenu->Items->Count > 0)
    FrameForm->LoadMenu (EditorPopupMenu->Items, "EditorPopupMenu");
  Editor->MaxLength = FrameForm->Konfig.MaxTextLaenge;
  Editor->WordWrap = FrameForm->Konfig.WortUmbruch;
  if (Editor->WordWrap)
    Editor->ScrollBars = ssVertical; // Bei Zeilenumbruch nur vertikale Bildlaufleiste
  else
    Editor->ScrollBars = ssBoth; // ohne Umbruch werden beide bentigt
  WordWrap1->Checked = Editor->WordWrap;

// Fenster-Voreinstellungen:

  if (FrameForm->DefaultWindow.ChildWinDefault == true) {
    Position = FrameForm->DefaultWindow.ChildPos;
    WindowState = FrameForm->DefaultWindow.ChildWin;
    switch (FrameForm->DefaultWindow.ChildPos) {
      case poDefaultPosOnly:
      case poScreenCenter:
      		Height = FrameForm->DefaultWindow.ChildHeight;
      		Width = FrameForm->DefaultWindow.ChildWidth;
            break;
      case poDefaultSizeOnly:
      		Top = FrameForm->DefaultWindow.ChildTop;
      		Left = FrameForm->DefaultWindow.ChildLeft;
            break;
    }
  }
  else {
    Height = FrameForm->DefaultWindow.ChildHeight;
    Width = FrameForm->DefaultWindow.ChildWidth;
    Top = FrameForm->DefaultWindow.ChildTop;
    Left = FrameForm->DefaultWindow.ChildLeft;
  }

  if (FrameForm->DefaultFont != NULL){
    Editor->Font->Assign (FrameForm->DefaultFont);
  }
/*
  Pfadname := cNamenVorgabe + ' ' + IntToStr (LRFrame.Zaehler);
  Caption := Pfadname; (* Steht nicht im Handbuch? *)
  IsoAnzeige := LRFrame.Konfig.IsoAnzeigen;
*/
  if (FrameForm->Konfig.AutoSaveAbfrage)
/*    AutoSave = MessageDlg ("Text alle " + IntToStr (LRFrame.Konfig.saveIntervall) +
                            ' Sekunden sichern?', mtConfirmation,
                     [mbYes, mbNo], 0) = id_Yes
*/;  else
    AutoSave = FrameForm->Konfig.saveIntervall > 0;
  Editor->RegisterConversionFormat (__classid (TDOSConversion), "dos", __classid (TDOSConversion));
  Editor->RegisterConversionFormat (__classid (TDOSConversion), "asc", __classid (TDOSConversion));
  Editor->RegisterConversionFormat (__classid (TDOSConversion), "tmp", __classid (TDOSConversion));
  Editor->RegisterConversionFormat (__classid (TDOSConversion), "sys", __classid (TDOSConversion));
  Editor->RegisterConversionFormat (__classid (TDOSConversion), "bat", __classid (TDOSConversion));
  Editor->RegisterConversionFormat (__classid (TDOSConversion), "xps", __classid (TDOSConversion));
//  Editor->RegisterConversionFormat ("tmp", TMausConversion);
  Editor->RegisterConversionFormat (__classid (TMacConversion), "mac", __classid (TMacConversion));
  Editor->RegisterConversionFormat (__classid (TMacConversion), "mrf", __classid (TMacConversion));

}
//---------------------------------------------------------------------------
void __fastcall TEditForm::Reload1Click(TObject *Sender)
{
ShowMessage ("Reload of Document not yet implemented");
/*
VAR mr: TModalResult;
    DatMan: TDateiManagerForm;
begin
  IF Editor.Modified THEN
    IF NOT (MessageDlg ('nderungen im aktuellen Textfenster berschreiben?', mtConfirmation,
      [mbYes, mbNo], 0) = mrYes) THEN Exit;
  IF NOT FileExists (Pfadname) THEN BEGIN
    DatMan := TDateiManagerForm.Create (Self);
    WITH DatMan AS TDateiManagerForm DO BEGIN
      Caption := 'Textdatei laden';
      DateiFilterComboBox.ItemIndex := LRFrame.Konfig.DateiFilterIndex;
      ButtonLaden.Enabled := TRUE; (* hm ... *)
      ButtonLaden.Default := TRUE;
      mr := ShowModal;
      IF mr = mrOk THEN BEGIN
        LRFrame.Konfig.DateiFilterIndex := DateiFilterComboBox.ItemIndex;
   //showMessage (ComboBoxDateiauswahlHistory.Text);
        Pfadname := Dateiauswahl; //ComboBoxDateiauswahlHistory.Text;
        WITH TEditForm.Create (Self) DO
          Open (Dateiauswahl);
      END (* IF mrOk *)
      ELSE EXIT;
    END (* WITH *);
  END (* Datei nicht gefunden *);
  Editor.Lines.LoadFromFile (Pfadname);
  Editor.Modified := FALSE;
  CursorDaten (Sender);
*/
} // NeuLaden1Click
//---------------------------------------------------------------------------
void __fastcall TEditForm::CloseAll1Click(TObject *Sender)
{
  FrameForm->AlleSchliessen();
}
//---------------------------------------------------------------------------
void __fastcall TEditForm::SaveAll1Click(TObject *Sender)
{
  FrameForm->AlleSpeichern (this);
}
//---------------------------------------------------------------------------
void __fastcall TEditForm::OpenFirstDocsInHistory1Click(TObject *Sender)
{
  FrameForm->OpenFirstDocsInHistory1Click (Sender);
}
//---------------------------------------------------------------------------
void __fastcall TEditForm::LoadFileAtCursor1Click(TObject *Sender)
{
  FrameForm->SpeedButtonLoadFromCursorClick (Sender);
}
//---------------------------------------------------------------------------
void __fastcall TEditForm::History1Click(TObject *Sender)
{
  int           i, max, off;
  TMenuItem     *menitem;
  const int     cBreak = 30;

  i = History1->Count;
  while (History1->Items [i - 1]->Caption != "-"){
    i--; History1->Delete (i);
  }
  i = History2->Count;
  while (History2->Items [i - 1]->Caption != "-"){
    i--; History2->Delete (i);
  }

  if (FrameForm->HistoryListe->Count < FrameForm->Konfig.AnzeigeHistory)
    max = FrameForm->HistoryListe->Count - 1;
  else
    max = FrameForm->Konfig.AnzeigeHistory - 1;

  off = 0;
  for (i = 0; i <= max; i++){
    if (fmodl (i + 1, cBreak) == 0) {
      menitem = new TMenuItem (EditorMainMenu);
      menitem->Break = mbBarBreak;
      History1->Add (menitem);
    } // if
    while ((i + off <= max) &&
      (FrameForm->findePfadnamen (FrameForm->HistoryListe->Strings [i + off]) != NULL)) {
      off++;
    } // while

    if (i + off + 1 >= FrameForm->HistoryListe->Count) break;

    menitem = new TMenuItem (EditorMainMenu);
    menitem->Caption = FrameForm->HistoryListe->Strings [i + off];
    menitem->OnClick = FrameForm->DateiMenuEndeClick;
    History1->Add (menitem);

    menitem = new TMenuItem (EditorPopupMenu);
    menitem->Caption = FrameForm->HistoryListe->Strings [i + off];
    menitem->OnClick = FrameForm->DateiMenuEndeClick;
    History2->Add (menitem);
  } // for
}
//---------------------------------------------------------------------------

void __fastcall TEditForm::FormDestroy(TObject *Sender)
{
  if (FrameForm->shutdown) return;
  if (FrameForm->MDIChildCount <= 1)
    FrameForm->SpeedButtonClose->Enabled = false;
  // ------------------- Speed-Buttons disable -------------------
  if (!FrameForm->SpeedButtonClose->Enabled){
    FrameForm->SpeedButtonSave->Enabled = false;
    FrameForm->SpeedButtonSaveAs->Enabled = false;
//    FrameForm->SpeedButtonClose->Enabled = false;
    FrameForm->SpeedButtonLoadFromCursor->Enabled = false;
    FrameForm->SpeedButtonFind->Enabled = false;
    FrameForm->SpeedButtonReplace->Enabled = false;
    FrameForm->SpeedButtonCut->Enabled = false;
    FrameForm->SpeedButtonCopy->Enabled = false;
    FrameForm->SpeedButtonPaste->Enabled = false;
    FrameForm->SpeedButtonUndo->Enabled = false;
    FrameForm->SpeedButtonPrint->Enabled = false;
    FrameForm->SpeedButtonPrevious->Enabled = false;
    FrameForm->SpeedButtonNext->Enabled = false;

    FrameForm->SpeedButtonBold->Enabled = false;
    FrameForm->SpeedButtonItalic->Enabled = false;
    FrameForm->SpeedButtonUnderline->Enabled = false;
    FrameForm->SpeedButtonLeft->Enabled = false;
    FrameForm->SpeedButtonCenter->Enabled = false;
    FrameForm->SpeedButtonRight->Enabled = false;
    FrameForm->SpeedButtonBullets->Enabled = false;
//    FrameForm->SpeedButtonProtect->Enabled = false;

  } // if SpeedButtonSave

}
//---------------------------------------------------------------------------

void __fastcall TEditForm::Historybrowseroeffnen1Click(TObject *Sender)
{
  // Hier Stringlistendialog ffnen ...
//  ShowMessage ("Stringlistendialog (Historybrowser) noch nicht implementiert!");
  FrameForm->Historybrowseroeffnen1Click (Sender);
}
//---------------------------------------------------------------------------


void __fastcall TEditForm::ReadOnly1Click(TObject *Sender)
{
  Editor->ReadOnly = !Editor->ReadOnly;
  ReadOnly1->Checked = Editor->ReadOnly;        
}
//---------------------------------------------------------------------------

void __fastcall TEditForm::OpenLastDoc1Click(TObject *Sender)
{
  FrameForm->OpenLastDocument1Click (Sender);
}
//---------------------------------------------------------------------------

void __fastcall TEditForm::FormActivate(TObject *Sender)
{

  SetupRuler();
  // ------------------- Speed-Buttons enable -------------------
//  SpeedButtonWriteback->Down = backwards;
  SetCurrentDir (ExtractFileDir (Pfad));
  if (!FrameForm->SpeedButtonSave->Enabled){
/*    if (EditorMainMenu->Items->Count > 0)
      FrameForm->SaveMenu (EditorMainMenu->Items, "EditorMainMenu");
    if (EditorPopupMenu->Items->Count > 0)
      FrameForm->SaveMenu (EditorPopupMenu->Items, "EditorPopupMenu");
*/
    FrameForm->SpeedButtonSave->Enabled = true;
    FrameForm->SpeedButtonSaveAs->Enabled = true;
    FrameForm->SpeedButtonClose->Enabled = true;
    FrameForm->SpeedButtonLoadFromCursor->Enabled = true;
    FrameForm->SpeedButtonFind->Enabled = true;
    FrameForm->SpeedButtonReplace->Enabled = true;
    FrameForm->SpeedButtonCut->Enabled = true;
    FrameForm->SpeedButtonCopy->Enabled = true;
    FrameForm->SpeedButtonPaste->Enabled = true;
    FrameForm->SpeedButtonUndo->Enabled = true;
    FrameForm->SpeedButtonPrint->Enabled = true;
    FrameForm->SpeedButtonPrevious->Enabled = true;
    FrameForm->SpeedButtonNext->Enabled = true;

    FrameForm->SpeedButtonBold->Enabled = true;
    FrameForm->SpeedButtonItalic->Enabled = true;
    FrameForm->SpeedButtonUnderline->Enabled = true;
    FrameForm->SpeedButtonLeft->Enabled = true;
    FrameForm->SpeedButtonCenter->Enabled = true;
    FrameForm->SpeedButtonRight->Enabled = true;
    FrameForm->SpeedButtonBullets->Enabled = true;
    FrameForm->SpeedButtonProtect->Enabled = true;

  } // if SpeedButtonSave
//  virtualSelStart = Editor->SelStart;
//  FrameForm->lastUserinput = 0;
  cursChanged = false;
  if (Editor) CursorDaten (Editor);
}
//---------------------------------------------------------------------------

void __fastcall TEditForm::FormClick(TObject *Sender)
{
  if (Editor) CursorDaten (Editor);
}
//---------------------------------------------------------------------------

void __fastcall TEditForm::CreateMenufile1Click(TObject *Sender)
{
  FrameForm->doSaveMenu ();
  if (EditorMainMenu->Items->Count > 0)
    FrameForm->SaveMenu (EditorMainMenu->Items, "EditorMainMenu");
  if (EditorPopupMenu->Items->Count > 0)
    FrameForm->SaveMenu (EditorPopupMenu->Items, "EditorPopupMenu");
}
//---------------------------------------------------------------------------

void __fastcall TEditForm::DeleteMenufile1Click(TObject *Sender)
{
  FrameForm->DeleteMenuFile1Click (Sender);
}
//---------------------------------------------------------------------------

void __fastcall TEditForm::GlobalSettings1Click(TObject *Sender)
{
  FrameForm->GlobalSettings1Click (Sender);
}
//---------------------------------------------------------------------------

void __fastcall TEditForm::Printfromfilename1Click(TObject *Sender)
{
//  ShowMessage ("Print from filename not yet implemented");
  AnsiString          NameAtCursor;
  TEditForm *EdForm = dynamic_cast <TEditForm*> (FrameForm->ActiveMDIChild);
  if (EdForm == NULL) return;
  NameAtCursor = EdForm->GetNameAtCursor ();
//ShowMessage ("'" + NameAtCursor + "'");
  if (FileExists (NameAtCursor)) {
    EditForm = new TEditForm (this);
    EditForm->Oeffnen (NameAtCursor);
    EditForm->Print1Click(Sender);
    EditForm->Close();
  }
  else {
    ShowMessage ("'" + NameAtCursor + "' not found");
//    DateiOeffnenDialog->FileName = NameAtCursor;
//    Open1Click (Sender);
  }
}
//---------------------------------------------------------------------------

void __fastcall TEditForm::SpeedButtonSelectAllClick(TObject *Sender)
{
  if (Editor->SelLength == 0)
    SelectAll1Click (Sender);
  else
    Editor->SelLength = 0;
}
//---------------------------------------------------------------------------

void __fastcall TEditForm::SpeedButtonEditorLoadFromCursorClick(TObject *Sender)
{
  LoadFileAtCursor1Click(Sender);        
}
//---------------------------------------------------------------------------


void __fastcall TEditForm::RulerResize(TObject *Sender)
{
     RulerLine->Width = (int)Ruler->ClientWidth - (RulerLine->Left*2);
}
//---------------------------------------------------------------------------

void __fastcall TEditForm::Test11Click(TObject *Sender)
{
  Char MyLine [256];
//  AnsiString MyLine;
//  MyLine = Editor->Lines->Strings [Row - 1].c_str();
}
//---------------------------------------------------------------------------

void __fastcall TEditForm::SpeedButtonWritebackClick(TObject *Sender)
{
  backwards = SpeedButtonWriteback->Down;
//  Left1Click (Sender);
//  Editor->WordWrap = false;
}


void __fastcall TEditForm::TextSettings1Click(TObject *Sender)
{
  ShowMessage ("Sorry - this is not yet implemented!");
}
//---------------------------------------------------------------------------

void __fastcall TEditForm::EditorChange(TObject *Sender)
{
//  cursChanged = true;
  if (Editor->Modified) CursorDaten (Sender);
}
//---------------------------------------------------------------------------
void __fastcall TEditForm::StatusBar1DrawPanel(TStatusBar *StatusBar,
      TStatusPanel *Panel, const TRect &Rect)
{
  if (Panel->Index == 6)
    if (Editor->Modified)
      StatusBar1->Canvas->Font->Color = clRed;
    else
      StatusBar1->Canvas->Font->Color = clGreen;
  else
    StatusBar1->Canvas->Font->Color = clBlue;

  StatusBar1->Canvas->Brush->Color = StatusBar1->Brush->Color;

  StatusBar1->Canvas->FillRect (Rect);
  StatusBar1->Canvas->TextRect (Rect, Rect.Left + 5, Rect.Top + 1, Panel->Text);
}
//---------------------------------------------------------------------------

void __fastcall TEditForm::EditorProtectChange(TObject *Sender,
      int StartPos, int EndPos, bool &AllowChange)
{
  if (!FrameForm->SpeedButtonProtect->Down)
    AllowChange = true;        
}
//---------------------------------------------------------------------------

void __fastcall TEditForm::NamebeiCursorselektieren1Click(TObject *Sender)
{
  AnsiString CursorName = GetNameAtCursor ();
//  ShowMessage (CursorName);
}
//---------------------------------------------------------------------------

void __fastcall TEditForm::RulerItemMouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{    TLabel * oTmpLabel = (TLabel *)Sender;
     FDragOfs = oTmpLabel->Width / 2;
     oTmpLabel->Left = oTmpLabel->Left+X-FDragOfs;
     FDragging = True;
}
//---------------------------------------------------------------------------

void __fastcall TEditForm::RulerItemMouseMove(TObject *Sender,
      TShiftState Shift, int X, int Y)
{    if (FDragging) {
        TLabel * oTmpLabel = (TLabel *)Sender;
        oTmpLabel->Left = oTmpLabel->Left+X-FDragOfs;
     }
}
//---------------------------------------------------------------------------

void __fastcall TEditForm::FirstIndMouseUp(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{    FDragging = False;
     Editor->Paragraph->FirstIndent = int((FirstInd->Left+FDragOfs-GutterWid) / RulerAdj);
     LeftindMouseUp(Sender, Button, Shift, X, Y);
}
//---------------------------------------------------------------------------

void __fastcall TEditForm::LeftindMouseUp(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{    FDragging = False;
     Editor->Paragraph->LeftIndent = int((Leftind->Left+FDragOfs-GutterWid)/
                RulerAdj)-Editor->Paragraph->FirstIndent;
     CursorDaten(Sender);
}
//---------------------------------------------------------------------------

void __fastcall TEditForm::RightIndMouseUp(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{    FDragging = False;
     Editor->Paragraph->RightIndent =
         int((Ruler->ClientWidth-RightInd->Left+FDragOfs-2) /
         RulerAdj)-2*GutterWid;
     CursorDaten(Sender);
}
//---------------------------------------------------------------------------

void __fastcall TEditForm::Undo1Click(TObject *Sender)
{
   SendMessage (Editor->Handle, EM_UNDO, 0, 0);
}
//---------------------------------------------------------------------------

void __fastcall TEditForm::SetupPage1Click(TObject *Sender)
{
//  if (PageSetupDialog1->Execute());
  FrameForm->GlobalSettings1Click (Sender);
  AllgEinstellDialog->PageControl1->ActivePage = AllgEinstellDialog->Seiten_Druckerlayout;
}
//---------------------------------------------------------------------------

void __fastcall TEditForm::FindWordAtCursor1Click(TObject *Sender)
{
  FrameForm->FindDialog1->FindTextA = GetNameAtCursor ();
  FrameForm->FindDialog1->Execute ();
}
//---------------------------------------------------------------------------

void __fastcall TEditForm::FindAgain1Click(TObject *Sender)
{
  if (FrameForm->FindDialog1->FindTextA == "")
    FindWordAtCursor1Click (Sender);
  else
    FrameForm->FindDialog1Find(FrameForm->FindDialog1);
}
//---------------------------------------------------------------------------

void __fastcall TEditForm::EditorSelectionChange(TObject *Sender)
{
  cursChanged = true;
  CursorDaten(Sender);
}
//---------------------------------------------------------------------------

