// Stand: 22. 10. 99
// Version: 0.22
//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "GlobalEinstellungen.h"
#include "CLRFrame.h"
#include "CLREdit.h"
#include <vcl\inifiles.hpp>
#include <stdio.h>
#include <vcl\printers.hpp>
//---------------------------------------------------------------------------
#pragma resource "*.dfm"
TAllgEinstellDialog *AllgEinstellDialog;
//---------------------------------------------------------------------------
__fastcall TAllgEinstellDialog::TAllgEinstellDialog(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TAllgEinstellDialog::ViewPrinterParams()
{
// Seitenparameter darstellen:

  int wPage = ::GetDeviceCaps (Printer()->Handle, PHYSICALWIDTH);
  int hPage = ::GetDeviceCaps (Printer()->Handle, PHYSICALHEIGHT);
  int xPPI = ::GetDeviceCaps (Printer()->Handle, LOGPIXELSX);
  int yPPI = ::GetDeviceCaps (Printer()->Handle, LOGPIXELSY);
  int xOffset = ::GetDeviceCaps (Printer()->Handle, PHYSICALOFFSETX);
  int yOffset = ::GetDeviceCaps (Printer()->Handle, PHYSICALOFFSETY);
  int xOffsetMM = (float) xOffset * 25.4 / xPPI;
  int yOffsetMM = (float) yOffset * 25.4 / yPPI;

  float InchW = (float) wPage / xPPI;
  float InchH = (float) hPage / yPPI;
  int wTwips = ::MulDiv (wPage, 1440, xPPI);
  int hTwips = ::MulDiv (hPage, 1440, yPPI);
  int wMM = (float) wPage * 25.4 / xPPI;
  int hMM = (float) hPage * 25.4 / yPPI;
  int hSize = ::GetDeviceCaps (Printer()->Handle, HORZSIZE);
  int vSize = ::GetDeviceCaps (Printer()->Handle, VERTSIZE);

  int IDefaultFontSize = FrameForm->DefaultFont->Size;
  int ITextHeight = FrameForm->GetTextHeight ("Testtext");
  int FontDU = MulDiv (IDefaultFontSize, yPPI, 72);
  int FontTwips = MulDiv (IDefaultFontSize, 1440, 72);
  float FontMM = (float) IDefaultFontSize * 25.4 / 72;
//  int FontTwips = MulDiv (ITextHeight, 1440, yPPI);
//  float FontMM = (float) ITextHeight * 25.4 / yPPI;

// Erstaunlich, dass man hier einfach int zuweisen kann ...
  StaticTextPhysicalW->Caption = wPage;
  StaticTextPhysicalH->Caption = hPage;
  StaticTextLogX->Caption = xPPI;
  StaticTextLogY->Caption = yPPI;
  StaticTextInchW->Caption = AnsiString::FloatToStrF (InchW, AnsiString::sffFixed, 7, 2);
  StaticTextInchH->Caption = AnsiString::FloatToStrF (InchH, AnsiString::sffFixed, 7, 2);

  StaticTextwTwips->Caption = wTwips;
  StaticTexthTwips->Caption = hTwips;
  StaticTextwMM->Caption = wMM;
  StaticTexthMM->Caption = hMM;
  StaticTextHorSize->Caption = hSize;
  StaticTextVertSize->Caption = vSize;
  StaticTextXOffset->Caption = xOffsetMM;
  StaticTextYOffset->Caption = yOffsetMM;

  StaticTextFontTwips->Caption = FontTwips;
  StaticTextFontDU->Caption = FontDU;
  StaticTextFontMM->Caption = AnsiString::FloatToStrF (FontMM, AnsiString::sffFixed, 7, 2);

  DefaultFontSize->Caption = IDefaultFontSize;
//  TextHeight->Caption = ITextHeight;
  StaticTextFont->Caption = FrameForm->DefaultFont->Name;
  StaticTextPrinter->Caption = Printer()->Printers->Strings[Printer()->PrinterIndex];
}
//---------------------------------------------------------------------------
void __fastcall TAllgEinstellDialog::EditHeaderMarginChange(TObject *Sender)
{
  if (EditHeaderMargin->Text != "")
    FrameForm->Konfig.HeaderMargin = EditHeaderMargin->Text.ToInt();
}
//---------------------------------------------------------------------------
void __fastcall TAllgEinstellDialog::EditLeftMarginChange(TObject *Sender)
{
  if (EditLeftMargin->Text != "")
    FrameForm->Konfig.LeftMargin = EditLeftMargin->Text.ToInt();
}
//---------------------------------------------------------------------------
void __fastcall TAllgEinstellDialog::EditRightMarginChange(TObject *Sender)
{
  if (EditRightMargin->Text != "")
    FrameForm->Konfig.RightMargin = EditRightMargin->Text.ToInt();
}
//---------------------------------------------------------------------------
void __fastcall TAllgEinstellDialog::EditTopMarginChange(TObject *Sender)
{
  if (EditTopMargin->Text != "")
    FrameForm->Konfig.TopMargin = EditTopMargin->Text.ToInt();
}
//---------------------------------------------------------------------------
void __fastcall TAllgEinstellDialog::EditBottomMarginChange(TObject *Sender)
{
  if (EditBottomMargin->Text != "")
    FrameForm->Konfig.BottomMargin = EditBottomMargin->Text.ToInt();
}
//---------------------------------------------------------------------------
void __fastcall TAllgEinstellDialog::EditorFensterRadioGroupClick(
	TObject *Sender)
{
  FrameForm->DefaultWindow.FrameWinDefault = true;
  switch (EditorFensterRadioGroup->ItemIndex) {
    case 0:		FrameForm->DefaultWindow.FramePos = poDesigned; break;
    case 1:		FrameForm->DefaultWindow.FramePos = poDefault; break;
    case 2:		FrameForm->DefaultWindow.FramePos = poDefaultPosOnly; break;
    case 3:		FrameForm->DefaultWindow.FramePos = poDefaultSizeOnly; break;
    case 4:		FrameForm->DefaultWindow.FramePos = poScreenCenter; break;
    case 5:		FrameForm->DefaultWindow.FrameWinDefault = false; break;
  }
//  FrameForm->Position = FrameForm->DefaultWindow.FramePos;
}
//---------------------------------------------------------------------------
void __fastcall TAllgEinstellDialog::TextFensterRadioGroupClick(TObject *Sender)
{
  FrameForm->DefaultWindow.ChildWinDefault = true;
  switch (TextFensterRadioGroup->ItemIndex) {
    case 0:		FrameForm->DefaultWindow.ChildPos = poDesigned; break;
    case 1:		FrameForm->DefaultWindow.ChildPos = poDefault; break;
    case 2:		FrameForm->DefaultWindow.ChildPos = poDefaultPosOnly; break;
    case 3:		FrameForm->DefaultWindow.ChildPos = poDefaultSizeOnly; break;
    case 4:		FrameForm->DefaultWindow.ChildPos = poScreenCenter; break;
    case 5:		FrameForm->DefaultWindow.ChildWinDefault = false; break;
  }
}
//---------------------------------------------------------------------------
void __fastcall TAllgEinstellDialog::KonfSpeichButtonClick(TObject *Sender)
{
  TFontEinstellungen TextAttr;
  FILE *FontFile;
  if (FrameForm->DefaultFont != NULL)
    FontVoreinstellDialog->Font = FrameForm->DefaultFont;
  if (FontVoreinstellDialog->Execute()){
    FrameForm->DefaultFont = FontVoreinstellDialog->Font;
    TextAttr.col = FrameForm->DefaultFont->Color;
    TextAttr.Nam = FrameForm->DefaultFont->Name;
    TextAttr.Pit = FrameForm->DefaultFont->Pitch;
    TextAttr.Siz = FrameForm->DefaultFont->Size;
    TextAttr.Styl = FrameForm->DefaultFont->Style;
    TextAttr.Hei = FrameForm->DefaultFont->Height;

// --- Dateidialog, ev. durch Dateimanager ersetzen
    SaveKonfig->FileName = ChangeFileExt (Application->ExeName, ".FON");
    SaveKonfig->Title = "Default-Font speichern";
    SaveKonfig->Filter = "Font-Datei (*.FON)|*.FON|Alle Dateien (*.*)|*.*";
    if (SaveKonfig->Execute()){
      FontFile = fopen (SaveKonfig->FileName.c_str(), "wb");
      fwrite (&TextAttr, sizeof (TFontEinstellungen), 1, FontFile);
      fclose (FontFile);
    } // if SaveKonfig

  } // if FontVoreinstellDialog->Execute
}
//---------------------------------------------------------------------------
void __fastcall TAllgEinstellDialog::KonfLadButtonClick(TObject *Sender)
{
  TFontEinstellungen TextAttr;
  FILE *FontFile;
  OpenKonfig->FileName = ChangeFileExt (Application->ExeName, ".FON");
  OpenKonfig->Title = "Default-Font laden";
  OpenKonfig->Filter = "Font-Datei (*.FON)|*.FON|Alle Dateien (*.*)|*.*";
  if (OpenKonfig->Execute()){
    FontFile = fopen (OpenKonfig->FileName.c_str(), "rb");
    if (FontFile != NULL) {
      fread (&TextAttr, sizeof (TFontEinstellungen), 1, FontFile);
      fclose (FontFile);
      FontVoreinstellDialog->Font->Color = TextAttr.col;
      FontVoreinstellDialog->Font->Name = TextAttr.Nam;
      FontVoreinstellDialog->Font->Pitch = TextAttr.Pit;
      FontVoreinstellDialog->Font->Size = TextAttr.Siz;
      FontVoreinstellDialog->Font->Style = TextAttr.Styl;
      FontVoreinstellDialog->Font->Height = TextAttr.Hei;
      if (FontVoreinstellDialog->Execute()){
        FrameForm->DefaultFont = FontVoreinstellDialog->Font;
      };
    } // if KonfigFile
  } // if OpenKonfig
}
//---------------------------------------------------------------------------
void __fastcall TAllgEinstellDialog::CheckSchaltleisteClick(TObject *Sender)
{
  FrameForm->Konfig.SchaltleisteAnzeigen = CheckSchaltleiste->Checked;
  FrameForm->PanelSpeed1->Visible = CheckSchaltleiste->Checked;
}
//---------------------------------------------------------------------------
void __fastcall TAllgEinstellDialog::CheckSchaltleiste2Click(TObject *Sender)
{
  FrameForm->Konfig.Schaltleiste2Anzeigen = CheckSchaltleiste2->Checked;
  FrameForm->PanelSpeedFont->Visible = CheckSchaltleiste2->Checked;
}
//---------------------------------------------------------------------------
void __fastcall TAllgEinstellDialog::CheckSchaltleiste3Click(TObject *Sender)
{
  FrameForm->Konfig.Schaltleiste3Anzeigen = CheckSchaltleiste3->Checked;
  FrameForm->PanelMedia->Visible = CheckSchaltleiste3->Checked;
}
//---------------------------------------------------------------------------
void __fastcall TAllgEinstellDialog::CheckLinealClick(TObject *Sender)
{
  FrameForm->Konfig.LinealAnzeigen = CheckLineal->Checked;
}
//---------------------------------------------------------------------------
void __fastcall TAllgEinstellDialog::CheckISOClick(TObject *Sender)
{
  FrameForm->Konfig.ISOAnzeigen = CheckISO->Checked;
  if (FrameForm->ActiveMDIChild == NULL) return;
  TEditForm *EdForm;
  if (EdForm = dynamic_cast <TEditForm *> (FrameForm->ActiveMDIChild)){
    EdForm->Status();
  } // if EdForm
}
//---------------------------------------------------------------------------
void __fastcall TAllgEinstellDialog::CheckWortumbruchClick(TObject *Sender)
{
  FrameForm->Konfig.WortUmbruch = CheckWortumbruch->Checked;
  if (FrameForm->ActiveMDIChild == NULL) return;
  TEditForm *EdForm;
  if (EdForm = dynamic_cast <TEditForm *> (FrameForm->ActiveMDIChild)){
    EdForm->Editor->WordWrap = CheckWortumbruch->Checked;
    if (EdForm->Editor->WordWrap)
      EdForm->Editor->ScrollBars = ssVertical; // Bei Zeilenumbruch nur vertikale Bildlaufleiste
    else
      EdForm->Editor->ScrollBars = ssBoth; // ohne Umbruch werden beide bentigt
    EdForm->WordWrap1->Checked = EdForm->Editor->WordWrap;
  } // if EdForm
}
//---------------------------------------------------------------------------
void __fastcall TAllgEinstellDialog::CheckTextfensterClick(TObject *Sender)
{
  FrameForm->Konfig.SaveTextWindow = CheckTextfenster->Checked;
}
//---------------------------------------------------------------------------
void __fastcall TAllgEinstellDialog::CheckStatusClick(TObject *Sender)
{
  FrameForm->Konfig.StatusLeiste = CheckStatus->Checked;
  FrameForm->StatusBar1->Visible = CheckStatus->Checked;
}
//---------------------------------------------------------------------------
void __fastcall TAllgEinstellDialog::CheckBoxAutoDateienClick(TObject *Sender)
{
  FrameForm->Konfig.AutoDateienMerken = CheckBoxAutoDateien->Checked;
}
//---------------------------------------------------------------------------
void __fastcall TAllgEinstellDialog::CheckBoxKeineDuplikateClick(
	TObject *Sender)
{
  FrameForm->Konfig.KeineDuplikateLaden = CheckBoxKeineDuplikate->Checked;
}
//---------------------------------------------------------------------------
int __stdcall EnumFontsProc (TLogFontA &LogFont, TTextMetricA &/*TextMetric*/,
							 int /*FontType*/, Pointer Data)
{
  ((TStrings *)Data)->Add((AnsiString)LogFont.lfFaceName);
  return 1;
} // EnumFontsProc
//---------------------------------------------------------------------------
void __fastcall TAllgEinstellDialog::FormCreate(TObject *Sender)
{
  PageControl1->ActivePage = GlobalAnzeige;
//ShowMessage ("AllgEinstellDialog::PageControlInit");
// -------- Diverse Voreinstellungen ------------------
  CheckBoxHistoryLaden->Checked = FrameForm->Konfig.AusHistoryLaden;
  MaxHistUpDown->Position = FrameForm->Konfig.MaxHistory;
//  MaxHistoryEdit->Text = AnsiString (FrameForm->Konfig.MaxHistory);
  LastHistoryUpDown->Position = FrameForm->Konfig.LastHistory;
//  LastHistoryEdit->Text = AnsiString (FrameForm->Konfig.LastHistory);
  ShowHisMenuUpdown->Position = FrameForm->Konfig.AnzeigeHistory;
//  ShowHisMenuEdit->Text = AnsiString (FrameForm->Konfig.AnzeigeHistory);

  UpDownSaveTime->Position = FrameForm->Konfig.saveIntervall;
  UpDownIncBackup->Position = FrameForm->Konfig.NIncBackup;

  CheckBoxAutoSave->Checked = FrameForm->Konfig.AutoSaveAbfrage;
  CheckBoxKonfigSave->Checked = FrameForm->Konfig.AutoSaveKonfig;
  CheckBoxBAK->Checked = FrameForm->Konfig.BAKErstellen;
  CheckIncBackup->Checked = FrameForm->Konfig.IncBackup;

  CheckSchaltleiste->Checked = FrameForm->Konfig.SchaltleisteAnzeigen;
  CheckSchaltleiste2->Checked = FrameForm->Konfig.Schaltleiste2Anzeigen;
  CheckSchaltleiste3->Checked = FrameForm->Konfig.Schaltleiste3Anzeigen;
  CheckLineal->Checked = FrameForm->Konfig.LinealAnzeigen;
  CheckISO->Checked = FrameForm->Konfig.ISOAnzeigen;
  CheckTextfenster->Checked = FrameForm->Konfig.SaveTextWindow;
  CheckWortumbruch->Checked = FrameForm->Konfig.WortUmbruch;
  CheckTextfenster->Checked = FrameForm->Konfig.SaveTextWindow;
  CheckStatus->Checked = FrameForm->Konfig.StatusLeiste;
  CheckExplorerTest->Checked = FrameForm->Konfig.NoExplorerTest;
  CheckBoxAutoSyntaxHighlight->Checked = FrameForm->Konfig.AutoSyntaxHighlight;
  CheckBoxAutoUmlaut->Checked = FrameForm->Konfig.AutoUmlaut;
  CheckBoxAutoTagAssistant->Checked = FrameForm->Konfig.AutoTagAssistant;
  CheckBoxAutoDateien->Checked = FrameForm->Konfig.AutoDateienMerken;
  CheckBoxKeineDuplikate->Checked = FrameForm->Konfig.KeineDuplikateLaden;
  CheckBoxAutoWebFenster->Checked = FrameForm->Konfig.AutoWebfenster;
  CheckBoxAutoHomepage->Checked = FrameForm->Konfig.AutoHomepage;
  CheckBoxAutoOnline->Checked = FrameForm->Konfig.AutoOnline;
  CheckBoxWebminimiert->Checked = FrameForm->Konfig.WebMinimiert;
  CheckBoxFontfilter->Checked = FrameForm->Konfig.UseFontfilter;
// -------- Drucker-Layout ----------------------------
  UpDownLeftMargin->Position = FrameForm->Konfig.LeftMargin;
  UpDownRightMargin->Position = FrameForm->Konfig.RightMargin;
  UpDownTopMargin->Position = FrameForm->Konfig.TopMargin;
  UpDownBottomMargin->Position = FrameForm->Konfig.BottomMargin;
  UpDownHeaderMargin->Position = FrameForm->Konfig.HeaderMargin;
  UpDownFooterMargin->Position = FrameForm->Konfig.FooterMargin;
  EditUeberschrift->Text = FrameForm->Konfig.PrintHeader;
  EditFusszeile->Text = FrameForm->Konfig.PrintFooter;
  CheckBoxFitPicture->Checked = FrameForm->Konfig.FitPicture;

// ---------- Fenster-Voreinstellungen ---------
  if (FrameForm->DefaultWindow.FrameWinDefault) {
    switch (FrameForm->DefaultWindow.FramePos) {
      case poDesigned:			EditorFensterRadioGroup->ItemIndex = 0; break;
      case poDefault:			EditorFensterRadioGroup->ItemIndex = 1; break;
      case poDefaultPosOnly:	EditorFensterRadioGroup->ItemIndex = 2; break;
      case poDefaultSizeOnly:	EditorFensterRadioGroup->ItemIndex = 3; break;
      case poScreenCenter:		EditorFensterRadioGroup->ItemIndex = 4; break;
    };
  }
  else
    EditorFensterRadioGroup->ItemIndex = 5;

  if (FrameForm->DefaultWindow.ChildWinDefault) {
    switch (FrameForm->DefaultWindow.ChildPos) {
      case poDesigned:			TextFensterRadioGroup->ItemIndex = 0; break;
      case poDefault:			TextFensterRadioGroup->ItemIndex = 1; break;
      case poDefaultPosOnly:	TextFensterRadioGroup->ItemIndex = 2; break;
      case poDefaultSizeOnly:	TextFensterRadioGroup->ItemIndex = 3; break;
      case poScreenCenter:		TextFensterRadioGroup->ItemIndex = 4; break;
    };
  }
  else
    TextFensterRadioGroup->ItemIndex = 5;

// ------------------- Projektdatei -----------------------
  try {
    ComboBoxProjekte->Items->LoadFromFile (ChangeFileExt (Application->ExeName, ".PRO"));
  }
  catch (EFOpenError*)
  {
    ShowMessage ("Kann Projekt-Datei nicht finden");
  }
   ComboBoxProjekte->Text =
     FrameForm->IniFile->ReadString ("Projects", "ActualProject",
       ExtractFileName (ChangeFileExt (Application->ExeName, ".HIS")));


  HDC hDC = GetDC (0);
  void * cTmp = (void *)ListBoxFonts->Items;
  EnumFonts (hDC, NULL, (FONTENUMPROC) EnumFontsProc, (long) cTmp);
  ReleaseDC (0, hDC);
  ListBoxFonts->Sorted = TRUE;

  FrameForm->IniFile->ReadSection ("Fontfilter", ListBoxFontfilter->Items);
}
//---------------------------------------------------------------------------
void __fastcall TAllgEinstellDialog::CheckBoxHistoryLadenClick(TObject *Sender)
{
    FrameForm->Konfig.AusHistoryLaden = CheckBoxHistoryLaden->Checked;
}
//---------------------------------------------------------------------------
void __fastcall TAllgEinstellDialog::MaxHistoryEditChange(TObject *Sender)
{
  if (MaxHistoryEdit->Text != "")
    FrameForm->Konfig.MaxHistory = MaxHistoryEdit->Text.ToInt();
}
//---------------------------------------------------------------------------
void __fastcall TAllgEinstellDialog::LastHistoryEditChange(TObject *Sender)
{
  if (LastHistoryEdit->Text != "")
    FrameForm->Konfig.LastHistory = LastHistoryEdit->Text.ToInt();
}
//---------------------------------------------------------------------------
void __fastcall TAllgEinstellDialog::ShowHisMenuEditChange(TObject *Sender)
{
  if (ShowHisMenuEdit->Text != "")
    FrameForm->Konfig.AnzeigeHistory = ShowHisMenuEdit->Text.ToInt();
}
//---------------------------------------------------------------------------
void __fastcall TAllgEinstellDialog::FormDestroy(TObject *Sender)
{
  FrameForm->IniFile->WriteString ("Projects", "ActualProject", ComboBoxProjekte->Text);
  int i;
  FrameForm->IniFile->EraseSection ("Fontfilter");
  for (i = 0; i < ListBoxFontfilter->Items->Count; i++)
    FrameForm->IniFile->WriteString ("Fontfilter", ListBoxFontfilter->Items->Strings [i], ListBoxFontfilter->Items->Strings [i]);

  try {
    ComboBoxProjekte->Items->SaveToFile (ChangeFileExt (Application->ExeName, ".PRO"));
  }
  catch (EFCreateError*)
  {
    ShowMessage ("Kann Projekt-Datei nicht anlegen");
  }
}
//---------------------------------------------------------------------------
void __fastcall TAllgEinstellDialog::ComboBoxProjekteKeyDown(TObject *Sender,
	WORD &Key, TShiftState Shift)
{
  TShiftState leer;
//  if ((Shift == leer) && (Key == VK_INSERT)) {
  if (Shift == leer) {
//    strcpy (keyname, "Einf");
//    Application->MessageBox (keyname, "Taste gedrck:", MB_OK);
    switch (Key) {
      case VK_RETURN: if (ComboBoxProjekte->Items->IndexOf (ComboBoxProjekte->Text) == -1)
                        ComboBoxProjekte->Items->Insert (0, ComboBoxProjekte->Text);
                      break;
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TAllgEinstellDialog::ComboBoxProjekteChange(TObject *Sender)
{
  FrameForm->ProjektName = ComboBoxProjekte->Text;
  FrameForm->ProjektFile->UpdateFile();
  delete FrameForm->ProjektFile;
  FrameForm->ProjektFile =
    new TIniFile (ExtractFilePath (Application->ExeName) +
      ChangeFileExt (FrameForm->ProjektName, ".WIN"));
}
//---------------------------------------------------------------------------
void __fastcall TAllgEinstellDialog::ButtonProjektLadenClick(TObject *Sender)
{
  if ((FrameForm->ProjektName != "") && (UpperCase (FrameForm->ProjektName) != ExtractFileName (ChangeFileExt (Application->ExeName, ".HIS")))) {
    try {
      FrameForm->ProjektListe->LoadFromFile (FrameForm->ProjektName);
      FrameForm->AlleSchliessen();
      FrameForm->OpenFirstDocsInHistory1Click (this);
    }
    catch (EFOpenError*) {
      ShowMessage ("Keine Projekt-Liste gefunden!");
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TAllgEinstellDialog::ComboBoxProjekteClick(TObject *Sender)
{
  FrameForm->ProjektName = ComboBoxProjekte->Text;
}
//---------------------------------------------------------------------------
void __fastcall TAllgEinstellDialog::Projekthinzufuegen1Click(
      TObject *Sender)
{
  if (ComboBoxProjekte->Items->IndexOf (ComboBoxProjekte->Text) == -1)
    ComboBoxProjekte->Items->Insert (0, ComboBoxProjekte->Text);
}
//---------------------------------------------------------------------------

void __fastcall TAllgEinstellDialog::ProjektausListeentfernen1Click(
      TObject *Sender)
{
  ComboBoxProjekte->Items->Delete (ComboBoxProjekte->ItemIndex);
}
//---------------------------------------------------------------------------

void __fastcall TAllgEinstellDialog::CheckBoxBAKClick(TObject *Sender)
{
  FrameForm->Konfig.BAKErstellen = CheckBoxBAK->Checked;
  CheckIncBackup->Enabled = CheckBoxBAK->Checked;
  EditIncBackup->Enabled = CheckBoxBAK->Checked;
  UpDownIncBackup->Enabled = CheckBoxBAK->Checked;
}
//---------------------------------------------------------------------------

void __fastcall TAllgEinstellDialog::EditSaveTimeChange(TObject *Sender)
{
  if (EditSaveTime->Text != "")
    FrameForm->Konfig.saveIntervall = EditSaveTime->Text.ToInt();
}
//---------------------------------------------------------------------------

void __fastcall TAllgEinstellDialog::EditIncBackupChange(TObject *Sender)
{
  if (EditIncBackup->Text != "")
    FrameForm->Konfig.NIncBackup = EditIncBackup->Text.ToInt();
}
//---------------------------------------------------------------------------

void __fastcall TAllgEinstellDialog::CheckBoxAutoSaveClick(TObject *Sender)
{
  FrameForm->Konfig.AutoSaveAbfrage = CheckBoxAutoSave->Checked;
}
//---------------------------------------------------------------------------

void __fastcall TAllgEinstellDialog::CheckBoxKonfigSaveClick(
      TObject *Sender)
{
  FrameForm->Konfig.AutoSaveKonfig = CheckBoxKonfigSave->Checked;
}
//---------------------------------------------------------------------------

void __fastcall TAllgEinstellDialog::CheckIncBackupClick(TObject *Sender)
{
  FrameForm->Konfig.IncBackup = CheckIncBackup->Checked;
}
//---------------------------------------------------------------------------

void __fastcall TAllgEinstellDialog::ButtonNichtSpeichernClick(
      TObject *Sender)
{
  EditSaveTime->Text = "0";
}
//---------------------------------------------------------------------------

void __fastcall TAllgEinstellDialog::Button10SekClick(TObject *Sender)
{
  EditSaveTime->Text = "10";
}
//---------------------------------------------------------------------------

void __fastcall TAllgEinstellDialog::Button30SekClick(TObject *Sender)
{
  EditSaveTime->Text = "30";
}
//---------------------------------------------------------------------------

void __fastcall TAllgEinstellDialog::Button5MinClick(TObject *Sender)
{
  EditSaveTime->Text = "300";
}
//---------------------------------------------------------------------------

void __fastcall TAllgEinstellDialog::CheckBoxFitPictureClick(
      TObject *Sender)
{
  FrameForm->Konfig.FitPicture = CheckBoxFitPicture->Checked;
}
//---------------------------------------------------------------------------

void __fastcall TAllgEinstellDialog::ButtonProjektSpeichernClick(
      TObject *Sender)
{
  ShowMessage ("Ups - noch nicht implementiert. Projekt wird aber beim Beenden des Editors gespeichert!");
}
//---------------------------------------------------------------------------

void __fastcall TAllgEinstellDialog::EditFooterMarginChange(
      TObject *Sender)
{
  if (EditFooterMargin->Text != "")
    FrameForm->Konfig.FooterMargin = EditFooterMargin->Text.ToInt();
}
//---------------------------------------------------------------------------


void __fastcall TAllgEinstellDialog::EditUeberschriftChange(
      TObject *Sender)
{
  FrameForm->Konfig.PrintHeader = EditUeberschrift->Text;
}
//---------------------------------------------------------------------------

void __fastcall TAllgEinstellDialog::EditFusszeileChange(TObject *Sender)
{
  FrameForm->Konfig.PrintFooter = EditFusszeile->Text;
}
//---------------------------------------------------------------------------

void __fastcall TAllgEinstellDialog::SpeedButtonPrinterClick(
      TObject *Sender)
{
  EditForm->PrinterSetupDialog1->Execute (); // Dialogfeld "Druckereinrichtung" ausfhren
  ViewPrinterParams ();
}
//---------------------------------------------------------------------------

void __fastcall TAllgEinstellDialog::SpeedButtonAddFontClick(
      TObject *Sender)
{
  if (ListBoxFonts->ItemIndex >= 0){
    if (ListBoxFontfilter->Items->IndexOf (ListBoxFonts->Items->Strings [ListBoxFonts->ItemIndex]) < 0)
      ListBoxFontfilter->Items->Append (ListBoxFonts->Items->Strings [ListBoxFonts->ItemIndex]);
  }
}
//---------------------------------------------------------------------------

void __fastcall TAllgEinstellDialog::SpeedButtonDeleteFontClick(
      TObject *Sender)
{
  if (ListBoxFontfilter->ItemIndex >= 0)
    ListBoxFontfilter->Items->Delete (ListBoxFontfilter->ItemIndex);
}
//---------------------------------------------------------------------------

void __fastcall TAllgEinstellDialog::CheckBoxFontfilterClick(
      TObject *Sender)
{
  FrameForm->Konfig.UseFontfilter = CheckBoxFontfilter->Checked;
  if (FrameForm->Konfig.UseFontfilter)
    FrameForm->FontName->Items->SetText (ListBoxFontfilter->Items->GetText ());
  else
    FrameForm->FontName->Items->SetText (ListBoxFonts->Items->GetText ());
}
//---------------------------------------------------------------------------

void __fastcall TAllgEinstellDialog::SpeedButtonUpdateFontsClick(
      TObject *Sender)
{
    FrameForm->FontName->Items->SetText (ListBoxFontfilter->Items->GetText ());
}
//---------------------------------------------------------------------------

void __fastcall TAllgEinstellDialog::SpeedButtonAddAllClick(
      TObject *Sender)
{
    ListBoxFontfilter->Items->SetText (ListBoxFonts->Items->GetText ());
}
//---------------------------------------------------------------------------

void __fastcall TAllgEinstellDialog::SpeedButtonDeleteAllFontsClick(
      TObject *Sender)
{
    ListBoxFontfilter->Clear();
}
//---------------------------------------------------------------------------

void __fastcall TAllgEinstellDialog::SpeedButtonUndoFontsClick(TObject *Sender)
{
    ListBoxFontfilter->Items->SetText (FrameForm->FontName->Items->GetText ());
}
//---------------------------------------------------------------------------

void __fastcall TAllgEinstellDialog::FormClose(TObject *Sender,
      TCloseAction &Action)
{
  if (FrameForm->Konfig.UseFontfilter)
    FrameForm->FontName->Items->SetText (ListBoxFontfilter->Items->GetText ());
  else
    FrameForm->FontName->Items->SetText (ListBoxFonts->Items->GetText ());
}
//---------------------------------------------------------------------------

void __fastcall TAllgEinstellDialog::FormActivate(TObject *Sender)
{
  ViewPrinterParams ();
}
//---------------------------------------------------------------------------

void __fastcall TAllgEinstellDialog::SpeedButtonHeaderFontClick(
      TObject *Sender)
{
  TFontEinstellungen TextAttr;
  if (FrameForm->DefaultFont != NULL)
    FontVoreinstellDialog->Font = FrameForm->DefaultFont;
  if (FontVoreinstellDialog->Execute()){
    FrameForm->DefaultFont = FontVoreinstellDialog->Font;
    ViewPrinterParams ();
  } // if FontVoreinstellDialog->Execute
}
//---------------------------------------------------------------------------


