	title	Uhrdevice mit Hardwaresupport

cseg	segment	para public 'code'

clk	proc	far
	assume cs:cseg,ds:cseg,es:cseg

begin:
start	equ	$
;
; device header
;
nextdev	dd	-1
att	dw	8008h		;es ist eine uhr
str	dw	devstrat	;device strategy entry
dint	dw	devint		;device interrupt
defn	db	'CLOCK$'	;device name
	db	0,0		;noch zwei bytes frei
funtab	label	byte		;functionstabelle
	dw	init		;initialisierung
	dw	mediacheck
	dw	buildbpb
	dw	ioctlin
	dw	input		;input
	dw	ndinput
	dw	instat
	dw	inflush
	dw	output		;output
	dw	outverify
	dw	outstat
	dw	outflush
	dw	ioctlout
uhrptr	dd	?
	dd	?
sec	db	?
rsec	db	?
min	db	?
tmin	db	?
hour	db	?
thour	db	?
week	db	?
day	db	?
tday	db	?
month	db	?
tmonth	db	?
year	db	?
tyear	db	?
hilf	db	?
hilf1	db	?
uport	equ	66h
uinpo	equ	65h
tagtab	dw	0
	dw	0
	dw	31
	dw	59
	dw	90
	dw	120
	dw	151
	dw	181
	dw	212
	dw	243
	dw	273
	dw	304
	dw	334
;
;   d e v i c e   s t r a t e g y
; abspeichern des Parameterblocks fuer den Interrupt
;
devstrat:
	mov	cs:word ptr [uhrptr+2],es
	mov	cs:word ptr [uhrptr],bx
	ret
;
;   d e v i c e   i n t e r r u p t
; Ausfuehren einer Taetigkeit
;
devint:
; allgemeiner Anfang
	cld			;retten aller Parameter
	push	ds
	push	es
	push	ax
	push	bx
	push	cx
	push	dx
	push	di
	push	si
	lds	bx,cs:[uhrptr]	;ds auf festes Parameterfeld
	mov	al,2[bx]	;der zweite Parameter ist die 
	rol	al,1		;auszufuehrende Funktion
	lea	si,cs:funtab	;berechnung des Einsprunges
	xor	ah,ah
	add	si,ax
	les	di,14[bx]	;di:es steht auf den Uhrparametern
	jmp	cs:word ptr [si]	;auf gehts
mediacheck:
buildbpb:
ioctlin:
ndinput:
instat:
inflush:
outverify:
outstat:
outflush:
ioctlout:
	or	3[bx],1103h	;Fehler, da nicht implementiert
	jmp	exit
;
init:
	lea	ax,uhren
	mov	cl,4
	ror	ax,cl
	mov	dx,cs
	add	dx,ax
	mov	word ptr 14[bx],0
	mov	word ptr 16[bx],dx
output:
	or	3[bx],100h	;kein Fehler passiert
	jmp	exit

;
;input = read clock
;
input:
	cli
inloop:
	mov	bx,offset sec
	mov	al,0
	mov	cx,13
inl1:
	or	al,10h
	out	uport,al
	or	al,80h
	out	uport,al
	and	al,7fh
	out	uport,al
	or	al,40h
	out	uport,al
	push	ax
	in	al,uinpo
	mov	cs:[bx],al
	test	al,10h
	pop	ax
	jz	inloop
	and	byte ptr cs:[bx],0fh
	and	al,0bfh
	out	uport,al
	and	al,0fh
	out	uport,al
	inc	bx
	inc	al
	loop	inl1
	sti
	mov	al,cs:tyear
	sub	al,8
	jge	noko
	add	al,0ah
noko:
	mov	bl,10
	mul	bl
	add	al,cs:year
	mov	ah,0
	push	ax
	mov	bx,4
	mov	dx,0
	div	bx
	inc	al
	mov	cs:hilf,al
	mov	cs:hilf1,dl
	pop	ax
	mov	bx,365
	mul	bx
	mov	bx,0
	cmp	cs:tmonth,1
	jnz	noko1
	mov	bl,10
noko1:
	add	bl,cs:month
	cmp	cs:hilf1,0
	jnz	noko2
	cmp	bl,3
	jge	noko2
	dec	cs:hilf
noko2:
	sal	bx,1
	mov	bx,cs:tagtab[bx]
	mov	cx,ax
	add	cx,bx
	mov	ah,0
	mov	al,cs:hilf
	add	cx,ax
	mov	al,cs:day
	add	cx,ax
	mov	al,cs:tday
	mov	bl,10
	mul	bl
	add	cx,ax
	dec	cx		;1-1-80 = 0 !!! und nicht 1 !!!
	mov	[di],cx
	mov	bx,offset hour
	and	byte ptr cs:1[bx],03h	;nur fuer 24 Stunden Betrieb
	call	conv
	mov	3[di],al
	mov	bx,offset min
	call	conv
	mov	2[di],al
	mov	bx,offset sec
	call	conv
	mov	5[di],al
	mov	byte ptr 4[di],0
;
; allgemeiner Ausgang
;
exit:
	or	3[bx],100h	;kein Fehler aufgetreten
	pop	si
	pop	di
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	pop	es
	pop	ds
	ret
conv	proc	near
	mov	al,cs:1[bx]
	mov	cl,10
	mul	cl
	add	al,cs:[bx]
	ret
conv	endp
	org	($-start)+16-(($-start)mod 16) ;nur volle Segmente
uhren	db	?
clk	endp
cseg	ends
	end	start
