(*****************************************************)
(*****                                           *****)
(***          zeilenscanner-demoprogramm           ***)
(**                                                 **)
(**            turbo-pascal-version 2.2             **)
(**                                                 **)
(***     16. november 1987 / sven b. schreiber     ***)
(*****                                           *****)
(*****************************************************)



program lscan (input,output);

const hsize      =   5;      (* zeichengroesse horizontal                   *)
      vsize      =   5;      (* zeichengroesse vertikal                     *)
      nval       =   8;      (* anzahl der werteintraege                    *)
      linelength =  13;      (* maximale laenge einer eingabezeile          *)
      scanlength =  78;      (* scanzeilenlaenge = linelength * (hsize + 1) *)
      dim1       =  25;      (* anzahl der eigenschaften = hsize * vsize    *)
      dim2       =  33;      (* anzahl der eigenschaften = dim1 + nval      *)
      pos        =   2;      (* wert fuer vorhandene eigenschaft            *)
      neg        =  -1.5;    (* wert fuer nicht vorhandene eigenschaft      *)
      atten      =  10;      (* rueckkopplungsdaempfung                     *)
      novlim     =   0.530;  (* obere grenze des neuheitsbetrags            *)
      ntrials    = 200;      (* anzahl der durchgaenge                      *)
      magnif     =   1.8;    (* vergroesserungsfaktor der neuheitsgrafik    *)

      heading_r  =   0;      (* koordinaten der kopfzeile      *)
      heading_c  =  40;
      learn_r    =   2;      (* lernstatus-koordinaten         *)
      learn_c    =  40;
      textline_r =   0;      (* koordinaten der eingabezeile   *)
      textline_c =   0;
      scanline_r =   4;      (* koordinaten der scanzeile      *)
      scanline_c =   0;
      novelty_r  =  10;      (* koordinaten der neuheitsgrafik *)
      novelty_c  =   0;
      result_r   =  19;      (* ergebnis-koordinaten           *)
      result_c   =   0;
      scan_r     =  21;      (* scanstatus-koordinaten         *)
      scan_c     =   0;
      code_r     =  21;      (* zeichencode-koordinaten        *)
      code_c     =  25;
      recall_r   =  22;      (* erinnerungsstatus-koordinaten  *)
      recall_c   =   0;
      exit_r     =  23;      (* ausstiegs-koordinaten          *)
      exit_c     =   0;

      bel        = $07;      (* bell            *)
      bs         = $08;      (* backspace       *)
      cr         = $0D;      (* carriage return *)
      can        = $18;      (* cancel          *)

type  matrix     = array[1..dim2,1..dim1] of real;
      kvector    = array[1..dim1] of real;
      cvector    = array[1..dim2] of real;
      scanmatrix = array[1..vsize,1..scanlength] of real;
      scanvector = array[1..scanlength] of real;
      charset    = array['@'..'Z',1..vsize] of string[hsize];
      values     = array['@'..'Z'] of string[nval];
      line       = string[linelength];

var   memory     : matrix;
      key        : kvector;
      content    : cvector;
      novelty    : scanvector;
      scanline   : scanmatrix;
      textline   : line;
      c          : charset;
      v          : values;



(****************************************************************************)
(*                                                                          *)
(*                             video-routinen                               *)
(*                                                                          *)
(****************************************************************************)



procedure setcur (row,col: integer);
begin
gotoxy (col+1,row+1) end;

procedure clline (row: integer);
begin
setcur (row,0);
clreol end;

procedure clpage;
begin
clrscr end;



(****************************************************************************)
(*                                                                          *)
(*                              e/a-routinen                                *)
(*                                                                          *)
(****************************************************************************)



procedure defchars;
begin

c['A',1]:='  '; c['B',1]:=' '; c['C',1]:=' '; c['D',1]:=' ';
c['A',2]:='   '; c['B',2]:='   '; c['C',2]:='    '; c['D',2]:='   ';
c['A',3]:='   '; c['B',3]:=' '; c['C',3]:='    '; c['D',3]:='   ';
c['A',4]:=''; c['B',4]:='   '; c['C',4]:='    '; c['D',4]:='   ';
c['A',5]:='   '; c['B',5]:=' '; c['C',5]:=' '; c['D',5]:=' ';

c['E',1]:=''; c['F',1]:=''; c['G',1]:=' '; c['H',1]:='   ';
c['E',2]:='    '; c['F',2]:='    '; c['G',2]:='    '; c['H',2]:='   ';
c['E',3]:=' '; c['F',3]:='  '; c['G',3]:='  '; c['H',3]:='';
c['E',4]:='    '; c['F',4]:='    '; c['G',4]:='   '; c['H',4]:='   ';
c['E',5]:=''; c['F',5]:='    '; c['G',5]:=' '; c['H',5]:='   ';

c['I',1]:='  '; c['J',1]:='    '; c['K',1]:='   '; c['L',1]:='    ';
c['I',2]:='    '; c['J',2]:='    '; c['K',2]:='   '; c['L',2]:='    ';
c['I',3]:='    '; c['J',3]:='    '; c['K',3]:='  '; c['L',3]:='    ';
c['I',4]:='    '; c['J',4]:='   '; c['K',4]:='   '; c['L',4]:='    ';
c['I',5]:='  '; c['J',5]:='  '; c['K',5]:='   '; c['L',5]:='';

c['M',1]:='   '; c['N',1]:='   '; c['O',1]:='  '; c['P',1]:=' ';
c['M',2]:=' '; c['N',2]:='  '; c['O',2]:='   '; c['P',2]:='   ';
c['M',3]:='  '; c['N',3]:='  '; c['O',3]:='   '; c['P',3]:=' ';
c['M',4]:='   '; c['N',4]:='  '; c['O',4]:='   '; c['P',4]:='    ';
c['M',5]:='   '; c['N',5]:='   '; c['O',5]:='  '; c['P',5]:='    ';

c['Q',1]:='  '; c['R',1]:=' '; c['S',1]:=' '; c['T',1]:='';
c['Q',2]:='   '; c['R',2]:='   '; c['S',2]:='    '; c['T',2]:='    ';
c['Q',3]:='  '; c['R',3]:=' '; c['S',3]:='  '; c['T',3]:='    ';
c['Q',4]:='   '; c['R',4]:='   '; c['S',4]:='    '; c['T',4]:='    ';
c['Q',5]:='  '; c['R',5]:='   '; c['S',5]:=' '; c['T',5]:='    ';

c['U',1]:='   '; c['V',1]:='   '; c['W',1]:='   '; c['X',1]:='   ';
c['U',2]:='   '; c['V',2]:='   '; c['W',2]:='   '; c['X',2]:='   ';
c['U',3]:='   '; c['V',3]:='   '; c['W',3]:='  '; c['X',3]:='    ';
c['U',4]:='  '; c['V',4]:='   '; c['W',4]:=' '; c['X',4]:='   ';
c['U',5]:='  '; c['V',5]:='    '; c['W',5]:='   '; c['X',5]:='   ';

c['Y',1]:='   '; c['Z',1]:=''; c['@',1]:='     ';
c['Y',2]:='   '; c['Z',2]:='    '; c['@',2]:='     ';
c['Y',3]:='    '; c['Z',3]:='    '; c['@',3]:='     ';
c['Y',4]:='    '; c['Z',4]:='    '; c['@',4]:='     ';
c['Y',5]:='    '; c['Z',5]:=''; c['@',5]:='     ';

v['@']:='XX      '; v['A']:='X X     '; v['B']:='X  X    '; v['C']:='X   X   ';
v['D']:='X    X  '; v['E']:='X     X '; v['F']:='X      X'; v['G']:=' XX     ';
v['H']:=' X X    '; v['I']:=' X  X   '; v['J']:=' X   X  '; v['K']:=' X    X ';
v['L']:=' X     X'; v['M']:='  XX    '; v['N']:='  X X   '; v['O']:='  X  X  ';
v['P']:='  X   X '; v['Q']:='  X    X'; v['R']:='   XX   '; v['S']:='   X X  ';
v['T']:='   X  X '; v['U']:='   X   X'; v['V']:='    XX  '; v['W']:='    X X ';
v['X']:='    X  X'; v['Y']:='     XX '; v['Z']:='     X X' end;

procedure readstr (var l: line);
var ch : char;
    i  : integer;
begin
for i := 1 to linelength do write ('_');
for i := 1 to linelength do write (chr(bs));
i := 1;
repeat
  read (kbd,ch); ch := upcase (ch);
  if ch in [' ','A'..'Z'] then begin
    if i <> linelength+1 then begin
      l[I] := ch;
      i    := i + 1;
      write (ch) end
    else
      write (chr(bel)) END
  else
    case ord(ch) of
      bs:  if i <> 1 then begin
             i := i - 1;
             write (chr(bs),'_',CHR(bs)) end
           else
             write (chr(bel));
      can: if i <> 1 then
             repeat
               i := i - 1;
               write (chr(bs),'_',chr(bs))
             until i = 1
           else
             write (chr(bel))
    else
      if ch <> chr(cr) then write (chr(bel)) end
until ch = chr(cr);
l[0] := chr(I-1);
for i := length(l)+1 to linelength do begin
  l[i] := ' ';
  write (' ') end end;

procedure readline;
var i,j,k : integer;
begin
setcur (textline_r,  textline_c);   write ('Ŀ');
setcur (textline_r+1,textline_c);   write ('                             ');
setcur (textline_r+2,textline_c);   write ('');
setcur (textline_r+1,textline_c+2); write ('Eingabezeile: ');
readstr (textline);
if length (textline) <> 0 then begin
  for i := 1 to vsize do
    for j := 1 to linelength do begin
      if not (textline[j] in ['A'..'Z']) then textline[j] := '@';
      for k := 1 to hsize do
        if c[textline[j],i][k] = ' ' then
          scanline[i,((j-1)*(hsize+1))+k] := neg
        else
          scanline[i,((j-1)*(hsize+1))+k] := pos;
      scanline[i,j*(hsize+1)] := neg end;
  for i := 1 to vsize do begin
    setcur (scanline_r+i-1,scanline_c);
    for j := 1 to scanlength do
      if scanline[i,j] = neg then write (' ') else
      if scanline[i,j] = pos then write ('') else write ('?') end end end;



(****************************************************************************)
(*                                                                          *)
(*                          gedaechtnis-routinen                            *)
(*                                                                          *)
(****************************************************************************)



procedure learn;
var i,j : integer;
    x   : real;
    ch  : char;
begin
setcur (learn_r,learn_c); write ('Lerndaten: ');
for i := 1 to dim2 do
  for j := 1 to dim1 do memory[i,j] := 0;
for ch := '@' to 'Z' do begin
  write (ch);
  for i := 1 to vsize do
    for j := 1 to hsize do begin
      if c[ch,i][j] = ' ' then x := neg else x := pos;
      key    [((i-1)*hsize)+j] := x;
      content[((i-1)*hsize)+j] := x end;
  for i := 1 to nval do begin
    if v[ch][i] = ' ' then x := neg else x := pos;
    content[dim1+i] := x end;
  for i := 1 to dim2 do
    for j := 1 to dim1 do
      memory[i,j] := memory[i,j] + (content[i] * key[j]) end end;

function recall (pattern: kvector) : real;
var i,j,trial : integer;
    sn,nov    : real;
begin
sn := 0;
for i := 1 to dim1 do sn := sn + sqr (pattern[i]);
for i := 1 to dim2 do content[i] := 0;
key   := pattern;
trial := 0;
repeat
  trial  := trial + 1;
  for i := 1 to dim2 do begin
    content[i] := 0;
    for j := 1 to dim1 do content[i] := content[i] + (memory[i,j] * key[j]);
    content[i] := content[i] / sn end;
  for i := 1 to dim1 do
    key[i] := key[i] + ((pattern[i] - content[i]) / (atten + 1));
  nov  := 0;
  for i := 1 to dim1 do nov  := nov  + sqr (content[i] - pattern[i]);
  nov  := sqrt (nov);
  setcur (recall_r,  recall_c); write ('Durchgang: ',trial:4);
  setcur (recall_r+1,recall_c); write ('Neuheit:   ',nov  :8:3);
  setcur (code_r,code_c); write ('Code: ');
  for j := dim1+1 to dim2 do write (content[j]:6:2);
  setcur (result_r,result_c); writeln
until trial = ntrials;
recall := nov end;

procedure scan;
var i,j,k,l : integer;
    x       : real;
begin
for i := novelty_r to result_r do clline (i);
for i := 1 to scanlength do begin
  for j := 1 to vsize do
    for k := 1 to hsize do begin
      l := i + (k - 1) - (hsize div 2);
      if (l >= 1) and (l <= scanlength) then
        x := scanline[j,l]
      else
        x := neg;
      key[((j-1)*hsize)+k] := x end;
  setcur (scan_r,scan_c); write ('Position:  ',i:4);
  novelty[i] := recall (key);
  for j := novelty_r to result_r-1 do
    if (j-novelty_r+1 > novelty[i]*magnif) or (j = result_r-1) then begin
      setcur (j,novelty_c+i-1); write ('') end;
  k := 0; x := 0;
  setcur (code_r+1,code_c); write ('      ');
  for j := dim1+1 to dim2 do begin
    write (content[j]:6:2);
    if (k = 0) or (content[j] > x) then begin x := content[j]; k := j end end;
  l := 0; x := 0;
  for j := dim1+1 to k-1 do
    if (l = 0) or (content[j] > x) then begin x := content[j]; l := j end;
  for j := k+1 to dim2 do
    if (l = 0) or (content[j] > x) then begin x := content[j]; l := j end;
  k := k - (hsize * vsize);
  l := l - (hsize * vsize);
  if k > l then j := l else begin j := k; k := l end;
  k := k - j - 1;
  l := nval;
  while j <> 1 do begin
    l := l - 1;
    k := k + l;
    j := j - 1 end;
  if novelty[i] < novlim then begin
    setcur (result_r,result_c+i-1); write (chr(ord('@')+k)) end end end;



(****************************************************************************)
(*                                                                          *)
(*                             hauptprogramm                                *)
(*                                                                          *)
(****************************************************************************)



begin
clpage;
setcur (heading_r,  heading_c); write ('SBS Zeilenscanner-Demoprogramm V2.2');
setcur (heading_r+1,heading_c); write ('16. November 1987 Sven B. Schreiber');
defchars; learn;
repeat
  readline;
  if length (textline) <> 0 then scan
until length (textline) = 0;
setcur (exit_r,exit_c) end.
