{Include-Datei MISC.PAS}
{in dieser Form auf Turbo 4.0 eingerichtet}
TYPE str4 = STRING[4];
  str8 = STRING[8];
  str24 = STRING[24];

VAR i, j, k : Integer;
  b : Byte;
  ch : Char;
  ack, id1, id2 : Byte;

  IntNo : Integer;
  OldIntO : Integer;
  OldIntS : Integer;

  Buffer : ARRAY[0..100] OF Byte;
  BufHead : Integer;
  BufTail : Integer;

CONST
  TurboDS : Integer = 0;

  {---}

  FUNCTION ByteToHex(h : Byte) : str4;
  CONST HexArray : ARRAY[0..15] OF Char
    = '0123456789ABCDEF';
  BEGIN
    ByteToHex := HexArray[h SHR 4]
    +HexArray[h AND $F];
  END;

  FUNCTION ByteToBin(b : Byte) : str8;
  VAR i : Byte; s : str8;
  BEGIN
    s := '';
    FOR i := 7 DOWNTO 0 DO
      BEGIN
        IF ((b SHR i) AND 1) = 0
        THEN s[8-i] := '0'
        ELSE s[8-i] := '1';
      END;
    s[0] := #8;
    ByteToBin := s;
  END;

  FUNCTION BinOut(h : Byte) : str24;
    {- gibt ein Byte als binren String aus}
  VAR i : Integer; s : str24;
  BEGIN
    s := '';
    FOR i := 7 DOWNTO 0 DO
      IF ((h SHR i) AND 1) = 1
      THEN s := s+'1  '
      ELSE s := s+'0  ';
    BinOut := s;
  END;


  FUNCTION WordToHex(h : Integer) : str4;
  BEGIN
    WordToHex := ByteToHex(Hi(h))
    +ByteToHex(Lo(h));
  END;

  {---}

  PROCEDURE InterruptR;     interrupt; {<- turbo 4.0}
    {- neue Int9 Routine }
  BEGIN
(*  Fr Turbo 3.0:
   "interrupt" in der Deklarierung weglassen
    hier und weiter unten INLINE einfgen

    INLINE(
      {Register retten, TURBO DatenS.laden}
      $50/$53/$51/$52/$57/$56/$06/$1e/$fb/
      $2e/$a1/TurboDS/
      $8e/$d8);
*)
    b := Port[$60];

    {lies id bytes}
    IF ack = 0
    THEN ack := b
    ELSE
      IF id1 = 0
      THEN id1 := b
      ELSE id2 := b;

    {Byte in Ringpuffer}
    Buffer[BufTail] := b;
    BufTail := (BufTail+1) MOD 100;

    {Empfang quittieren}
    b := Port[$61];
    b := b+$80;
    Port[$61] := b;
    b := b AND $7f;
    Port[$61] := b;
    {Interrupt zurcksetzen}
    Port[$20] := $20;
 (*
    INLINE(
      {Interrupt sperren, Register zurckladen}
      $fa/
      $1f/$07/$5e/$5f/$5a/$59/$5b/$58/
      {TURBO "aufrumen" und zurck vom Interrupt}
      $8b/$e5/                {mov    sp,bp}
      $5d/                    {pop    bp}
      $CF);                   {IRET   }
 *)
 END;

  PROCEDURE NewInt(no : Integer);
    {- rettet alten Interrupt-Vektor}
    {  und setzt einen neuen}

  BEGIN
    TurboDS := DSeg;          {hallo, TURBO 3.0}
    IntNo := no;
    OldIntO := MemW[0:no*4];
    OldIntS := MemW[0:no*4+2];

    {jetzt bitte nicht stren!}
    INLINE($fa);
    MemW[0:no*4] := Ofs(InterruptR);
    MemW[0:no*4+2] := CSeg;
    INLINE($fb);
  END;


  PROCEDURE RestoreInt;
    {- alten Interrupt-Vektor restaurieren}
  BEGIN
    INLINE($fa);
    MemW[0:IntNo*4] := OldIntO;
    MemW[0:IntNo*4+2] := OldIntS;
    INLINE($fb);
  END;

  {--- Ab hier nur fr AT! ----------}


  {im Manual des Model 50 steht, vor dem Schreiben
  des Kommando-Ports $64 mten im Statusregister
  das Bit 0 = 1 und das Bit 1 = 0 sein.}
  {Nach etlichen Versuchen bin ich zu den folgenden
  Routinen gelangt, die diese Vorgabe NICHT ein-
  halten, aber immerhin funktionieren. Fr eigene
  Erfahrung bleibt wie berall bei IBM hinreichend
  Raum.}

  PROCEDURE O8042cmd(b : Byte);
  BEGIN
    INLINE(
      $fa/                    {cli}
      $e6/$64/                {out command port}
      $2b/$c9/                {sub cx,cx}
      $e4/$64/                {in status port}
      $24/$02/                {chk buffer full}
      $e0/$fa                 {wait for command accept}
      );
  END;

  FUNCTION In8042 : Byte;
  BEGIN
    {wait until 8042 output buffer full}
    REPEAT UNTIL (Port[$64] AND 1) = 1;
    In8042 := Port[$60];
  END;

  PROCEDURE ShowCmd;
    {- aktuelles 8042 command byte anzeigen}
  BEGIN
    O8042cmd($20);
    WriteLn('command byte is %', ByteToBin(In8042));
  END;

  {---}
