;-----------------------------------------------------------------------------
; Programm zur Ermittlung der Fehlerhufigkeit der dynamischen RAMs in PC
; oder AT       mit CGA bzw. Hercules
; Funktion: 	die Refresh-Rate wird reduziert und alle
;               Speicherstellen werden mit 00 bzw. im zweiten Durch-
;		gang mit FF beschrieben. Nach einer lngeren Pause
;               (ca. 14 Sek) werden die Speicherstellen wieder ausgelesen
;               und Fehler in den Datenbits erkannt.
;		Zustzlich wird nach jedem Lesevorgang das Parity-Bit unter-
;		sucht, um festzustellen, ob das Parity-RAM gekippt ist.
; Eingabe       'Startwert' fr die Refresh-Rate in Timer-Ticks (0.83 s)
;               Beim PC mindestens 3 eingeben, sonst evtl. Dauer-Refresh
;               'Differenz' fr die nderung ber +/- in Timer-Ticks
;-----------------------------------------------------------------------------

message         macro  zeile,spalte,adr
                mov  cl,zeile
                mov  ch,spalte
                mov  si,offset adr
                call out_mess
                endm

wait            macro   millisecs
local           wait_low,wait_high
                mov     cx,millisecs
wait_low:     	in	al,dx		;
		test	al,20h		;Warten bis Timer 2 auf Low geht
		jnz	wait_low
wait_high:      in      al,dx           ;und wieder high
                test    al,20h
                jz     wait_high
		loop	wait_low	;1000 mal
                endm

hercules	segment at 0b000h
hercules	ends
screen		segment at 0b800h      ; bei MDA hier 0b000h
		org	1000h
beginprg	label	byte
screen		ends
bios_rom	segment at 0f000h
		org	0fff0h
boots_trap	label	far
		org	0fffeh
machine_type	label	byte
bios_rom	ends

;-----------------------------------------------------------------------------

code		segment
		assume cs:code,ds:nothing,es:nothing,ss:nothing
                org 100h
start:
Init            proc far
                cli
                mov     al,0
                mov     dx,3f2h
                out     dx,al           ;Laufwerke aus
		mov	ax,cs
		mov	ds,ax		;zuerst die Segment-Register korrekt
		mov	ax,seg bios_rom	;einstellen
		mov	es,ax
                push    ds
                mov     ax,40h
                mov     ds,ax
                mov     ax,ds:[0013h]    ; MemSize in Kbyte;
                pop     ds
		assume	ds:code,es:bios_rom
                mov     bx,40h           ; ergibt MemSize
                mul     bx               ; in Paragrafen
                mov     memsize,ax
                mov     al,0FFh          ; keine Interrupts
                out     [21h],al
		test    es:[machine_type],3; ist es ein AT?
		jnz	no_at		;ja ->
ist_at1:	mov	al,80h
		out	70h,al		;NMI abschalten
                in      al,71h          ;vorsichtshalber Dummy-Read
                mov     dx,61h          ;AT-Port fr Parity-Fehler
                mov     [port],dx       ;
                jmp     short video_ad
no_at:          mov     al,00h
                out     0A0h,al         ;NMI aus
                mov     dx,62h          ;PC-Port fr Parity
                mov     [port],dx
video_ad:	mov	al,03h		;schaltet bei Hercules zweite
		mov	dx,03bfh	;Seite ein (bei CGA keine Funktion)
		out	dx,al
		mov	ax,0b000h	;ES zeigt auf die erste Seite der
		mov	es,ax		;Hercules-Karte

		assume	es:hercules

		mov	ah,0
		mov	al,55h
		mov	es:byte ptr [0],al
                mov     cx,0
                loop    $                  ; eine Zeitlang warten
		cmp	es:byte ptr [0],al ;ist eine Hercules-Karte da?
		jnz	no_herc		   ;nein ->
		inc	ah
no_herc:	mov	[disp_type],ah	   ;0=CGA und 1=HERC
		mov	ax,seg screen
		mov	es,ax

		assume	es:screen

		mov	si,offset startprg ;bertragen der Daten in die
		mov	di,offset beginprg ;Grafikkarte
		mov	cx,offset (endprg) - offset (startprg)
		rep	movsb
		push	es
		mov	ax,offset beginprg
		push	ax
		ret                        ; und ab in den Bildschirm
Init            endp
;-----------------------------------------------------------------------------
                org 1000h
                assume  cs:code,ds:code
program		proc	near
startprg:
		mov	ax,cs		;fr den neuen Bereich die Segmente
		mov	ds,ax		;wieder richtig setzen
		mov	sp,offset stack+256 ;mit eigenem Stack
		mov	ss,ax
		xor	ax,ax
		mov	es,ax
weiter1:	call	clr_scr         ; Blidschirm klar
                message 0,0, startmess  ; Startmeldung
                message 1,0, startwert  ; Anfangswert fr Refresh
                mov     ch,40           ;
                call    get_word        ; von Tastatur lesen
                mov     [refresh],dx
                message 2,0, diffwert   ; Erhhungswert
                mov     ch,40           ;
                call    get_word        ; einlesen
                mov     [differenz],dx

h_loop:		call	set_refresh	;Refresh-Wert in Timer 0 Register
		call	display_refresh ;Anzeigen auf Bildschirm
		call	off_on_parity   ;Parity-Fehler-Flag lschen
                message 20,0,no_mess    ;lscht Menue-zeile
		mov	ax,0000h  	;
                message 7,0,mem_mess_00 ;
                call	set_mem		;Speicher mit 00 vollschreiben
		call	warte_lange	;und einen Refresh-Zyklus warten
		call	search_for_bad	;danach nach gekippten Bits suchen
		call	off_on_parity	;dsgl mit Testwert FF
                message 10,0,wait_taste ;
                call    warte_for_tast ;
  		mov	ax,0ffffh
                message 7,0,mem_mess_FF ;
		call	set_mem
		call	warte_lange
		call	search_for_bad

ende_loop:	message 20,0,weiter_mess
loop3:		call	warte_for_tast
		cmp	al,12h		;Programm beenden
		jz	prg_ende
		cmp	al,31h		;noch mal neu
                jnz     no_N
		jmp	weiter1
no_N:		cmp	al,1bh		;Taste '+'
		jnz	minus		;nein, dann vielleicht die '-'
plus:           mov     ax,refresh
                add     ax,differenz
		mov     refresh,ax      ;sonst Refresh-Wert erhhen
		jmp     short  h_loop
minus:		cmp	al,35h		;Taste '-'
		jnz	ende_loop       ; dann erniedrigen
                mov     ax,refresh
                sub     ax,differenz
                mov     refresh,ax
		jmp     h_loop	        ;und wieder testen

prg_ende:	jmp	boots_trap	;ab ins ROM F000:FFF0

;-----------------------------------------------------------------------------
; spezifische Unterprogramme fr die Hauptschleife des Testprogramms
;-----------------------------------------------------------------------------

set_refresh:	mov	al,74h		;Timer 1, Low u. High, Mode 2, binr
		out	43h,al		;Timer-cntrl-Register
		jmp	short x1	;zur Verzgerung
x1:		mov	ax,refresh	;und danach den Refresh-Wert in Timer 0
		out	41h,al
		jmp	short x2
x2:		mov	al,ah
		out	41h,al
		ret

display_refresh:message 5,0, zeit_mess
		mov	ax,refresh	;des Refresh-Wertes
		mov	ch,35
		call	out_zahl
		ret

off_on_parity:	push	ax		;
		in	al,61h		;Port B, Parity-Enable-Bits
		xor	al,14h          ;4h fr AT und 10h fr PC
		out	61h,al          ;setzen
                jmp	short x3        ;etwas warten
x3:		xor	al,14h  	;und zurcksetzen
		out	61h,al
		pop	ax
		ret

set_mem:	message 8,0,no_mess
                message 9,0,no_mess
		mov	bp,0000h        ; beginnend ab 0000:0000h
loop_mem:       mov     es,bp           ;
                mov     cx,200h         ; in 1-KByte-Schritten
                mov     di,0            ; DI durchluft das K-Byte
                rep     stosw           ;
                add     bp,40h          ; 1 KByte = 40h Paragrafen
                cmp     bp, word ptr memsize
                jnz     loop_mem
		ret

warte_lange:	push	ax
                message 10,0,wart_mess;
loop_w:		mov	al,0b6h		;Timer 2, low u. high, Mode 2, binr
		out	43h,al          ;fr
		mov	ax,1193 	;toggle im 1-ms-Rhytmus = 1193 ticks
		out	42h,al          ;beim AT htte man auch Bit 4
		mov	al,ah           ;als Refresh-Toggle
		out	42h,al          ;zur Verfgung
		in	al,61h          ;
		or	al,1
                and     al,0fdh         ;kein Piepen
		out	61h,al		;Gate von Timer 2 aufmachen
                mov     dx,port

warte_14s:      rept    14              ;1-s-Warteschleife 14mal
                 wait    1000           ;1000 ms warten
                endm                    ;aufgeteilt, weil u.U
                pop	ax              ;auch Prozessor-Zugriffe aufs
		ret                     ;Video-RAM einen Refresh bewirken

search_for_bad:	push	ax
                message 10,0,test_mess
		mov	bp,0000H	;wieder bei 0000:0000 anfangen
loop_7:		mov	ax,bp
 		mov	cl,10
		mov	ch,30
		call	out_word
		pop	ax
                push    ax
		mov	si,0
                mov     es,bp
loop_bad:       cmp	es:word ptr [si],ax
		jnz	error_found	;Fehler beim Vergleich
                push    ax
                mov     dx,port
		in	al,dx		;
		test	al,80h		;nur das Parity-Bit gekippt?
                pop     ax
		jnz	parity_error	;ja ->
entry:		inc	si
		inc	si
		cmp	si,0
		jnz	loop_bad	;nchste Bank? nein ->
		add	bp,1000h
		cmp	bp, word ptr memsize;Speicherende?
		jb	loop_7		;nein ->
                pop     ax
		ret

error_found:	mov	cx,es:word ptr [si]
		push	ax
		push	si
		push	es
		push	cx
                message 8,0,fehler_1
		pop	ax
		mov	ch,22
		call	out_word	;fehlerhaftes Word ausgeben
                message 8,23,fehler_2
                jmp     short error_adr;

parity_error:	push	ax
                push    si
                push	es
                message 9,0,fehler_3
error_adr:      pop	ax
                push	ax
		mov	ch,50		;Adresse des Fehlers ausgeben
		call	out_word        ; Segment
		pop	es
		pop	ax
		push	ax
		push	es
		mov	ch,55
		call	out_word       ;  Offset
		pop	es
		pop	si
		pop	ax
                call    off_on_parity   ; Paritts-Flipflop wieder scharf
		jmp	entry		;und auch nchste versuchen

;-----------------------------------------------------------------------------
; algemeine Unterprogramme zum Bildschirmlschen, Textausgabe, Feststellen der
; Grafikkarte ...
;-----------------------------------------------------------------------------

clr_scr:	mov	di,0
		call	get_vid_type	;CGA oder HERC Anfangsadresse bestimmen
		mov	ax,0720h	;lschen mit Blank und Standardattr.
		mov	cx,80*25	;Spalten mal Zeilen
                rep     stosw
		ret

get_word:       mov     dx,0
inloop:         xor     ax,ax
                call    warte_for_tast  ;
                cmp     al, 1Ch         ; Scan-Code fr RET
                jz      Enter           ;
                add     dx,dx           ;dx:=dx*10
                mov     bx,dx           ;geht einfacher und
                add     dx,dx           ;schneller als mit MUL
                add     dx,dx
                add     dx,bx
                cmp     al,0Bh;         ; Scan-Code fr 0
                jnz     skip_0
                mov     al,1h
skip_0:         dec     al
                add     dx,ax;
                call    out_nibble
                inc     ch
                jmp     short inloop ;
enter:          ret

out_mess:       push    ax
        	call	rechne_zeile	;Byte-Adresse aus Zeile und Spalte
		push	ax		;errechnen
		call	get_vid_type	;Startadresse Video-Speicher
		pop	di
loop2:		mov	al,[si]		;Zeichen holen
		or	al,al		;ist es eine 0
		jnz	ausgabe		;nein, dann ausgeben
                pop     ax
		ret

ausgabe:	mov	es:[di],al	;in den Videospeicher
		inc	di		;Attribut
		inc	di		;nchstes Zeichenbyte
		inc	si		;pointet auf nchstes Zeichen
		jmp	short loop2

out_zahl:       mov     bx,10           ;Dezimal-Zahl in AX ausgeben
div_loop:       mov     dx,0
                div     bx              ; durch 10 teilen
                xchg    ax,dx           ; Rest in dx nach ax
                call    out_nibble      ; auf Screen
                dec     ch              ; Spalte vermindern
                xchg    ax,dx           ; Quotient wieder nach ax
                or      ax,ax           ; ist er 0
                jnz     div_loop        ; nein, dann weiter
                ret

out_word:       push    bx
                mov     bl,4
out_loop:	call    out_nibble
                dec 	ch		;Spalte vermindern
		shr	ax,1		;und nchstes Nibble reinschieben
		shr	ax,1
		shr	ax,1
		shr	ax,1
		dec	bl		;ein Word sind 4 Nibbles
		jnz	out_loop
                pop     bx
                ret

out_nibble:     push    ax
                and	ax,0fh		;unters Nibble maskieren
		add	al,'0'		;und nach ASCII wandeln
		cmp	al,'9'		;ist es HEX A bis F?
		jle	no_add		;nein ->
		add	al,7		;wegen der Hex-Ziffern
no_add:		push	ax
		call	get_vid_type	;Startadresse Video-Speicher
		call	rechne_zeile	;Adresse berechnen
		mov	di,ax
		pop	ax
		mov	es:[di],al	;und ASCII ausgeben
                pop     ax
                ret

get_vid_type:	cmp	[disp_type],1	;je nach Karte das richtige Segment
		jz	ist_herc	;zurckliefern
		mov	ax,seg screen
		jmp	short weiter2
ist_herc:	mov	ax,seg hercules
weiter2:	mov	es,ax
		ret

warte_for_tast: mov     al,0Ah         ;Zum Lesen des IRR
                out     20h,al         ;an Int-Contr
                in      al,20h         ;hole IRR
                test    al,2           ;IRQ1 aktiv?
                jz      warte_for_tast ;nein, dann warte
                in      al,60h
                push    ax             ;------------------
                in      al,61h         ;nur fr PC, setzt
                or      al,80h         ;IRQ1 zurck
                out     61h,al         ;   "
                and     al,7fh         ;   "
                out     61h,al         ;   "
                pop     ax             ;-----------------
                test    al,80h         ;Loslass-Code?
                jnz     warte_for_tast; dann warte weiter
		ret

rechne_zeile:   push    cx
                mov	ax,160		;soviele Bytes hat eine Zeile
		mul	cl
		mov	cl,ch
                mov	ch,0
		add	ax,cx		;Adresse fr Zeichen
                add     ax,cx           ;2mal da Zeichen + Attribut
                pop     cx
		ret

program		endp
;--------------------------------------------------------------------------
no_mess		db   '                                         '
		db   '                                         ',0
startmess	db   'Refresh-Test-Programm V 1.0 (C) 1988 c''t/Ernst/AS',0
startwert       db   'Startwert in Timer-Ticks ( 0.83 s): ',0
Diffwert        db   'Differenz in Timer-ticks ( 0.83 s): ',0
Fehler_1	db   'Datenbit-Fehler ',0
Fehler_2	db   ' bei Adresse : ',0
Fehler_3	db   'Parity-Fehler bei Adresse           : ',0
zeit_mess	db   'aktuelle Refresh-Rate : ',0
test_mess	db   'Testing RAM-Bank   ',0
weiter_mess	db   '(N)eu, (E)nde, (+,-) Refresh erhhen/erniedrigen ',0
mem_mess_00	db   '1.Lauf, Speicher gefllt mit 00h  ',0
mem_mess_FF     db   '2.Lauf, Speicher gefllt mit FFh  ',0
wait_taste      db   'weiter mit Taste                  ',0
wart_mess	db   '14 Sekunden warten                ',0
memsize         dw      ?
port            dw   	?	;Port C bei PC, Port B bei AT
disp_type	db	?	;CGA oder HERC
refresh		dw	?	;aktueller Refresh-Wert
differenz       dw      ?       ;Differenz fr '+' und '-'
endprg		label   near
stack		db	256 dup (?)
code            ends
                end     start
