/* taste ->  AUFRUF:  taste Fxx [string1 [string2]]
   taste legt einen oder zwei Strings auf die mit "Fxx" (x E {1..10})
         angegebene Taste. Fehlen die Strings, wird der Original-
         Zustand wiederhergestellt. */

#include "exec/io.h"
#include "exec/ports.h"
#include "exec/memory.h"
#include "devices/keymap.h"
#include "devices/console.h"
#include "intuition/intuitionbase.h"

struct IOStdReq *conwrite;
struct Port *conport;
struct IntuitionBase *IntuitionBase;

extern APTR AllocMem();
extern struct IntuitionBase *OpenLibrary();
extern struct IOStdReq *CreateStdIO();
extern struct Port *CreatePort();

/* es wird ein Window bentigt, um das Console-Device zu ffnen 
   da es vom Typ BACKDROP BORDERLESS ist, kann man es aber nicht
   sehen */
struct NewWindow nw = 
{ 10,10,20,20,(BYTE)2,(BYTE)3,0L,SMART_REFRESH|BACKDROP|
  BORDERLESS,0L,0L,0L,0L,0L,0,0,0,0,WBENCHSCREEN 
};

char F1[80] = { 1,1,1,1 } ; /* damit keine Null die strcpy-
                   Funktion flschlicherweise beendet */

char Fx[]  = { 3,       /* Lnge String ohne SHIFT */
               4,       /* Abstand Stringanfang - F1 */
               4,       /* Lnge String mit SHIFT */
               7,       /* Abstand Stringanfang - F1 */
               0x9B,'0','~',      /* erster  String: "ESC[0~"  */
               0x9B,'1','0','~'   /* zweiter String: "ESC[10~" */
             };                   /* das sind die Default-Werte*/

char *stringspace;           /* Zeiger auf Platz fr Texte */

struct Window *w;      /* Pointer auf eine Window-Struktur */
extern struct Window *OpenWindow(); 

struct KeyMap *mymap;             /* Zeiger auf eine Keymap */

int                        /* AskKeyMap() erfragt eine Keymap */
AskKeyMap(request,keymap)  /* und bekommt einen Zeiger auf */
struct IOStdReq *request;  /* eine Kopie der KeyMap zurck. */
struct KeyMap *keymap;
{
   int error;         /* error = zum Einlesen eines Fehlers */
   request->io_Command = (UWORD) CD_ASKKEYMAP;        
   request->io_Length  = (ULONG) sizeof(struct KeyMap);
   request->io_Data    = (APTR)  keymap;              
   DoIO(request);               /* abschicken + warten */
   error = request->io_Error;   /* Fehler abfragen */
   if (error)                   /* milungen ? */
      return(FALSE);            /* dann FALSE zurckgeben */
   else                         /* sonst */
      return(TRUE);             /* TRUE returnieren */
}

main(argc,argv)       /* Hauptprogramm */
int argc;             /* Anzahl Parameter */
char *argv[];         /* Stringfeld mit Parametern */
{
    SHORT error;      /* error = Fehlernummer */
    int FNum;         /* FNum  = Funktionstastennummer */

    /* Parameter-Check */
    if (argc == 1 || (argc==2 && *argv[1] == '?')) 
    {  printf("Aufruf %s Fx [ohne SHIFT] [mit SHIFT]\n",argv[0]);
       exit(0);     /* Meldung ausgeben und Programm beenden */
    }

    /* Funktionstaste und deren Tastencode bestimmen */
    sscanf(argv[1]+1,"%d",&FNum);
    if (FNum < 1 || FNum > 10)   /* Nummer falsch ? */
    {  printf("Funktionstaste existiert nicht\n"); 
       exit(21);   /* Meldung ausgeben und Programm beenden */
    }
    FNum += 15;   /* Code der Funktionstaste speichern */

    /* Vorbereitungen zum ffnen eines Windows 
       und des Console-Device */
    conport  = CreatePort(0L,0L);
    conwrite = CreateStdIO(conport);
    IntuitionBase = OpenLibrary("intuition.library",0L);

    if (conwrite == 0L) /* Fehler bei der Vorbereitung ? */
    {  if (conport != 0L)                 /* Port kreiert ? */
          DeletePort(conport);             /* dann lschen */
       printf("Port oder IO geht nicht auf\n"); 
                   /* Meldung ausgeben und Programm beenden */
       exit(20);                                
    }

    w = OpenWindow(&nw);     /* unsichtbares Window erffnen */
    if (w == 0L)                        /* ging nicht auf ? */
    {  DeleteStdIO(conwrite);            /* Request lschen */
       DeletePort(conport);              /* Port lschen */
       printf("Window geht nicht auf\n");/* Meldung ausgeben */
       exit(21);                       /* Programm verlassen */
    }

    /* Device erffnen */
    conwrite->io_Data   = (APTR)  w;      /* Window eintragen */
    conwrite->io_Length = (ULONG) sizeof(*w); 
    error = OpenDevice("console.device",0,conwrite,0);

    if (error)  /* wenn nicht gelungen */
    {  DeleteStdIO(conwrite);             /* Request lschen */
       DeletePort(conport);               /* Port lschen */
       CloseWindow(w);                    /* Window schlieen */
       printf("Device geht nicht auf\n"); /* Meldung ausgeben */
       exit(21);                         /* Programm beenden */
    }

    /* Speicher fr die KeyMap besorgen */
    mymap = (struct KeyMap *)AllocMem((long) sizeof(*mymap), 
                                       MEMF_PUBLIC);
    AskKeyMap(conwrite,mymap);           /* KeyMap holen */

    stringspace = (char *)AllocMem((long)sizeof(F1),MEMF_PUBLIC);

    if (argc == 2)   /* wenn die Original-Belegung hergestellt 
                        werden soll */
    {  Fx[5] = (BYTE)(FNum+32); /* richtige Nummern eintragen */
       Fx[9] = Fx[5];
       /* in die Stringtabelle kopieren */
       strncpy(stringspace,Fx,sizeof(Fx));    
       /* Taste reagiert nur auf SHIFT */
       mymap->km_HiKeyMapTypes[FNum] = 
         (BYTE)(KCF_SHIFT|KCF_STRING);
    }
    else             /* sonst */
    {  F1[0] = (BYTE)strlen(argv[2]);      /* Lnge eintragen */
       F1[1] = (BYTE)4;                    /* Offset eintragen */
       strncpy(F1+4,argv[2],(int)F1[0]);   /* String kopieren */
       if (argc == 4)  /* wenn zwei Strings angegeben wurden */
       {  F1[2] = (BYTE)strlen(argv[3]);   /* Lnge 2. Strings */
          F1[3] = (BYTE)(4 + F1[0]);       /* Offset festlegen */
          strncpy(F1+4+F1[0],argv[3],(int)F1[2]); /* kopieren */
          /* Typ festlegen: Mit und ohne SHIFT */
          mymap->km_HiKeyMapTypes[FNum] = 
            (BYTE)(KCF_SHIFT|KCF_STRING);
       }
       else            /* sonst */
          /* Typ festlegen: Nur ohne irgendwelche Qualifier */
          mymap->km_HiKeyMapTypes[FNum] = (BYTE)(KCF_STRING);

       /* fertige Tabelle an den besorgten Platz kopieren */
       strncpy(stringspace,F1,sizeof(F1));
    }

    /* Zeiger in der HiKeyMap auf die Stringtabelle umbiegen */
    mymap->km_HiKeyMap[FNum]      = (ULONG)stringspace;

    /* System aufrumen */
    FreeMem(mymap,(long)sizeof(*mymap));  /* KeyMap freigeben */
    CloseDevice(conwrite);                /* Device schlieen */
    DeleteStdIO(conwrite);                /* Request lschen */
    DeletePort(conport);                  /* Port lschen */
    CloseWindow(w);                       /* Window schlieen */
}                                         /* das wars !!*/
