;---------------------------------------------------------------------
;- Programm: TEK Basic Input Output System  (TEKBIOS.PRG)   8.5.1988 -
;-                                                                   -
;- GEMDOS-Erweiterung zur Bedienung der TEK 4/8 Karte im Universal-  -
;- interface. Dieser Treiber verbleibt nach seinem Aufruf im         -
;- Speicher und kann dann mittels GEMDOS-Aufrufen angesprochen       -
;- werden. Folgende Routinen knnen benutzt werden:                  -
;-                                                                   -
;- DOS Nr. Befehl                           Ergebnis (D0=0 Ok)       -
;-                                                                   -
;-  100    SetLinkAdr(Adr:W)                D0 =-1 nicht bereit      -
;-  101    ByteToLink(Value:W)              D0 =-1 Timeout           -
;-  102    ByteFromLink()                   D0 =-1    "              -
;-  103    LongWordToLink(Value:L)          D0 =-1    "              -
;-  104    LongWordFromLink((Value):L)      D0 =-1    "              -
;-  105    SliceToLink((Buf):L,Len:L)       D0 RealLen               -
;-  106    SliceFromLink((Buf):L,Len:L)     D0    "                  -
;-  107    reserviert                       D0 =-32                  -
;-  108    reserviert                       D0 =-32                  -
;-  109    reserviert                       D0 =-32                  -
;-  110    reserviert                       D0 =-32                  -
;-  111    TestError()                      D0 =1 Transputer Error   -
;-  112    SetReset()                       D0 =0                    -
;-  113    SetAnalyse()                     D0 =0                    -
;-  114    BootRoot((FileName):L)           D0 <0 Error              -
;-                                                                   -
;- (c) 1988 Helge Schulz                                             -
;---------------------------------------------------------------------

;------ Konstanten

GemDos    =       1  ;Trapnummer fr GEMDOS
Bios      =      13  ;     "      "  BIOS
XBios     =      14  ;     "      "  XBIOS
Super     =      32  ;GEMDOS-Nr. fr Umschaltung in Superv.-Mode
Ptermres  =      49  ;   "        "  Programm verlassen (P. resisdent)
Fopen     =      61  ;   "        "  File ffnen
Fclose    =      62  ;   "        "  File schlieen
Fread     =      63  ;   "        "  File lesen
Mshrink   =      74  ;   "        "  Speicher freigeben
DosTrap   =     $84  ;Adresse des GEMDOS-Traps
CmdOffset =     100  ;"Offset" zu den normalen GEMDOS-Befehlen
MaxCmd    =     114  ;hchste Kommandonummer
BufLen    =   $1000  ;Lnge des Buffers fr BootRoot
OTimeOut  =   $6000  ;Ausgabe Timeout
ITimeOut  =   $D000  ;Eingabe Timeout
ResTime   =   $C000  ;Zeit fr Reset- und Analyse-Signale
DataWrite = $FB0000  ;Universalinterfaceadresse fr Daten schreiben
DataRead  = $FB0101  ;            "              "  Daten lesen
Status1   = $FB0200  ;            "              "  Statusregister 1
Status2   = $FB0300  ;            "              "  Statusregister 2
AdrHWrite = $FB0400  ;            "              "  Adresse (H) A8-A15
AdrLWrite = $FB0500  ;            "              "  Adresse (L) A0-A7
SlotExp   = $FBFFF0  ;Basisadresse des Slot-Expanders

;Hier gehts los:

          text
          align.w

;------ Init ( -- )
;------ Initialisierung des Treibers resistent im Speicher

Init:     move.l $04(SP),A0         ;(Basepage) -> A0
          move.l $0C(A0),D3         ;Lnge des Text-Segments -> D3
          add.l  $14(A0),D3         ;D3 + Lnge des Data-Segmentes -> D3
          add.l  $1C(A0),D3         ;D3 + Lnge des Bss-Segmentes  -> D3
          add.l  #$100,D3           ;D3 + Lnge der Basepage       -> D3

          move.l D3,-(SP)           ;restlichen Speicher freigeben
          move.l A0,-(SP)
          move.w #0,-(SP)
          move.w #Mshrink,-(SP)
          trap #GemDos
          lea $0C(SP),SP            ;schneller und krzer als add.l #$0C,SP
          tst.l D0                  ;Fehler ?
          beq Init1                 ;nein, dann --> Init1

          clr.w -(SP)               ;zurck zum Desktop
          trap #GemDos

Init1:    clr.l -(SP)               ;in den Supervisor-Mode schalten
          move.w #Super,-(SP)
          trap #GemDos
          addq.l #6,SP

          move.l #DosTrap,A0        ;DosTrap -> A0
          move.l (A0),OldTrap+2     ;alten DosTrap retten
          move.l #NewTrap,(A0)      ;neuen DosTrap installieren

          move.l D0,-(SP)           ;in den User-Mode schalten
          move.w #Super,-(SP)
          trap #GemDos
          addq.l #6,SP

          move.w #0,-(SP)           ;zurck zum Desktop mit Speicher res.
          move.l D3,-(SP)           ;Lnge des resevierten Speichers
          move.w #Ptermres,-(SP)
          trap #GemDos

;------ NewTrap ( -- )
;------ Routine auf die die GEMDOS-Aufrufe umgelenkt werden

NewTrap:  btst #$05,(SP)            ;Supervisormode ?
          lea $06(SP),A0            ;SSP + 6 -> A0
          bne NewTrap1              ;ja, SSP benutzen --> NewTrap1
          move.l USP,A0             ;USP -> A0

NewTrap1: clr.l D0
          move.w (A0),D0            ;GEMDOS-Nummer holen
          cmp.w #CmdOffset,D0       ;Nummer zu klein ?
          blt OldTrap               ;ja, dann normaler Aufruf --> OldTrap
          cmp.w #MaxCmd,D0          ;Nummer zu gro ?
          bgt OldTrap               ;ja, nicht mein Problem --> OldTrap
          bra NewTrap2              ;Link-Adapter ist gemeint

OldTrap:  jmp $FFFFFF

NewTrap2: movem.l D2-D7/A2-A6,-(SP) ;Register retten
          move.l #DataWrite,A1      ;DataWrite -> A1
          move.l #DataRead,A2       ;DataRead -> A2
          move.l #JmpTab,A3         ;JmpTab -> A3
          sub.w #CmdOffset,D0       ;relative Nummer -> D0
          lsl.w #$02,D0             ;D0 * 4 -> D0
          move.l $00(A3,D0),A3      ;Adresse der Routine -> A3
          bsr SlotOn                ;Umschalten auf Link-Slot
          jsr (A3)                  ;ausfhren
          bsr SlotOff               ;Umschalten auf alten Slot
          movem.l (SP)+,D2-D7/A2-A6 ;Register wiederherstellen
          rte

JmpTab:   dc.l SLAdr                ;Sprungtabelle
          dc.l BTLink
          dc.l BFLink
          dc.l LTLink
          dc.l LFLink
          dc.l STLink
          dc.l SFLink
          dc.l Reserv
          dc.l Reserv
          dc.l Reserv
          dc.l Reserv
          dc.l TstErr
          dc.l SetRes
          dc.l SetAly
          dc.l BootR

;------ XXX ( A0=Param.-Stack A1=DataWrite A2=DataRead -- D0=Ergebnis )
;------ Routinen der einzelnen Funktionen
;
;--- SetLinkAdr

SLAdr:    move.w $02(A0),D0        ;LinkAdresse -> D0
          tst.w D0                 ;D0 < 0 ?
          bmi SLAdr1               ;ja, nur Adresse abfragen

          move.l #SlotExp,A3       ;SlotExp -> A3
          tst.b $E(A3)             ;Slot-Expander aktivieren
          tst.b $E(A3)
          tst.b $E(A3)
          and.w #3,D0              ;mgliche Adresse ausfiltern
          move.w D0,D1             ;Adresse -> D1
          lsl.w #1,D1              ;D1 * 2 -> D1
          tst.b 0(A3,D1.w)         ;Slot aktivieren

          tst.b $400(A1)           ;A10=0
          btst #5,$601(A1)         ;Businterface-Status testen
          bne SLAdr2               ;Bit 5 = 0 ? nein, dann nicht
          tst.b $404(A1)           ;A10=1
          btst #5,$601(A1)         ;Businterface-Status testen
          beq SLadr2               ;Bit 5 = 1 ? nein, dann nicht

          move.w D0,LinkAdr        ;Adresse merken

SLAdr1:   move.w LinkAdr,D0        ;LinkAdr zurckgeben
          rts

SLAdr2:   moveq #-1,D0             ;Fehler, Businterface nicht vorhanden
          rts

;--- ByteToLink

BTLink:   move.w $02(A0),D0         ;Ausgabewert -> D0
          bsr ByteOut               ;Wert in D0 ausgeben
          rts

;--- ByteFromLink

BFLink:   bsr ByteIn                ;Eingabewert -> D0
          rts

;--- LongWordToLink

LTLink:   move.l $02(A0),D3         ;Ausgabewert -> D3
          moveq #$03,D4             ;4 Bytes sind auszugeben

LTLLoop:  move.b D3,D0              ;Byte -> D0
          bsr ByteOut               ;Wert D0 ausgeben
          bmi LTLink1               ;Fehler ? ja, dann --> LTLink1
          ror.l #$08,D3             ;nchstes Byte
          dbf D4,LTLLoop            ;und weiter

LTLink1:  rts

;--- LongWordFromLink

LFLink:   move.l $02(A0),A3         ;Adresse fr das Ergebnis -> A3
          clr.l D3                  ;0 -> D3
          moveq #$03,D4             ;4 Bytes sind einzulesen

LFLLoop:  bsr ByteIn                ;Eingabewert -> D0
          bmi LFLink1               ;Fehler ? ja, dann --> LFLink1
          move.b D0,D3              ;Byte ablegen
          ror.l #$08,D3             ;einschieben
          dbf D4,LFLLoop            ;und weiter

          move.l D3,(A3)            ;Langwort ablegen
          clr.l D0                  ;keine Fehler
LFLink1:  rts

;--- SliceToLink

STLink:   move.l $02(A0),A3         ;Bufferadresse -> A3
          move.l $06(A0),D3         ;Lnge -> D3
          move.l D3,D4              ;Lnge -> D4
          beq STLink1               ;Lnge = 0 ? ja --> STlink1

STLLoop:  move.b (A3)+,D0           ;Byte holen
          bsr ByteOut               ;Wert D0 ausgeben
          bmi STLink2               ;Fehler ? ja, dann --> STLink2
          subq.l #1,D3              ;D3 - 1 -> D3
          bne STLLoop               ;Fertig ? nein --> STLLoop

          sub.l D3,D4               ;tatschliche Anzahl -> D4
STLink1:  move.l D4,D0              ;      "        "    -> D0
STLink2:  rts

;--- SliceFromLink

SFLink:   move.l $02(A0),A3         ;Bufferadresse -> A3
          move.l $06(A0),D3         ;Lnge -> D3
          move.l D3,D4              ;Lnge -> D4
          beq SFLink1               ;Lnge = 0 ? ja --> SFLink1

SFLLoop:  bsr ByteIn                ;Wert reinholen
          bmi SFLink2               ;Fehler ? ja, dann --> SFLink2
          move.b D0,(A3)+           ;Wert ablegen
          subq.l #1,D3              ;D3 - 1 -> D3
          bne SFLLoop               ;Fertig ? nein --> SFLLoop

          sub.l D3,D4               ;tatschliche Anzahl -> D4
SFLink1:  move.l D4,D0              ;      "        "    -> D0
SFLink2:  rts

;--- Fr Erweiterungen resevierte Funktionen

Reserv:   moveq.l #-32,D0           ;Funktion nicht vorhanden
          rts

;--- TestError

TstErr:   tst.b $401(A1)            ;ErrorRegister adressieren
          tst.b $560(A1)
          tst.b $370(A1)            ;NotIORD = 0
          move.b (A2),D0            ;ErrorFlag -> D0
          tst.b $3F0(A1)            ;NotIORD = 1
          not.b D0                  ;Bit umdrehen, da NotError
          and.l #1,D0               ;Flag ausfiltern
          rts

;--- SetReset

SetRes:   tst.b $23F(A1)            ;Alle NotSelect-Leitungen = 1
          tst.b $3F0(A1)
          tst.b $401(A1)            ;AnalyseRegister adressieren
          tst.b $561(A1)
          tst.b (A1)                ;Analyse = 0
          bsr WriteIt               ;AnalyseRegister einschreiben
          tst.b $560(A1)            ;ResetRegister adressieren
          tst.b (A1)                ;Reset = 0
          bsr WriteIt               ;ResetRegister einschreiben
          bsr ResWait               ;warten
          tst.b $001(A1)            ;Reset = 1
          bsr WriteIt               ;ResetRegister einschreiben
          bsr ResWait               ;warten
          tst.b (A1)                ;Reset = 0
          bsr WriteIt               ;ResetRegister einschreiben
          clr.l D0                  ;kein Fehler
          rts

;--- SetAnalyse

SetAly:   tst.b $23F(A1)            ;Alle NotSelect-Leitungen = 1
          tst.b $3F0(A1)
          tst.b $401(A1)            ;AnalyseRegister adressieren
          tst.b $561(A1)
          tst.b (A1)                ;Analyse = 0
          bsr WriteIt               ;AnalyseRegister einschreiben
          tst.b $560(A1)            ;ResetRegister adressieren
          tst.b (A1)                ;Reset = 0
          bsr WriteIt               ;ResetRegister einschreiben
          bsr ResWait               ;warten
          tst.b $561(A1)            ;AnalyseRegister adressiern
          tst.b $001(A1)            ;Analyse = 1
          bsr WriteIt               ;AnalyseRegister einschreiben
          bsr ResWait               ;warten
          tst.b $560(A1)            ;ResetRegister adressiern
          tst.b $001(A1)            ;Reset = 1
          bsr WriteIt               ;ResetRegister einschreiben
          bsr ResWait               ;warten
          tst.b (A1)                ;Reset = 0
          bsr WriteIt               ;ResetRegister einschreiben
          tst.b $561(A1)            ;AnalyseRegister adressiern
          tst.b (A1)                ;Analyse = 0
          bsr WriteIt               ;AnalyseRegister einschreiben
          clr.l D0                  ;kein Fehler
          rts

;--- BootRoot

BootR:    move.l $02(A0),A3         ;Adresse des Filenamens -> A3
          clr.w -(SP)               ;File zum lesen ffnen
          move.l A3,-(SP)
          move.w #Fopen,-(SP)
          trap #GemDos
          lea $08(SP),SP            ;Stack korrigieren
          tst.l D0                  ;Fehler ?
          bmi BootR2                ;ja, dann zurck --> BootR2
          move.l D0,D3              ;Filehandle -> D3

BRLoop1:  move.l #Buffer,-(SP)      ;Block lesen
          move.l #BufLen,-(SP)
          move.w D3,-(SP)
          move.w #FRead,-(SP)
          trap #GemDos
          lea $0C(SP),SP            ;Stack korrigieren
          tst.l D0                  ;Fehler ?
          bmi BootR1                ;ja, dann zurck --> BootR1

          move.l #DataWrite,A1      ;DataWrite -> A1
          move.l #DataRead,A2       ;DataRead  -> A2
          move.l #Buffer,A3         ;BufAdr    -> A3

          move.l D0,D4              ;Anzale der Bytes -> D4
          move.l D0,D5              ;  "     "    "   -> D5
          subq.l #1,D4              ;D4 - 1 -> D4

BRLoop2:  move.b (A3)+,D0           ;Byte holen
          bsr ByteOut               ;Byte ausgeben
          bmi BootR1                ;Fehler ? ja, dann --> BootR1
          dbf D4,BRLoop2            ;weiter

          cmp.l #BufLen,D5          ;Anzahl der Bytes = BufLen ?
          beq BRLoop1               ;ja, dann nchsten Block

BootR1:   move.w D3,-(SP)           ;File schlieen
          move.w #Fclose,-(SP)
          trap #GemDos
          addq.l #$4,SP             ;Stack korrigieren
BootR2:   rts

;------ Unterprogramme
;
;--- SlotOn ( -- D0== D1=X A4=X )
;--- Umschalten auf Link-Slot falls Slot-Expander vorhanden

SlotOn:   move.l #SlotExp,A4        ;SlotExp -> A4
          tst.b $E(A4)              ;Slot-Expander aktivieren
          tst.b $E(A4)
          tst.b $E(A4)
          move.b $8(A4),D1          ;aktuellen Slot holen
          not.b D1                  ;negieren, da negative Logik
          and.b #3,D1               ;Slot-Nr. ausfiltern
          move.w D1,OldSlot         ;Slot-Nr. merken
          move.w LinkAdr,D1         ;Link-Slot holen
          lsl.w #1,D1               ;D1 * 2 -> D1
          tst.b 0(A4,D1.w)          ;Link-Slot aktivieren
          rts

;--- SlotOff ( -- D0== D1=X A4=X )
;--- Umschalten auf alten Slot falls Slot-Expander vorhanden

SlotOff:  move.l #SlotExp,A4        ;SlotExp -> A4
          tst.b $E(A4)              ;Slot-Expander aktivieren
          tst.b $E(A4)
          tst.b $E(A4)
          move.w OldSlot,D1         ;alte Slot-Nr. holen
          lsl.w #1,D1               ;D0 * 2 -> D1
          tst.b 0(A4,D1.w)          ;alten Slot aktivieren
          rts

;--- ByteOut ( D0=Ausgabe -- D0=Fehler D1=X D2=X )

ByteOut:  move.w #OTimeOut,D1       ;Ausgabetimeout -> D1
          tst.b $401(A1)            ;OutputStatusRegister adressieren
          tst.b $553(A1)

BOLoop:   tst.b $370(A1)            ;NotIORD = 0
          move.b (A2),D2            ;OutputStatus des C011 -> D2
          tst.b $3F0(A1)            ;NotIORD = 1

          btst #$00,D2              ;ausgabebereit ?
          bne ByteOut1              ;ja, dann raus damit --> ByteOut1

          dbf D1,BOLoop             ;weiter versuchen
          moveq #-1,D0              ;Timeout !!
          rts

ByteOut1: tst.b $551(A1)            ;OutputDataRegister adressieren
          and.w #$FF,D0             ;Wert ausfiltern
          tst.b 0(A1,D0.w)          ;Daten einstellen
          tst.b $21F(A1)            ;Datenbustreiber ein
          tst.b $3B0(A1)            ;NotIOWR = 0
          tst.b $3F0(A1)            ;NotIOWR = 1
          tst.b $23F(A1)            ;Datenbustreiber aus
          clr.l D0                  ;keine Fehler
          rts

;--- ByteIn ( D0=X -- D0=Ergebnis D1=X D2=X )

ByteIn:   move.w #ITimeOut,D1       ;Eingabeauszeit -> D1
          tst.b $401(A1)            ;InputStatusRegister adressieren
          tst.b $552(A1)

BILoop:   tst.b $370(A1)            ;NotIORD = 0
          move.b (A2),D2            ;InputStatus des C011 -> D2
          tst.b $3F0(A1)            ;NotIORD = 1

          btst #$00,D2              ;etwas angekommen ?
          bne ByteIn1               ;ja, dann her damit --> ByteIn1

          dbf D1,BILoop             ;weiter versuchen
          moveq #-1,D0              ;Auszeit !!
          rts

ByteIn1:  tst.b $550(A1)            ;InputDataRegister adressieren
          tst.b $370(A1)            ;NotIORD = 0
          move.b (A2),D0            ;InptutData des C011 -> D0
          tst.b $3F0(A1)            ;NotIORD = 1
          andi.l #$FF,D0            ;Wert ausfiltern, N-Flag = 0
          rts

;--- WriteIt ( -- )

WriteIt:  tst.b $21F(A1)            ;Datenbustreiber ein
          tst.b $3B0(A1)            ;NotIOWR = 0
          tst.b $3F0(A1)            ;NotIOWR = 1
          tst.b $23F(A1)            ;Datenbustreiber aus
          rts

;--- ResetWait ( -- D2=X )

ResWait:  move.w #ResTime,D2        ;ResTime -> D2
RWLoop:   dbf D2,RWLoop
          rts

;------ Variablen und Buffer

          data
          align.w

LinkAdr:  dc.w $0000                ;Speicher fr LinkAdr (Standart=0)
OldSlot:  dc.w $0000                ;Speicher fr alte Slot-Nr.

          bss
          align.w

Buffer:   ds.b BufLen               ;Buffer fr BootRoot

          end
 
 