;-----------------------------------------------------
;
;               SCREEN.ASM     V# 1.1 / 15.05.88
;               written by     G.Wilde & C.Meyer
;
;-----------------------------------------------------
;
;verschiebt Bildspeicher in Pufferbereich und umgekehrt
;fr Hercules- und CGA-kompatible Bildschirmadapter
;Aufruf aus dBase mit
;       load screen.bin
;       ...
;       call screen with function
;function="R" fr read/restore, "W" fr write/save, "S" fr swap
;

V_LENBUF   equ  0fa0h                 ;Lnge des Bildschirmspeichers

_prog   segment byte
        assume  cs:_prog
savepg  proc    far
        mov     ax,cs                 ;eigenes Segment feststellen
        jmp     start

;----- Datenbereich:

scrseg  dw      ?
saveds  dw      ?
puffer  db      V_LENBUF+1 dup(0)

start:
        mov     [saveds],ds           ;ds retten
        mov     cx,0                  ;Bildschirmmodus feststellen:
        mov     ds,cx                 ;Datensegment 0
        mov     cx,0b000h             ;default fr Monochrom-Screen
        mov     [scrseg],cx
        mov     cl,ds:[449h]          ;Adresse Bildschirmmodus
        cmp     cl,7                  ;Monochrommodus?
        je      convert               ;ja: keine nderung
        mov     cx,0b800h             ;nein: Screensegment auf b800h setzen
        mov     [scrseg],cx
convert:
        mov     ds,[saveds]
        mov     dx,ds:[bx]            ;erstes Zeichen des dBase-Parameters
        or      dx,32                 ;konvertiere auf Kleinbuchstaben
        cmp     dx,"r"
        je      restore
        cmp     dx,"w"
        je      save
        cmp     dx,"s"
        je      swap
        ret

;----- Bildschirmseite in den Puffer verschieben:

save:
        lea     di,puffer             ;relative Pufferadresse berechnen
        mov     es,ax                 ;Programmsegment=Puffersegment
        mov     ax,[scrseg]           ;Bildschirmsegment
        mov     ds,ax
        mov     cx,V_LENBUF/2
        mov     si,0
        cld
        rep     movsw
        mov     ds,[saveds]           ;restore ds
        ret

;----- Pufferseite in den Bildschirmspeicher verschieben:

restore:
        lea     si,puffer         ;relative Pufferadresse berechnen
        mov     ds,ax
        mov     ax,[scrseg]
        mov     es,ax
        mov     cx,V_LENBUF/2
        mov     di,0
        cld
        rep     movsw
        mov     ds,[saveds]       ;restore ds
        ret

;----- Bildschirmseite mit Pufferinhalt vertauschen:

swap:
        lea     si,puffer         ;relative Pufferaddresse berechnen
        mov     di,0              ;screen fngt immer bei 0 an
        mov     ax,[scrseg]
        mov     ds,ax
        mov     ax,cs
        mov     es,ax             ;es := Puffersegment, ds := screensegment
        mov     cx,V_LENBUF
swaploop:
        mov     bl,es:[si]
        mov     bh,ds:[di]
        mov     es:[si],bh
        mov     ds:[di],bl
        inc     si
        inc     di
        loop    swaploop
        mov     ds,[saveds]
        ret

savepg endp
_prog  ends
       end
