/*********************************************************************
*
*                  DECODE.TOS                  14.8.88
*                  ==========
*                              letzte nderung 21.8.88
*
*
*  Geschrieben fr Megamax C ("int" ist 16 Bit gro).
*  Erzeugt die KAOS- Datei "KAOS" im aktuellen Verzeichnis.
*  Erwartet die KAOS- Patches "KAOS.PTC" im aktuellen Verzeichnis
*   und ein Original- TOS 1.2 im ROM.
*  Gibt bei Fehlern die DOS- Fehlercodes zurck.
*  Bildet eine Prfsumme der erzeugten KAOS- Datei. Bei falscher
*   Prfsumme wird die Datei zwar trotzdem erzeugt, ist aber mit
*   groer Wahrscheinlichkeit nicht lauffhig.
*
*  Aufbau der Datei "KAOS.PTC":
*   Ein Langwort fr Checksumme
*   Eintrge der Art : 1 Langwort fr Patchadresse
*                      1 Wort     fr Lnge des Patchbereichs in Bytes
*                      Patchdaten (soviele Bytes, wie das obige Wort angibt)
*
*********************************************************************/


#include <osbind.h>
#include <onlysys.h>    /* Runtime- Package des Compilers weglassen */
#include <tosdefs.h>


#define TRUE  1
#define FALSE 0
#define NULL  0L

char      *adr,*buf,*bufp;
long      err;
int       ohdl,ihdl;

main()
{
     long patchadr;
     unsigned int patchlen;
     long chksum,testsum;
     long *longbuf;


     if   (!(buf =  (char *) Malloc(196608L)))
          mem: Pterm((int) ENSMEM);
     if   (0 > (ihdl = Fopen("kaos.ptc",0)))
          Pterm(ihdl);
     if   (0 > (ohdl = Fcreate("kaos",0)))
          Pterm(ohdl);
     /* Header (32 Bit Checksumme) */
     err  = Fread(ihdl,4L,&chksum);
     if   (err != 4L)
          Pterm((int) err);
     /* ROM ins RAM kopieren */
     for  (bufp=buf, adr = (char *) 0xfc0000; adr < (char *) 0xff0000;)
          *(bufp++) = *(adr++);
     do   {
          /* Adresse holen */
          err = Fread(ihdl,4L,&patchadr);
          if   (err == 0L)
               break;
          if   (err != 4L)
               e: Pterm((int) err);
          patchadr -= 0xfc0000;
          /* Gre des Patchbereichs in Bytes */
          if   (2L != (err = Fread(ihdl,2L,&patchlen)))
               goto e;
          bufp = buf + patchadr;
          err = Fread(ihdl,(long) patchlen, bufp);
          if   (err != patchlen)
               goto e;
          }
     while(TRUE);

     /* Checksumme berprfen */
     /* --------------------- */

     testsum = 0L;
     for  (longbuf = (long *) buf; longbuf < (long *) (buf + 196608L); longbuf++)
          testsum += *longbuf;
     if   (testsum != chksum)
          {
          Cconws("Prfsummenfehler beim Erstellen der KAOS- Datei\15\12");
          Cconws("Wahrscheinlich falsche oder nicht originale TOS- Version im ROM!\15\12");
          Crawcin();
          }
     err = Fwrite(ohdl,196608L,buf);
     Fclose(ohdl);
     if   (err < 0L)
          Pterm((int) err);
     if   (err != 196608L)
          {
          Cconws("Disk voll\15\12");
          Fdelete("kaos");
          Pterm((int) ENSMEM);
          }
     Pterm0();
}
