/* Diese Programme gehoeren zum Artikel "Filtration, 10/88, S. 180 */

/*-----------------------------------------------------------------*/
/* "hilfe.c". Wird von allen anderen Programmen benoetigt           */

#define FALSE                 0
#define TRUE                  1
#define LF                    10  /* LF = Zeilenende !! */
#define UNGLEICH              !=
#define ABBRUCH               break
#define ZUM_LESEN             "r"
#define ZUM_SCHREIBEN         "w"
#define TEST_DATEI            "test.text"
#define BOOL                  int
#define ULONG                 unsigned long
#define UBYTE                 unsigned char

UBYTE zeile[120];
UBYTE einwort[40];

/* hole_zeile liest eine Zeile ein und gibt deren Laenge zurueck
   bei einem Fehler -1. Uebergabe-Parameter sind
    FILE *fp   -- Pointer auf eine File-Deskriptor zum Einlesen
    char *text -- Pointer auf ein Feld fuer den Text.
   Das Ende der Zeile ist die \0, ein \n wird ausgefiltert !! */

hole_zeile(fp,text)
register FILE *fp;
register UBYTE *text;
{
     register int ein, zaehler = 0;

     while ((ein = fgetc(fp))!= LF && ein != EOF)
        text[zaehler++] = ein;         /* kopieren und weiter */

     text[zaehler] = '\0';  /* Zeichenkette mit 0 abschliessen */
     if (ein == EOF && zaehler == 0) return -1;
     return zaehler;                         /* -1, falls EOF */
}

/* hole_wort liest ein Wort ein und gibt die Laenge des gelesenen
   Wortes zurueck, bei einem Fehler aber -1. Parameter sind
    FILE *fp   -- Pointer auf eine File-Deskriptor zum Einlesen
    char *text -- Pointer auf ein Feld fuer den Text.  */

hole_wort(fp,text)
register FILE *fp;
register unsigned char *text;
{
     register int zaehler = 0,ein = '\0';

     while (((ein = fgetc(fp)) == ' ' || ein==LF) && ein!=EOF)
         ;
     do
     {   if (ein != EOF && ein != ' ' && ein != LF)
            text[zaehler++] = ein;    /* kopieren und weiter */
         else
            ABBRUCH;
     } while ((ein = fgetc(fp)) != EOF); /* bis EOF erreicht */
     text[zaehler] = '\0';       /* String mit 0 abschliessen */
     if (ein == EOF && zaehler == 0) return -1;
     return zaehler;                       /* -1, falls EOF  */
}

/*-------------------------------------------------------------*/
/* "grob" sucht einfach alles ohne Methode durch */

#include "stdio.h"
#include "hilfe.c"

char *worte[] =
{
  "aberl","undivie","diesol","daser","wuep","qae","baldo","wald",
  "ratsam","unhold","quiwa","blob","hue","kanaa","rijk","tommmi"
};
int anzahl = sizeof(worte) / sizeof(*worte);

main()
{
    register int zaehler,zaehler1,wlaenge,zwischen;
    register UBYTE *pointtoit;
    int zlaenge;
    FILE *fp,*fopen();

    fp = fopen(TEST_DATEI,ZUM_LESEN);
    if (fp == 0L) exit(20);

    printf("Start...\n");
    zlaenge = hole_zeile(fp,zeile);
    do                /* wiederhole folgendes ... */
    {  for (zaehler = 0; zaehler < anzahl; zaehler++)
       {                    /* fuer alle Woerter */
          wlaenge = strlen(worte[zaehler]);
          zwischen = zlaenge - (wlaenge); pointtoit = zeile;
          for (zaehler1 = 0; zaehler1 <= zwischen; zaehler1++)
          {  if (strncmp(worte[zaehler],pointtoit++,wlaenge)==0)
             {  printf("' habe %s gefunden\n",worte[zaehler]);
                ABBRUCH; /* kann keinem zweiten Wort gleichen */
             }
          }
       }
    }  while ((zlaenge = hole_zeile(fp,zeile)) UNGLEICH -1);
       /* ... bis alle Zeilen gelesen */
    printf("Das war's\n"); fclose(fp);
}


/*-------------------------------------------------------------*/
/* teile sucht TOKEN-weise den Text nach bestimmten Worten */

#include "stdio.h"
include "hilfe.c"

char *worte[] = {
   "aberl", "undivie", "diesol", "daser", "wuep", "qae", "baldo",
   "wald", "ratsam", "unhold", "quiwa", "blob","hue", "kanaa",
   "rijk", "tommmi"
};
int anzahl = sizeof(worte) / sizeof(*worte);  /* 16 Woerter */

main()
{
    register int zaehler,wort_laenge;
    FILE *fp,*fopen();

    fp = fopen(TEST_DATEI,ZUM_LESEN);
    if (fp == 0L) exit(20);
    wort_laenge = hole_wort(fp,einwort);  /* hole ein Wort */

    printf("Start ...\n");
    do                /* wiederhole folgendes ... */
    {  for (zaehler = 0; zaehler < anzahl; zaehler++)
       {
          if (strcmp(worte[zaehler],einwort) == 0)
          {  printf("' habe %s gefunden\n",worte[zaehler]);
             ABBRUCH;
          }
       }
    }  while ((wort_laenge = hole_wort(fp,einwort)) != -1);
       /* ... bis alle Worte gelesen sind */

    printf("Das war's\n"); fclose(fp);
}


/*-------------------------------------------------------------*/
/* "laenge" errechnet erst die Laenge eines Wortes, bevor
   es ein Suchwort mit einem Wort aus dem Text vergleicht */

#include "stdio.h"
#include "hilfe.c"

struct string
{  int   laenge;
   UBYTE  worte[20];
};

struct string feld[] = {
   { 5,"aberl"},  { 7,"undivie"}, { 6,"diesol"}, { 5,"daser"},
   { 3,"wuep"},    { 2,"qae"},      { 5,"baldo"},  { 4,"wald"},
   { 6,"ratsam"}, { 6,"unhold"},  { 5,"quiwa"},  { 4,"blob"},
   { 2,"hue"},     { 5,"kanaa"},   { 4,"rijk"},   { 6,"tommmi"}
};
int anzahl = sizeof(feld) / sizeof(*feld);

main()
{
    register int zaehler, wort_laenge;
    FILE *fp,*fopen();

    fp = fopen(TEST_DATEI,ZUM_LESEN);
    if (fp == 0L) exit(20);

    printf("Start...\n");
    wort_laenge = hole_wort(fp,zeile);
    do                /* wiederhole folgendes ... */
    {  for (zaehler = 0; zaehler < anzahl; zaehler++)
       {
          if (feld[zaehler].laenge == wort_laenge)
             if (strcmp(feld[zaehler].worte,zeile) == 0)
             {  printf("' habe %s ",feld[zaehler].worte);
                printf("gefunden\n"); ABBRUCH;
             }
       }
    }  while ((wort_laenge = hole_wort(fp,zeile)) != -1);
       /* ... bis alle Worte gelesen sind */

    printf("Das war's\n"); fclose(fp);
}


/*-------------------------------------------------------------*/
/* "Hash.c". Programm, das beliebige Strings in einem Text sucht
   und sich dabei eines raffinierten Hash-Mechanismus bedient.
   Diese Version funktioniert nur mit 32Bit grossen Integer-
   Variablen.  D. Goehler 11.08.1988 */

#include "stdio.h"
#include "hilfe.c"

/* fuer die 16-Bit-Version  "#define ULONG unsigned int" */
struct string
{
   int    laenge;
   ULONG  maske;         /* Maske zum verUNDen des hashcode */
   ULONG  hashcode;      /* hashcode des Strings  */
   UBYTE  worte[20];     /* siehe Artikel .... */
};

struct string feld[] =
{
   { 0,0L,0L,"aberl"}, { 0,0L,0L,"diesol"},{ 0,0L,0L,"rijk"},
   { 0,0L,0L,"daser"}, { 0,0L,0L,"wuep"},   { 0,0L,0L,"qae"},
   { 0,0L,0L,"baldo"}, { 0,0L,0L,"wald"},  { 0,0L,0L,"ratsam"},
   { 0,0L,0L,"unhold"},{ 0,0L,0L,"quiwa"}, { 0,0L,0L,"blob"},
   { 0,0L,0L,"hue"},    { 0,0L,0L,"kanaa"}, { 0,0L,0L,"undivie"},
   { 0,0L,0L,"tommmi"}
};
int anzahl = sizeof(feld) / sizeof(*feld);

#define ANZAHL 8     /* Zahl der kodierten Buchstaben, die in
                      ein Register passen. 16-Bit : 5 */
#define SHIFT  4     /* Zahl der Stellen, um die verschoben wird.
                      16-Bit: 3 */
#define MASKE  0x0fL /* SHIFT-Maske. 16-Bit : 0x07 (ohne "L")*/

main()
{
    register int zaehler,zaehler1;
    int zlaenge;
    register UBYTE *pointtonext;
    UBYTE *pointtoit;
    register struct string *now;
    register ULONG hash_it;
    FILE *fp,*fopen();

    init_worte();
    fp = fopen(TEST_DATEI,ZUM_LESEN);
    if (fp == 0L) exit(20);

    printf("Start...\n");
    zlaenge = hole_zeile(fp,zeile);
    do         /* wiederhole folgendes fuer eine Zeile */
    {  hash_it = 0L; pointtonext = pointtoit = zeile;
       for (zaehler1 = 0; zaehler1 < zlaenge; zaehler1 ++)
       {  hash_it = (hash_it<<SHIFT) + (*pointtonext++ & MASKE);
          for (zaehler = 0; zaehler < anzahl; zaehler++)
          {  now = &(feld[zaehler]);
             if (now->hashcode ==  (now->maske & hash_it))
             {
                if (strncmp(now->worte, pointtoit-now->laenge+1,
                      now->laenge) == 0)
                {  printf("' habe %s gefunden\n",now->worte);
                   ABBRUCH;
                }
             }
          }
          pointtoit++;
       }
    }  while ((zlaenge = hole_zeile(fp,zeile)) UNGLEICH -1);
       /* ... bis alle Zeilen gelesen */

    printf("Das war's\n"); fclose(fp);
}

init_worte()
{
    int i,j,laenge;

    for (i=0; i < anzahl; i++)
    {
      feld[i].laenge = strlen(feld[i].worte);
      laenge = feld[i].laenge > ANZAHL ? ANZAHL : feld[i].laenge;
      /* die Laenge darf nicht groesser als 8 werden */
      if (laenge == 0) continue;  /* bei Laenge Null: NEXT i */
      feld[i].maske    = MASKE;
      feld[i].hashcode = feld[i].worte[0] & MASKE;

      for (j=1; j < laenge; j++)
      {   feld[i].maske = (feld[i].maske << SHIFT) + MASKE;
          feld[i].hashcode = (feld[i].hashcode << SHIFT) +
                               (feld[i].worte[j] & MASKE);
      }
    }
}


/*-------------------------------------------------------------*/
/* "druck" druckt einen Text aus, kann ihn mit Seiten- und
   Zeilennummer versehen, und diverse Textersetzungen vornehmen
   (mittels eines raffinierten, schnellen Hash-Mechanismus)
   D. Goehler 1988 */

#include "stdio.h"
#include "hilfe.c"

#define DEFAULTL 62          /* default: Zeilen pro Seite */
#define DEFAULTS 1           /* default: erste Seitennummer */
#define DEFAULTZ 1           /* default: erste Zeilennummer */
#define FF       12          /* Formfeed */
#define PRINTER  "PRT:" /* Bezeichnung Printerschnittstelle */

/* Makro, um eine Textzeile auszugeben */
#define putline(pointer,text)   fputs(text,pointer)

struct string
{
   int     laenge;        /* Laenge des Suchwortes */
   ULONG   maske;         /* Maske zum verUNDen des hashcode */
   ULONG   hashcode;      /* Suchwert in 4-Bit-Gruppen */
   UBYTE   worte[20];     /* zu suchendes Wort */
   int     elaenge;       /* Laenge des Ersatzwortes */
   UBYTE   eworte[20];    /* damit wird ersetzt */
};
int anzahl;               /* Anzahl der zu suchenden Woerter */
struct string feld[100];  /* fuer maximal 100 Ersetzungen */
UBYTE filename[80];       /* auszulesende Datei */
int Seiten = 0;           /* Zaehler fuer die Seitennummer */
int Zeilen = 0;           /* Zaehler der Zeilennummer */
int Laenge = DEFAULTL;    /* Laenge einer Seite in Zeilen */
int Zaehler = 0;          /* Zaehlt die ausgedruckten Zeilen */

main(argc,argv)
int argc;
UBYTE **argv;
{
    FILE *fpout,*fopen(),*fp;
    int zaehler,zaehler1,zlaenge;
    UBYTE *pointtoit,*pointtonext;
    struct string *now;
    ULONG hash_it;
    BOOL ers_flag = FALSE;

    if (argc <=1 || (argc == 2 && *argv[1] == '?'))
    {  printf("Aufruf: %s Dateiname Z[<n>] S[<n>] L[<n>] Dname\n",
               argv[0]);
       printf("   Z - Zeilennummern ein mit Startwert n\n");
       printf("   S - Seitennummern ein mit Startwert n\n");
       printf("   L - Seitenlaenge in Zeilen n (72 = ohne FF)\n");
       printf("   D - Dateiname fuer Datei mit Ersetzungen\n\n");
       exit(0);
    }

    /* nur wenn argc > 2 gibt es Parameter */
    while (--argc > 1)
    switch(*argv[argc]++)
    {  case 'Z': if ((Zeilen = atoi(argv[argc])) == 0)
                    Zeilen = DEFAULTZ;
                 break;
       case 'S': if ((Seiten = atoi(argv[argc])) == 0)
                    Seiten = DEFAULTS;
                 break;
       case 'L': if ((Laenge = atoi(argv[argc])) == 0)
                    Laenge = DEFAULTL;
                 break;
       case 'D': strcpy (filename,argv[argc]); ers_flag = TRUE;
                 break;
       default : printf("Unbekannte Option %c\n\n",argv[argc]-1);
                 exit(20);
                 break;
    }
    if ((fpout = fopen(PRINTER,ZUM_SCHREIBEN)) == NULL)
    {  printf("prt: ist nicht bereit\n");
       exit(20);
    }
    if ((fp = fopen(argv[1],ZUM_LESEN)) == NULL)
    {  printf("Datei nicht vorhanden\n");
       fclose(fpout);
       exit(20);
    }
    if (ers_flag)
    { if (init_worte(filename) == 1)
      {  printf("Datei mit Ersetzungen nicht gefunden\n");
         fclose(fpout); fclose(fp); exit(20);
      }
      zlaenge = hole_zeile(fp,zeile);

      do         /* wiederhole folgendes fuer eine Zeile */
      {  hash_it = 0L; pointtonext = pointtoit = zeile;
         for (zaehler1 = 0; zaehler1 < zlaenge; zaehler1 ++)
         {  hash_it = (hash_it << 4) + ((*pointtonext++) & 0x0f);
            for (zaehler = 0; zaehler < anzahl; zaehler++)
            {  now = &(feld[zaehler]);
               if (now->hashcode ==  (now->maske & hash_it))
               {  if (strncmp(now->worte, pointtoit-now->laenge+1,
                              now->laenge) == 0)
                  {
                     zlaenge = ersetze(zaehler1-now->laenge+1,
                               now,zlaenge);
                     hash_it = 0L; pointtonext = zeile;
                     pointtoit = zeile-1;
                     zaehler1 = -1;
                     break;
                  }
               }
            }
            pointtoit++;
         }
         gibaus(fpout,zeile);
      }  while ((zlaenge = hole_zeile(fp,zeile)) UNGLEICH -1);
         /* ... bis alle Zeilen gelesen */
    }
    else
       druckepur(fp,fpout);

    fputc(FF,fpout);          /* letzte Seite rausschieben */
    printf("Das waren %d Zeilen\n",Zaehler);
    fclose(fpout); fclose(fp); /* "Dateien" wieder schliessen */
}

/* init_worte() liest die Such- und Ersetzwoerter einer
   angegebenen Datei ein und errechnet die zugehoerigen
   Masken- und Suchwerte. Der Dateiname wird in
   "filename" uebergeben. */

init_worte(filename)
UBYTE *filename;
{
    int i,j,c,laenge; FILE *fpin;

    fpin = fopen(filename,ZUM_LESEN);
    if (fpin == NULL)
       return 1;

    i = 0;
    do
    {  j = 0;
       if ((c = fgetc(fpin)) == EOF)
          break; /* ein Wort lesen */
       c = getdez(feld[i].worte,&(feld[i].laenge),fpin,c);
       if (c == EOF) break;
       while ((c = fgetc(fpin))== ' ')
          ;/* Leerzeichen ueberlesen */
       c = getdez(feld[i].eworte,&(feld[i].elaenge),fpin,c);
       laenge = (feld[i].laenge) >= 8 ? 8 : feld[i].laenge;
                  /* nicht laenger als 8 Zeichen */
       if (laenge == 0) continue;
       feld[i].maske    = 0x000fL;
       feld[i].hashcode = feld[i].worte[0] & 0x000fL;

       for (j=1; j < laenge; j++)
       {   feld[i].maske = (feld[i].maske << 4) + 0x000fL;
           feld[i].hashcode = (feld[i].hashcode << 4) +
                                (feld[i].worte[j] & 0x000f);
       }
       while (c != '\n' && c != EOF)
          c = fgetc(fpin);       /* Rest der Zeile ueberlesen */
       i++;
    }  while (c != EOF);
    anzahl = i; fclose(fpin); return 0;
}

/* ersetze fuehrt an der Stelle "posi" eine Ersetzung durch.
   Hierfuer werden das Such- und Ersatzwort von "zeiger"
   herangezogen. "zlen" ist die neue Zeilenlaenge nach der
   Ersetzung. */

ersetze(posi,zeiger,zlen)
int posi;
struct string *zeiger;
int zlen;
{   register int i,j; UBYTE *p = zeile + posi;

    if (zeiger->laenge > zeiger->elaenge)
    {  strncpy(p,zeiger->eworte,zeiger->elaenge);
       strcpy(p+zeiger->elaenge, p+zeiger->laenge);
       return(zlen-zeiger->laenge+zeiger->elaenge);
    }
    if (zeiger->laenge == zeiger->elaenge)
    {  strncpy(zeile+posi,zeiger->eworte,zeiger->elaenge);
       return(zlen);
    }
    j = zeiger->elaenge-zeiger->laenge;
    for (i = zlen +j; i >= posi+zeiger->elaenge; i--)
       zeile[i] = zeile[i-j];
    strncpy(zeile+posi,zeiger->eworte,zeiger->elaenge);
    return(zlen+j);
}

druckepur(fp,fpout)        /* durckt den Text ohne Ersetzungen */
FILE *fp,*fpout;
{
   while (hole_zeile(fp,zeile) UNGLEICH -1)
      gibaus(fpout,zeile);
}

gibaus(fp,zeile)       /* durckt eine Zeile und fuegt eventuell */
FILE *fp;               /* Zeilennummern sowie Seitennummern   */
UBYTE *zeile;          /* ein/an. */
{
   if (Zeilen)                  /* wenn Zeilennumern erwuenscht */
      fprintf(fp,"%4d  ",Zeilen++);

   putline(fp,zeile);                        /* Zeile ausgeben */
   fputc('\n',fp);                       /* Linefeed hinterher */
   if ((++Zaehler % Laenge) == 0)          /* pruefe Seitenende */
   {  if (Seiten)                        /* wenn Seitennummern */
      {  putline(fp,"\x0A                             Seite ");
         fprintf(fp,"%3d\n",Seiten++);        /* ausgeben + LF */
      }                          /* neue Zeilennummer ausgeben */
      if (Laenge != 72)                       /* am Seitenende */
         fputc(FF,fp);                    /* Formfeed ausgeben */
   }
}

/* getdez liest Buchstaben ein. Diese koennen aber auch mit einem
   fuehrenden "/" dezimal angegeben werden. Der eingelesene String
   wird in "wort" abgelegt, die Laenge in "laenge" eingetragen.
   Ein SPACE, LINEFEED oder EOF beendet diese Funktion         */

getdez(wort,laenge,fpin,c)
UBYTE *wort;
int *laenge,c;
FILE *fpin;
{
   int j = 0;
   while (c != ' ' && c != '\n' && c != EOF)
   {
      if (c == '/')                 /* folgt ein Dezimalwert ? */
      {  c = (fgetc(fpin)-48)*10;
         c = (c + (fgetc(fpin)-48))*10;       /* herausfiltern */
         c += fgetc(fpin)-48;
      }
      wort[j++] = (UBYTE) (255 & c);          /* und speichern */
      c = fgetc(fpin);
   }
   wort[j] = '\0';   *laenge = j;   return c;
}
