/**
 *  IEEE math.h 3.2 for Alcyon 4.14 in use with Libh   
 *  07/05/88 S.Hering
**/

/* Declarations of Math Routines */

long atol();            /* ascii to long */
char *ltoa();           /* long to ascii */

double atof();          /* ascii to float */
char *ftoa();           /* float to %f format */
char *etoa();           /* float to scientific notation format */

/* "angle"-functions */
double sin();
double cos();
double tan();

/* area functions */
double asin();
double acos();
double atan();
double atan2();         

/* hyperbolic functions */
double sinh();
double cosh();
double tanh();

/* area hyperbolic functions */
double atanh();

double fabs();          /* floatingpoint absolute */
double floor();         /* returns largest int    */
double ceil();          /* returns smallest int   */ 
double fmod();          /* flotingpoint modulo    */

double log10();         /* decade logarithm  */
double log2();          /* binary logarithm  */
double logn();          /* natural logarithm */
double log();           /* natural logarithm */
double ln();            /* natural logarithm */

double pow();           /* x^y               */
double sqrt();          /* square root       */
double exp();           /* e^x               */
double tentox();        /* 10^x              */
double twotox();        /*  2^x              */

/* manipulate floats */
double modf();          
double ldexp();
double frexp();

/* constants */
double pi();            /* 3.1415.....       */

/* end of math.h */
