{$N-}
Program Maus_zeiger_editor;
{$DEFINE resident}
{$IFDEF resident}
{ unit drivers und fonts wurden nach Turbo Pascal Manual
  aus allen Treibern und Fonts erzeugt }
uses dos,crt,graph,mousunit,drivers,fonts;
{$ELSE}
uses dos,crt,graph,mousunit;
{$ENDIF}
var
  Gd,Gm,GrSave : integer;
  i,updateflag : byte;
  x,y,Count : word;
  Flag : MouseMenuFlags;
  NewCursor : MaskRecord;
  s:string[8];
  Menu1: string;
  f:text;

{$F+}
Procedure MouseInt(Mask,Button,X,Y:Word);
{ Diese Prozedur wird vom Maustreiber indirekt ber die
  Maus-Unit aufgerufen, wenn einer der Knpfe bettigt wird}
Begin
  case Button of
    1:  Sound(440);        { Linker Knopf  }
    2:  Sound(880);        { Rechter Knopf }
    3:  Sound(1000);       { Beide Knpfe  }
  end;
  delay(20);
  Nosound;
End;
{$F-}

Procedure Abort(msg:string);
begin
  writeln (msg, ': Treiber nicht gefunden!');
  halt(1);
end;

Procedure RegisterAll;
begin
  if RegisterBGIdriver(@CGADriverProc) < 0 then     Abort('CGA');
  if RegisterBGIdriver(@EGAVGADriverProc) < 0 then  Abort('EGA/VGA');
  if RegisterBGIdriver(@HercDriverProc) < 0 then    Abort('Herc');
  if RegisterBGIdriver(@ATTDriverProc) < 0 then     Abort('AT&T');
  if RegisterBGIdriver(@PC3270DriverProc) < 0 then  Abort('PC 3270');
end;

Procedure BitInvert(var mask:word;nr:byte);
{ Invertiert Bit nr in word mask }
begin
  mask:= mask xor ($8000 shr nr);
end;

Function BitTest(mask:word;nr:byte):boolean;
{ Testet Bit nr in word mask }
begin
  BitTest:=(mask and ($8000 shr nr)) > 0;
end;

Function Hexval(value:word):string;
{ Verwandelt word value in Hexstring }
Var
  hext : string;
  i,r : byte;
const
  hexst = '0123456789ABCDEF';
Begin
  hext:='';
  for i:=1 to 4 do begin
    r:=1+value-(value shr 4) shl 4;
    value:=value shr 4;
    hext:=copy(hexst,r,1)+hext;
  end;
  hexval:=hext;
end;

Procedure InitScreen;
{ Initialisiert Variable und Bildschirm }
Begin
  HideMouse;
  NewCursor.x:=0;
  NewCursor.y:=0;
  for x:=1 to 17 do begin
    if x<17 then begin
      NewCursor.mask[0,x-1]:=0;
      NewCursor.mask[1,x-1]:=0;
    end;
    for y:=1 to 17 do begin
      if y < 17 then line(x*15,y*15,x*15,(y+1)*15);
      if x < 17 then line(x*15,y*15,(x+1)*15,y*15);
    end;
  end;
  setgraphicscursor(StandardCursor);
  Updateflag:=MouseMenu(menu1,3,flag);
  ShowMouse;
end;

begin
{ Grafik-Initialisierung }
  Gd := Detect;
  {$IFDEF resident}
    RegisterAll;
    InitGraph(Gd, Gm, '');
  {$ELSE}
    InitGraph(Gd, Gm, '\turbo\driver');
  {$ENDIF}
    GrSave:=GraphResult;
  if GrSave <> grOk then begin
    writeln('Grafik Initialisierungs Fehler Nr.: ',GrSave);
    Halt(1);
  end;
  { Men Texte Zuweisen }
  Menu1:='10Reset: ;02Neuer Cursor:02Standard Cursor;04Exit: ';
  resetmouse;              { Maus initialisieren }
  for i:=1 to 20 do flag[i]:=false;
  { Setzt MouseInt als Interrupt-Prozedur, die vom Maustreiber
    gerufen wird, wenn einer der Knpfe bettigt wird = $0A }
  SetMouseProcedure($0A,@MouseInt);
  InitScreen;               { Initialisierung Variablen + Screen }
  ShowMouse;                { Mauszeiger einschalten }
  repeat
    if flag[2] then setgraphicscursor(NewCursor)
               else setgraphicscursor(StandardCursor);
    if Updateflag > 0 then Updateflag:=MouseMenu(menu1,3,flag)
                      else Updateflag:=MouseMenu('',3,flag);
    Flag[20]:=buttonpressinfo(LeftB,Count,x,y);
    ShowMouse;
    if Count > 0 then begin
      for x:=1 to 16 do begin
        for y:=1 to 16 do begin
          if MouseInBox(x*15,y*15,(x+1)*15,(y+1)*15) then begin
            { Modifiziere Bildschirmmaske }
            setgraphicscursor(StandardCursor);
            if leftbutton and rightbutton then begin
              { Setze heien Fleck }
              NewCursor.x:=x-1;
              NewCursor.y:=y-1;
            end;
            BitInvert(NewCursor.mask[0,y-1],x-1);
            i:=0;
            if BitTest(NewCursor.mask[0,y-1],x-1) then i:=i+1;
            if BitTest(NewCursor.mask[1,y-1],x-1) then i:=i+2;
            Case i of
              0: SetFillStyle(EmptyFill,GetMaxColor);
              1: SetFillStyle(CloseDotFill,GetMaxColor);
              2: SetFillStyle(SolidFill,GetMaxColor);
              3: SetFillStyle(XHatchFill,GetMaxColor);
            end;
            HideMouse;
            bar(x*15+1,y*15+1,(x+1)*15-1,(y+1)*15-1);
            ShowMouse;
          end;
        end;
      end;
    end;
    Flag[20]:=buttonpressinfo(RightB,Count,x,y);
    ShowMouse;
    if Count > 0 then begin
      for x:=1 to 16 do begin
        for y:=1 to 16 do begin
          if MouseInBox(x*15,y*15,(x+1)*15,(y+1)*15) then begin
            { Modifiziere Zeigermaske }
            setgraphicscursor(StandardCursor);
            if leftbutton and rightbutton then begin
              { Setze heien Fleck }
              NewCursor.x:=x-1;
              NewCursor.y:=y-1;
            end;
            BitInvert(NewCursor.mask[1,y-1],x-1);
            i:=0;
            if BitTest(NewCursor.mask[0,y-1],x-1) then i:=i+1;
            if BitTest(NewCursor.mask[1,y-1],x-1) then i:=i+2;
            Case i of
              0: SetFillStyle(EmptyFill,GetMaxColor);
              1: SetFillStyle(CloseDotFill,GetMaxColor);
              2: SetFillStyle(SolidFill,GetMaxColor);
              3: SetFillStyle(XHatchFill,GetMaxColor);
            end;
            HideMouse;
            bar(x*15+1,y*15+1,(x+1)*15-1,(y+1)*15-1);
            ShowMouse;
          end;
        end;
      end;
    end;
    if flag[1] then begin
      flag[1]:=false;
      cleardevice;
      InitScreen;
    end;
  until flag[3];                     { Exit:Exit }

  CloseGraph;
  { Neue Mauszeiger-Definition in Datei schreiben }
  write('Eingabe Cursorname : ');
  readln(s);
  assign(f,s+'.inc');
  rewrite(f);
  write(f,s,'Cursor : Maskrecord = (mask:((');
  for x:=0 to 14 do begin
    if (x and 7) = 0 then writeln(f);
    write(f,'$',hexval(NewCursor.mask[0,x]),',');
  end;
  write(f,'$',hexval(NewCursor.mask[0,15]),'),(');
  for x:=0 to 14 do begin
    if (x and 7) = 0 then writeln(f);
    write(f,'$',hexval(NewCursor.mask[1,x]),',');
  end;
  writeln(f,'$',hexval(NewCursor.mask[1,15]),'));x:',
  NewCursor.x:2,';y:',NewCursor.y:2,');');
  close(f);
end.
