; PARTSEC.ASM: der neue Partitionssektor

vectors segment at 0000h
vectors ends

code    segment
        assume  cs:code,ds:nothing,es:nothing

;Partitionslader verschiebt sich von 7C00h nach 600h
start proc far
        cli
        mov     ax,0
        mov     ss,ax
        mov     sp,7C00h          ;Eigener Stackpointer
        sti
        mov     ds,ax
        mov     es,ax             ;DS=CS=ES=SS=0
        assume  ds:vectors,es:vectors
        mov     cx,200h           ; 512 Bytes von
        mov     si,7C00h          ; 7C00h nach
        mov     di,0600h          ; 600h verschieben
        cld
        rep     movsb
        push    ax                ; Kopie am Label "weiter"
        mov     ax,offset weiter+600h  ; starten
        push    ax
        ret
start endp


weiter proc far
        mov     si,offset part_sav+600h
        mov     di,offset part_buf+600h
        mov     cx,40h            ;Partitionsdaten bertragen
        repz    movsb
        ;DOS-Partition suchen und ermitteln, ob sie aktiv ist
        mov     si,offset part_buf-0Fh+600h
        mov     cx,4              ;max. 4 Durchlufe
        mov     di,0
        mov     dx,offset fehler_tab+600h

loop1:  add     si,0Fh            ;eine Tabelle weiter
        sub     byte ptr [si+4],73h ;entschlsseln
        cmp     byte ptr [si+4],1h ;Sytembyte 1
        jz      dos_sm
        cmp     byte ptr [si+4],4h ;Systembyte 4
dos_sm: lodsb
        cmp     al,80h            ;Partition aktiv?
        jz      aktiv_found
        cmp     al,00h
        jnz     error
        loop    loop1
        jmp     short ende

aktiv_found:
        or      di,di     ;Partition gefunden?
        jnz     error
        mov     di,si     ;Aktuellen Tabelleneintrag sichern
        dec     di        ;Fehlermeldung bei einer weiteren
        loop    loop1     ;aktiven Partionen.

ende:   or      di,di
        jz      error
        mov     bp,di
        mov     ax,0301h  ;Sektor zurckschreiben,
        mov     bx,0600h  ;damit DOS nicht
        mov     cx,0001h  ;durcheinanderkommt
        mov     dx,0080h
        int     13h
        mov     dx,offset update_err+600h
        jb      error
        mov     ax,0201h
        mov     bx,0      ;DOS-Boot-Sektor lesen
        push    bx
        mov     bx,7c00h
        push    bx
        mov     dx,[bp]
        mov     cx,[bp+2]
        push    dx
        int     13h
        mov     dx,offset load_err+600h
        jb      error
        pop     dx
        mov     si,bp
        ret              ;Boot-Programm starten

error:  mov     si,dx
        mov     bh,0
loop2:  lodsb
        cmp     al,0
        jz      out_end
        mov     ah,0eh    ;Textausgabe ber TTY-Funktion
        int     10h
        jmp     short loop2
out_end:jmp     short out_end

weiter endp

fehler_tab  db 0dh,0ah,'Partitionstabelle fehlerhaft',0
update_err  db 0dh,0ah,'System-Parameter nicht schreibbar',0
load_err    db 0dh,0ah,'Fehler beim Laden des Boot-Sektors',0

.radix 16
                org     17e

part_sav        db    080, 001, 001, 000, 077, 003, 05A, 08F
                db    01A, 000, 000, 000, 066, 0A2, 000, 000
                db    000, 000, 041, 090, 078, 003, 09A, 064
                db    080, 0A2, 000, 000, 088, 056, 000, 000
                db    000, 000, 000, 000, 073, 000, 000, 000
                db    000, 000, 000, 000, 000, 000, 000, 000
                db    000, 000, 000, 000, 073, 000, 000, 000
                db    000, 000, 000, 000, 000, 000, 000, 000

                org     1be
                ; Hierhin wird die neue Tabelle bertragen
part_buf        db      4*10 dup (0)

                org     1fe
                db      055,0AA

code    ends
end
