{*********************************************************}
{*      R E A D P A R T - Partitionsektoren lesen
                 Ralf Preller /// c't
          Mit Turbo-Pascal 4.0 zu kompilieren

 Anmerkung zum DMA-Problem:

 Der DMA-Controller im XT/AT benutzt nur 16-Bit-Adressen,
 daher kann er keine Sektoren in RAM-Puffer laden, die
 durch eine physikalische 64-K-Speichergrenze verlaufen. Der
 hier benutzte "Buffer1" kann je nachdem, wohin DOS dieses
 Programm ldt, davon betroffen sein. READPART weicht dann
 auf "Buffer2" aus.                                      *}
{*********************************************************}
PROGRAM ReadPartitionSectors;        { READPART }

USES dos;

CONST
   Drive         = $80;   { $80 = 1.Festplatte, $81 = 2. }
   FilenameSt    = 'PARTSEKT.BIN';

TYPE
   tPhysicalPos  = record
                      Head      : byte;
                      case integer of
                         1 : (Sector, Cylinder : byte);
                         2 : (SectorCylinder   : word);
                      end;
   tPartSector   = record
                      Bootcode  : array[0..$1BD] of byte;
                      PartTable : array[1..4] of record
                             BootInd   : byte;
                             PhysStart : tPhysicalPos;
                             SysInd    : byte;
                             PhysEnd   : tPhysicalPos;
                             RelStart  : array[0..3] of byte;
                             NrSectors : array[0..3] of byte;
                      end;
                      Signature : word;
                   end;

VAR
   Buffer1, Buffer2             : tPartSector;
   BufferPtr                    : ^tPartSector;
   EXTDOSfound                  : boolean;
   NrPartSectors, ErrorNr       : integer;
   I                            : word;
   Outfile                      : file;
   Regs                         : Registers;

BEGIN
   BufferPtr := addr(Buffer1);
   I := Dseg shl 4 + ofs(Buffer1);
                               { 64K-Speichergrenze ? }
   if (I<0) and ((I + sizeof(Buffer1)) >= 0) then
      BufferPtr := addr(Buffer2); { ausweichen auf Buffer2 }
   writeln ('XT/AT-Partitionssektor-Leser fr ',
            'Festplatten-Laufwerk ',Drive-$80);
   writeln;
   assign (Outfile, FilenameSt);
   rewrite (Outfile);
   NrPartSectors := 0;
   Regs.CX := 1;
   Regs.DH := 0;     { Zylinder, Sektor, Kopf }
   repeat

      {**** Partitionssektor lesen ****}
      Regs.ES := seg(BufferPtr^);
      Regs.BX := ofs(BufferPtr^);
      Regs.AX := $0201;
      Regs.DL := Drive;
      Intr($13,Regs);
      ErrorNr := 0;
      if (Regs.Flags and 1) <> 0 then
         begin
         ErrorNr := Regs.AH;
         writeln ('Festplatten-Lesefehler ',ErrorNr);
         end;
      if BufferPtr^.Signature <> $AA55 then
         begin
         ErrorNr := 1;
         writeln ('Partitions-Signatur fehlerhaft!');
         end;
      if ErrorNr = 0 then
         begin
         blockwrite (Outfile, BufferPtr^, 4);
         EXTDOSfound := false;
         if BufferPtr^.Signature = $AA55 then
            begin
            NrPartSectors := succ(NrPartSectors);

            {**** Nach EXT DOS-Partition suchen ****}
            For I := 4 downto 1 do
               begin
               with BufferPtr^.PartTable[I] do
                  if SysInd = 5 then
                     begin
                     EXTDOSfound := true;
                     with PhysStart do
                        begin { nchster Partitionssektor }
                        Regs.DH := Head;
                        Regs.CX := SectorCylinder;
                        end;
                     end;
               end;
            end;
         end;
   until (ErrorNr <> 0) or not EXTDOSfound;
   close (Outfile);
   if ErrorNr = 0 then
      writeln (NrPartSectors,' Partitionssektor(en) gefunden ',
               'und in Datei ',FilenameSt, ' gespeichert')
   else
      begin
      writeln ('Fehler: Partitionssektor wurde nicht bertragen.');
      erase (outfile);
      end;
END.
