#define STRICT
#include "wclsinc.h"

class Editor : public ToplevelWindow {
protected:
  EditControl *pEdit;

  virtual BOOL QueryClose();

public:
  DECL_HANDLER(WM_SIZE);
  DECL_HANDLER(WM_ACTIVATE);

  Editor( WindowClass *pClass);
};





class EditorClass : public WindowClass {
public:
  EditorClass():WindowClass("MySpecialWindowClass",hInstance)
  {
    MAP_HANDLER(Editor,WM_SIZE);
    MAP_HANDLER(Editor,WM_ACTIVATE);
  }
};


Editor::Editor( WindowClass *pClass):
                ToplevelWindow("Simple Editor",pClass)
{
RECT rc;

  GetClientRect(&rc);
  pEdit=new EditControl("",WS_CHILD|WS_VISIBLE|WS_HSCROLL|
			   WS_VSCROLL|ES_MULTILINE,
                        0,0,rc.right,rc.bottom,
			WinHandle,1);
}


DEF_HANDLER(Editor,WM_SIZE)
{
  pEdit->Move(0,0,LOWORD(lParam),HIWORD(lParam),TRUE);
  return 0L;
}



DEF_HANDLER(Editor,WM_ACTIVATE)
{
  if (wParam && !HIWORD(lParam))
    pEdit->SetFocus();

  return 0L;
}



BOOL Editor::QueryClose()
{
  return MessageBox(WinHandle,
		    "Wollen sie dieses Programm wirklich verlassen?",
		    "Simple Editor 1",
                    MB_YESNO|MB_ICONQUESTION)==IDYES;
}

int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hPrevInst,
		   LPSTR lpCmdLine, int nCmdShow)
{
Editor		*pWindow;
EditorClass	*pClass;  // ps: lokal statt global
MSG msg;

   hInstance=hInst; // Wichtig damit WClasses funktioniert.
   hPrevInstance=hPrevInst; // dito.

   pClass=new EditorClass();
   pWindow=new Editor( pClass);
   pWindow->Show(nCmdShow);

   while (GetMessage(&msg,0,0,0)) {
     TranslateMessage(&msg);
     DispatchMessage(&msg);
   }
   return msg.wParam;
}