/* Abstrakte Basisklassen fuer WCLASSES
   Thomas Hornschuh, c't 10/93
*/

class MSGHashTable; // forward

class MessageMap {
protected:
   MSGHashTable *pTable;
public:
   MessageMap();
   ~MessageMap();

   inline MSGHashTable *GetTable() { return pTable; }
   void Message(UINT Message,PMSGHandler pHandler);
};    

class AbstractWindow; // forward

class MetaClass {
protected:
  MessageMap * pMap;
  virtual MessageMap *CreateOwnMessageMap();

public:
  MetaClass();
  ~MetaClass();

  virtual MessageMap *GetMap();
  inline MSGHashTable *GetHashTable() 
    { return GetMap()->GetTable(); }
  void Message(UINT Message,PMSGHandler pHandler);
  virtual void DeleteInstance(AbstractWindow *pWindow);
};

class AbstractWindow {
protected:
  HWND WinHandle;
  MSGHashTable * pMSGHashTable;
  MetaClass * pMetaClass;

public:

  virtual LRESULT 
    CallDefProc(UINT msg,WPARAM wParam, LPARAM lParam)=0;
  virtual LRESULT 
    HandleMessage(UINT message ,WPARAM wParam,LPARAM lParam);

  AbstractWindow() { }
  AbstractWindow(MetaClass *pMeta,HWND hWnd);

  MetaClass* gMetaClass() { return pMetaClass; }

  inline HWND GetHandle() { return WinHandle; }
  inline HWND SetFocus() { return ::SetFocus(WinHandle); }

  virtual ~AbstractWindow();

  inline void SetText(LPSTR lpStr) {
     SendMessage(WinHandle,WM_SETTEXT,0,(LONG)lpStr);
  }

  inline WORD GetText(LPSTR buff,WORD maxlen) {
    return (WORD)SendMessage(WinHandle,WM_GETTEXT,maxlen,LONG(buff));
  }

  inline HDC GetDC() { return ::GetDC(WinHandle); }
  inline void ReleaseDC(HDC hDC) {  ::ReleaseDC(WinHandle,hDC); }

  inline void Update() { UpdateWindow(WinHandle); }
  inline void Invalidate(LPRECT rc) 
    { InvalidateRect(WinHandle,rc,TRUE); }

  inline void GetClientRect(LPRECT rc)
    { ::GetClientRect(WinHandle,rc); }

  inline void Move(int x,int y,int w,int h,BOOL repaint)
    { MoveWindow(WinHandle,x,y,w,h,repaint); }

  inline void ClassMapChanged()
  {
    pMSGHashTable= pMetaClass->GetHashTable();
  }

  inline void SetMetaClass(MetaClass *pMeta)
  {
    pMetaClass=pMeta;
    pMSGHashTable= pMetaClass->GetHashTable();
  }

  static LRESULT AbstractWndProc(HWND hWnd,
                                 AbstractWindow *w,UINT uMsg,
                                 WPARAM wParam,LPARAM lParam);
};