/* WCLASSES Kontrollelemente-Klassen
   Thomas Hornschuh, Stephan Schwab, Norbert Unterberg, c't 10/93 */

#define STRICT

#include "wclsinc.h"
#include "msghash.h"

void ControlMetaClass::DeleteInstance(AbstractWindow *pWnd)
{
  pWnd->CallDefProc(WM_NCDESTROY,0,0L); // Wichtig !!
  delete pWnd;
}

ControlMetaClass TheMetaClass;

/* Implementation der Basisklasse "Control" */

/* Speichert den this-Zeiger des Objekts als Fenster-Property. */
void Control::SetThis()
{
   #if defined (__LARGE__) || defined(__DLL__)
      SetProp( WinHandle, "_l", HANDLE(LOWORD( this)));
      SetProp( WinHandle, "_h", HANDLE(HIWORD( this)));
   #else
      SetProp( WinHandle, "_p", HANDLE(this)); 
   #endif
}

/* Ermittelt this-Zeiger des Fensters hWnd. */
Control *Control::GetThis( HWND hWnd)
{    
   #if defined(__LARGE__) || defined(_DLL_)
      return ( Control*)(
         MAKELONG( GetProp( hWnd, "_l"), GetProp( hWnd, "_h")));
   #else
      return ( Control*)GetProp( hWnd, "_p");
   #endif
}

/* CallDefProc wird  von Window::HandleMessage fuer jede nicht
   behandelte Nachricht aufgerufen. Control berldt diese
   Methode: Anstatt der DefWindowProc wird die Original
   Fenster-Prozedur des Controls aktiviert */
long Control::CallDefProc( UINT msg, WPARAM wParam, LPARAM lParam)
{
   return CallWindowProc( DefProc, WinHandle, msg, wParam, lParam);
}

/* bernimmt Initialisierung, bereitet Subclassing vor */
void Control::Init( DlgBox *pD, HWND hWnd, BOOL fSubClass)
{
   pDlg= pD;
   WinHandle= hWnd ;
   SetThis();
   if ( fSubClass) {
      DefProc= (WNDPROC)SetWindowLong( 
                  WinHandle, GWL_WNDPROC, (LONG)ControlWndProc);
   } 
   else
      DefProc= NULL;
}

/* Erzeugt ein Controlfenster der Klasse <lpClassName>. Wenn fr
   <SubClassFlag> TRUE uebergeben wird, setzt der Konstruktor
   die ControlWndProc von WCLASSES als neue Fensterprozedur
   fuer das Kontrollelement. Die Adresse der Originalprozedur wird
   gespeichert, um sie in CallDefProc verwenden zu koennen.
*/
Control::Control( LPSTR lpClassName, LPSTR lpWindowName, DWORD dwStyle,
              int X, int Y, int nWidth, int nHeight, HWND hWndParent, 
              WORD id, BOOL fSubClass, HINSTANCE hInst):
              AbstractWindow(&TheMetaClass,NULL)
{
   HWND  hWnd;

   hWnd= CreateWindow( lpClassName, lpWindowName, dwStyle | WS_CHILD,
                  X, Y, nWidth, nHeight, hWndParent,(HMENU)id, 
                  hInst? hInst: hInstance,(void FAR *)this);
   if ( hWnd)           
      Init(NULL, hWnd, fSubClass);
}

/* Erzeugt ein Objekt der Klasse Control zu einem bereits existierenden
   Fenster (welches z.B. durch einen Aufruf von CreateDialog erzeugt wurde).
   Es werden Parentfenster und Control-ID angegeben. */

Control::Control( HWND hParent, WORD wCtrlID, BOOL fSubClass):
         AbstractWindow(&TheMetaClass,NULL)

{
   Init( NULL, GetDlgItem( hParent, wCtrlID), fSubClass);
}


#ifdef _WDLG_H_
/* Wie der vorherige Konstruktor, nur fuer DlgBox-Objekte */
Control::Control(WORD wCtrlID, DlgBox *pD, BOOL fSubClass):
         AbstractWindow(&TheMetaClass,NULL)

{
   Init( pD, GetDlgItem( pD-> GetHandle(), wCtrlID), fSubClass);
   Init( pD, GetDlgItem( pD-> GetHandle(), wCtrlID), fSubClass);
}
#endif

/* Destruktor */
Control::~Control()
{
   if ( DefProc) 
      SetWindowLong( WinHandle, GWL_WNDPROC,LONG( DefProc));  

#if defined (__LARGE__) || defined(_DLL_)
   RemoveProp( WinHandle, "_l");
   RemoveProp( WinHandle, "_h");
#else
   RemoveProp( WinHandle, "_p");
#endif
}    


long FAR PASCAL _export ControlWndProc( HWND hWnd, UINT message,
                              WPARAM wParam, LPARAM lParam)
{
   Control  *w;

   w= Control::GetThis( hWnd);

   return AbstractWindow::AbstractWndProc(hWnd,w,message,wParam,lParam);

}
  
/* Implementation der Kontrollelemenklasse "Button" */

Button::Button( LPSTR lpText, DWORD dwStyle,
          int x, int y, int w, int h, HWND hWndParent,
          WORD id, BOOL SubClass, HINSTANCE hInst):
          Control( "Button", lpText, dwStyle, x, y, w, h,
             hWndParent, id, SubClass, hInst)
{
}

#ifdef _WDLG_H_
Button::Button( WORD idControl, DlgBox *pD, BOOL subClass):
      Control( idControl, pD, subClass)
{
}
#endif


Button::Button( HWND hParent, WORD wCtrlID, BOOL subClass):
              Control(hParent,wCtrlID,subClass) 
{
}  



void Button::Command( UINT idItem, HWND hWndControl, WORD wNotification)
{
   switch ( wNotification)
   {
      case BN_CLICKED:
         Clicked();
         break;
      case BN_DOUBLECLICKED:
         DoubleClicked();
         break;
   }
}

/* Implementation der Kontrollelemenklasse "EditControl" */

EditControl::EditControl( LPSTR lpText, DWORD dwStyle, 
                    int x, int y, int w, int h, HWND hWndParent,
                    WORD id, BOOL SubClass, HINSTANCE hInst):
          Control( "Edit", lpText, dwStyle, x, y, w, h,
                 hWndParent, id, SubClass, hInst)
{
}

EditControl::EditControl( HWND hParent, WORD wCtrlID, BOOL Subclass):
          Control( hParent, wCtrlID, Subclass)
{
}

#ifdef _WDLG_H_
EditControl::EditControl( int idControl, DlgBox *pD, BOOL subClass):
          Control( idControl, pD, subClass)
{
}
#endif

void EditControl::GetSel( int &nStart, int &nEnd)
{
   LONG  l;

   l= Send( EM_GETSEL, 0, 0L);
   nStart= LOWORD( l);
   nEnd = HIWORD( l); 
}

void EditControl::Command( UINT idItem, HWND hWndControl, WORD wNotification)
{
   switch ( wNotification)
   {
      case EN_CHANGE:
         Changed();
         break;
      case EN_ERRSPACE:
         ErrSpace();
         break;
      case EN_HSCROLL:
         HScrolled();
         break;
      case EN_KILLFOCUS:
         KillFocus();
         break ;
      case EN_MAXTEXT:
         MaxText();
         break;
      case EN_SETFOCUS:
         GotFocus();
         break;
      case EN_UPDATE:
         Updated();
         break;
      case EN_VSCROLL:
         VScrolled();
         break;
   }
}

/* Implementation der Kontrollelemenklasse "ScrollBar" */

ScrollBar::ScrollBar( DWORD dwStyle, int x, int y, int w, int h,
                      HWND hWndParent, WORD id, BOOL SubClass,
                      HINSTANCE hInst):
            Control( "ScrollBar", NULL, dwStyle, x, y, w, h,
                     hWndParent, id, SubClass, hInst)
{
  wScrollType= SB_CTL;
}

ScrollBar::ScrollBar( HWND hParent, WORD wCtrlID, BOOL Subclass):
                      Control( hParent, wCtrlID, Subclass)
{
  wScrollType= SB_CTL;
}

ScrollBar::ScrollBar( HWND hWndClient, BOOL Vertical)
{
   pDlg= NULL;
   WinHandle= hWndClient;
   if ( Vertical)
      wScrollType= SB_VERT;
   else
      wScrollType= SB_HORZ;
}

BOOL ScrollBar::Show( int nShow)
{
   ShowScrollBar( WinHandle, wScrollType, nShow);
   return TRUE;
}

/* Implementation der Kontrollelemenklasse "ListBox" */


ListBox::ListBox( LPSTR lpText, DWORD dwStyle,
                  int x, int y, int w, int h, HWND hWndParent,
                  WORD id, BOOL SubClass, HINSTANCE hInst):
         Control("ListBox", lpText, dwStyle, x, y, w, h,
                  hWndParent, id, SubClass, hInst)
{
}

ListBox::ListBox( HWND hParent, WORD wCtrlID, BOOL Subclass):
       Control( hParent, wCtrlID, Subclass)
{
}


#ifdef _WDLG_H
ListBox::ListBox( int idControl, DlgBox *pD, BOOL subClass):
       Control( idControl, pD, subClass)
{
}
#endif


void ListBox::Command( UINT idItem, HWND hWndControl, WORD wNotification)
{
   switch ( wNotification)
   {
      case LBN_DBLCLK:
         DoubleClicked();
         break;
      case (WORD)LBN_ERRSPACE:   // *** Strict :)
         ErrSpace();
         break;
      case LBN_KILLFOCUS:
         KillFocus();
         break;
      case LBN_SELCANCEL:
         SelCancel();
         break;
      case LBN_SELCHANGE:
         SelChange();
                        break;
      case LBN_SETFOCUS:
         GotFocus();
         break;
   }
}

/* Implementation der Kontrollelemenklasse "ComboBox" */

ComboBox::ComboBox( LPSTR lpText, DWORD dwStyle,
                    int x, int y, int w, int h, HWND hWndParent,
                    WORD id, BOOL SubClass, HINSTANCE hInst):
          Control( "ComboBox", lpText, dwStyle, x, y, w, h,
                 hWndParent, id, SubClass, hInst)
{
}

ComboBox::ComboBox( HWND hParent, WORD wCtrlID, BOOL Subclass):
          Control( hParent, wCtrlID, Subclass)
{
}


#ifdef _WDLG_H_
ComboBox::ComboBox( int idControl, DlgBox *pD, BOOL subClass):
        Control( idControl, pD, subClass)
{
}
#endif

void ComboBox::Command( UINT idItem, HWND hWndControl, WORD wNotification)
{
   switch ( wNotification)
   {
      case CBN_CLOSEUP:
         CloseUp();
         break ;
      case CBN_DBLCLK:
         DoubleClicked();
         break;
      case CBN_DROPDOWN:
         DropDown();
         break;
      case CBN_EDITCHANGE:
         EditChange();
         break;
      case CBN_EDITUPDATE:
         EditUpdate();
         break;
      case (WORD)CBN_ERRSPACE:   // *** Strict :)
         ErrSpace();
         break;
      case CBN_KILLFOCUS:
         KillFocus();
         break;
      case CBN_SELCHANGE:
         SelChange();
         break;
      case CBN_SELENDCANCEL:
         SelEndCancel();
         break;
      case CBN_SELENDOK:
         SelEndOk();
         break;
      case CBN_SETFOCUS:
         GotFocus();
         break;
   }
}
