/* WCTRL.H -- WCLASSES-Kontrollelemente-Klassen
   Stephan Schwab, Thomas Hornschuh, c't 10/93 */

#ifndef WCTRL_H
#define WCTRL_H

#ifndef _WDLG_H_ // fr z.Zt. fehlende Dialog-Klasse
typedef  UINT  DlgBox;
#endif

class ControlMetaClass : public MetaClass {
public:
  virtual void DeleteInstance(AbstractWindow *pWnd);
};


class Control : public AbstractWindow {
private:
   void Init( DlgBox *pD, HWND hWnd, BOOL fSubClass);
protected:
   DlgBox   *pDlg ;
   WNDPROC  DefProc;

   void SetThis();

   Control( LPSTR, LPSTR, DWORD, int, int, int, int, HWND, WORD, BOOL= FALSE, HINSTPARAM);
   Control( HWND hParent, WORD wCtrlID, BOOL subClass= FALSE);
#ifdef _WDLG_H_
   Control( WORD wCtrlID, DlgBox *pD, BOOL subClass= FALSE);
#endif
   inline Control() { DefProc=NULL; }

   virtual void Command( UINT idItem, HWND hWndControl, WORD wNotification)=0;


public:
   ~Control();
   static Control * GetThis( HWND);

   inline LRESULT Send( UINT uMsg, WPARAM wParam, LPARAM lParam)
      { return SendMessage( WinHandle, uMsg, wParam, lParam); }


   virtual LRESULT CallDefProc( UINT, WPARAM, LPARAM);


   // Notification methods
   virtual void KillFocus() {;}
   virtual void SelChange() {;}
   virtual void GotFocus() {;}
   virtual void ErrSpace() {;}
   virtual void DoubleClicked() {;}


   /* friends */
friend long FAR PASCAL _export
   ControlWndProc( HWND, UINT, WPARAM, LPARAM);
#ifdef _WDLG_H_
friend class DlgBox;
#endif
};

class Button : public Control {
 protected:
    virtual void Command( UINT idItem, HWND hWndControl, WORD wNotification);
 public:
    Button( LPSTR, DWORD, int, int, int, int,
            HWND, WORD,BOOL= FALSE, HINSTPARAM) ;

    Button( HWND hParent, WORD wCtrlID, BOOL subClass= FALSE);
#ifdef _WDLG_H_
      Button( WORD wCtrlID, DlgBox *pD, BOOL subClass= FALSE);
#endif



    inline BOOL IsChecked()
       { return Send( BM_GETCHECK, 0, 0L) == 1 ; }
    inline void Check( BOOL f)
       { Send( BM_SETCHECK, f? 1: 0, 0L) ; }

    // Notification methods
    virtual void Clicked() {;}
};


class EditControl : public Control {
protected:
   virtual void Command( UINT idItem, HWND hWndControl, WORD wNotification);
public:
   EditControl( LPSTR, DWORD, int, int, int, int, HWND, WORD,BOOL= FALSE, HINSTPARAM) ;
   EditControl( HWND hParent, WORD wCtrtlID, BOOL subClass= FALSE) ;
#ifdef _WDLG_H_
   EditControl( int idControl, DlgBox *pDlg, BOOL subClass= FALSE) ;
#endif
   inline UINT GetInt( BOOL FAR* lpTranslated, BOOL fSigned= FALSE)
      { return ::GetDlgItemInt( GetParent( WinHandle),
              GetWindowWord( WinHandle, GWW_ID),
              lpTranslated, fSigned) ; }
   inline WORD GetText( LPSTR lpszBuff, WORD cbMax)
      { return (WORD)Send( WM_GETTEXT, cbMax, (LPARAM)lpszBuff) ; }
   inline void SetInt(UINT uValue, BOOL fSigned=FALSE)
      { ::SetDlgItemInt( GetParent( WinHandle),
                     GetWindowWord( WinHandle, GWW_ID),
                     uValue, fSigned) ; }
   void SetText( LPCSTR lpszBuff)
      { Send( WM_SETTEXT, 0, (LONG)lpszBuff) ; }
   void GetSel( int &nStart, int &nEnd);
   inline BOOL SetSel( BOOL fScroll, int nStart, int nEnd)
      { return (BOOL)Send( EM_SETSEL, (WPARAM)fScroll,
                      MAKELPARAM( nStart, nEnd)) ; }
   inline void ReplaceSel( LPSTR lpszReplace)
      { Send( EM_REPLACESEL, 0, (LPARAM)lpszReplace) ; }

   /* Notifcation Methods */
   virtual void Changed() {}
   virtual void HScrolled() {}
   virtual void VScrolled() {}
   virtual void MaxText() {}
   virtual void Updated() {}
} ;

class ScrollBar : public Control {
protected:
   WORD  wScrollType;
public:
   ScrollBar( DWORD, int, int, int, int, HWND, WORD, BOOL= FALSE, HINSTPARAM);
   ScrollBar(HWND hParent, WORD wCtrlID, BOOL subClass= FALSE);
   ScrollBar(HWND hWndClient, BOOL  Vertical);
   inline void SetRange( int nMin, int nMax, BOOL fRedraw)
      { SetScrollRange( WinHandle, wScrollType, nMin, nMax, fRedraw); }
   inline int SetPos( int nPos, BOOL fRedraw)
      { return SetScrollPos( WinHandle, wScrollType, nPos, fRedraw); }
   inline int GetPos()
      { return GetScrollPos( WinHandle, wScrollType); }
   void GetRange( int &MinPos, int &MaxPos)
      { GetScrollRange( WinHandle, wScrollType, &MinPos, &MaxPos); }
   virtual BOOL Show( int nShow);



};

class ListBox : public Control {
protected:
   virtual void Command( UINT idItem, HWND hWndControl, WORD wNotification);
public:
   ListBox( LPSTR, DWORD, int, int, int, int, HWND, WORD,BOOL= FALSE, HINSTPARAM) ;
   ListBox( HWND hParent, WORD wCtrtlID, BOOL subClass= FALSE) ;
#ifdef _WDLG_H_
    ListBox( int idControl, DlgBox *pDlg, BOOL subClass= FALSE) ;
#endif

   inline int AddString( LPSTR lpsz)
   { return (int)Send( LB_ADDSTRING, 0, (LPARAM)lpsz) ; }
   inline int DeleteString( int nSel)
      { return (int)Send( LB_DELETESTRING, nSel, 0L) ; }
   inline int InsertString( int nSel, LPSTR lpsz)
      { return (int)Send( LB_INSERTSTRING, WPARAM(nSel), LPARAM(lpsz)); }
   inline int GetCount()
      { return (int)Send( LB_GETCOUNT, 0, 0L) ; }
   inline void ResetContent()
      { Send( LB_RESETCONTENT, 0, 0L) ; }
   inline int SetCurSel( int nSel)
      { return (int)Send( LB_SETCURSEL, nSel, 0L) ; }
   inline int GetCurSel()
      { return (int)Send( LB_GETCURSEL, 0, 0L) ; }
   inline int GetLBText( int nSel, LPSTR lpsz)
      { return (int)Send( LB_GETTEXT, nSel, (LONG)lpsz) ; }
   inline int GetSelText( LPSTR lpsz)
      { return (int)Send( LB_GETTEXT,
                     (WPARAM)Send( LB_GETCURSEL, 0, 0L),
                     (LONG)lpsz) ; }
   inline BOOL SetData( int nSel, DWORD dwData)
      { return Send( LB_SETITEMDATA, nSel, (LONG)dwData) != LB_ERR ; }
   inline DWORD GetData( int nSel)
      { return Send( LB_GETITEMDATA, nSel, 0L) ; }
   inline int GetSelItems( int Buffer[], int nMaxItems)
      { return (int)Send(LB_GETSELITEMS,WPARAM(nMaxItems),LPARAM(Buffer)); }
   inline int GetSelCount()
      { return (int)Send(LB_GETSELCOUNT,0,0L); }

   // Notification handlers
   virtual void SelCancel() {;}
};

class ComboBox : public Control {
protected:
   virtual void Command( UINT idItem, HWND hWndControl, WORD wNotification);
public:
   ComboBox( LPSTR, DWORD, int, int, int, int, HWND, WORD,BOOL= FALSE, HINSTPARAM) ;
   ComboBox( HWND hParent, WORD wCtrtlID, BOOL subClass= FALSE) ;
#ifdef _WDLG_H_
   ComboBox( int idControl, DlgBox *pDlg, BOOL subClass= FALSE) ;
#endif
   inline int AddString( LPSTR lpsz)
      { return (int)Send( CB_ADDSTRING, 0, (LPARAM)lpsz); }
   inline int SetCurSel( int nSel)
      { return (int)Send( CB_SETCURSEL, nSel, 0L) ; }
   inline int GetCurSel()
      { return (int)Send( CB_GETCURSEL, 0, 0L) ; }
   inline int GetLBText( int nSel, LPSTR lpsz)
      { return (int)Send( CB_GETLBTEXT, nSel, (LPARAM)lpsz) ; }
   inline int GetSelText( LPSTR lpsz)
      { return (int)Send( CB_GETLBTEXT, (WPARAM)Send( CB_GETCURSEL, 0, 0L),
            (LPARAM)lpsz) ; }
   inline BOOL SetData( int nSel, DWORD dwData)
      { return Send( CB_SETITEMDATA, nSel, (LONG)dwData) != LB_ERR ; }
   inline DWORD GetData( int nSel)
      { return Send( CB_GETITEMDATA, nSel, 0L) ; }
   // Notification handlers
   virtual void CloseUp() {;}
   virtual void DropDown() {;}
   virtual void EditChange() {;}
   virtual void EditUpdate() {;}
   virtual void SelEndCancel() {;}
   virtual void SelEndOk() {;}
};

#endif
