program Example3D;
(* Copyright 1994  Heiko Stuckenberg / c't *)
uses
  WinTypes, WinProcs, OWindows, CTL3D;

{$R Exampl3D.RES}

type
  PExampleWindow = ^TExampleWindow;
  TExampleWindow = object( T3DDlgWindow )
                     procedure WMInitDialog( var Msg : TMessage );
                       virtual wm_First + wm_InitDialog;
                   end;

  PExampleApplication = ^TExampleApplication;
  TExampleApplication = object( T3DApplication )
                          procedure InitMainWindow; virtual;
                        end;

procedure TExampleWindow.WMInitDialog( var Msg : TMessage );
var
  Title   : array[0..80] of char;
  AStruct : record
              majorversion : word;
              minorversion : word;
            end;
begin
  inherited WMInitDialog( Msg );
  AStruct.majorversion := HiByte( CTL3DGetVer );
  AStruct.minorversion := LoByte( CTL3DGetVer );
  wvsprintf( Title, 'CTL3D.DLL Version %d.%02d', AStruct );
  MessageBox ( 0, Title, 'Easy Rider', MB_OK or MB_IconExclamation);
end;

procedure TExampleApplication.InitMainWindow;
begin
  MainWindow := New( PExampleWindow, Init( nil, 'Dialog_1' ) );
end;

var
  ExampleApp : TExampleApplication;

begin
  ExampleApp.Init( '3D-Example' );
  ExampleApp.Run;
  ExampleApp.Done;
end.
