#include <windows.h>
#include <owl.h>
#include <math.h>
#include "bms.h"
#include <stdio.h>
#include <commdlg.h>


// Copyright (C) 1994, Manfred Rieg, Johannes A. Wohlrab


TVerkleinernDialog::TVerkleinernDialog (PTWindowsObject AParant,LPSTR name):
                                                      TDialog(AParant, name)
{
  SetCaption("Verkleinern");
  breite=new TEdit(this, 200, sizeof(((TBitWindow *)Parent)->VerkleinernTransfer.Breite));
  breite->EnableTransfer();

  hoehe=new TEdit(this, 201, sizeof(((TBitWindow *)Parent)->VerkleinernTransfer.Hoehe));
  hoehe->EnableTransfer();


  TransferBuffer = (void far*)
			&(((TBitWindow *)Parent)->VerkleinernTransfer);

  char far *sbr=(char far*)
			&(((TBitWindow *)Parent)->VerkleinernTransfer.Breite);

  for (int i =0;i<5;i++) sBreite[i]=*sbr++;
  for (i =0;i<5;i++)     sHoehe[i] =*sbr++;
};


BOOL TVerkleinernDialog::CanClose()
{
  FillBuffers();
  if (ValidFaktor() ) return TRUE;
  else return FALSE;
};


void TVerkleinernDialog::FillBuffers()
{ char sZoom[5];
  GetDlgItemText(HWindow, 200,sZoom,5);
  bre=atoi(sZoom);
  GetDlgItemText(HWindow, 201,sZoom,5);
  hoe=atoi(sZoom);

};

BOOL TVerkleinernDialog::ValidFaktor()
{
  if((atoi(sBreite)<bre)||(atoi(sHoehe)<hoe))
  {
    MessageBeep(0);
    MessageBox(NULL,"Eingabe zu gro","Dialogbox",MB_OK);
    return(FALSE);
  }
  else return(TRUE);
};



void TVergroessernDialog::WMInitDialog(RTMessage)
{
  SetCaption("Vergrern");
  SetupWindow();
}

BOOL TVergroessernDialog::ValidFaktor()
{
  if((atoi(sBreite)>bre)||(atoi(sHoehe)>hoe))
  {
    MessageBeep(0);
    MessageBox(NULL,"Eingabe zu klein","Dialogbox",MB_OK);
    return(FALSE);
  }
  else return(TRUE);
};







TBitWindow::TBitWindow(PTWindowsObject AParent, LPSTR ATitle, LPSTR dateiname) :
						TWindow(AParent, ATitle)
{
  long Dateilaenge;

  HCURSOR OldCur = SetCursor(LoadCursor(0, IDC_WAIT));

  int DateiHandle = _lopen(dateiname,OF_READ);
  _lread(DateiHandle, &ff, sizeof(ff));

  gHandle = GlobalAlloc(GMEM_MOVEABLE, ff.bfSize);
  char huge *p = GlobalLock(gHandle);

  BITMAPCOREHEADER bch;

  DWORD typ;

  _lread(DateiHandle,&typ,sizeof(typ));
  _llseek(DateiHandle,sizeof(ff),0);

  if (typ==sizeof(BITMAPCOREHEADER))
  {
    _lread(DateiHandle,&bch,sizeof(bch));

    bih.biSize			=sizeof(BITMAPINFOHEADER);
    bih.biWidth			=bch.bcWidth;
    bih.biHeight		=bch.bcHeight;
    bih.biPlanes		=bch.bcPlanes;
    bih.biBitCount		=bch.bcBitCount;
    bih.biCompression		=0;
    bih.biSizeImage		=
                        (DWORD)((((DWORD)bih.biWidth*3l+3)>>2l<<2l)*(DWORD)bih.biHeight);
    bih.biXPelsPerMeter		=0;
    bih.biYPelsPerMeter		=0;
    bih.biClrUsed		=0;
    bih.biClrImportant		=0;

  }
  else
  {
    _lread(DateiHandle,&bih,sizeof(bih));
    if (bih.biSizeImage==0)
       bih.biSizeImage =(DWORD)((((DWORD)bih.biWidth*3l+3)>>2l<<2l)*(DWORD)bih.biHeight);


  }

  _llseek(DateiHandle,ff.bfOffBits,0);

  for (Dateilaenge = bih.biSizeImage/*ff.bfSize*/; Dateilaenge>0; Dateilaenge-=0xFFFF)
  {
    _lread(DateiHandle, p, 0xFFFF);
    p+=0xFFFF;
  }
  _lread(DateiHandle, p, Dateilaenge);

  _lclose(DateiHandle);

  GlobalUnlock(gHandle);

  SetCursor(OldCur);
}



TBitWindow::~TBitWindow()
{
  GlobalFree(gHandle);
}



void TBitWindow::WMQuit( TMessage& )
{
  TWindow::CloseWindow();
};




void TBitWindow::SetupWindow()
{
  TWindow::SetupWindow();
  SetWindowPos(HWindow,0,0,0,bih.biWidth+8,
     bih.biHeight+27,SWP_NOACTIVATE | SWP_NOMOVE | SWP_NOZORDER);
}




void TBitWindow::WMSize(TMessage& msg)
{
  TWindow::WMSize( msg);


  HDC HandleDC=GetDC(HWindow);
  BYTE huge* p=GlobalLock(gHandle);

  Bitmap = CreateDIBitmap(HandleDC,&bih,CBM_INIT,p,(LPBITMAPINFO)&bih,DIB_RGB_COLORS);

  HDC MemDC =CreateCompatibleDC(HandleDC);
  MemObject = SelectObject(MemDC, Bitmap);

  SelectObject(MemDC, MemObject);

  DeleteDC(MemDC);
  ReleaseDC(HWindow, HandleDC);
  GlobalUnlock(gHandle);

}


void TBitWindow::WMPaint (TMessage& msg)
{
  TWindow::WMPaint(msg);
}


void TBitWindow::Paint (HDC PaintDC, PAINTSTRUCT&)
{
  if(bih.biBitCount<24)
  {
    MessageBox(HWindow, "Kein True-Color-Bild","Fehler",MB_OK);
    CloseWindow();
  }else
  {
    HANDLE MemObject;
    HDC MemDC;

    MemDC=CreateCompatibleDC(PaintDC);
    MemObject=SelectObject(MemDC, Bitmap);

    BitBlt(PaintDC, 0, 0, bih.biWidth, bih.biHeight, MemDC, 0, 0, SRCCOPY);

    SelectObject(MemDC, MemObject);
    DeleteDC(MemDC);
  }
}




void TBitWindow::Dateispeichern( TMessage&)
{
  OPENFILENAME ofn;
  char szFile[256], szFileTitle[256];

  szFile[0] ='\0';
  
  memset(&ofn, 0, sizeof(OPENFILENAME));
  ofn.lStructSize = sizeof(OPENFILENAME);
  ofn.hwndOwner = HWindow;
  ofn.lpstrFilter = "Bitmap (*.BMP)\0*.bmp\0";
  // szFilter;
  ofn.nFilterIndex = 1;
  ofn.lpstrFile = szFile;
  ofn.nMaxFile = sizeof(szFile);
  ofn.lpstrFileTitle = szFileTitle;
  ofn.nMaxFileTitle = sizeof(szFileTitle);
  ofn.lpstrInitialDir = (LPSTR)
			&(((TBildVerarbeitung *)Parent)->szDirName);
  ofn.Flags =  OFN_PATHMUSTEXIST | OFN_OVERWRITEPROMPT;

  if (GetSaveFileName(&ofn))
  {
    unsigned char huge *q=GlobalLock(gHandle);

    OFSTRUCT of;
    int DateiHandle = OpenFile(ofn.lpstrFile,&of,OF_CREATE);

    _lwrite(DateiHandle, &ff, sizeof(ff));
    _lwrite(DateiHandle, &bih, sizeof(bih));

    MessageBeep(0);
    for (long Dateilaenge = bih.biSizeImage; Dateilaenge>0; Dateilaenge-=0xFFFF)
    {
      _lwrite(DateiHandle, q, 0xFFFF);
      q+=0xFFFF;
    }
    _lwrite(DateiHandle, q, Dateilaenge);
    _lclose(DateiHandle);
    SetCaption(ofn.lpstrFile);

    GlobalUnlock(gHandle);
  }
}




void TBitWindow::Verkleinern(TMessage&)                // ***** BILD SKALIEREN *****
{
  sprintf(VerkleinernTransfer.Breite,"%i",bih.biWidth);       //Breite und Hhe des Quell-
  sprintf(VerkleinernTransfer.Hoehe,"%i",bih.biHeight);       //   bildes als Startwerte
  if (GetModule()->ExecDialog(                                //   verwenden
	     new TVerkleinernDialog(this,"DIALOG_1"))== IDOK)
  {
    DWORD BiBr,BiHo;                                          //Breite und Hoehe Zielbild
    float erg_rot, erg_gruen,erg_blau;                        //Aufsummieren der Quellpixel
                                                              //   ohne Rundungsfehler fr
                                                              //   je 1 Zielpixel

    BiBr=atol(VerkleinernTransfer.Breite);                    //aktuelle Breite und Hhe 
    BiHo=atol(VerkleinernTransfer.Hoehe);                     //   des Zielbildes holen

    HCURSOR OldCur = SetCursor(LoadCursor(0, IDC_WAIT));      //Sanduhr laden: es kann
                                                              //   dauern ...

    float fx  = (float)bih.biWidth/(float)BiBr;               //Salierungs-Faktoren festlegen
    float fy  = (float)bih.biHeight/(float)BiHo;
    float fxy =  fx*fy;                                       //Flchenwichtungsfaktor

    float bx, ex, by, ey;                                     //Beginn und Ende der Quell-
    int   bxab, exab, byab, eyab;                             //   pixel fr je 1 Zielpixel

    unsigned char huge* p = GlobalLock(gHandle);              //Quellbildpointer
    GLOBALHANDLE gZielHandle =
          GlobalAlloc(GMEM_MOVEABLE, (DWORD) ((((DWORD)BiBr*3l+4l)>>2l)<<2l)*(DWORD)BiHo);
    if(gZielHandle==NULL)
    {
      MessageBox(HWindow, "Nicht gengend Speicher","Fehler",MB_OK);
      return;
    }

                                                              //Platz fr Zielbild
    unsigned char huge* q=GlobalLock(gZielHandle);            //   und Zielbildpointer

    unsigned char huge* pDummy;                               //zeigt auf 1 Quellpixel
    unsigned char huge* qDummy;                               //zeigt auf 1 Zielpixel

    long QuellZeilenOffset;                                   //Hilfsvariable Quellfeld
    long QuellZeilenLaenge = (bih.biWidth*3+3)>>2<<2;
    float LinkerRandstreifenfaktor;                           //Hilfsfaktor links
    float RechterRandstreifenfaktor;                          //Hilfsfaktor rechts
    float UntererRandstreifenfaktor;                          //Hilfsfaktor unten
    float ObererRandstreifenfaktor;                           //Hilfsfaktor oben

    for (int Zeile=0; Zeile <BiHo; Zeile++)                   //Zeilen Zielbild abarbeiten
    {
      qDummy = q + ((long)Zeile)*((BiBr*3+3)>>2<<2);
                                                              //1.Pixel in Zielzeile
      by=fy*Zeile;                                            //Erster  Quellpixel (float)
      ey=fy*(Zeile+1);                                        //Letzter Quellpixel (float)

      byab=(int)by;                                           //Erster  Quellpixel (int)
      eyab=(int)ey;                                           //Letzter Quellpixel (int)
      if (eyab==ey) eyab--;                                   //   wichtig: ggf. abrunden!

      UntererRandstreifenfaktor = 1+byab-by;                  //bercksichtigt die Flchenan-
      ObererRandstreifenfaktor  = ey-eyab;                    //   teile der Randstreifen
                                                              
      for (int Spalte=0; Spalte<BiBr; Spalte++)
      {
	erg_blau =0;                                          //Ziel-Pixel-Blauanteil
                                                              //   float wg. Rundungsfehlern
	erg_gruen=0;                                          //Ziel-Pixel-Grnanteil
                                                              //   float wg. Rundungsfehlern
	erg_rot  =0;                                          //Ziel-Pixel-Rotanteil
                                                              //   float wg. Rundungsfehlern

	bx=fx*Spalte;                                         //Erster  Quellpixel (float)
	ex=fx*(Spalte+1);                                     //Letzter Quellpixel (float)

	bxab=(int)bx;                                         //Erster  Quellpixel (int)
	exab=(int)ex;                                         //Letzter Quellpixel (int)
	if (exab==ex) exab--;                                 //   wichtig: ggf. abrunden!

        LinkerRandstreifenfaktor  = 1+bxab-bx;                //bercksichtigt die Flchenan-
        RechterRandstreifenfaktor = ex-exab;                  //   teile der Randstreifen

	QuellZeilenOffset = ((long)(byab-1))*QuellZeilenLaenge;

	for (int i=byab; i<=eyab; i++)
	{
          QuellZeilenOffset += QuellZeilenLaenge;
	  pDummy = p + QuellZeilenOffset + (long)(3*bxab);    //aktueller Quellfilepixel
                                                              //spart Rechenzeit
          for (int j=bxab; j<=exab; j++)
 	  {
	    float sum_blau  = *pDummy++  /(fxy);              //flchenmig gewichteter
	    float sum_gruen = *(pDummy++)/(fxy);              //   Summationsanteil des
	    float sum_rot   = *(pDummy++)/(fxy);              //   Quellpixels

	    if(j==bxab)                                       //linke Grenze?
	    {
	      sum_blau  *= LinkerRandstreifenfaktor;          //dann Randstreifen abziehen
	      sum_gruen *= LinkerRandstreifenfaktor;          //   durch Multiplikation mit
	      sum_rot   *= LinkerRandstreifenfaktor;          //   linkem Randstreifenfaktor 
	    }
            else if(j==exab)
	         {
	           sum_blau  *= RechterRandstreifenfaktor;    //dann Randstreifen abziehen
	           sum_gruen *= RechterRandstreifenfaktor;    //   durch Multiplikation mit
	           sum_rot   *= RechterRandstreifenfaktor;    //   rechtem Randstreifenfaktor
	         }

	    if(i==byab)
	    {
	      sum_blau  *= UntererRandstreifenfaktor;         //dann Randstreifen abziehen
	      sum_gruen *= UntererRandstreifenfaktor;         //   durch Multiplikation mit
	      sum_rot   *= UntererRandstreifenfaktor;         //   unterem Randstreifenfaktor
	    }
            else if(i==eyab)
	         {
	           sum_blau  *= ObererRandstreifenfaktor;     //dann Randstreifen abziehen
	           sum_gruen *= ObererRandstreifenfaktor;     //   durch Multiplikation mit
	           sum_rot   *= ObererRandstreifenfaktor;     //   oberem Randstreifenfaktor
	         }

	    erg_blau +=sum_blau;                              //1 Quellpixelfarbe hinzuaddieren  
	    erg_gruen+=sum_gruen;
	    erg_rot  +=sum_rot;
	  }  // Ende Spalte Quellbild
        }    // Ende Zeile  Quellbild

	*qDummy++=erg_blau+.5;                                //(float)-Farbe ins Zielfeld
	*qDummy++=erg_gruen+.5;                               //   eintragen und dabei
	*qDummy++=erg_rot+.5;                                 //   Runden auf (int)
      }      // Ende Spalte Zielbild
    }        // Ende Zeile  Zielbild

    bih.biWidth =BiBr;
    bih.biHeight=BiHo;
    bih.biSizeImage =(DWORD)((((DWORD)BiBr*3l+3)>>2l<<2l)*(DWORD)BiHo);

    ff.bfSize = (DWORD)bih.biSizeImage+ sizeof(bih)+sizeof(ff);
    ff.bfOffBits = sizeof(BITMAPINFOHEADER)+sizeof(BITMAPFILEHEADER);

    SetCursor(OldCur);

    GlobalUnlock(gZielHandle);
    GlobalUnlock(gHandle);
    GlobalFree(gHandle);
    gHandle=gZielHandle;

    SetWindowPos(HWindow,0,0,0,bih.biWidth+8,
       bih.biHeight+27,SWP_NOACTIVATE | SWP_NOMOVE | SWP_NOZORDER);

    InvalidateRect(HWindow,NULL,TRUE);
  }
}




void TBitWindow::Vergroessern(TMessage&)                  // ***** BILD SKALIEREN *****
{
  sprintf(VerkleinernTransfer.Breite,"%i",bih.biWidth);       //Breite und Hhe des Quell-
  sprintf(VerkleinernTransfer.Hoehe,"%i",bih.biHeight);       //   bildes als Startwerte
  if (GetModule()->ExecDialog(                                //   verwenden
	     new TVergroessernDialog(this,"DIALOG_1"))== IDOK)
  {
    DWORD BiBr,BiHo;                                          //Breite und Hoehe Zielbild
    float erg_rot, erg_gruen,erg_blau;                        //Aufsummieren der Quellpixel
                                                              //   ohne Rundungsfehler fr
							      //   je 1 Zielpixel

    BiBr=atol(VerkleinernTransfer.Breite);                    //aktuelle Breite und Hhe 
    BiHo=atol(VerkleinernTransfer.Hoehe);                     //   des Zielbildes holen

    HCURSOR OldCur = SetCursor(LoadCursor(0, IDC_WAIT));      //Sanduhr laden: es kann
                                                              //   dauern ...

    float fx  = (float)bih.biWidth/(float)BiBr;               //Salierungs-Faktoren festlegen
    float fy  = (float)bih.biHeight/(float)BiHo;

    float bx, ex, by, ey;                                     //Beginn und Ende der Quell-
    int   bxab, exab, byab, eyab;                             //   pixel fr je 1 Zielpixel

    unsigned char huge* p = GlobalLock(gHandle);              //Quellbildpointer
    GLOBALHANDLE gZielHandle =
          GlobalAlloc(GMEM_MOVEABLE, (DWORD) ((((DWORD)BiBr*3l+4l)>>2l)<<2l)*(DWORD)BiHo);
                                                              //Platz fr Zielbild
    unsigned char huge* q=GlobalLock(gZielHandle);            //   und Zielbildpointer

    unsigned char huge* pDummy;                               //zeigt auf 1 Quellpixel
    unsigned char huge* qDummy;                               //zeigt auf 1 Zielpixel

    long QuellZeilenOffset;                                   //Hilfsvariable Quellfeld
    long QuellZeilenLaenge = (bih.biWidth*3+3)>>2<<2;
    float TeilSpalte, TeilZeile;
    float LinkerRandstreifenfaktor;                           //Hilfsfaktor links
    float RechterRandstreifenfaktor;                          //Hilfsfaktor rechts
    float UntererRandstreifenfaktor;                          //Hilfsfaktor unten
    float ObererRandstreifenfaktor;                           //Hilfsfaktor oben

    for (int Zeile=0; Zeile <BiHo; Zeile++)                   //Zeilen Zielbild abarbeiten
    {
      qDummy = q + ((long)Zeile)*((BiBr*3+3)>>2<<2);
                                                              //1.Pixel in Zielzeile
      by=fy*Zeile;                                            //Erster  Quellpixel (float)
      ey=fy*(Zeile+1);                                        //Letzter Quellpixel (float)

      byab=(int)by;                                           //Erster  Quellpixel (int)
      eyab=(int)ey;                                           //Letzter Quellpixel (int)
      if (eyab==ey) eyab--;                                   //   wichtig: ggf. abrunden!

      TeilZeile = eyab/fy;                                    //zielpixelbezogene Grenze
      UntererRandstreifenfaktor = TeilZeile-Zeile;            //bercksichtigt die Flchenan-
      ObererRandstreifenfaktor  = Zeile+1-TeilZeile;          //   teile der Randstreifen
                                                              
      for (int Spalte=0; Spalte<BiBr; Spalte++)
      {
	erg_blau =0;                                          //Ziel-Pixel-Blauanteil
                                                              //   float wg. Rundungsfehlern
	erg_gruen=0;                                          //Ziel-Pixel-Grnanteil
                                                              //   float wg. Rundungsfehlern
	erg_rot  =0;                                          //Ziel-Pixel-Rotanteil
                                                              //   float wg. Rundungsfehlern

	bx=fx*Spalte;                                         //Erster  Quellpixel (float)
	ex=fx*(Spalte+1);                                     //Letzter Quellpixel (float)

	bxab=(int)bx;                                         //Erster  Quellpixel (int)
	exab=(int)ex;                                         //Letzter Quellpixel (int)
	if (exab==ex) exab--;                                 //   wichtig: ggf. abrunden!

        TeilSpalte = exab/fx;                                 //zielpixelbezogene Grenze
        LinkerRandstreifenfaktor  = TeilSpalte-Spalte;        //bercksichtigt die Flchenan-
        RechterRandstreifenfaktor = Spalte+1-TeilSpalte;      //   teile der Randstreifen

        QuellZeilenOffset = ((long)(byab-1))*QuellZeilenLaenge;

	for (int i=byab; i<=eyab; i++)
	{
          QuellZeilenOffset += QuellZeilenLaenge;
	  pDummy = p + QuellZeilenOffset + (long)(3*bxab);    //aktueller Quellfilepixel
                                                              //spart Rechenzeit
          for (int j=bxab; j<=exab; j++)
 	  {
            float sum_blau  = *pDummy++;                      //(nicht gewichtete) Farbe
	    float sum_gruen = *(pDummy++);                    //   des Quellpixels
	    float sum_rot   = *(pDummy++);

            if(bxab!=exab)                                    //gibt es li./re. Randstreifen?
            {                                                 //   ja:
	      if(j==bxab)                                     //if linker Randstreifen?
	      {
	        sum_blau  *= LinkerRandstreifenfaktor;        //dann Randstreifen abziehen
	        sum_gruen *= LinkerRandstreifenfaktor;        //   durch Multiplikation mit
	        sum_rot   *= LinkerRandstreifenfaktor;        //   linkem Randstreifenfaktor
	      }
              else                                            //else rechter Randstreifen
	      {                                               
	        sum_blau  *= RechterRandstreifenfaktor;       //dann Randstreifen abziehen
	        sum_gruen *= RechterRandstreifenfaktor;       //   durch Multiplikation mit
	        sum_rot   *= RechterRandstreifenfaktor;       //   rechtem Randstreifenfaktor
	      }
            }
            if(byab!=eyab)                                    //gibt es ob./unt. Randstreifen?
            {                                                 //   ja:
	      if(i==byab)                                     //if unterer Randstreifen?
	      {
	        sum_blau  *= UntererRandstreifenfaktor;       //dann Randstreifen abziehen
	        sum_gruen *= UntererRandstreifenfaktor;       //   durch Multiplikation mit
	        sum_rot   *= UntererRandstreifenfaktor;       //   unterem Randstreifenfaktor
	      }
              else                                            //else oberer Randstreifen
	      {
	        sum_blau  *= ObererRandstreifenfaktor;        //dann Randstreifen abziehen
	        sum_gruen *= ObererRandstreifenfaktor;        //   durch Multiplikation mit
	        sum_rot   *= ObererRandstreifenfaktor;        //   oberem Randstreifenfaktor
	      }
            }

	    erg_blau +=sum_blau;                              //je 1 Quellpixelfarbe hinzuadd.
	    erg_gruen+=sum_gruen;
	    erg_rot  +=sum_rot;
	  }  // Ende Spalte Quellbild
        }    // Ende Zeile  Quellbild

	*qDummy++=erg_blau+.5;                                //(float)-Farbe ins Zielfeld
	*qDummy++=erg_gruen+.5;                               //   eintragen und dabei
	*qDummy++=erg_rot+.5;                                 //   Runden auf (int)
      }      // Ende Spalte Zielbild
    }        // Ende Zeile  Zielbild

    bih.biWidth =BiBr;
    bih.biHeight=BiHo;
    bih.biSizeImage =(DWORD)((((DWORD)BiBr*3l+3)>>2l<<2l)*(DWORD)BiHo);

    ff.bfSize = (DWORD)bih.biSizeImage+ sizeof(bih)+sizeof(ff);
    ff.bfOffBits = sizeof(BITMAPINFOHEADER)+sizeof(BITMAPFILEHEADER);

    SetCursor(OldCur);

    GlobalUnlock(gZielHandle);
    GlobalUnlock(gHandle);
    GlobalFree(gHandle);
    gHandle=gZielHandle;

    SetWindowPos(HWindow,0,0,0,bih.biWidth+8,
       bih.biHeight+27,SWP_NOACTIVATE | SWP_NOMOVE | SWP_NOZORDER);

    InvalidateRect(HWindow,NULL,TRUE);
  }
}


















