{ MacInterface Demo 0.8 vom 22.09.94,  Carsten Meyer und ct }
{ TE-Services von Apple DTS und Apple Computer Inc. }
{ Demonstriert Verwendung des universellen ADB-Devices MacInterface }

program MacInterface;
{$D+}

	uses
{Types, QuickDraw, Events, Windows, Dialogs, Fonts, DiskInit, TextEdit, Traps, Desk, Memory, SegLoad, Scrap, ToolUtils, OSEvents, OSUtils, Menus, }
		DeskBus, Traps;

{$IFC UNDEFINED OLDROUTINENAMES}
{$SETC OLDROUTINENAMES := 1}
{$ENDC}

	const
{ Rand vom Textfeld zum Festerrahmen }
		kTextMargin = 2;

{ maximale Anzahl offener Fenster/Docs }
		kMaxOpenDocuments = 5;

{ maximale Breite des Fensters }
		kMaxDocWidth = 576;

{ Kleinste Gre des Fensters }
		kMinDocDim = 64;

{ Konstanten zum Ein- und Ausschalten der Controls }
		kActive = 0;
		kDimmed = $FF;
		kCtrlOff = 0;
		kCtrlOn = $FF;

{ Breite und Rand-Korrekturwert fr Scrollbars }
		kScrollbarWidth = 16;
		kScrollbarAdjust = kScrollbarWidth - 1;
		kScrollTweek = 2;

{ CR und Del fr Text-Block sowie PgUp/PgDown-Tasten auf extd. Keyboard }
		kCRChar = 13;
		kDelChar = 8;
		kPgUp = 11;
		kPgDown = 12;
		kEnd = 4;
		kHome = 1;
		kFwdDel = 127;
		kCursFwd = 29;

{ Anzahl zu scrollender Pixel bei horiz. Scrollbar }
		kButtonScroll = 4;

{ maximale Lnge eines TE-Textes }
		kMaxTELength = 32000;

{  nur diese SysEnvirons }
		kSysEnvironsVersion = 1;

{ Multifinder-Zeugs }
		kOSEvent = app4Evt;	{event used by MultiFinder}
		kSuspendResumeMessage = 1;		{high byte of suspend/resume event message}
		kResumeMask = 1;		{bit of message field for resume vs. suspend}
		kMouseMovedMessage = $FA;		{high byte of mouse-moved event message}
		kNoEvents = 0;		{no events mask}

{ minimale Heap-Gre }
		kMinHeap = 29 * 1024;
		kMinSpace = 20 * 1024;

{kExtremeNeg and kExtremePos are used to set up wide open rectangles and regions.}
		kExtremeNeg = -32768;
		kExtremePos = 32767 - 1;	{required for old region bug}

{ Pufferbereich zur Sicherheit beim Editieren }
		kTESlop = 1024;

{ Resource ID fr Meldungen in STR#-Resource.}
		kErrStrings = 128;
		kMessStrings = 129;

{ Index in STR# Resources.}
		eWrongMachine = 1;
		eSmallSize = 2;
		eNoMemory = 3;
		eNoSpaceCut = 4;
		eNoCut = 5;
		eNoCopy = 6;
		eExceedPaste = 7;
		eNoSpacePaste = 8;
		eNoWindow = 9;
		eExceedChar = 10;
		eNoPaste = 11;
		eNoADBdev = 12;
		eResFailed = 13;
		eADBDevAd = 14;

		nWait = 1;
		nClick = 2;
		nListen1 = 3;
		nTalk3 = 4;
		nEnterDelay = 5;
		nEnterString = 6;
		nNewDevice = 7;
		nHelloSerial = 8;
		nHelloDisplay = 9;


{ Resource IDs von Mens, Alerts und Dialogen }
		rMenuBar = 128;				{ application's menu bar }
		rAboutDialog = 128;			{ about alert }
		rUserAlert = 130;				{ user error alert }
		rDocWindow = 128;			{ application's window }
		rDocRefcon = 10;				{ ID des Fensters (in Ressource) }
		rMessDialog = 250;
		rVScroll = 128;					{ vertical scrollbar control }
		rHScroll = 129;					{ horizontal scrollbar control }
		rBdDialog = 240;
		rSetPort = 260;
		iPortStr = 21;					{ Eingabe-Textfeld des DLOGs }

		rCustomCmd = 270;
		kCustomRefcon = 1;
		iCmdStr = 11;				{ Device-Textfeld des DLOGs }
		iDataStr = 12;				{ Daten-Textfeld des DLOGs }

		rStrDialog = 280;
		rValueDialog = 290;
		iValStr = 3;							{ Eingabe-Textfeld des DLOGs }

		mApple = 128;					{ Apple menu }
		iAbout = 1;

		mFile = 129;						{ File menu }
		iNew = 1;
		iClose = 2;
		iErase = 3;
		iQuit = 5;

		mEdit = 130;						{ Edit menu }
		iUndo = 1;
		iCut = 3;
		iCopy = 4;
		iPaste = 5;
		iClear = 6;

{ ADB-Test-Men }
		mADB = 131;
		iTimLis = 1;
		iTimTalk = 2;
		iCustom = 3;
		iNewDev = 5;
		iADBinfo = 6;
		iADBReInit = 7;
		iTalkAll = 9;

{ MacInterface-Men }
		mIntf = 132;
		iSet0 = 1;
		iSet1 = 2;
		iSetBd = 3;
		iSendSer = 5;
		iSendDisp = 6;
		iReadCd = 7;
		iChars = 9;
		iDebug = 10;

{1.01 - kDITop and kDILeft are used to locate the Disk Initialization dialogs.}
		kDITop = $0050;
		kDILeft = $0070;

{ Applikationsspezifische Konstanten }
		kADBDeviceInitial = $7;
		kADBListen = $8;					{ ADB-Befehlskonstanten }
		kADBTalk = $C;
		kADBFlush = $1;
		kADBReset = 0;
		kADBcmdmsk = $FC;				{ Maske fr ADB-Befehl, filtert Register aus }
		kADBregmsk = $03;				{ Maske fr ADB-Register, filtert Befehl aus }
 { wird eigentlich von Apple zugeteilt, hier vorlufig: }
		kADBhdlID = $09;
 { Flags fr Host- und Device-Service-Flagregister }
		kP0fc = $1;         					{ PortSelectBits/PortServFlags-Konstanten }
		kP1fc = $2;
		kSerfc = $4;
		kBdfc = $8;
		kDispfc = $10;
		kCdRdfc = $20;        				{ Befehl zum Auslesen der T-Karte }
		kDevConfc = $80; 					{ Konfiguration (Display-Debug-Mode) setzen }
		kAllOff = $F0 + 8;					{ fr Kartenleseroutine }
{ Konfigurationen MacInterface }
		kDevCdebug = 1; 					{ Debug-Monitor Display }
		kDevConf1 = 2; 						{ weitere Konfigurationen (optional) }
		kDevConf2 = 4;
		kDevConf3 = 8;
		kDevConf4 = 16;
		kDevConf5 = 32;
		kDevConf6 = 64;
		kDevConf7 = 128;
		kHexStr = '0123456789ABCDEF';
		kBinStr = '01';


	type
{ alles, was zum TW-Fenster dazugehrt }
{ Konstanten: Fenstergren, Codes der Kommandos usw. }
		DocumentRecord = record
				docWindow: WindowRecord;
				docTE: TEHandle;
				docVScroll: ControlHandle;
				docHScroll: ControlHandle;
				docClik: ProcPtr;
			end;
		DocumentPeek = ^DocumentRecord;


	var
{ "g" als Prfix kennzeichnet globale Variablen }
		gMac: SysEnvRec;	{ Mac-Ausstattung, von Initialize aufgesetzt }
		gHasColor: byte;		{ 1 mit Color QD, 0 ohne }
		gHasWaitNextEvent: boolean;

{ GInBackground is maintained by our OSEvent handling routines. Any part of}
{ the program can check it to find out if it is currently in the background.}
		gInBackground: BOOLEAN;		{ maintained by Initialize and DoEvent }

{ GNumDocuments is used to keep track of how many open documents there are }
{ at any time. It is maintained by the routines that open and close documents. }
		gNumDocuments: INTEGER;		{ maintained by Initialize, DoNew, and DoCloseWindow }

{ globale Variablen fr MacInterface }
		gDebug, gChars: boolean;
		gPort0, gPort1: byte;
		gSerBd: byte;
		gVersion: Str32;
		gADBSetInfoBlock: ADBSetInfoBlock;
		gADBServCode: Handle;
		gADBServRoutinePtr, aPtr: Ptr;
		gADBDevice: byte;
		gADBopBuf: packed array[0..8] of byte;

{ "Eigener Befehl" Modeless-Dialog: Variable mssen global sein }
		gCustomDLOG: DialogPtr;
		gCustomBtnState: array[3..10] of Boolean;
		gADBCmd, gADBreg: Byte;
		gADBData: integer;


{$S Initialize}
	function TrapAvailable (tNumber: INTEGER; tType: TrapType): BOOLEAN;
{ Eruiert, ob ein Trap verfgbar ist }

	begin
		if (tType = ToolTrap) & (gMac.machineType > envMachUnknown) & (gMac.machineType < envMacII) then
			begin		{it's a 512KE, Plus, or SE}
				tNumber := BAND(tNumber, $03FF);
				if tNumber > $01FF then							{which means the tool traps}
					tNumber := _Unimplemented;					{only go to $01FF}
			end;
		TrapAvailable := NGetTrapAddress(tNumber, tType) <> GetTrapAddress(_Unimplemented);
	end; {TrapAvailable}



{$S Main}
	function IsDAWindow (window: WindowPtr): BOOLEAN;
{ berprft, ob ein Fenster zu einem Desk Accessory gehrt }

	begin
		if window = nil then
			IsDAWindow := FALSE
		else	{DA windows have negative windowKinds}
			IsDAWindow := WindowPeek(window)^.windowKind < 0;
	end; {IsDAWindow}


{$S Main}
	function IsAppWindow (window: WindowPtr): BOOLEAN;
{ berprft, ob ein Fenster zu uns gehrt }

	begin
	{application windows have windowKinds = userKind (8)}
		with WindowPeek(window)^ do
			IsAppWindow := (windowKind = userKind);
		if (window = nil) then
			IsAppWindow := FALSE;
	end; {IsAppWindow}


{$S Main}
	procedure AlertUser (error: INTEGER);
{ Fehler aufgetreten: User informieren. Auch fr andere Anwendungen brauchbar. }

		var
			itemHit: INTEGER;
			message: Str255;
	begin
		SetCursor(arrow);
		GetIndString(message, kErrStrings, error);
		ParamText(message, '', '', '');
		itemHit := Alert(rUserAlert, nil);
	end; {AlertUser}


{$S Main}
	procedure GetTERect (window: WindowPtr; var teRect: Rect);
{ Ermittelt eigentliche Gre des Editierfeldes }

	begin
		teRect := window^.portRect;
		InsetRect(teRect, kTextMargin, kTextMargin);			{adjust for margin}
		teRect.bottom := teRect.bottom - kScrollbarAdjust;	{and for the scrollbars}
		teRect.right := teRect.right - kScrollbarAdjust;
	end; {GetTERect}


{$S Main}
	function DoCloseWindow (window: WindowPtr): BOOLEAN;
{ TE-Record wegschmeien und Fenster schlieen }

	begin
		DoCloseWindow := TRUE;
		if IsDAWindow(window) then
			CloseDeskAcc(WindowPeek(window)^.windowKind)
		else if IsAppWindow(window) then
			begin
				with DocumentPeek(window)^ do
					if docTE <> nil then
						TEDispose(docTE);		{dispose the TEHandle}
				CloseWindow(window);
				DisposPtr(Ptr(window));
				gNumDocuments := gNumDocuments - 1;
			end;
	end; {DoCloseWindow}


{$S Main}
	procedure AdjustViewRect (docTE: TEHandle);
{ TERec so einstellen, das es ein ganzzahliges Vielfaches von lineHeight ergibt }

	begin
		with docTE^^ do
			begin
				viewRect.bottom := (((viewRect.bottom - viewRect.top) div lineHeight) * lineHeight) + viewRect.top;
			end;
	end; {AdjustViewRect}


{$S Main}
	procedure AdjustTE (window: WindowPtr);
{ TERec scrollen, so da es mit vernderten  Scrollbars bereinstimmt }

		var
			value: INTEGER;
	begin
		with DocumentPeek(window)^ do
			begin
				TEScroll((docTE^^.viewRect.left - docTE^^.destRect.left) - GetCtlValue(docHScroll), (docTE^^.viewRect.top - docTE^^.destRect.top) - (GetCtlValue(docVScroll) * docTE^^.lineHeight), docTE);
			end;
	end; {AdjustTE}


{$S Main}
	procedure AdjustHV (isVert: BOOLEAN; control: ControlHandle; docTE: TEHandle; canRedraw: BOOLEAN);
{ Aus verndertem TE-Record neue Werte fr Fahrstuhl-Position und -maxVal ermitteln. }

		var
			value, lines, max: INTEGER;
			oldValue, oldMax: INTEGER;
	begin
		oldValue := GetCtlValue(control);
		oldMax := GetCtlMax(control);
		if isVert then
			begin
				lines := docTE^^.nLines;
		{since nLines isnt right if the last character is a return, check for that case}
				if Ptr(ORD(docTE^^.hText^) + docTE^^.teLength - 1)^ = kCRChar then
					lines := lines + 1;
				max := lines - ((docTE^^.viewRect.bottom - docTE^^.viewRect.top) div docTE^^.lineHeight);
			end
		else
			max := kMaxDocWidth - (docTE^^.viewRect.right - docTE^^.viewRect.left);
		if max < 0 then
			max := 0;			{check for negative values}
		SetCtlMax(control, max);
		if isVert then
			value := (docTE^^.viewRect.top - docTE^^.destRect.top) div docTE^^.lineHeight
		else
			value := docTE^^.viewRect.left - docTE^^.destRect.left;
		if value < 0 then
			value := 0
		else if value > max then
			value := max;					{pin the value to within range}
		SetCtlValue(control, value);
		if canRedraw & ((max <> oldMax) | (value <> oldValue)) then
			ShowControl(control);			{check to see if the control can be re-drawn}
	end; {AdjustHV}


{$S Main}
	procedure AdjustScrollValues (window: WindowPtr; canRedraw: BOOLEAN);

{ Horizontale und vertikale Position der Fahrsthle neu einstellen }

	begin
		with DocumentPeek(window)^ do
			begin
				AdjustHV(TRUE, docVScroll, docTE, canRedraw);
				AdjustHV(FALSE, docHScroll, docTE, canRedraw);
			end;
	end; {AdjustScrollValues}


{$S Main}
	procedure AdjustScrollSizes (window: WindowPtr);
{ Lnge und Position der Scrollbars neu berechnen, Offsets bercksichtigen }

		var
			teRect: Rect;
	begin
		GetTERect(window, teRect);
		with DocumentPeek(window)^, window^.portRect do
			begin
				docTE^^.viewRect := teRect;
				AdjustViewRect(docTE);										{ nchstmglich Zeile }
				MoveControl(docVScroll, right - kScrollbarAdjust, -1);
				SizeControl(docVScroll, kScrollbarWidth, (bottom - top) - (kScrollbarAdjust - kScrollTweek));
				MoveControl(docHScroll, -1, bottom - kScrollbarAdjust);
				SizeControl(docHScroll, (right - left) - (kScrollbarAdjust - kScrollTweek), kScrollbarWidth);
			end;
	end; {AdjustScrollSizes}


{$S Main}
	procedure AdjustScrollbars (window: WindowPtr; needsResize: BOOLEAN);
{ Scrollbars neu plazieren. Neue Gre und ggf. neue Position der Fahrsthle berechnen. }

		var
			oldMax, oldVal: INTEGER;
	begin
		with DocumentPeek(window)^ do
			begin
{ Ausschalten durch Eintragen einer 0 in ihr contrlVis-Feld }
				docVScroll^^.contrlVis := kCtrlOff;	{turn them off}
				docHScroll^^.contrlVis := kCtrlOff;
				if needsResize then								{move and size if needed}
					AdjustScrollSizes(window);
				AdjustScrollValues(window, not needsResize);	{fool with max and current value}
{ Einschalten durch Eintragen von $FF in ihr contrlVis-Feld }
				docVScroll^^.contrlVis := kCtrlOn;		{turn them on}
				docHScroll^^.contrlVis := kCtrlOn;
			end;
	end; {AdjustScrollbars}


{$S Main}
	procedure DoNew;
{ Erzeugen eines neuen Fensters und zugehrigen TERecords. }

		var
			good, ignore: BOOLEAN;
			storage: Ptr;
			window: WindowPtr;
			destRect, viewRect: Rect;

	begin
		storage := NewPtr(SIZEOF(DocumentRecord));
		if storage <> nil then
			begin
				window := GetNewWindow(rDocWindow, storage, WindowPtr(-1));
				if window <> nil then
					begin
						gNumDocuments := gNumDocuments + 1;	{this will be decremented when we call DoCloseWindow}
						good := FALSE;
						SetPort(window);
						with window^, DocumentPeek(window)^ do
							begin
								GetTERect(window, viewRect);
								destRect := viewRect;
								destRect.right := destRect.left + kMaxDocWidth;
								docTE := TENew(destRect, viewRect);
								if docTE <> nil then
									begin		{1.02 - moved}
										good := TRUE;				{ hat geklappt }
										docTE^^.txFont := Monaco;
										AdjustViewRect(docTE);
										TEAutoView(TRUE, docTE);
										docClik := docTE^^.clikLoop;
									end;
								if good then
									begin
										docVScroll := GetNewControl(rVScroll, window);
										good := (docVScroll <> nil);
									end;
								if good then
									begin
										docHScroll := GetNewControl(rHScroll, window);
										good := (docHScroll <> nil);
									end;
								if good then
									begin
										AdjustScrollValues(window, FALSE);
										ShowWindow(window);			{ immer noch in Ordnung: anzeigen}
									end
								else
									begin
										ignore := DoCloseWindow(window);	{otherwise regret we ever created it...}
										AlertUser(eNoWindow);				{and tell user}
									end
							end;
					end
				else
					DisposPtr(storage);					{get rid of the storage if it is never used}
			end;
	end; {DoNew}

{$S Main}
	procedure InitADB;
	forward;

{$S Main}
	procedure initDLOGs;
		var
			n: integer;
	begin
{ Custom-Command Dialog, Variablen aufsetzen }
		gCustomDLOG := GetNewDialog(rCustomCmd + gHasColor, nil, Pointer(-1));
		for n := 4 to 10 do
			gCustomBtnState[n] := false;
		gCustomBtnState[3] := true;
		gCustomBtnState[7] := true;
	end;

{$S Main}
	procedure BigBadError (error: INTEGER);
	begin
		AlertUser(error);
		ExitToShell;
	end;


{$S Initialize}
	procedure Initialize;
{ Globale Initialisierung. Wird spter rausgeschmissen }

		var
			menuBar: Handle;
			total, contig: LongInt;
			ignoreResult: BOOLEAN;
			event: EventRecord;
			count, m, n, ignoreError: INTEGER;
			GDev: GDHandle;
			versionHandle: handle;

{ Nichts geht mehr: }
		procedure BigBadError (error: INTEGER);
		begin
			AlertUser(error);
			ExitToShell;
		end;

	begin
		gInBackground := FALSE;

		InitGraf(@thePort);
		InitFonts;
		InitWindows;
		InitMenus;
		TEInit;
		InitDialogs(nil);
		InitCursor;
{ Events abbauen }
		for count := 1 to 3 do
			ignoreResult := EventAvail(everyEvent, event);
		ignoreError := SysEnvirons(kSysEnvironsVersion, gMac);
{ Uralt-Mac? }
		if gMac.machineType < 0 then
			BigBadError(eWrongMachine);
{ Farbe mglich? Whlt spter andere Men-IDs (+1) aus }
		if gMac.HasColorQD then
			begin
				GDev := GetMainDevice;


				gHasColor := 1
			end
		else
			gHasColor := 0;
		gHasWaitNextEvent := TrapAvailable(_WaitNextEvent, ToolTrap);
{ Genug RAM frei? }
		if ORD(GetApplLimit) - ORD(ApplicZone) < kMinHeap then
			BigBadError(eSmallSize);
		PurgeSpace(total, contig);
		if total < kMinSpace then
			if UnloadScrap <> noErr then
				BigBadError(eNoMemory)
			else
				begin
					PurgeSpace(total, contig);
					if total < kMinSpace then
						BigBadError(eNoMemory);
				end;
		menuBar := GetNewMBar(rMenuBar);
		if menuBar = nil then
			BigBadError(eNoMemory);
		SetMenuBar(menuBar);
		DisposHandle(menuBar);
		AddResMenu(GetMHandle(mApple), 'DRVR');
		DrawMenuBar;
		gNumDocuments := 0;
{ weitere, anwendungsspezifische Initialisierungen }
		gADBServCode := GetResource('ADBs', 128);
		if gADBServCode = nil then
			AlertUser(eResFailed);
		HLock(gADBServCode);
		gADBServRoutinePtr := gADBServCode^;
		InitADB;
		VersionHandle := GetResource('vers', 1);
		gVersion := '';
		if VersionHandle <> nil then
			begin
				aPtr := ptr(ord(VersionHandle^) + 6);				{ Offset in vers-Ressource }
				m := aPtr^;						{ String-Lnge }
				for n := 0 to m do			{ vers-String nach gVersion kopieren }
					begin
						gVersion[n] := char(aPtr^);
						aPtr := ptr(succ(ord(aPtr)));
					end;
				ReleaseResource(VersionHandle);
			end;
		gCustomDLOG := nil;
{ Neues Text-Fenster aufbauen }
		DoNew;
		InitDLOGs;

	end; {Initialize}


{$S Main}
	procedure Terminate;
{ Pointer, Handles wegwerfen usw. }
		var
			aWindow: WindowPtr;
			closed: BOOLEAN;
			Error: OSErr;
	begin
		if gCustomDLOG <> nil then
			disposDialog(gCustomDLOG);
		gADBSetInfoBlock.siServiceRtPtr := nil;
		gADBSetInfoBlock.siDataAreaAddr := nil;
		Error := SetADBInfo(gADBSetInfoBlock, kADBDeviceInitial);
		HUnLock(gADBServCode);
		if gADBServCode <> nil then
			ReleaseResource(gADBServCode);
		closed := TRUE;
		repeat
			aWindow := FrontWindow;					{get the current front window}
			if aWindow <> nil then
				closed := DoCloseWindow(aWindow);	{close this window}
		until (not closed) | (aWindow = nil);		{do all windows}
		if closed then
			ExitToShell;							{exit if no cancellation}
	end; {Terminate}

{$S Main}
	function FrontDocWindow: WindowPtr;
{ ermittelt das oberste rDocrefcon-Fenster; quick&dirty }
		var
			window: windowPtr;
	begin
		window := FrontWindow;
		FrontDocWindow := window;
		if (window <> nil) and (GetWrefcon(window) <> rDocrefcon) then
			begin
				window := windowPtr(WindowPeek(window)^.nextwindow);
				if IsAppWindow(window) then
					FrontDocWindow := window
				else
					FrontDocWindow := nil;
			end;
	end;

{$S Main}
	procedure AdjustMenus;
{ Je nach Erforderniss Menpunkte dimmen oder entdimmen }

		var
			window: WindowPtr;
			menu: MenuHandle;
			offset: LONGINT;
			undo: BOOLEAN;
			cutCopyClear: BOOLEAN;
			paste: BOOLEAN;

	begin
		window := FrontWindow;
		menu := GetMHandle(mFile);
		if gNumDocuments < kMaxOpenDocuments then
			EnableItem(menu, iNew)				{New is enabled when we can open more documents}
		else
			DisableItem(menu, iNew);
		if FrontDocWindow = nil then			{Close is enabled when there is a window to close}
			begin
				DisableItem(menu, iClose);
				DisableItem(menu, iErase);
			end
		else
			begin
				EnableItem(menu, iClose);
				EnableItem(menu, iErase);
			end;
		menu := GetMHandle(mEdit);
		undo := FALSE;
		cutCopyClear := FALSE;
		paste := FALSE;
		if IsDAWindow(window) then
			begin
				undo := TRUE;				{all editing is enabled for DA windows}
				cutCopyClear := TRUE;
				paste := TRUE;
			end
		else if IsAppWindow(window) then
			begin
				with DocumentPeek(window)^.docTE^^ do
					if selStart < selEnd then
						cutCopyClear := TRUE;
				{Cut, Copy, and Clear is enabled for app. windows with selections}
				if GetScrap(nil, 'TEXT', offset) > 0 then
					paste := TRUE;			{Paste is enabled for app. windows}
			end;
		if undo then
			EnableItem(menu, iUndo)
		else
			DisableItem(menu, iUndo);
		if cutCopyClear then
			begin
				EnableItem(menu, iCut);
				EnableItem(menu, iCopy);
				EnableItem(menu, iClear);
			end
		else
			begin
				DisableItem(menu, iCut);
				DisableItem(menu, iCopy);
				DisableItem(menu, iClear);
			end;
		if paste then
			EnableItem(menu, iPaste)
		else
			DisableItem(menu, iPaste);
	end; {AdjustMenus}


{**************************** app specific procs  & funcs **********************************}
	var
		aInt: Integer;
		aLongInt: LongInt;
		aStr: str255;
		aChar: Char;

{$S Main}
	function ByteToHex (theByte: byte): string;
		var
			a, c: Integer;
			s: string[4];
	begin
		s := '00';
		for c := 2 downto 1 do
			begin
				a := band(theByte, $F);
				theByte := bsr(theByte, 4);
				s[c] := char(kHexStr[a + 1]);
			end;
		ByteToHex := s;
	end;

{$S Main}
	function NumToHex (theLongInt: LongInt): string;
		var
			a, c: Integer;
			s: string[16];
	begin
		s := '00000000';
		for c := 8 downto 1 do
			begin
				a := band(theLongInt, $F);
				theLongInt := bsr(theLongInt, 4);
				s[c] := char(kHexStr[a + 1]);
			end;
{ Leerzeichen zur besseren Lesbarkeit einfgen }
		insert(' ', s, 5);
		NumToHex := s;
	end;

{$S Main}
	function NumToBin (theLongInt: LongInt): string;
		var
			a, c: Integer;
			s: string[40];
	begin
		s := '00000000000000000000000000000000';
		for c := 32 downto 1 do
			begin
				a := band(theLongInt, 1);
				theLongInt := bsr(theLongInt, 1);
				s[c] := char(kBinStr[a + 1]);
			end;
{ Leerzeichen zur besseren Lesbarkeit einfgen }
		insert(' ', s, 25);
		insert(' ', s, 17);
		insert(' ', s, 9);
		NumToBin := s;
	end;

{$S Main}
	procedure PasteString (theStr: string);
{ String in TE-Record einsetzen und anzeigen }
		var
			te: TEHandle;
			n: Integer;
			window: WindowPtr;
	begin
		window := FrontDocWindow;
		if window = nil then
			begin
				DoNew;
				window := FrontWindow;
			end;
		te := DocumentPeek(window)^.docTE;
		TEInsert(@theStr[1], length(theStr), te);
{ Anzeigen der letzten Einfgung erzwingen - kleiner Trick: Space und Backspace einsetzen }
		TESelView(te);
		AdjustScrollValues(window, false);
		AdjustTE(window);
	end;

{$S Main}
	procedure sendADB (cmdbyte: byte; byte1: byte; byte2: byte);
{ Senden eines ADB-Kommandos ohne Completion-Routine }

		var
			Error: OSErr;
	begin
		gADBopBuf[0] := 2;
		gADBopBuf[1] := byte1;
		gADBopBuf[2] := byte2;
		Error := ADBOp(nil, nil, @gADBopBuf, cmdbyte);
	end;

{$S Main}
	procedure recvADB (cmdbyte: byte; byte1: byte; byte2: byte);
{ Senden eines ADB-Kommandos, Completion-Routine liefert App1Evt }

		var
			Error: OSErr;
	begin
		gADBopBuf[0] := 2;
		gADBopBuf[1] := byte1;
		gADBopBuf[2] := byte2;
		Error := ADBOp(nil, gADBServRoutinePtr, @gADBopBuf, cmdbyte);
	end;

{$S Main}
	procedure InitADB;
		var
			error: OSErr;
	begin
		gChars := false;
		gDebug := false;
		gPort0 := $FF;
		gPort1 := $F8;
		gSerBd := 8;
		gADBCmd := kADBListen;
		gADBreg := 0;
		gADBDevice := kADBDeviceInitial;
		gADBSetInfoBlock.siServiceRtPtr := gADBServRoutinePtr;
		gADBSetInfoBlock.siDataAreaAddr := nil;
		Error := SetADBInfo(gADBSetInfoBlock, gADBDevice);
		if Error <> noErr then
			AlertUser(eNoADBdev);
		sendADB(gADBDevice * 16 + kADBFlush, 0, 0);
		CheckItem(GetMenu(mIntf), iChars, gChars);
		CheckItem(GetMenu(mIntf), iDebug, gDebug);
	end;

{$S Main}
	procedure showADBInfo;
{ ADB-Device-Eintrge auflisten }
		var
			n: Integer;
			Error: OSErr;
			theADBData: ADBDataBlock;
	begin
		for n := 0 to 15 do
			begin
				Error := GetADBInfo(theADBData, n);
				if Error = NoErr then
					with theADBData do
						begin
							PasteString(concat('Device: $', ByteToHex(n), ', DevType: $', ByteToHex(devType)));
							PasteString(concat(',  OrigADBAddr: $', ByteToHex(origADBAddr), ',', char(13)));
							PasteString(concat('ServRoutine: $', NumToHex(Longint(dbServiceRtPtr)), ', '));
							PasteString(concat('DataArea: $', NumToHex(Longint(dbDataAreaAddr)), char(13)));
						end;
			end;
	end;

{$S Main}
	procedure DoApp1Evt (message: LongInt);
{ Auf von ADBs-Code-Ressource gelierferten app1Evt reagieren. Hier: Einfach anzeigen. }
{ Der Event enthlt im oberen Byte des LongInts "message" den ADB-Befehl. Es folgen: }
{ Die Anzahl der empfangenen Bytes (0 oder 2) und die ersten 2 Datenbytes des }
{ empfangenen Datenblocks.  Da Macinterface hchsten 2 Bytes liefert,  ist diese }
{ einfache Art des Datenaustauchs mglich. Fr andere Devices, die bis zu 8 Bytes liefern, }
{ mte die Adresse des Datenblocks anstelle der Daten selbst bergeben werden. }
		var
			te: TEHandle;
			tADBopBuf: packed array[0..8] of byte;
			tADBCmd: byte;
			n: Integer;
			ItemType: Integer;
			ItemHdl: Handle;
			ItemBox: Rect;
	begin
{ als Protokoll in das Event-Textfenster einsetzen }
		if gChars then
			PasteString(aChar)
		else
			begin
				if gDebug then
					sysbeep(0);
				aStr := concat('$', NumToHex(message), '  =  %', NumToBin(message), '  (', aChar, ')', char(13));
				PasteString(aStr);
			end;
	end;

{**************************** app specific dlgs & alrts **********************************}

{$S Main}
	procedure SetBtnState (theDLOG: DialogPtr; ItemNo: Integer; CheckIt: Boolean);
{ Checkbox oder Button ein- oder ausschalten }
		var
			ItemType, CtrlValue: Integer;
			ItemHdl: Handle;
			ItemBox: Rect;
	begin
		if CheckIt then
			CtrlValue := kCtrlOn
		else
			CtrlValue := kCtrlOff;
		GetDItem(theDLOG, ItemNo, ItemType, ItemHdl, ItemBox);
		SetCtlValue(ControlHandle(ItemHdl), CtrlValue);
	end;

{$S Main}
	procedure SetHilite (theDLOG: DialogPtr; ItemNo: Integer; CheckIt: Boolean);
{ Checkbox oder Button dimmen oder hiliten }
		var
			ItemType, CtrlValue: Integer;
			ItemHdl: Handle;
			ItemBox: Rect;
	begin
		if CheckIt then
			CtrlValue := kActive
		else
			CtrlValue := kDimmed;
		GetDItem(theDLOG, ItemNo, ItemType, ItemHdl, ItemBox);
		HiliteControl(ControlHandle(ItemHdl), CtrlValue);
	end;

{$S Main}
	function StrDialog (var EingStr: Str255; Message: Str32): boolean;
{ erzeugt einen modalen Dialog mit Vorgabe EingStr, liefert TRUE, wenn OK gedrckt }
		const
			EingStrItem = 3;		{ Eingabe-Textfeld des DLOGs }
			OK2 = 5;
		var
			AusgStr: Str255;
			aDLOG: DialogPtr;
			ItemType, Item, n: Integer;
			ItemHdl: Handle;
			ItemBox: Rect;
			aDefOrdner: Boolean;
	begin
		InitCursor;
		aDLOG := GetNewDialog(rStrDialog + gHasColor, nil, Pointer(-1));
		SetPort(aDLOG);
		GetDItem(aDLOG, EingStrItem, ItemType, ItemHdl, ItemBox);
		SetIText(Itemhdl, EingStr);      					{Default-Text einsetzen}
		SelIText(aDLOG, EingStrItem, 0, kCtrlOn);     		{Default-Text hiliten}
		ParamText(Message, '', '', '');
{solange Eingaben zulassen bis RETURN, Abbruch oder OK gedrckt}
		repeat
			GetDItem(aDLOG, OK, ItemType, ItemHdl, ItemBox);
			PenSize(3, 3);										{ OK-Button stetig neu defaulten }
			InsetRect(Itembox, -4, -4);
			FrameRoundRect(ItemBox, 16, 16);
			ModalDialog(nil, item);
		until (item = OK) or (item = OK2) or (item = Cancel);   				{RETURN entspricht OK}
		GetDItem(aDLOG, EingStrItem, ItemType, ItemHdl, ItemBox);
		GetIText(ItemHdl, AusgStr);
		if (item = Cancel) then
			StrDialog := false
		else
			begin
				EingStr := AusgStr;
				StrDialog := true;
			end;
		DisposDialog(aDLOG);
	end;

{$S Main}
	function ValueDialog (var Value: LongInt; Message: Str32): boolean;
{ erzeugt einen modalen Dialog mit Vorgabe Value, liefert TRUE, wenn OK gedrckt }
		const
			OK2 = 5;
		var
			AusgStr: Str255;
			aDLOG: DialogPtr;
			ItemType, Item, n: Integer;
			ItemHdl: Handle;
			ItemBox: Rect;
	begin
		NumToString(Value, AusgStr);
		InitCursor;
		aDLOG := GetNewDialog(rValueDialog + gHasColor, nil, Pointer(-1));
		SetPort(aDLOG);
		GetDItem(aDLOG, iValStr, ItemType, ItemHdl, ItemBox);
		SetIText(Itemhdl, AusgStr);      					{Default-Text einsetzen}
		SelIText(aDLOG, iValStr, 0, kCtrlOn);     		{Default-Text hiliten}
		ParamText(Message, '', '', '');
{solange Eingaben zulassen bis RETURN, Abbruch oder OK gedrckt}
		repeat
			GetDItem(aDLOG, 1, ItemType, ItemHdl, ItemBox);
			PenSize(3, 3);										{ OK-Button stetig neu defaulten }
			InsetRect(Itembox, -4, -4);
			FrameRoundRect(ItemBox, 16, 16);
			ModalDialog(nil, item);
		until (item = OK) or (item = OK2) or (item = Cancel);   					{RETURN entspricht OK}
		GetDItem(aDLOG, iValStr, ItemType, ItemHdl, ItemBox);
		GetIText(ItemHdl, AusgStr);
		if (item = Cancel) then
			ValueDialog := false
		else
			begin
				StringToNum(AusgStr, Value);
				ValueDialog := true;
			end;
		DisposDialog(aDLOG);
	end;

{$S Main}
	function SetBaudDialog (defBaud: Byte): Byte;
{ erzeugt einen modalen Dialog zur Einstellung der MacInterface-RS232-Schnittstelle }
		const
			OK2 = 13;
		var
			aDLOG: DialogPtr;
			ItemType, Item, n: Integer;
			aByte: Byte;
			ItemHdl: Handle;
			ItemBox: Rect;
			BtnState: array[4..9] of Boolean;
	begin
{ temporre Button-States, falls spter Abbruch geklickt }
		InitCursor;
		for n := 4 to 9 do
			begin
				BtnState[n] := false;
			end;
		BtnState[defBaud] := true;
		aDLOG := GetNewDialog(rBdDialog + gHasColor, nil, Pointer(-1));
		SetPort(aDLOG);
		for n := 4 to 9 do
			SetBtnState(aDLOG, n, BtnState[n]);
{ bis RETURN, Abbruch oder OK gedrckt}
		repeat
			GetDItem(aDLOG, 1, ItemType, ItemHdl, ItemBox);
			PenSize(3, 3);											{ OK-Button stetig neu defaulten }
			InsetRect(Itembox, -4, -4);
			FrameRoundRect(ItemBox, 16, 16);
			ModalDialog(nil, item);
			case item of
				4..9: 
					begin
						for n := 4 to 9 do
							begin
								BtnState[n] := false;
								SetBtnState(aDLOG, n, false);
							end;
						BtnState[item] := true;					{ nur ein Button }
						SetBtnState(aDLOG, item, true);
					end;
			end;
		until (item = OK) or (item = Cancel) or (item = OK2);   	{RETURN entspricht OK}
		if (item <> Cancel) then
			begin
				for n := 4 to 9 do
					if BtnState[n] then
						SetBaudDialog := n;
			end
		else
			SetBaudDialog := defBaud;
		DisposDialog(aDLOG);
	end;

	function evalADBcbyte: byte;
{ errechnet je nach Befehl die Zusammensetzung desselben }
	begin
		case gADBCmd of
			kADBListen, kADBTalk: 
				evalADBcbyte := 16 * gADBdevice + gADBCmd + gADBreg;
			kADBFlush: 
				evalADBcbyte := 16 * gADBdevice + gADBCmd;
			kADBReset: 
				evalADBcbyte := gADBCmd;
		end;
	end;


{$S Main}
	procedure CustomCmdDialog;
{ aktiviert den nichtmodalen Dialog "Eigener Befehl", der bereits von Initialize geholt wurde }
		var
			ItemType, Item, n, m: Integer;
			ItemHdl: Handle;
			ItemBox: Rect;

	begin
		InitCursor;
		SetPort(gCustomDLOG);
		m := 10;
		if (gADBCmd = kADBReset) or (gADBCmd = kADBFlush) then
			m := 6;
		for n := 3 to m do
			SetBtnState(gCustomDLOG, n, gCustomBtnState[n]);
		GetDItem(gCustomDLOG, iCmdStr, ItemType, ItemHdl, ItemBox);
		SetIText(Itemhdl, ByteToHex(evalADBcbyte));      	{Default-Text einsetzen}
		GetDItem(gCustomDLOG, iDataStr, ItemType, ItemHdl, ItemBox);
		SetIText(Itemhdl, '00 00');      			{Default-Text einsetzen}
		gADBData := 0;
		SelIText(gCustomDLOG, iDataStr, 0, kCtrlOn);     	{Default-Text hiliten}
		item := 0;
		if gHasColor = 0 then
			begin
				GetDItem(gCustomDLOG, 1, ItemType, ItemHdl, ItemBox);
				PenSize(3, 3);													{ OK-Button stetig neu defaulten }
				InsetRect(Itembox, -4, -4);
				FrameRoundRect(ItemBox, 16, 16);
			end;
		showWindow(gCustomDLOG);
		selectWindow(gCustomDLOG);
	end;

	procedure DoDialogs (event: EventRecord);
{ Events fr Modeless-Dialoge behandeln; hier nur fr den Dialog "Eigener Befehl" }
		var
			aDialogPtr: DialogPtr;
			ItemType, Item, n, m: Integer;
			ItemHdl: Handle;
			ItemBox: Rect;
			Error: OSErr;
			tADBcbyte: Byte;


	begin
		if DialogSelect(Event, aDialogPtr, Item) then
			case GetWRefCon(aDialogPtr) of
{ Refcon ist eine Konstante in der DLOG-Resource zur Unterscheidung der Dialoge/Fenster }
				kCustomRefcon: 
					begin
						case item of
							3..6:  		{ Befehlswahl }
								begin
									for n := 3 to 6 do
										begin
											gCustomBtnState[n] := false;
											SetBtnState(gCustomDLOG, n, false);
										end;
									gCustomBtnState[item] := true;					{ nur ein Button ist an }
									SetBtnState(gCustomDLOG, item, true);
									case item of
										3: 
											begin
												gADBCmd := kADBListen;
												for n := 7 to 10 do
													begin
														SetBtnState(gCustomDLOG, n, gCustomBtnState[n]);
														SetHilite(gCustomDLOG, n, true);
													end;
											end;
										4: 
											begin
												gADBCmd := kADBTalk;
												for n := 7 to 10 do
													begin
														SetBtnState(gCustomDLOG, n, gCustomBtnState[n]);
														SetHilite(gCustomDLOG, n, true);
													end;
											end;
										5: 
											begin
												gADBCmd := kADBFlush;
												for n := 7 to 10 do
													begin
														SetBtnState(gCustomDLOG, n, false);
														SetHilite(gCustomDLOG, n, false);
													end;
											end;
										6: 
											begin
												gADBCmd := kADBReset;
												for n := 7 to 10 do
													begin
														SetBtnState(gCustomDLOG, n, false);
														SetHilite(gCustomDLOG, n, false);
													end;
											end;
									end;
									GetDItem(gCustomDLOG, iCmdStr, ItemType, ItemHdl, ItemBox);
									SetIText(Itemhdl, ByteToHex(evalADBcbyte));      	{ neuer gADBCmd-Wert }
								end;
							7..10: 			{ Registerwahl }
								begin
									for n := 7 to 10 do
										begin
											gCustomBtnState[n] := false;
											SetBtnState(gCustomDLOG, n, false);
										end;
									gCustomBtnState[item] := true;									{ nur ein Button }
									SetBtnState(gCustomDLOG, item, true);
									gADBreg := item - 7;
									GetDItem(gCustomDLOG, iCmdStr, ItemType, ItemHdl, ItemBox);
									SetIText(Itemhdl, ByteToHex(evalADBcbyte));      	{ neuer gADBCmd-Wert }
								end;
							1:
{ Befehl senden: aus Textfeldern entnehmen, da der Anwender evt. hier selbst etwas eingetragen hat }
								begin
									GetDItem(gCustomDLOG, iCmdStr, ItemType, ItemHdl, ItemBox);
									GetIText(ItemHdl, aStr);
									aStr[0] := char(2);	{ Lnge begrenzen }
									StuffHex(@aStr[4], aStr);
									tADBcbyte := byte(aStr[4]);
									GetDItem(gCustomDLOG, iDataStr, ItemType, ItemHdl, ItemBox);
									GetIText(ItemHdl, aStr);
{ eventuelle Leerzeichen entfernen }
									aStr := concat(aStr, char(13));
									n := 0;
									repeat
										n := n + 1;
										if aStr[n] = ' ' then
											delete(aStr, n, 1);
									until aStr[n] = char(13);
									delete(aStr, n, 1);
{ bei unrunder Lnge fhrende 0 ergnzen }
									if length(aStr) mod 2 = 1 then
										insert('0', aStr, 1);
									if gCustomBtnState[3] and (length(aStr) < 4) or (length(aStr) > 16) then
										begin
											sysbeep(0);
											aStr := '0000';
										end;
									gADBopBuf[0] := length(aStr) div 2;
									StuffHex(@gADBopBuf[1], aStr);
									Error := ADBOp(nil, gADBServRoutinePtr, @gADBopBuf, tADBcbyte);
								end;
							2: 			{ OK: nur Dialog verstecken }
								HideWindow(gCustomDLOG);
						end;
					end;
			end;
	end;


{$S Main}
	function SetPortDialog (PortNr: byte; InputState: Byte): Byte;
{ erzeugt einen modalen Dialog zur Steuerung der Macinterface-Ausgangsports }
		var
			aDLOG: DialogPtr;
			ItemType, Item, n: Integer;
			aByte: Byte;
			ItemHdl: Handle;
			ItemBox: Rect;
			BtnState: array[4..11] of Boolean;
	begin
		InitCursor;
{ temporre Button-States, falls spter Abbruch geklickt }
		aByte := InputState;
		for n := 4 to 11 do
			begin
				BtnState[n] := boolean(band(aByte, 1));
				aByte := bsr(aByte, 1);
			end;
		aDLOG := GetNewDialog(rSetPort + gHasColor, nil, Pointer(-1));
		SetPort(aDLOG);
		for n := 4 to 11 do
			SetBtnState(aDLOG, n, BtnState[n]);
{solange Eingaben zulassen bis RETURN, Abbruch oder OK gedrckt}
		aByte := InputState;
		repeat
			GetDItem(aDLOG, 1, ItemType, ItemHdl, ItemBox);
			PenSize(3, 3);										{ OK-Button stetig neu defaulten }
			InsetRect(Itembox, -4, -4);
			FrameRoundRect(ItemBox, 16, 16);
			ParamText(char(PortNr + 48), '', '', '');
			GetDItem(aDLOG, iPortStr, ItemType, ItemHdl, ItemBox);
			SetIText(Itemhdl, ByteToHex(aByte));      					{Default-Text einsetzen}
			SelIText(aDLOG, iPortStr, 0, kCtrlOn);     		{Default-Text hiliten}
			ModalDialog(nil, item);
			case item of
				4..11: 
					begin
						BtnState[item] := not BtnState[item];					{ Status invertieren }
						SetBtnState(aDLOG, item, BtnState[item]);
						for n := 11 downto 4 do
							aByte := bsl(aByte, 1) + byte(BtnState[n]);
						if PortNr = 0 then
							sendADB(gADBDevice * 16 + kADBListen, kP0fc, aByte)
						else
							sendADB(gADBDevice * 16 + kADBListen, kP1fc, aByte);
					end;
			end;
		until (item = OK) or (item = 22);   									{ RETURN entspricht OK}
		for n := 11 downto 4 do
			aByte := bsl(aByte, 1) + byte(BtnState[n]);
		SetPortDialog := aByte;
		DisposDialog(aDLOG);
	end;

{$S Main}
	procedure aboutMacIntf (Laenge: Integer);
{ ber... -Meldung als selbstterminierender Dialog }
		var
			aDLOG: DialogPtr;
			n: Integer;
			m: LongInt;
			ItemHit: Integer;
			dEvent: eventRecord;
	begin
		n := 0;
		ParamText(gVersion, '', '', '');
		aDlog := GetNewDialog(rAboutDialog + gHasColor, nil, Pointer(-1));
		Drawdialog(aDLOG);
		repeat
			Delay(6, m);
			n := n + 1;
			if WaitNextEvent(everyEvent, dEvent, 30, nil) then
				if dEvent.what = KeyDown then
					n := Laenge  										{Taste gedrckt?}
				else if IsDialogEvent(dEvent) then
					if DialogSelect(dEvent, aDlog, ItemHit) then
						n := Laenge;
		until n = Laenge;
		DisposDialog(aDlog);
	end;

{**************************** app specific menu handlers **********************************}

{$S Main}
	procedure DoADBMenu (menuItem: Integer);
{ Auswahlen im ADB-Men behandeln }
		var
			n: integer;
			bStr: Str255;
			aDLOG: DialogPtr;
			delayVal: LongInt;
			ItemType, Item: Integer;
			ItemHdl: Handle;
			ItemBox: Rect;
	begin
		case menuItem of
			iTimLis: 
				begin
					GetIndString(aStr, kMessStrings, nEnterDelay);
					delayVal := 3;
					if ValueDialog(delayVal, aStr) then
						begin
							GetIndString(aStr, kMessStrings, nClick);
							GetIndString(bStr, kMessStrings, nListen1);
							ParamText(aStr, bStr, '', '');
							aDLOG := GetNewDialog(rMessDialog, nil, Pointer(-1));
							Drawdialog(aDLOG);
							n := 0;
							repeat
								n := n + 1;
								if n = 256 then
									n := 0;
								sendADB(gADBDevice * 16 + kADBListen, kP1fc, n);
								Delay(delayVal, aLongInt);
							until button;
							DisposDialog(aDLOG);
						end;
				end;
			iTimTalk: 
				begin
					GetIndString(aStr, kMessStrings, nEnterDelay);
					delayVal := 3;
					if ValueDialog(delayVal, aStr) then
						begin
							GetIndString(aStr, kMessStrings, nClick);
							GetIndString(bStr, kMessStrings, nTalk3);
							ParamText(aStr, bStr, '', '');
							aDLOG := GetNewDialog(rMessDialog, nil, Pointer(-1));
							Drawdialog(aDLOG);
							repeat
								sendADB(gADBDevice * 16 + kADBTalk + 3, 0, 0);
								Delay(2, aLongInt);
							until button;
							DisposDialog(aDLOG);
						end;
				end;
			iCustom: 
				CustomCmdDialog;
			iADBinfo: 
				showADBInfo;
			iADBReInit: 
				begin
					GetIndString(aStr, kMessStrings, nWait);
					ParamText(aStr, '', '', '');
					aDLOG := GetNewDialog(rMessDialog, nil, Pointer(-1));
					Drawdialog(aDLOG);
					ADBReInit;
					InitADB;
					DisposDialog(aDLOG);
					showADBInfo;
				end;
			iNewDev: 
				begin
					aLongInt := gADBDevice;
					GetIndString(aStr, kMessStrings, nNewDevice);
					if ValueDialog(aLongInt, aStr) then
						begin
							if (aLongInt > 15) or (aLongInt < 1) then
								AlertUser(eADBDevAd)
							else
								begin
									gADBDevice := aLongInt;
									GetDItem(gCustomDLOG, iCmdStr, ItemType, ItemHdl, ItemBox);
									SetIText(Itemhdl, ByteToHex(16 * gADBDevice + gADBCmd + gADBreg));      			{ insert new gADBCmd value }
								end;
						end;
				end;
			iTalkAll: 
				begin
					for n := 0 to 3 do
						begin
							recvADB(gADBDevice * 16 + kADBTalk + n, 0, 0);
							Delay(2, aLongInt);
						end;
				end;
		end;
	end;


{$S Main}
	procedure DoIntfMenu (menuItem: Integer);
{ Auswahlen im MacInterface-Men behandeln }
		var
			b: byte;
			n: Integer;
			bStr: Str255;
	begin
		case menuItem of
			iSet0: 
				gPort0 := SetPortDialog(0, gPort0);
			iSet1: 
				gPort1 := SetPortDialog(1, gPort1);
			iSetBd: 
				begin
					gSerBd := SetBaudDialog(gSerBd);
					case gSerBd of
						4: 
							b := 3;
						5: 
							b := 12;
						6: 
							b := 24;
						7: 
							b := 48;
						9: 
							b := 192;
						otherwise
							b := 96;
					end;
					sendADB(gADBDevice * 16 + kADBListen, kBdfc, b);
				end;
			iSendSer: 
				begin
					GetIndString(aStr, kMessStrings, nHelloSerial);
					GetIndString(bStr, kMessStrings, nEnterString);
					if StrDialog(aStr, bStr) then
						for n := 1 to length(aStr) do
							begin
								b := byte(aStr[n]);
								sendADB(gADBDevice * 16 + kADBListen, kSerfc, b);
								delay(1, aLongInt);
							end;
				end;
			iSendDisp: 
				begin
					GetIndString(aStr, kMessStrings, nHelloDisplay);
					GetIndString(bStr, kMessStrings, nEnterString);
					if StrDialog(aStr, bStr) then
						for n := 1 to length(aStr) do
							begin
								b := byte(aStr[n]);
								sendADB(gADBDevice * 16 + kADBListen, kDispfc, b);
								delay(1, aLongInt);
							end;
				end;
			iReadCd: 
				begin
					sendADB(gADBDevice * 16 + kADBListen, kCdRdfc, 0);
				end;
			iChars: 
				begin
					gChars := not gChars;
					CheckItem(GetMenu(mIntf), iChars, gChars);
				end;
			iDebug: 
				begin
					gDebug := not gDebug;
					CheckItem(GetMenu(mIntf), iDebug, gDebug);
					sendADB(gADBDevice * 16 + kADBListen, kDevConfc, byte(gDebug));
				end;
		end;
	end;

{*****************************************************************************}


{$S Main}
	procedure DoMenuCommand (menuResult: LONGINT);
{ Menbefehl ausfhren }

		var
			menuID, menuItem: INTEGER;
			itemHit, daRefNum: INTEGER;
			daName: Str255;
			ignoreResult, saveErr: OSErr;
			handledByDA: BOOLEAN;
			te: TEHandle;
			window: WindowPtr;
			ignore: BOOLEAN;
			aHandle: Handle;
			oldSize, newSize: LongInt;
			total, contig: LongInt;

	begin
		window := FrontDocWindow;
		menuID := HiWrd(menuResult);	{use built-ins (for efficiency)...}
		menuItem := LoWrd(menuResult);	{to get menu item number and menu number}
		case menuID of

			mApple: 
				case menuItem of
					iAbout:				{bring up alert for About, 5 sec. }
						aboutMacIntf(50);
					otherwise
						begin		{all non-About items in this menu are DAs}
							GetItem(GetMHandle(mApple), menuItem, daName);
							daRefNum := OpenDeskAcc(daName);
						end;
				end;

			mFile: 
				case menuItem of
					iNew: 
						DoNew;
					iClose: 
						begin
							ignore := DoCloseWindow(window); {we don't care if cancelled}
						end;
					iErase: 
						if window <> nil then
							begin
								te := DocumentPeek(window)^.docTE;
								TESetSelect(0, 32767, te);
								TEDelete(te);
							end;
					iQuit: 
						Terminate;
				end;

			mEdit: 
				begin				{call SystemEdit for DA editing & MultiFinder}
					if not SystemEdit(menuItem - 1) then
						begin
							te := DocumentPeek(window)^.docTE;
							case menuItem of

								iCut: 
									begin		{after cutting, export the TE scrap}
										if ZeroScrap = noErr then
											begin
												PurgeSpace(total, contig);
												if (te^^.selEnd - te^^.selStart) + kTESlop > contig then
													AlertUser(eNoSpaceCut)
												else
													begin
														TECut(te);
														if TEToScrap <> noErr then
															begin
																AlertUser(eNoCut);
																ignoreResult := ZeroScrap;
															end;
													end;
											end;
									end;

								iCopy: 
									begin	{after copying, export the TE scrap}
										if ZeroScrap = noErr then
											begin
												TECopy(te);
												if TEToScrap <> noErr then
													begin
														AlertUser(eNoCopy);
														ignoreResult := ZeroScrap;
													end;
											end;
									end;

								iPaste: 
									begin	{import the TE scrap before pasting}
										if TEFromScrap = noErr then
											begin
												if TEGetScrapLen + (te^^.teLength - (te^^.selEnd - te^^.selStart)) > kMaxTELength then
													AlertUser(eExceedPaste)
												else
													begin
														aHandle := Handle(TEGetText(te));
														oldSize := GetHandleSize(aHandle);
														newSize := oldSize + TEGetScrapLen + kTESlop;
														SetHandleSize(aHandle, newSize);
														saveErr := MemError;
														SetHandleSize(aHandle, oldSize);
														if saveErr <> noErr then
															AlertUser(eNoSpacePaste)
														else
															TEPaste(te);
													end;
											end
										else
											AlertUser(eNoPaste);
									end;

								iClear: 
									TEDelete(te);

							end;
							AdjustScrollbars(window, FALSE);
							AdjustTE(window);
						end;
				end;

			mADB: 
				DoADBMenu(menuItem);
			mIntf: 
				DoIntfMenu(menuItem);

		end;
		HiliteMenu(0);					{unhighlight what MenuSelect (or MenuKey) hilited}
	end; {DoMenuCommand}


{$S Main}
	procedure DrawWindow (window: WindowPtr);
{ Fenster komplett anzeigen }

	begin
		SetPort(window);
		with window^ do
			begin
				EraseRect(portRect);			{as per TextEdit chapter of Inside Macintosh}
				DrawControls(window);		{this ordering makes for a better appearance}
				DrawGrowIcon(window);
				TEUpdate(portRect, DocumentPeek(window)^.docTE);
			end;
	end; {DrawWindow}


{$S Main}
	function GetSleep: LONGINT;
{ Angemessene Sleep Value berechnen }

		var
			sleep: LONGINT;
			window: WindowPtr;

	begin
		sleep := MAXLONGINT;						{default value for sleep}
		if not gInBackground then
			begin			{if we are in front...}
				window := FrontWindow;			{and the front window is ours...}
				if IsAppWindow(window) then
					begin
						with DocumentPeek(window)^.docTE^^ do
							if selStart = selEnd then	{and the selection is an insertion point...}
								sleep := GetCaretTime;	{we need to blink the insertion point}
					end;
			end;
		GetSleep := sleep;
	end; {GetSleep}


{$S Main}
	procedure CommonAction (control: ControlHandle; var amount: INTEGER);
{ Gemeinsamer Teil von VActionProc und HActionProc }

		var
			value, max: INTEGER;
			window: WindowPtr;
	begin
		value := GetCtlValue(control);	{get current value}
		max := GetCtlMax(control);		{and max value}
		amount := value - amount;
		if amount < 0 then
			amount := 0
		else if amount > max then
			amount := max;
		SetCtlValue(control, amount);
		amount := value - amount;		{calculate true change}
	end; {CommonAction}


{$S Main}
	procedure VActionProc (control: ControlHandle; part: INTEGER);
{ Entscheidet, was bei Bettigung des vertikalen Scrollbars zu tun ist }

		var
			amount: INTEGER;
			window: WindowPtr;
	begin
		if part <> 0 then
			begin
				window := control^^.contrlOwner;
				with DocumentPeek(window)^, DocumentPeek(window)^.docTE^^ do
					begin
						case part of
							inUpButton, inDownButton:
{ eine Zeile beim Klick in die Pfeile }
								amount := 1;
							inPageUp, inPageDown:
{ eine ganze Seite rauf/runter }
								amount := (viewRect.bottom - viewRect.top) div lineHeight;
						end;
						if (part = inDownButton) | (part = inPageDown) then
							amount := -amount;			{ rckwrts }
						CommonAction(control, amount);
						if amount <> 0 then
							TEScroll(0, amount * docTE^^.lineHeight, docTE);
					end;
			end;
	end; {VActionProc}


{$S Main}
	procedure HActionProc (control: ControlHandle; part: INTEGER);
{ Entscheidet, was bei Bettigung des horizontalen Scrollbars zu tun ist }

		var
			amount: INTEGER;
			window: WindowPtr;
	begin
		if part <> 0 then
			begin
				window := control^^.contrlOwner;
				with DocumentPeek(window)^, DocumentPeek(window)^.docTE^^ do
					begin
						case part of
							inUpButton, inDownButton:
{ einige Pixel beim Klick in die Pfeile }
								amount := kButtonScroll;
							inPageUp, inPageDown:
{ ein ganzer Seiteninhalt }
								amount := viewRect.right - viewRect.left;
						end;
						if (part = inDownButton) | (part = inPageDown) then
							amount := -amount;												{ rckwrts }
						CommonAction(control, amount);
						if amount <> 0 then
							TEScroll(amount, 0, docTE);
					end;
			end;
	end; {HActionProc}




{$S Main}
	procedure DoKeyDown (event: EventRecord);
{ Normale Key-Downs (Texteingabe) behandeln }

		var
			window: WindowPtr;
			key: CHAR;
			te: TEHandle;
			amount: integer;
	begin
		window := FrontWindow;
		if IsAppWindow(window) then
			begin
				te := DocumentPeek(window)^.docTE;
				key := CHR(BAnd(event.message, charCodeMask));
{ PgUp oder PageDown? }
				case ord(key) of
					kPgUp: 
						VActionProc(DocumentPeek(window)^.docVScroll, inPageUp);
					kPgDown: 
						VActionProc(DocumentPeek(window)^.docVScroll, inPageDown);
					kHome: 
						begin
							TESetSelect(0, 0, te);
							AdjustScrollbars(window, False);
						end;
					kEnd: 
						begin
							TESetSelect(kMaxTELength, kMaxTELength, te);
							AdjustScrollbars(window, False);
						end;
					kFwdDel: 
						begin
							key := chr(kCursFwd);
							TEKey(key, te);
							key := chr(kDelChar);
							TEKey(key, te);
							AdjustScrollbars(window, FALSE);
							AdjustTE(window);
						end;
					otherwise
						if (key = CHR(kDelChar)) | (te^^.teLength - (te^^.selEnd - te^^.selStart) + 1 < kMaxTELength) then							{don't count deletes}
							begin	{but check haven't gone past}
								TEKey(key, te);
								AdjustScrollbars(window, FALSE);
								AdjustTE(window);
							end
						else
							AlertUser(eExceedChar);
				end;
			end;
	end; {DoKeyDown}


{$S Main}
	procedure DoContentClick (window: WindowPtr; event: EventRecord);
{ Mouse-downs im Fenster behandeln }

		var
			mouse: Point;
			control: ControlHandle;
			part, value: INTEGER;
			shiftDown: BOOLEAN;
			teRect: Rect;

	begin
		if IsAppWindow(window) then
			begin
				SetPort(window);
				mouse := event.where;											{get the click position}
				GlobalToLocal(mouse);											{convert to local coordinates}
		{see if we are in the viewRect. if so, we wont check the controls}
				GetTERect(window, teRect);
				if PtInRect(mouse, teRect) then
					begin
						shiftDown := BAnd(event.modifiers, shiftKey) <> 0;	{extend if Shift is down}
						TEClick(mouse, shiftDown, DocumentPeek(window)^.docTE);
					end
				else
					begin
						part := FindControl(mouse, window, control);
						with DocumentPeek(window)^ do
							case part of
								0: 
									;											{do nothing for viewRect case}
								inThumb: 
									begin
										value := GetCtlValue(control);
										part := TrackControl(control, mouse, nil);
										if part <> 0 then
											begin
												value := value - GetCtlValue(control);
												if value <> 0 then
													if control = docVScroll then
														TEScroll(0, value * docTE^^.lineHeight, docTE)
													else
														TEScroll(value, 0, docTE);
											end;
									end;
								otherwise									{must be page or button}
									if control = docVScroll then
										value := TrackControl(control, mouse, @VActionProc)
									else
										value := TrackControl(control, mouse, @HActionProc);
							end;
					end;
			end;
	end; {DoContentClick}


{$S Main}
	procedure ResizeWindow (window: WindowPtr);
{ Grennderung des Fensters, neue Scrollbars usw. }

	begin
		with window^ do
			begin
				AdjustScrollbars(window, TRUE);
				AdjustTE(window);
				InvalRect(portRect);
			end;
	end; {ResizeWindow}


{$S Main}
	procedure GetLocalUpdateRgn (window: WindowPtr; localRgn: RgnHandle);
{ liefert Update-Region in lokalen Koordinaten }

	begin
		CopyRgn(WindowPeek(window)^.updateRgn, localRgn);						{save old update region}
		with window^.portBits.bounds do
			OffsetRgn(localRgn, left, top);										{convert to local coords}
	end; {GetLocalUpdateRgn}


{$S Main}
	procedure DoGrowWindow (window: WindowPtr; event: EventRecord);
{ Fenster vergrern/verkleinen. Was ntig, neu zeichnen. }
{ Bereits vorhandene Region bestehen lassen. }

		var
			growResult: LONGINT;
			tempRect: Rect;
			tempRgn: RgnHandle;
			ignoreResult: BOOLEAN;

	begin
		with screenBits.bounds do
{ Grenzen des Wachstums: maximale Gre des Schirms }
			SetRect(tempRect, kMinDocDim, kMinDocDim, right, bottom);
		growResult := GrowWindow(window, event.where, tempRect);
		if growResult <> 0 then 		{ berhaupt verndert? }
			with DocumentPeek(window)^, window^ do
				begin
					tempRect := docTE^^.viewRect;									{save old text box}
					tempRgn := NewRgn;
					GetLocalUpdateRgn(window, tempRgn);						{ vorhandene Anzeige-Region }
					SizeWindow(window, LoWrd(growResult), HiWrd(growResult), TRUE);
					ResizeWindow(window);
{ Berechnen, was gleich geblieben ist }
					ignoreResult := SectRect(tempRect, docTE^^.viewRect, tempRect);
					ValidRect(tempRect);											{ vom Update entfernen }
					InvalRgn(tempRgn);
					DisposeRgn(tempRgn);
				end;
	end; {DoGrowWindow}


{$S Main}
	procedure DoZoomWindow (window: WindowPtr; part: INTEGER);
{ Zoom-Box angeklickt: alles neu zeichnen }

	begin
		with window^ do
			begin
				EraseRect(portRect);
				ZoomWindow(window, part, (window = FrontWindow));
				ResizeWindow(window);
			end;
	end; {DoZoomWindow}


{$S Main}
	procedure DoUpdate (window: WindowPtr);
{ Update des Fensters, aber nur, wenn ntig (visRgn nicht leer)}

	begin
		if IsAppWindow(window) then
			begin
				BeginUpdate(window);					{this sets up the visRgn}
				if not EmptyRgn(window^.visRgn) then	{draw if updating needs to be done}
					DrawWindow(window);
				EndUpdate(window);
			end;
	end; {DoUpdate}


{$S Main}
	procedure DoActivate (window: WindowPtr; becomingActive: BOOLEAN);
{ Fenster wird an- oder abgeschaltet. }

		var
			tempRgn, clipRgn: RgnHandle;
			growRect: Rect;

	begin
		if IsAppWindow(window) then
			with DocumentPeek(window)^ do
				if becomingActive then
					begin
{ Damit TEActivate keine Selektion in einem Bereich anzeigt, der gelscht }
{ und neu gezeichnet werden soll, wird diese Region vorher ausgeschnitten. }
						tempRgn := NewRgn;
						clipRgn := NewRgn;
						GetLocalUpdateRgn(window, tempRgn);			{ lokale Update-Region }
						GetClip(clipRgn);
						DiffRgn(clipRgn, tempRgn, tempRgn);			{ von clipRgn abziehen }
						SetClip(tempRgn);
						TEActivate(docTE);							{ TE malt drauflos }
						SetClip(clipRgn);							{ beschdigte clipRgn wiederherstellen }
						DisposeRgn(tempRgn);
						DisposeRgn(clipRgn);

{ ScrollBars und GrowBox anzeigen, waren ausgeschaltet }
						docVScroll^^.contrlVis := kCtrlOn;
						docHScroll^^.contrlVis := kCtrlOn;
						InvalRect(docVScroll^^.contrlRect);
						InvalRect(docHScroll^^.contrlRect);
						growRect := window^.portRect;
						with growRect do
							begin
								top := bottom - kScrollbarAdjust;
								left := right - kScrollbarAdjust;
							end;
						InvalRect(growRect);
					end
				else
					begin
{ TE, ScrollBars abschalten, GrowBox bleibt }
						TEDeactivate(docTE);
						HideControl(docVScroll);
						HideControl(docHScroll);
						DrawGrowIcon(window);
					end;
	end; {DoActivate}


{$S Main}
	procedure AdjustCursor (mouse: Point; region: RgnHandle);
{ Stellt  Maus-Cursor auf richtige Form, wenn Edit-Fenster ganz oben liegt }

		var
			window: WindowPtr;
			arrowRgn: RgnHandle;
			iBeamRgn: RgnHandle;
			iBeamRect: Rect;

	begin
		window := FrontWindow;	{we only adjust the cursor when we are in front}
		if (not gInBackground) and (not IsDAWindow(window)) then
			begin
		{calculate regions for different cursor shapes}
				arrowRgn := NewRgn;
				iBeamRgn := NewRgn;

		{start with a big, big rectangular region}
				SetRectRgn(arrowRgn, kExtremeNeg, kExtremeNeg, kExtremePos, kExtremePos);

		{calculate iBeamRgn}
				if IsAppWindow(window) then
					begin
						iBeamRect := DocumentPeek(window)^.docTE^^.viewRect;
						SetPort(window);					{make a global version of the viewRect}
						with iBeamRect do
							begin
								LocalToGlobal(topLeft);
								LocalToGlobal(botRight);
							end;
						RectRgn(iBeamRgn, iBeamRect);
						with window^.portBits.bounds do
							SetOrigin(-left, -top);
						SectRgn(iBeamRgn, window^.visRgn, iBeamRgn);
						SetOrigin(0, 0);
					end;

		{subtract other regions from arrowRgn}
				DiffRgn(arrowRgn, iBeamRgn, arrowRgn);

		{change the cursor and the region parameter}
				if PtInRgn(mouse, iBeamRgn) then
					begin
						SetCursor(GetCursor(iBeamCursor)^^);
						CopyRgn(iBeamRgn, region);
					end
				else
					begin
						SetCursor(arrow);
						CopyRgn(arrowRgn, region);
					end;

		{get rid of our local regions}
				DisposeRgn(arrowRgn);
				DisposeRgn(iBeamRgn);
			end;
	end; {AdjustCursor}

	procedure DoIdle (event: EventRecord);
		var
			window: WindowPtr;
			whichDLOG: DialogPtr;
			ItemHit: Integer;
{ If you are using modeless dialogs that have editText items,}
{ you will want to call IsDialogEvent to give the caret a chance}
{ to blink, even if WNE/GNE returned FALSE. However, check FrontWindow}
{ for a non-NIL value before calling IsDialogEvent.}
	begin
		window := FrontWindow;
		if IsAppWindow(window) then
			TEIdle(DocumentPeek(window)^.docTE);
		if window <> nil then
			if isDialogEvent(event) then
				if DialogSelect(Event, whichDlog, itemHit) then
					;
	end;

{$S Main}
	procedure DoEvent (event: EventRecord);

{Do the right thing for an event. Determine what kind of event it is, and call}
{ the appropriate routines.}

		var
			part, err: INTEGER;
			window: WindowPtr;
			key: CHAR;
			ignore: BOOLEAN;
			aPoint: Point;

	begin
		if event.what = app1Evt then
{ hier abfragen, geht sonst in IsDialogEvent unter }
			DoApp1Evt(event.message);
		if IsDialogEvent(Event) then
			DoDialogs(Event)
		else
			case event.what of
				nullEvent: 
					DoIdle(event);
				mouseDown: 
					begin
						part := FindWindow(event.where, window);
						case part of
							inMenuBar: 
								begin
									Adjustmenus;
									DoMenuCommand(MenuSelect(event.where));
								end;
							inSysWindow: 
								SystemClick(event, window);
							inContent: 
								if window <> FrontWindow then
									begin
										SelectWindow(window);
						{DoEvent(event);}
	{use this line for "do first click"}
									end
								else
									DoContentClick(window, event);
							inDrag: 
								DragWindow(window, event.where, screenBits.bounds);
							inGrow: 
								DoGrowWindow(window, event);
							inGoAway: 
								if TrackGoAway(window, event.where) then
									ignore := DoCloseWindow(window);		{we don't care if cancelled}
							inZoomIn, inZoomOut: 
								if TrackBox(window, event.where, part) then
									DoZoomWindow(window, part);
						end;
					end;
				keyDown, autoKey: 
					begin
						key := CHR(BAnd(event.message, charCodeMask));
						if BAnd(event.modifiers, cmdKey) <> 0 then
							begin	{Command key down}
								if event.what = keyDown then
									begin
										Adjustmenus;			{enable/disable/check menu items properly}
										DoMenuCommand(MenuKey(key));
									end;
							end
						else
							DoKeyDown(event);
					end;								{call DoActivate with the window and...}
				activateEvt:						{TRUE for activate, FALSE for deactivate}
					DoActivate(WindowPtr(event.message), BAnd(event.modifiers, activeFlag) <> 0);
				updateEvt:							{call DoUpdate with the window to update}
					DoUpdate(WindowPtr(event.message));
		{1.01 - It is not a bad idea to at least call DIBadMount in response}
{		 to a diskEvt, so that the user can format a floppy.}
				diskEvt: 
					if HiWrd(event.message) <> noErr then
						begin
							SetPt(aPoint, kDILeft, kDITop);
							err := DIBadMount(aPoint, event.message);
						end;
				kOSEvent: 
					case BAnd(BRotL(event.message, 8), $FF) of	{high byte of message}
						kMouseMovedMessage: 
							DoIdle(event);					{mouse moved is also an idle event}
						kSuspendResumeMessage: 
							begin
								gInBackground := BAnd(event.message, kResumeMask) = 0;
								DoActivate(FrontWindow, not gInBackground);
							end;
					end;
			end;
	end; {DoEvent}


{$S Main}
	procedure EventLoop;

{Get events forever, and handle them by calling DoEvent.}
{ Also call AdjustCursor each time through the loop.}

		var
			cursorRgn: RgnHandle;
			gotEvent: BOOLEAN;
			event: EventRecord;
			mouse: Point;

	begin
		cursorRgn := NewRgn;		{we'll pass an empty region to WNE the first time thru}
		repeat
			if gHasWaitNextEvent then
				begin	{put us 'asleep' forever under MultiFinder}
					if OSEventAvail(kNoEvents, event) then
						;
					AdjustCursor(event.where, cursorRgn);
					gotEvent := WaitNextEvent(everyEvent, event, GetSleep, cursorRgn);
				end
			else
				begin
					SystemTask;					{must be called if using GetNextEvent}
					gotEvent := GetNextEvent(everyEvent, event);
				end;
			if gotEvent then
				begin
					AdjustCursor(event.where, cursorRgn);	{make sure we have the right cursor}
					DoEvent(event);				{Handle the event only if for us.}
				end
			else
				DoIdle(event);
		until FALSE;	{loop forever}
	end; {EventLoop}


{$S Main}
begin

	{1.01 - call to ForceEnvirons removed}
	{If you have stack requirements that differ from the default,}
{	 then you could use SetApplLimit to increase StackSpace at }
{	 this point, before calling MaxApplZone.}

	MaxApplZone;			{expand the heap so code segments load at the top}

	Initialize;				{initialize the program}
	UnloadSeg(@Initialize);	{note that Initialize must not be in Main!}

	EventLoop;				{call the main event loop}
end.


{ "message" in echten Buffer umkopieren und in Custom-Dialog Textfeld einsetzen }
aChar := char(band(message, $FF));
tADBCmd := bsr(band(message, $FF000000), 24);
tADBopBuf[0] := bsr(band(message, $FF0000), 16);
tADBopBuf[1] := bsr(band(message, $FF00), 8);
tADBopBuf[2] := band(message, $FF);
aStr := '';
if tADBopBuf[0] > 1 then
	for n := 1 to tADBopBuf[0] do
		aStr := concat(aStr, ByteToHex(tADBopBuf[n]), ' ');
GetDItem(gCustomDLOG, iDataStr, ItemType, ItemHdl, ItemBox);
SetIText(Itemhdl, aStr);      			{Default-Text einsetzen}
SelIText(gCustomDLOG, iDataStr, 0, kCtrlOn);     		{Default-Text hiliten}

{ letzten (zurckgelieferten) Befehl in Custom-Dialog Textfeld einsetzen }
{    GetDItem(gCustomDLOG, iCmdStr, ItemType, ItemHdl, ItemBox);}
{    SetIText(Itemhdl, ByteToHex(tADBCmd));}
