Unit NWBasic;

{ NetWare-API-Funktionen unter Turbo/Borland Pascal
  (C) Copyright 1994 Alexander Schulze }

Interface

Uses
 Dos, NWHilf;

Const
 DefaultServerName  = 'OPUS'; { sollte in Ihrer Anwendung eingebbar sein! }

 { IDs der einzelnen VLMs }
 vlm_id_VLM         = $0001;
 vlm_id_CONN        = $0010;
 vlm_id_TRAN        = $0020;
 vlm_id_NWP         = $0030;
 vlm_id_BIND        = $0031;
 vlm_id_PRINT       = $0042;
 vlm_id_NetX        = $0050;

 { Die VLM-Funktions-Nummern }
 NWP_CON            = $04;
 NWP_DIS            = $05;
 NWP_LIN            = $08;
 NWP_LOUT           = $09;

 CONN_ALO           = $04;
 CONN_FRE           = $06;
 CONN_LUP           = $0A;

 CEI_TRAN_BUFF      = $11;

 { Maximal-Konstanten }
 MaxNetWareVolumes  =   32;            { Achtung! Zhlung beginnt bei 0 }

 MaxReceiver        =  100;            { Empfnger bei Broadcast-Messages }
 MaxQueueJobs       =  250;            { Anzahl Jobs pro Queue }
 MaxServer          =    8;            { Anzahl Verbindungen zu Servern }
 MaxXfrBuffSize     = 1024;            { Gre der betragungspuffer }

 { Broadcast-Modi }
 bm_AutoServAndUser = $00; { Autom. Zustellen von Server- und Benutzernachr. }
 bm_AutoServNoUser  = $01; { Autom. Zustellen nur von Servernachrichten }
 bm_PollServNoUser  = $02; { Manuelles Abholen nur von Servernachrichten }
 bm_PollServAndUser = $03; { Manuelles Abholen von Server- und Benutzernachr. }

 { Completion Codes }
 cc_Success         = 0;               { erfolgreiche Durchfhrung }

 { Capture-Stati }
 cs_NotActive       = $00;
 cs_Active          = $FF;

 { Capture Print Flags }
 cpf_Standard       = $00;
 cpf_JobRelease     = $04;
 cpf_AutoFormFeed   = $08;
 cpf_TabInterpret   = $40;
 cpf_BannerPage     = $80;


 { Drv-Flags }
 df_NotAllocated          = $00;
 df_PermanentNetworkDrv   = $01;
 df_TemporaryNetworkDrv   = $02;
 df_LocalDrv              = $80;
 df_LocalAllocToPermNWDrv = $81;
 df_LocalAllocToTempNWDrv = $82;

 { Objekt-Flags, statisch oder dynamisch }
 of_Static          = $00;
 of_Dynamic         = $01;

 { Novell Objekt-Typen (ObjectTypes) }
 ot_Wild            = $FFFF;
 ot_Unknown         = $0000;
 ot_User            = $0001;
 ot_UserGroup       = $0002;
 ot_PrintQueue      = $0003;
 ot_FileServer      = $0004;
 ot_JobServer       = $0005;
 ot_Gateway         = $0006;
 ot_PrintServer     = $0007;
 ot_ArchiveQueue    = $0008;
 ot_ArchiveServer   = $0009;
 ot_JobQueue        = $000A;
 ot_Administration  = $000B;
 ot_RemBridgeServer = $0026;
 ot_AdvPrintServer  = $0047;

 { Objekt-Zugriffsrechte (ObjectSecurity) }
 os_Anyone          = $00;
 os_Logged          = $01;
 os_Object          = $02;
 os_Supervisor      = $03;
 os_Netware         = $04;

 { Port-Nummer Printer }
 pn_LPT1            = $00;
 pn_LPT2            = $01;
 pn_LPT3            = $02;

{ --- Typen Defintionen --- }
Type
 TFSNameStr         = String[47];
 TObjNameStr        = String[47];
 TVolumeStr         = String[16];
 TQueueStr          = String[16];
 TQueuePath         = String[47+1+16];
 TStr80             = String[80];

 { Puffer fr Datenbertragungen }
 TRep = Array[0..Pred(MaxXfrBuffSize)] of { Char oder } Byte;
 TReq = Array[0..Pred(MaxXfrBuffSize)] of { Char oder } Byte;

 TAddReq =
  Record
   ReqLen     : Word;
   ReqCommand : Byte;
   ReqData    : Array[0..SizeOf(TReq)-3] of Char
  End;

 TBinderyObject =
  Record
   bo_ID       : LongInt;
   bo_Typ      : Word;
   bo_Name     : TObjNameStr;
   bo_Password : String[127];
   bo_Flag     : Byte;
   bo_Security : Byte;
   bo_HasProp  : Byte;
  End;

 TCaptureFlags =
  Record
   Status         : Byte;
   Flags          : Byte;
   TabSize        : Byte;
   ServerPrinter  : Byte;
   NumberOfCopies : Byte;
   FormType       : Byte;
   reserved_01    : Byte;
   BannerText     : Array[1..13] of Char;
   reserved_02    : Byte;
   LocalLPTDevice : Byte;
   FlushTimeOut   : Word;
   FlushOnDevClose: Byte;
   MaxLines       : Word;
   MaxColumns     : Word;
   FormName       : Array[1..13] of Char;
   LPTCaptureFlag : Byte;
   FileCaptureFlag: Byte;
   TimingOutFlag  : Byte;
   PPrinterSetup  : Pointer;
   PPrinterReset  : Pointer;
   ConnectID      : Byte;
   CaptureInProgr : Byte;
   PrintQueueFlag : Byte;
   PrintJobValid  : Byte;
   PrintQueueID   : LongInt;
   PrintJobNo     : Word;
  End;

 TConnectInfo =
  Record
   SlotInUse        : Byte;
   ServerOrderNo    : Byte;
   ServerNetNo      : Array[1..4] of Byte;
   PhysNodeAdr      : Array[1..6] of Byte;
   SocketNo         : Array[1..2] of Byte;
   ReceiveTimeOut   : Array[1..2] of Byte;
   RouterPhysNodeAdr: Array[1..6] of Byte;
   PacketSeqNo      : Byte;
   ConnectNo        : Byte;
   ConnectState     : Byte;
   MaximumTimeOut   : Array[1..2] of Byte;
   Filler           : Array[1..5] of Byte;
  End;

 TDrvConnectIDTable= Array[1..26] of Byte;
 TDrvFlagTable    = Array[1..26] of Byte;
 TDrvHandleTable  = Array[1..26] of Byte;

 TFileServerInfo =
  Record
   ServerName         : TFSNameStr;
   NetWareVers        : Byte;
   NetWareSubVers     : Byte;
   MaxConnections     : Word;
   UsedConnections    : Word;
   MaxConnectedVolumes: Word;
   OSRevisionNo       : Byte;
   SFTLevel           : Byte;
   TTSLevel           : Byte;
   PeakConnectionsUsed: Word;
   AccountingVers     : Byte;
   VAPVers            : Byte;
   QueuingVers        : Byte;
   PrintServerVers    : Byte;
   VirtualConsoleVers : Byte;
   SecurRestrictLevel : Byte;
   InternetBridgeVers : Byte;
   reserved           : Array[1..60] of Byte;
  End;

 TFSNameTable = Array[0..MaxServer] of TFSNameStr;

 TFSDescrStrings =
  Record
   CompanyName  : String;
   Revision     : String;
   RevisionDate : String;
   CopyrightNote: String;
  End;

 TNetworkNumber  = Array[1..4] of Byte;
 TNetworkNumberC = Array[1..4] of Char;
 TNodeAddress    = Array[1..6] of Byte;
 TNodeAddressC   = Array[1..6] of Char;

 TProperty =
  Record
   Name      : String[15];
   Flags     : Byte;
   Security  : Byte;
   SequenceNo: LongInt;
   HasValue  : Boolean
  End;

 TPropertyValue =
  Record
   Content  : String[127];
   SegmentNo: Byte;
   Flags    : Byte
  End;

 TSendList = Set of 1..MaxReceiver;

 TSocketNumber = Word;

 TOkList = Set of 1..MaxReceiver;

 TQueueJobEntry =
  Record
   ClientStation    : Byte;
   ClientTaskNr     : Byte;
   ClientID         : LongInt;
   TargetServerID   : LongInt;
   TargetExecTime   : Array[1..6] of Byte;
   JobEntryTime     : Array[1..6] of Byte;
   JobNo            : Word;
   JobType          : Word;
   JobPosition      : Byte;
   JobControlFlags  : Byte;
   JobFileName      : Array[1..14] of Char;
   JobFileHandle    : Array[1..6] of Byte;
   ServerStation    : Byte;
   ServerTaskNo     : Byte;
   ServerID         : LongInt;
   TextJobDescr     : Array[1..50] of Char;
   ClientRecArea    : Array[1..152] of Byte;
  End;

 TQueueJobList = Array[0..MaxQueueJobs] of Word;

 TQueueStatus =
  Record
   QueueID     : LongInt;
   QueueStatus : Byte;
   NoOfJobs    : Byte;
   NoOfServers : Byte;
   ServerList  :
    Array[1..25] of
     Record
      ID       : LongInt;
      ConnectNo: Byte
     End;
   MaxServer   : Byte;
  End;

 TVolumeInfo =
  Record
   SystemElapsedTimed : LongInt{Word};
   VolumeNo           : Byte;
   LogicalDrvNo       : Byte;
   SectorsPerBlock    : Word;
   StartingBlock      : LongInt{Word};
   TotalBlocks        : Word;
   AvailableBlocks    : Word;
   TotalDirSlots      : Word;
   AvailableDirSlots  : Word;
   MaxUsedDirEntries  : Word;
   VolumeIsHashed     : Boolean;
   VolumeIsCached     : Boolean;
   VolumeIsRemovable  : Boolean;
   VolumeIsMounted    : Boolean;
   VolumeName         : String[16];
  End;

Var
 { Die bertragungspuffer zwischen Anwendung und NetWare }
 Req  : TReq;
 Rep  : TRep;

Const
 { Zeiger auf die NetWare-bertragungspuffer }
 PReq : Pointer = @Req;
 PRep : Pointer = @Rep;

 { Interrupt zum Aufruf von NETX-Fuktionen }
 NetWareIntr    = $21;

 { Globale Fehlervariable hnlich IOResult oder DOSError }
 NetWareResult  : Integer = 0;

 { zustzliche Konstanten fr die VLM-Nutzung }
 ClientHandle   : Word = 0;
 VLMFarCallPtr  : Pointer = Nil;
 useVLM         : Boolean = false;

Type
 { Typ der Fragmentliste fr die VLMs }
 TFragList =
  Record
   FragPtr : Pointer;
   FragSize: LongInt;
  End;

Var
 { Die Fragmentlisten fr die VLM-Kommunikation }
 ReqFragList,
 RepFragList : TFragList;


{ Basisfunktionen }
Procedure PutInit
           (InCommand: Byte);
Procedure PutItem
           (InLen: Byte; Var InData);
Procedure GetInit
           (OutLen: Word);
Procedure GetItem
           (OutLen: Byte; Var OutData);
Function  NetWareErrMsg
           (cc: word): String;
Procedure DisplayErrorIfExist
           (ErrorCode: Word);

{ Bindery-Funktionen }
Function  ObjTypeStr
           (ObjType: Word): String;
Function  ScanBinderyObjectFirst
           (Var BindObj: TBinderyObject;
            ObjType: Word; Mask: String): Boolean;
Function  ScanBinderyObjectNext
           (Var BindObj: TBinderyObject;
            ObjType: Word; Mask: String): Boolean;
Function  ScanPropertyFirst
           (Var BinderyObject: TBinderyObject;
            Var Property: TProperty;
            Mask:String): Boolean;
Function  ScanPropertyNext
           (Var BinderyObject: TBinderyObject;
            Var Property: TProperty;
            Mask:String): Boolean;
Function  ReadPropertyValueFirst
           (Var BinderyObject: TBinderyObject;
            Var Property: TProperty;
            Var Content: String): Boolean;
Function  ReadPropertyValueNext
           (Var BinderyObject: TBinderyObject;
            Var Property: TProperty;
            Var Content: String): Boolean;
Function  GetBinderyObject
           (ID: LongInt;
            Var BinderyObject: TBinderyObject) : Byte;

{ Verbindungs-Funktionen }
Function  GetConnectionNo: Byte;
Function  GetConnectionInfo
           (No: LongInt;
            Var BinderyObject:
                TBinderyObject): Byte;
Function  GetConnectNoFromName
           (UserName: String;
            Var BinderyObject: TBinderyObject): Byte;
Function  GetStationAddress
           (Var NodeAddress: TNodeAddress): String;
Function  GetInternetAddress
           (ConnectNo: Byte;
            Var NetworkNumber: TNetworkNumber;
            Var NodeAddress  : TNodeAddress;
            Var SocketNumber : TSocketNumber): Byte;
Function  LoginToFileServer
           (Var BinderyObject: TBinderyObject): Word;
Procedure LogOut;
Function  AttachToFileServer
           (ServerName: TStr80): Word;
Function  DetachFromFileServer
           (ConnectionID: Byte): Word;

{ Fileserver-Funktionen }
Function  CheckConsolePrivileges: Boolean;
Procedure GetFileServerDateAndTime
           (Var Year,Month,Day,DayOfWeek,Hour,Min,Sec: Word);
Function  GetFileServerDescriptionStrings
           (Var FSDescrStrs: TFSDescrStrings) : Byte;
Function  GetFileServerInformation
           (Var FSInfo: TFileServerInfo) : Byte;
Function  GetBinderyObjectDiskSpaceLeft
           (ObjectID: LongInt;
            Var FreeSpace: LongInt;
            Var Restrictions: Boolean): Byte;

{ Message-Funktionen }
Function  GetBroadcastMode: Byte;
Function  SetBroadcastMode
           (Mode: Byte): Byte;
Function  SendBroadcastMessage
           (SendList: TSendList;
            Message: String): Byte;
Function  GetBroadcastMessage
           (Var Message: String): Byte;

Procedure GetDrvHandleTable
           (Var DrvHandleTable: TDrvHandleTable);
Procedure GetDrvFlagTable
           (Var DrvFlagTable: TDrvFlagTable);
Procedure GetDrvConnectIDTable
           (Var DrvConTable: TDrvConnectIDTable);

Function  GetDefaultConnectionID: Byte;
Function  GetPrimaryConnectionID: Byte;
Function  GetPreferredConnectionID: Byte;
Function  GetConnectionID
           (Var ConnectInfo: TConnectInfo): Byte;

Function  GetFileServerNameTable
           (Var FSNameTable: TFSNameTable): Byte;
Function  GetFileServerName
           (ConnectID: Byte): String;

Procedure SetPreferredConnectionID
           (ConnectID: Byte);
Procedure SetPrimaryConnectionID
           (ConnectID: Byte);

Function  ActualServerName: String;
Function  DrvFlagStr
           (DrvFlag: Byte): String;

Function  GetVolumeName
           (VolumeNo: Byte): String;
Function  GetVolumeInformation
           (VolumeNo: Byte;
            Var VolumeInfo: TVolumeInfo): Word;
Function  GetVolumeInfoWithNumber
           (VolumeNo: Byte;
            Var VolumeInfo: TVolumeInfo): Word;
Function  GetDirectoryHandle
           (DrvNo: Byte;
            Var DrvFlags: Byte): Byte;
Function  GetDirectoryPath
           (DirHandle: Byte): String;
Function  DeallocateDirectoryHandle
           (DirHandle: Byte): Byte;
Function  AllocPermanentDirectoryHandle
           (Drv: Char;
            Var DirHandle: Byte;
            Path: String): Byte;

{ Die Print-Funktionen }
Function  StartLPTCapture: Byte;
Function  EndLPTCapture: Byte;
Function  CancelLPTCapture: Byte;
Function  FlushLPTCapture: Byte;
Function  GetDefaultLocalPrinter: Byte;
Function  SetDefaultLocalPrinter
           (LPTDevice: Byte): Byte;
Function  GetLPTCaptureStatus
           (Var ConnectID: Byte): Byte;
Function  GetDefaultCaptureFlags
           (Var CaptureFlags: TCaptureFlags): Byte;
Function  SetDefaultCaptureFlags
           (Var CaptureFlags: TCaptureFlags): Byte;
Function  SetCapturePrintQueue
           (LPTDevice: Byte; QueueID: LongInt): Byte;

{ Die Queue-Funktionen }
Function  GetQueueID
           (QueueTyp: Word;
            QueueName: TQueueStr;
            Var QueueID: LongInt): Boolean;
Function  GetQueueJobList(QueueID: LongInt; Var QueueJobList: TQueueJobList): Byte;
Function  ReadQueueJobEntry
           (QueueID: LongInt;
            JobNo: Word;
            Var QueueJobEntry: TQueueJobEntry): Byte;
Function  ReadQueueCurrentStatus
           (QueueID: LongInt;
            Var QueueStatus: TQueueStatus): Byte;

{ zustzliche neue VLM-Funktionen }
Function  VLMInstalled(Var VLMFarCallPtr: Pointer): Boolean;
Function  GetVLMVersion: String;

Implementation


{  Die NetWare-Basisfunktionen  }


{ Initialisierung des Anfrage-Puffers }
Procedure PutInit(InCommand: Byte);
Begin
 FillChar(PReq^,SizeOf(TReq),0);       { Puffer lschen }
 With TAddReq(PReq^) do
  Begin
   ReqCommand:= InCommand;             { Kommando setzen }
   ReqLen:= 1                          { Bisher nur Kommando gespeichert }
  End
End;

{ Eintrag an den Anfrage-Puffer anhngen }
Procedure PutItem(InLen: Byte; Var InData);
Begin
 With TAddReq(PReq^) do
  Begin                                { Falls Lnge = 0, dann String- }
   If InLen = 0                        { bertragung mit vorangestelltem }
    then                               { Lngenbyte }
     InLen:= Succ(Mem[Seg(InData):Ofs(InData)]);
   Move(InData,ReqData[ReqLen-1],InLen);
   Inc(ReqLen,InLen)
  End
End;

{ aktuelle Auslese-Position im Antwort-Puffer }
Var
 RepPos: Word;

{ Initialisieren der Ausgabefunktion }
Procedure GetInit(OutLen: Word);
Begin
 FillChar(PRep^,SizeOf(TRep),0);
 If useVLM                             { Falls kein VLM, dann erstes Wort }
  then RepPos:= 0
  else RepPos:= 2;                     { Erste Ausleseposition }
 Word(PRep^):= OutLen                  { gleich maximale Lnge des Puffers }
End;

{ Auslesen eines Eintrags aus dem Antwort-Puffer }
Procedure GetItem(OutLen: Byte; Var OutData);
Begin
 If OutLen = 0                         { Eine Null bewirkt das Lesen eines }
  then                                 { Lngenbytes und das anschlieende }
   OutLen:= Succ(Byte(TRep(PRep^)[RepPos]));        { bertragen eines dynamischen }
                                       { Datenbereiches (Strings,Tabellen) }
 Move(TRep(PRep^)[RepPos],OutData,OutLen);
 Inc(RepPos,OutLen)
End;

{ Test, ob VLM installiert ist ber DOS-Multiplex-Interrupt 2Fh }
Function VLMInstalled(Var VLMFarCallPtr: Pointer): Boolean;
Var
 Regs: Registers;
 Ok  : Boolean;
Begin
 With Regs do
  Begin
   ax:= $7A20;
   bx:= 0;
   Intr($2F,Regs);
   Ok:= ax = 0;
   If Ok
    then VLMFarCallPtr:= Ptr(es,bx)
    else VLMFarCallPtr:= Nil;

   VLMInstalled:= Ok
  End
End;

{ Der Aufruf der VLM-Routine ber FAR CALL Einsprung }
Function VLM_Call(VLMID: Word; DestFunc: Word; Var Regs: Registers): Word;
 Assembler;
Var
 VlmAdr: Pointer;
ASM
 PUSH  DS                              { Datensegment sichern }

 LDS   SI, VLMFarCallPtr               { Einsprung-Adresse holen und ... }
 MOV   WORD PTR VlmAdr, SI             { in lokale Variable kopieren, weil: }
 MOV   WORD PTR VlmAdr + 2, DS         { Datensegment ist bereits verloren }

 LDS   SI, Regs                        { Adresse der Register-Var. holen }
 MOV   AX, [SI   ]                     { und in die einzelnen Register }
 MOV   BX, [SI+02]                     { bertragen }
 MOV   CX, [SI+04]
 MOV   DX, [SI+06]
 MOV   DI, [SI+12]
 MOV   ES, [SI+16]
 PUSH  AX                              { [AX] sichern }
 MOV   AX, [SI+10]                     { Segmentregister ber den Stack }
 PUSH  AX                              { aus der Registervariablen laden }
 MOV   AX, [SI+14]
 PUSH  AX
 POP   DS
 POP   SI
 POP   AX                              { [AX] wieder herstellen }

 PUSH  0                               { Caller ID (Appl) auf den Stack }
 PUSH  VLMID                           { VLM ID auf den Stack }
 PUSH  DestFunc                        { Funktions-Nummer auf den Stack }

 CALL  DWORD PTR VLMAdr                { VLM-Funktion aufrufen }

 LES   DI, Regs                        { ES:DI brauchen wir nicht mehr }
 MOV   ES:[DI   ], AX                  { Jetzt knnen alle Register in }
 MOV   ES:[DI+02], BX                  { unsere Register-Variable zurck- }
 MOV   ES:[DI+04], CX                  { geschrieben werden }
 MOV   ES:[DI+06], DX
 MOV   ES:[DI+10], SI
 MOV   ES:[DI+14], DS

 POP   DS                              { Datensegment wieder herstellen }
END;

Function GetVLMVersion: String;
Var
 Regs: Registers;
Begin
 With Regs do
  Begin
   bx:= 0;
   VLM_Call(vlm_id_VLM,$0001,Regs);
   GetVLMVersion:= NrToStr(bx,0) + '.' + NrToStr(cx,0)
  End
End;

Function _ConnAllocHandle(Var Handle: Word): Word;
Var
 Regs: Registers;
Begin
 _ConnAllocHandle:= $8801;

 With Regs do
  Begin
   VLM_Call(vlm_id_CONN,CONN_ALO,Regs);
   If ax = cc_Success
    then
     Begin
      _ConnAllocHandle:= ax;
      Handle:= cx
     End
  End
End;

Function _ConnNameToHandle(Name: String; Var Handle: Word): Boolean;
Var
 Regs: Registers;
Begin
 _ConnNameToHandle:= false;
 With Regs do
  Begin
   Name := Name + #0;
   cx:= 0;

   ds:= Seg(Name);
   si:= Ofs(Name)+ 1;

   VLM_Call(vlm_id_CONN,$000E,Regs);
   _ConnNameToHandle:= ax = 0;

   If ax = 0
    then Handle:= cx
    else Writeln('Fehler: '+HexStr(ax,4));
  End
End;

Function _ConnFreeHandle(Handle: Word): Boolean;
Var
 Regs: Registers;
Begin
 With Regs do
  Begin
   cx:= Handle;
   VLM_Call(vlm_id_CONN,CONN_FRE,Regs);
   _ConnFreeHandle:= ax = 0
  End
End;

Function _ConnLookUpHandle(Handle: Word): Word;
Var
 Regs: Registers;
Begin
 _ConnLookUpHandle:= 0;
 With Regs do
  Begin
   bh:= CEI_TRAN_BUFF;
   bl:= 0;
   cx:= 0;
   dx:= 0;
   VLM_Call(vlm_id_CONN,CONN_LUP,Regs);
   If ax = 0
    then _ConnLookUpHandle:= cx
  End
End;

Function _ConnNameLookUp(Handle: Word): String;
Var
 Regs: Registers;
 Temp: String;
Begin
 Temp:= '';
 With Regs do
  Begin
   cx:= Handle;
   es:= Seg(Temp);
   di:= Succ(Ofs(Temp));
   VLM_Call(vlm_id_CONN,$000D,Regs);
   If ax = 0
    then Temp[0]:= Char(bl)
    else Temp[0]:= #0
  End;
 _ConnNameLookUp:= Temp
End;

Function _ConnGetNumConnections: Word;
Var
 Regs: Registers;
Begin
 With Regs do
  Begin
   VLM_Call(vlm_id_CONN,$000F,Regs);
   If ax = 0
    then _ConnGetNumConnections:= dx
    else _ConnGetNumConnections:= 0
  End
End;

{ Aufruf des NetWare-Requesters ber ermittelte Einsprungadresse }
Procedure RequesterCall(Var Regs: Registers);
Begin
 With Regs do
  Begin
   With ReqFragList do                 { Initialisieren der Fragmentlisten }
    Begin
     FragPtr:= PReq;                   { Zeiger auf Anfrage-Puffer }
     FragSize:= Word(PReq^) + 2        { + 2 fr vorangestelltes Lngenwort }
    End;

   With RepFragList do
    Begin
     FragPtr:= PRep;                   { Zeiger auf Anfrage-Puffer }
     FragSize:= Word(PRep^)            { hier gibt's kein Lngenwort }
    End;

   cx:= ClientHandle;                  { siehe Unit-Initialisierungsteil }

   If ReqFragList.FragSize > 2         { Wenn Daten im Puffer (2Bytes=Lnge) }
    then bx:= 1                        { dann ein Fragment }
    else bx:= 0;                       { sonst brauchen wir keines }

   If RepFragList.FragSize > 0         { Wenn Daten im Puffer, }
    then dx:= 1                        { dann ein Fragment }
    else dx:= 0;                       { sonst brauchen wir keines }

   ds:= Seg(ReqFragList);              { [DS:SI] zeigt auf }
   si:= Ofs(ReqFragList);              { Anfrage-Fragment-Liste }
   es:= Seg(RepFragList);              { [ES:DI] zeigt auf }
   di:= Ofs(RepFragList);              { AntwortFragmentListe }

   VLM_Call(vlm_ID_TRAN,$0006,Regs);   { VLM-Fuhnktion in TRAN.VLM ausfhren }
  End
End;

{ Aufruf von NetX ber Interrupt 21h }
Procedure NetxCall(Var Regs: Registers);
Begin
 With Regs do
  Begin
   ds:= Seg(PReq^);                    { [DS:SI] zeigt auf Anfragepuffer }
   si:= Ofs(PReq^);
   es:= Seg(PRep^);                    { [ES:DI] zeigt auf Antwortpuffer }
   di:= Ofs(PRep^)
  End;
 Intr(NetWareIntr,Regs)                { Interrupt 21h ausfhren }
End;

Procedure NetWareCall(Var Regs: Registers);
Begin
 If useVLM
  then RequesterCall(Regs)
  else NetxCall(Regs);

 NetWareResult:= Regs.ax
End;

Function NetXErrorMessage(cc: Byte): String;
Var
 s: String;
Begin
 s:= 'Unknown NETX-Error 0x'+HexStr(cc,2);

 Case cc of
  $00: s:= 'O.K. Operation successful';
  $01: s:= 'Server in use, Semaphore overflow, TTS available';
  $02: s:= 'File not found';
  $03: s:= 'Path not found';
  $04: s:= 'Too many open files';
  $05: s:= 'Access denied';
  $06: s:= 'Invalid file handle';
  $07: s:= 'Memory blocks destroyed';
  $08: s:= 'Insuffient memory';
  $09: s:= 'Invalid memory block address';
  $0A: s:= 'Invalid environment';
  $0B: s:= 'Invalid format';
  $0C: s:= 'Invalid access code';
  $0D: s:= 'Invalid data';
  $0F: s:= 'Invalid drive';
  $10: s:= 'Attempt do delete current directory';
  $11: s:= 'Not same device';
  $12: s:= 'No more files';
  $20: s:= 'Sharing violation';
  $21: s:= 'Lock violation';
  $80: s:= 'File in use error';
  $81: s:= 'No more file handles';
  $82: s:= 'No open privileges';
  $83: s:= 'I/O error on network disk';
  $84: s:= 'No create privileges';
  $85: s:= 'No create / delete privileges';
  $86: s:= 'Create file exists read only';
  $87: s:= 'Wild cards in create file name';
  $88: s:= 'Invalid file handle';
  $89: s:= 'No search privileges';
  $8A: s:= 'No delete privileges';
  $8B: s:= 'No rename privileges';
  $8C: s:= 'No modify privileges';
  $8D: s:= 'Some files affected in use';
  $8E: s:= 'No files affected in use';
  $8F: s:= 'Some files affected read only';
  $90: s:= 'No files affected read only';
  $91: s:= 'Some files renamend name exists';
  $92: s:= 'No files renamed name exists';
  $93: s:= 'No read privileges';
  $94: s:= 'No write privileges or read only';
  $95: s:= 'File detached';
  $96: s:= 'Server out of memory or dynamic workspace';
  $97: s:= 'No disk space for spool file';
  $98: s:= 'Volume does not exist';
  $99: s:= 'Directory full';
  $9A: s:= 'Renaming across volumes';
  $9B: s:= 'Bad directory handle';
  $9C: s:= 'Invalid path, no more trustees';
  $9D: s:= 'No more directory handles';
  $9E: s:= 'Invalid filename';
  $9F: s:= 'Directory active';
  $A0: s:= 'Directory not empty';
  $A1: s:= 'Directory IO error';
  $A2: s:= 'Read file with locked record';
  $C0: s:= 'No account privileges';
  $C1: s:= 'Login denied, no account balance';
  $C2: s:= 'Account credit limit exceeded, login denied';
  $C3: s:= 'Account to many holds';
  $C5: s:= 'Intruder detection lock';
  $C6: s:= 'No console operator';
  $D0: s:= 'Queue error';
  $D1: s:= 'No queue';
  $D2: s:= 'No queue server';
  $D3: s:= 'No queue rights';
  $D4: s:= 'Queue full';
  $D5: s:= 'No queue job';
  $D6: s:= 'No job rights';
  $D7: s:= 'Password not unique, queue servicing';
  $D8: s:= 'Password to short, queue not active';
  $D9: s:= 'Login denied, no connection, station not server';
  $DA: s:= 'Unauthorized login time, queue haltet';
  $DB: s:= 'Unauthorized login station, max queue servers';
  $DC: s:= 'Account disabled';
  $DE: s:= 'Password has expired, no grace';
  $DF: s:= 'Password has expired';
  $E8: s:= 'Not item property, write property to group';
  $E9: s:= 'Member already exists';
  $EA: s:= 'No such member';
  $EB: s:= 'Not group property';
  $EC: s:= 'No such segment, SPX terminated poorly';
  $ED: s:= 'connection failed, connection terminated';
  $EE: s:= 'Object already exists, SPX: invalid connection';
  $EF: s:= 'Invalid name, SPX: connection table full';
  $F0: s:= 'Wild cards not allowed, IPX: not installed';
  $F1: s:= 'Invalid bindery security';
  $F2: s:= 'No object read privileges';
  $F3: s:= 'No object rename privileges';
  $F4: s:= 'No object delete privileges';
  $F5: s:= 'No object create privileges';
  $F6: s:= 'No property delete privileges, not same local drive';
  $F7: s:= 'No property create privileges, target drive not local';
  $F8: s:= 'Already attached to server, no property write privileges, not attached to server';
  $F9: s:= 'No free connection slots, no property read privileges';
  $FA: s:= 'No more server slots, temp remap error';
  $FB: s:= 'Invalid parameters, no such property, unknown request';
  $FC: s:= 'Internet packet request cancelled, unknown file server';
  $FD: s:= 'bad station number';
  $FE: s:= 'Requested object locked or disabled';
  $FF: s:= 'Requested object failure or active';
  End;

 NetXErrorMessage:= s
End;


Function RequesterErrorMessage(cc: Byte): String;
Var
 s: String;
Begin
 s:= 'Unknown Requester-Error 0x'+HexStr(cc,2);

 Case cc of
  $00: s:= 'Already Attached';
  $01: s:= 'Invalid Connection';
  $02: s:= 'Drive in use (OS/2 only)';
  $03: s:= 'Can''t add current directory structure';
  $04: s:= 'Bad drive base, invalid path specification';
  $05: s:= 'Net receive error';
  $06: s:= 'Unknown network error';
  $07: s:= 'Invalid server slot';
  $08: s:= 'No server slots';
  $0A: s:= 'No route to server';
  $0B: s:= 'Bad local target (OS/2 only)';
  $0C: s:= 'Too many reuqest fragments';
  $0D: s:= 'Connection list overflow';
  $0E: s:= 'Buffer overflow';
  $0F: s:= 'No connection to server';
  $10: s:= 'No router found (OS/2 only)';
  $11: s:= 'Bad function, invalid shell call';
  $30: s:= 'Not same connection';
  $31: s:= 'Primary Connection not set';
  $33: s:= 'Invalid buffer length';
  $34: s:= 'No user name';
  $35: s:= 'No netware print spooler';
  $36: s:= 'Invalid parameter';
  $37: s:= 'Failed to open configuration file (OS/2 only)';
  $38: s:= 'No configuration file (OS/2 only)';
  $39: s:= 'Config file read failed (OS/2 only)';
  $3A: s:= 'Config line too long (OS/2 only)';
  $3B: s:= 'Config lines ignored (OS/2 only)';
  $3C: s:= 'Not my resource';
  $3D: s:= 'Daemon installed (OS/2 only)';
  $3E: s:= 'Spooler installed';
  $3F: s:= 'Connection Table full';
  $40: s:= 'Config section not found';
  $41: s:= 'Invalid transport type';
  $42: s:= 'TDS tag in use (OS/2 only)';
  $43: s:= 'TDS out of memory (OS/2 only)';
  $44: s:= 'TDS invalid tag';
  $45: s:= 'TDS write truncated';
  $46: s:= 'Service busy';
  $47: s:= 'No server, connect failed';
  $48: s:= 'Bad VLM or function call to not-loaded VLM';
  $49: s:= 'Network drive in use';
  $4A: s:= 'Local drive in use';
  $4B: s:= 'No drives available';
  $4C: s:= 'Device not redirected';
  $4D: s:= 'No more SFT entries';
  $4E: s:= 'Unload error';
  $4F: s:= 'Already in use, attempt to re-use connection entry';
  $50: s:= 'Request with too many reply fragments';
  $51: s:= 'Table full';
  $52: s:= 'Socket not open';
  $53: s:= 'Enhanced Memory operation failed';
  $54: s:= 'SFT3-error';
  $55: s:= 'Preferred server not found, another server returned';
  $56: s:= 'Device not recognized';
  $57: s:= 'Bad net type';
  End;

 RequesterErrorMessage:= s
End;

Function ServerNCPErrorMessage(cc: Byte): String;
Var
 s: String;
Begin
 s:= 'Unknown Server-NCP-Error 0x'+HexStr(cc,2);

 Case cc of
   $80: s:= 'File already open';
   $81: s:= 'No more file handles';
   $82: s:= 'No open privileges';
   $83: s:= 'IO error on network disk (bad sector)';
   $84: s:= 'No create privileges';
   $85: s:= 'No create delete privileges';
   $86: s:= 'Create file exists read only';
   $87: s:= 'Wildcards in create file not allowed';
   $88: s:= 'Invalid file handle';
   $89: s:= 'No search privileges';
   $8A: s:= 'No delete privileges';
   $8B: s:= 'No rename privileges';
   $8C: s:= 'No modify privileges';
   $8D: s:= 'Some files affected are in use';
   $8E: s:= 'No files affected are in use';
   $8F: s:= 'Some files affected are read only';
   $90: s:= 'No file affected are read only';
   $91: s:= 'Some files renamed name already exists';
   $92: s:= 'No files renamed name exists';
   $93: s:= 'No read privileges';
   $94: s:= 'No write privileges or write only';
   $95: s:= 'File detached';
   $96: s:= 'Server out of memory';
   $97: s:= 'No disk space for spool file';
   $98: s:= 'Volume does not exist';
   $99: s:= 'Directory full';
   $9A: s:= 'Renaming across volumes';
   $9B: s:= 'Bad directory handle';
   $9C: s:= 'Invalid path, no more trustees';
   $9D: s:= 'No more directory handles';
   $9E: s:= 'Invalid filename';
   $9F: s:= 'Directory active';
   $A0: s:= 'Directory not empty';
   $A1: s:= 'Directory IO error';
   $A2: s:= 'Read file with locked record';
   $C1: s:= 'Login denied, no account balance';
   $C2: s:= 'Account credit limit exceeded, login denied';
   $C5: s:= 'Intruder detection lock';
   $C6: s:= 'No console operator';
   $D7: s:= 'Password not unique, queue servicing';
   $D8: s:= 'Password to short, queue not active';
   $D9: s:= 'Login denied, no connection, station not server';
   $DA: s:= 'Unauthorized login time, queue haltet';
   $DB: s:= 'Unauthorized login station, max queue servers';
   $DC: s:= 'Account disabled';
   $DE: s:= 'Password has expired, no grace';
   $DF: s:= 'Password has expired';
   $E8: s:= 'Not item property, write property to group';
   $E9: s:= 'Member already exists';
   $EA: s:= 'No such member';
   $EB: s:= 'Not group property';
   $EC: s:= 'No such segment';
   $ED: s:= 'Property already exists';
   $EE: s:= 'Object already exists';
   $EF: s:= 'Invalid name';
   $F0: s:= 'Wild cards not allowed';
   $F1: s:= 'Invalid bindery security';
   $F2: s:= 'No object read privileges';
   $F3: s:= 'No object rename privileges';
   $F4: s:= 'No object delete privileges';
   $F5: s:= 'No object create privileges';
   $F6: s:= 'No property delete privileges, not same local drive';
   $F7: s:= 'No property create privileges, target drive not local';
   $F8: s:= 'Already attached to server, no property write privileges, not attached to server';
   $F9: s:= 'No free connection slots, no property read privileges';
   $FA: s:= 'No more server slots, temp remap error';
   $FB: s:= 'Invalid parameters, no such property, unknown request';
   $FC: s:= 'No more objects, unknown file server, internet packet request cancelled';
   $FD: s:= 'Bad station number';
   $FE: s:= 'Requested object locked or disabled';
   $FF: s:= 'Requested object failure or active';
  End;
 ServerNCPErrorMessage:= s
End;

{ Umwandlung einer NetWare-Fehler-Codes in einen String }
Function NetWareErrMsg(cc: Word): String;
Begin
 Case Hi(cc) of
   $88: NetWareErrMsg:= RequesterErrorMessage(Lo(cc));
   $89: NetWareErrMsg:= ServerNCPErrorMessage(Lo(cc));
   else NetWareErrMsg:= NetXErrorMessage(Lo(cc))
  End
End;

{ Ausgabe eines Fehlers, falls aufgetreten }
Procedure DisplayErrorIfExist(ErrorCode: Word);
Begin
 If ErrorCode <> cc_Success
  then Writeln(NetWareErrMsg(ErrorCode))
End;

{ wandelt ObjectTyp-Wort in String um, zur Anzeige }
Function ObjTypeStr(ObjType: Word): String;
Begin
 Case ObjType of
   ot_Wild           : ObjTypeStr:= 'Wild';
   ot_Unknown        : ObjTypeStr:= 'unknown';
   ot_User           : ObjTypeStr:= 'User';
   ot_UserGroup      : ObjTypeStr:= 'Usergroup';
   ot_PrintQueue     : ObjTypeStr:= 'Printqueue';
   ot_FileServer     : ObjTypeStr:= 'Fileserver';
   ot_JobServer      : ObjTypeStr:= 'Jobserver';
   ot_Gateway        : ObjTypeStr:= 'Gateway';
   ot_PrintServer    : ObjTypeStr:= 'Printserver';
   ot_ArchiveQueue   : ObjTypeStr:= 'Archivequeue';
   ot_ArchiveServer  : ObjTypeStr:= 'Archiveserver';
   ot_JobQueue       : ObjTypeStr:= 'Jobqueue';
   ot_Administration : ObjTypeStr:= 'Administration';
   ot_RemBridgeServer: ObjTypeStr:= 'Remote-Bridge-Server';
   ot_AdvPrintServer : ObjTypeStr:= 'Adv. Printserver';
   else                ObjTypeStr:= 'unknown'
  End
End;


{  Die NetWare-Binderyfunktionen  }


{ Laden eines Bindery-Objektes, Suche nach ID }
Function GetBinderyObject
 (ID: LongInt; Var BinderyObject: TBinderyObject) : Byte;
Var
 Regs: Registers;
Begin
 With Regs do
  Begin
   ah:= $E3;                           { E3h = Funktionsnummer }
   al:= $17;                           { 17h = VLM Funktionsnr. }
   PutInit($36);                       { 36h = Unterfunktion }
   PutItem(4,ID);                      { ID bertragen }
   GetInit(56);                        { Antwortpuffer mit Lnge 56 Bytes }
   NetWareCall(Regs);

   GetBinderyObject:= al;              { Statusmeldung zurckliefern }

   FillChar(BinderyObject,SizeOf(BinderyObject),0);
   If al = cc_Success                  { Falls Operatiom O.K. }
    then
     With BinderyObject do
      Begin
       GetItem(4,bo_ID);               { ID laden }
       GetItem(2,bo_Typ);              { Typ laden }
        bo_Typ:= Swap(bo_typ);
       GetItem(48,bo_Name);            { Namen laden und }
        bo_Name:= PStr(bo_Name);       { in Pascal-String umwandeln }
      End
  End
End;

{ Suchen nach Bindery Objekten, Suche ber ID }
Var
 bo_LastID: LongInt;

Function ScanBinderyObject
 (Var BindObj: TBinderyObject;
  Var LastID: LongInt; ObjType: Word; Mask: String): Boolean;
Var
 Regs: Registers;
Begin
 With Regs do
  Begin
   ah:= $E3;                           { E3h = Funktionsummer NetX }
   al:= $17;
   PutInit($37);                       { 37h = Unterfunktion }
   PutItem(4,LastID);                  { ID bertragen }
   ObjType:= Swap(ObjType);            { Typ ins NetWare-Format wandeln }
   PutItem(2,ObjType);                 { und bertragen }
   PutItem(0,Mask);                    { Suchmaske bertragen }
   GetInit(57);                        { Antwort-Puffer initialisieren }
   NetWareCall(Regs);

   ScanBinderyObject:= al = cc_Success; { Suchaktion fehlerfrei? }

   FillChar(BindObj,SizeOf(BindObj),0);{ Ergebnis initialisieren }

   If al = 0
    then
     With BindObj do
      Begin
       GetItem(4,bo_ID);               { Objekt-ID bertragen }
       GetItem(2,bo_Typ);              { Objekt-Typ bertragen }
        bo_Typ:= Swap(bo_Typ);         { wird im hi-lo Format geliefert }
       GetItem(48,bo_Name);            { 0-terminierten Namens-String }
        bo_Name:= PStr(bo_Name);       { in Pascal-String umwandeln }
       GetItem(1,bo_Flag);             { Objekt-Flag }
       GetItem(1,bo_Security);         { Objekt-Zugriffsrechte }
       GetItem(1,bo_HasProp);          { Objekt-Eigenschaften vorhanden? }

       bo_LastID:= bo_ID               { um nchsten Eintrag zu finden }
      End
  End
End;

{ Suchen des nchsten Bindery Objects }
Function ScanBinderyObjectNext
 (Var BindObj: TBinderyObject;
  ObjType: Word; Mask: String): Boolean;
Begin
 ScanBinderyObjectNext:=
  ScanBinderyObject
   (BindObj,bo_LastID,ObjType,Mask)
End;

{ Suchen des ersten Bindery Objects }
Function ScanBinderyObjectFirst
 (Var BindObj: TBinderyObject;
  ObjType: Word; Mask: String): Boolean;
Begin
 bo_LastID:= $FFFFFFFF;                { Initialisierung fr erstes Object }
 ScanBinderyObjectFirst:=
  ScanBinderyObjectNext
   (BindObj,ObjType,Mask)
End;

Var
 LastSequenceNumber: LongInt;

{ Suchen nach Eigenschaften eines Objektes }
Function ScanProperty
 (BinderyObject: TBinderyObject;
  Var Property: TProperty; Mask: String): Boolean;
Var
 Regs: Registers;
 b: Byte;
Begin
 With Regs, BinderyObject do
  Begin
   ah:= $E3;                           { E3h Funktionsnummer }
   al:= $17;                           { 17h = VLM Funktionsnr. }

   PutInit($3C);                       { 3Ch Unterfunktion }
    bo_Typ:= Swap(bo_Typ);
   PutItem(2,bo_Typ);                  { Objekt-Typ bertragen }
   PutItem(0,bo_Name);                 { Objekt-Namen betragen }
   PutItem(4,LastSequenceNumber);
   PutItem(0,Mask);                    { Suchmaske betragen }

   GetInit(26);                        { Antwort-Puffer Lnge = 26 Bytes }

   NetWareCall(Regs);

   ScanProperty:= al = 0;              { Suchaktion fehlerfrei? }

   FillChar(Property,
            SizeOf(Property),0);       { Ergebnis initialisieren }

   If al = cc_Success                  { Falls Funktion erfolgreich }
    then
     With Property do                  { dann Eigenschaften bertragen }
      Begin
       GetItem(16,Name);               { Namen bertragen }
        Name:= PStr(Name);             { und in Pascal Format bertragen }
       GetItem(1,Flags);               { Flags bertragen }
       GetItem(1,Security);            { Zugriffsrechte bertragen }
       GetItem(4,SequenceNo);
       GetItem(1,b);                   { Eigenschafts-Wert vorhanden? }
        HasValue:= b <> 0;
       GetItem(1,b);                   { Weitere Eigenschaften? }
        ScanProperty:= b <> 0;
       LastSequenceNumber:= SequenceNo
      End
  End
End;

{ Suche nach der ersten Eigenschaft eines Bindery Objektes }
Function ScanPropertyFirst
 (Var BinderyObject: TBinderyObject;
  Var Property: TProperty;
  Mask:String): Boolean;
Begin
 LastSequenceNumber:= $FFFFFFFF;
 ScanPropertyFirst:=
  ScanProperty(BinderyObject,Property,Mask)
End;

{ Suche nach weiteren Objekt-Eigenschaften }
Function ScanPropertyNext
 (Var BinderyObject: TBinderyObject;
  Var Property: TProperty;
  Mask:String): Boolean;
Begin
 ScanPropertyNext:=
  ScanProperty(BinderyObject,Property,Mask)
End;

Const
 LastSegmentNo: Byte = $01;

{ Suchen nach Eigenschafts-Werten eines Bindery-Objektes }
Function
 ReadPropertyValue
  (BinderyObject: TBinderyObject;
   Property: TProperty;
   Var Content: String): Boolean;
Var
 Regs: Registers;
Begin
 With Regs do
  Begin
   ah:= $E3;                           { E3h Funktionsnummer }
   al:= $17;                           { 17h = VLM Funktionsnr. }

   PutInit($3D);                       { 3Dh Unterfunktion }
   With BinderyObject do
    Begin
      bo_Typ:= Swap(bo_typ);
     PutItem(2,bo_Typ);
     PutItem(0,bo_Name)
    End;

   PutItem(1,LastSegmentNo);
   PutItem(0,Property.Name);

   GetInit(132);                       { 132d Lnge des Antwortpuffers }
   NetWareCall(Regs);

   GetItem(128,Content[1]);
   Content[0]:= #128;

   ReadPropertyValue:= al = cc_Success
  End
End;

{ Suchen nach erstem Eigenschafts-Wert einer Eingenschaft eines Objektes }
Function
 ReadPropertyValueFirst
  (Var BinderyObject: TBinderyObject;
   Var Property: TProperty;
   Var Content: String): Boolean;
Begin
 LastSegmentNo:= $01;
 ReadPropertyValueFirst:=
  ReadPropertyValue(BinderyObject,Property,Content)
End;

{ Suchen nach weiterem Eigenschafts-Wert }
Function
 ReadPropertyValueNext
  (Var BinderyObject: TBinderyObject;
   Var Property: TProperty;
   Var Content: String): Boolean;
Begin
 Inc(LastSegmentNo);
 ReadPropertyValueNext:=
  ReadPropertyValue(BinderyObject,Property,Content)
End;


{  Die NetWare-Verbindungsfunktionen  }


{ Verbindungsnummer der anfragenden Station am aktuellen Server }
Function GetConnectionNo: Byte;
Var
 Regs: Registers;
Begin
 With Regs do
  Begin
   ah:= $DC;                           { DCh = Funktionsnumer }
   Intr(NetWareIntr,Regs);             { Parameter werden nicht bentigt }
   NetWareResult:= al;
   GetConnectionNo:= al                { Verbindungs-Nummer in [AL] }
  End
End;

{ Ermittlung der Ethernet-Adresse (physical node address) der Station }
Function GetStationAddress(Var NodeAddress: TNodeAddress): String;
Var
 Regs: Registers;
Begin
 With Regs do
  Begin
   ah:= $EE;                           { EEh = Funktions-Nummer }
   Intr(NetWareIntr,Regs);             { Keine weiteren Parameter erforderlich }
   NetWareResult:= 0;

   NodeAddress[1]:= ch;
   NodeAddress[2]:= cl;
   NodeAddress[3]:= bh;
   NodeAddress[4]:= bl;
   NodeAddress[5]:= ah;
   NodeAddress[6]:= al;

   GetStationAddress:=
    NrToStr(ch,0)+':'+                 { Anstelle der Dezimal-Zahlen }
    NrToStr(cl,0)+':'+                 { knnen hier mit HexStr aus }
    NrToStr(bh,0)+':'+                 { Hexadezimal-Zahlen ausgegeben }
    NrToStr(bl,0)+':'+                 { werden }
    NrToStr(ah,0)+':'+
    NrToStr(al,0)
  End
End;

{ Ermittlung der Internet-Adresse einer Station }
Function
 GetInternetAddress
  (ConnectNo: Byte;
   Var NetworkNumber: TNetworkNumber;
   Var NodeAddress  : TNodeAddress;
   Var SocketNumber : TSocketNumber): Byte;
Var
 Regs: Registers;
Begin
 With Regs do
  Begin
   ah:= $E3;                           { E3h Funktionsnummer }
   al:= $17;                           { 17h = VLM Funktionsnr. }

   PutInit($13);                       { 13h Unterfunktion }
   PutItem(1,ConnectNo);               { Verbindungs-Nummer bergeben }
   GetInit(14);                        { 14d Lnge des Antwortpuffers }
   NetWareCall(Regs);                  { NetWare-Funktion aufrufen }
   GetInterNetAddress:= al;            { Statuscode als Ergebnis }

   Move(TRep(PRep^)[RepPos   ],NetworkNumber,SizeOf(TNetworkNumber));
   Move(TRep(PRep^)[RepPos+ 4],NodeAddress  ,SizeOf(TNodeAddress));
   Move(TRep(PRep^)[RepPos+10],SocketNumber ,SizeOf(TSocketNumber))
  End
End;

{ Information ber Server-Verbindung }
Function
 GetConnectionInfo
  (No: LongInt;                        { Logische Verbindungs-Nummer }
   Var BinderyObject:                  { Hier soll die Info abgelegt werden }
       TBinderyObject): Byte;
Var
 Regs: Registers;
Begin
 With Regs do
  Begin
   ah:= $E3;                           { E3h Funktions-Nummer }
   al:= $17;
   PutInit($16);                       { 16h Unterfunktion }
   PutItem(1,No);                      { Verbindungs-Nummer bergeben }
   GetInit(63);                        { 63d Ergebnislnge }
   NetWareCall(Regs);                  { NetWare-Funktion aufrufen }

   GetConnectionInfo:= al;             { Statuscode als Ergebnis }

   If al = cc_Success                  { Falls Aufruf erfolgreich }
    then
     With BinderyObject do             { Daten an Objekt-Parameter bertr. }
      Begin
       GetItem(4,bo_ID);               { Objekt-ID bertragen }
       GetItem(2,bo_Typ);              { Objekt-Typ bertragen }
        bo_Typ:= Swap(bo_Typ);         { wird im hi-lo Format geliefert }
       GetItem(48,bo_Name);            { 0-terminierten Namens-String }
        bo_Name:= PStr(bo_Name)        { in Pascal-String umwandeln }
                                       { LogIn-Time wird nicht abgefragt }
     End
  End
End;

{ Beispielfunktion, um die Verbindungs-Nummer eines namentlich bekannten
  Users am Server zu erhalten }
Function GetConnectNoFromName
 (UserName: String;
  Var BinderyObject: TBinderyObject): Byte;
Var
 No: Byte;
 NameFound: Boolean;
Begin
 No:= 1;                               { Zhlung beginnt bei 1 }
 NameFound:= false;                    { Bisher keine bereinstimmung (Init) }
 GetConnectNoFromName:= 0;             { Keine Verbindungs-Nummer gefunden }
 While not NameFound and
       (GetConnectionInfo(No,BinderyObject) = cc_Success) do
  Begin
   NameFound:=
    BinderyObject.bo_Name = UserName;  { Namen mit Listeneintrag vergleichen }
   If NameFound                        { Falls bereinstimmung... }
    then GetConnectNoFromName:= No     { Verbindungs-Nummer bergeben }
    else Inc(No)                       { sonst nchsten Eintrag prfen }
  End
End;

Function _NWPConnect(Server: TStr80; Var Handle: Word): Word;
Var
 Regs: Registers;
Begin
 _NWPConnect:= $8801;
 With Regs do
  Begin
   dl:= 8;
   If Handle <> 0 then Exit;           { denn dann besteht Verbindung }
   cx:= Handle;
   Server:= Server + #0;
   ds:= Seg(Server);
   si:= Ofs(Server) + 1;
   VLM_Call(vlm_id_NWP,NWP_CON,Regs);
   If (ax = cc_Success) or (ax = $8800)
    then Handle:= cx;

   _NWPConnect:= ax
  End
End;

Function _NWPDisconnect(Var Handle: Word): Word;
Var
 Regs: Registers;
Begin
 _NWPDisconnect:= $8801;
 If Handle = 0 then Exit;              { denn dann besteht keine Verb. }
 With Regs do
  Begin
   cx:= Handle;
   VLM_Call(vlm_id_NWP,NWP_DIS,Regs);
   _NWPDisconnect:= ax;
   Handle:= 0
  End
End;

Function _NWPLogin(Var Handle: Word; Server, Name, Password: TStr80): Word;
Var
 Regs: Registers;
Begin
 With Regs do
  Begin
   _NWPLogin:= $8801;
   If Handle = 0 then _NWPConnect(Server,Handle);
   If Handle = 0 then Exit;

   Name    := Name + #0;
   Password:= Password + #0;

   bx:= ot_User;
   cx:= Handle;
   ds:= Seg(Name);
   si:= Ofs(Name) + 1;
   es:= Seg(Password);
   di:= Ofs(Password) + 1;

   VLM_Call(vlm_id_NWP,NWP_LIN,Regs);
   _NWPLogin:= ax
  End
End;

Function _NWPLogout(Var Handle: Word): Word;
Var
 Regs: Registers;
Begin
 With Regs do
  Begin
   cx:= Handle;
   VLM_Call(vlm_id_NWP,NWP_LOUT,Regs);
   _NWPLogout:= ax
  End
End;

{ Einloggen einer Station am aktuellen File-Server }
Function LoginToFileServer
 (Var BinderyObject: TBinderyObject): Word;
Var
 Regs: Registers;
Begin
 If useVLM
  then
   With BinderyObject do
    LoginToFileServer:=
     _NWPLogin(ClientHandle,DefaultServerName,bo_Name,bo_Password)
  else
   With Regs do
    Begin
     ah:= $E3;                         { E3h = Funktionsnummer }
     PutInit($14);                     { 14h = Unterfunktion }
     With BinderyObject do
      Begin
        bo_Typ:= Swap(bo_Typ);         { Intel- => NetWare-Format }
       PutItem(2,bo_Typ);              { Objekt-Typ bertragen }
       PutItem(0,bo_Name);             { Name bertragen }
       PutItem(0,bo_Password)          { Kennwort bertragen }
      End;

     GetInit(2);                       { Antwort-Puffer initialisieren }
     NetWareCall(Regs);
     LoginToFileServer:= al            { Erfolg des Login zurckliefern }
    End
End;

{ LogOut an allen Fileservern }
Procedure LogOut;
Var
 Regs: Registers;
Begin
 If useVLM
  then _NWPLogOut(ClientHandle)
  else
   Begin
    Regs.ah:= $D7;                     { D7h = Funktionsnummer }
    Intr(NetWareIntr,Regs);            { LogOut ausfhren }
    NetWareResult:= Regs.al
   End
End;

Function AttachToFileServer(ServerName: TStr80): Word;
Var
 Regs: Registers;
Begin
 ServerName:= UpCaseStr(ServerName);

 If useVLM
  then _NWPConnect(ServerName,ClientHandle)
  else AttachToFileServer:= $8801;
(*
   With Regs do
    Begin
     ah:= $F1;                         { F1h = Funktionsnummer }
     al:= $00;                         { 00h = Unterfunktion }
     dl:= ConnectionID;                { Server Connection ID }
     Intr(NetWareIntr,Regs);           { NetWare-Funktion ausfhren }
     AttachToFileServer:= al           { Rckmeldung }
    End
*)
End;

Function DetachFromFileServer(ConnectionID: Byte): Word;
Var
 Regs: Registers;
Begin
 If useVLM
  then
   _NWPDisconnect(ClientHandle)
  else
   With Regs do
    Begin
     ah:= $F1;                         { Funktionsnummer }
     al:= $01;
     dl:= ConnectionID;
     Intr(NetWareIntr,Regs);           { NetWare-Funktion ausfhren }
     NetWareResult:= al;
     DetachFromFileServer:= al
    End
End;


{  Die NetWare-Fileserverfunktionen  }


{ Prfung, ob der aufrufende Benutzer Console-Rechte besitzt }
Function CheckConsolePrivileges: Boolean;
Var
 Regs: Registers;
Begin
 With Regs do
  Begin
   ah:= $E3;
   al:= $17;                           { 17h = VLM Funktionsnr. }

   PutInit($C8);
   GetInit(2);
   NetWareCall(Regs);
   CheckConsolePrivileges:= al = cc_Success
  End
End;

{ Laden von aktueller Zeit und aktuellem Datum des preferred Fileservers }
Procedure
 GetFileServerDateAndTime
  (Var Year,Month,Day,DayOfWeek,Hour,Min,Sec: Word);
Var
 Regs: Registers;
 Buff: Array[0..6] of Byte;
Begin
 With Regs do
  Begin
   ah:= $E7;
   ds:= Seg(Buff);
   dx:= Ofs(Buff);
   Intr(NetWareIntr,Regs);
   NetWareResult:= al;

   Year     := Buff[0] + 1900;
   Month    := Buff[1];
   Day      := Buff[2];
   Hour     := Buff[3];
   Min      := Buff[4];
   Sec      := Buff[5];
   DayOfWeek:= Buff[6]
  End
End;

{ Ldt die Beschreibungsstrings des preferred Fileservers }
Function
 GetFileServerDescriptionStrings
  (Var FSDescrStrs: TFSDescrStrings) : Byte;
Var
 Regs: Registers;
 p: Word;
 s: String;
Begin
 With Regs do
  Begin
   ah:= $E3;
   al:= $17;
   PutInit($C9);
   GetInit(514);
   NetWareCall(Regs);

   GetFileServerDescriptionStrings:= al;

   FillChar(FSDescrStrs,SizeOf(FSDescrStrs),0);
   If al = cc_Success
    then
     With FSDescrStrs do
      Begin
       p:= RepPos;
       Move(TRep(PRep^)[p],CompanyName,SizeOf(CompanyName));
       CompanyName:= PStr(CompanyName);
       Inc(p,Length(CompanyName)+1);
       Move(TRep(PRep^)[p],Revision,SizeOf(Revision));
       Revision:= PStr(Revision);
       Inc(p,Length(Revision)+1);
       Move(TRep(PRep^)[p],RevisionDate,SizeOf(RevisionDate));
       RevisionDate:= PStr(RevisionDate);
       Inc(p,Length(RevisionDate)+1);
       Move(TRep(PRep^)[p],CopyrightNote,SizeOf(CopyrightNote));
       CopyrightNote:= PStr(CopyrightNote);
       Inc(p,Length(CopyrightNote)+1)
      End
  End
End;

{ Ldt Informationen ber den preferred Fileserver }
Function
 GetFileServerInformation
  (Var FSInfo: TFileServerInfo) : Byte;
Var
 Regs: Registers;
 s: String;
Begin
 With Regs do
  Begin
   ah:= $E3;
   al:= $17;                           { 17h = VLM Funktionsnr. }

   PutInit($11);
   GetInit(130);
   NetWareCall(Regs);
   GetFileServerInformation:= al;
   FillChar(FSInfo,SizeOf(FSInfo),0);
   If al = cc_Success
    then
     With FSInfo do
      Begin
       Move(TRep(PRep^)[RepPos],FSInfo,SizeOf(FSInfo));
       ServerName         := PStr(ServerName);
       MaxConnections     := Swap(MaxConnections);
       UsedConnections    := Swap(UsedConnections);
       MaxConnectedVolumes:= Swap(MaxConnectedVolumes);
       PeakConnectionsUsed:= Swap(PeakConnectionsUsed)
      End
  End
End;

{ Ermittelt den gesamten freien Festplattenspeicher fr die aktuelle Station
  bzw. ein beliebiges anderes Object, falls Console-Rechte bestehen }
Function
 GetBinderyObjectDiskSpaceLeft
  (ObjectID: LongInt;
   Var FreeSpace: LongInt;
   Var Restrictions: Boolean): Byte;
Var
 Regs: Registers;
 l: LongInt;
 b: Byte;
Begin
 With Regs do
  Begin
   ah:= $E3;                           { E3h Funktions-Nummer }
   al:= $17;                           { 17h = VLM Funktionsnr. }

   PutInit($E6);                   { E6h Unterfunktion }
   PutItem(4,ObjectID);          { ID in Puffer bertragen }
   GetInit(15);                    { 15d Lnge Ergebnis-Puffer }
   NetWareCall(Regs);            { Freien Platz holen }
   GetBinderyObjectDiskSpaceLeft:= al; { evtl. Fehlercode zurckliefern }
   GetItem(4,l);               { elapsed-time, nicht bentigt }
   GetItem(4,l);               { Object-ID, nicht bentigt }
   GetItem(4,l);               { Anzahl freier Blcke  4096 }
   FreeSpace:= l shr 2;                { div 4 -> freier Platz in KBytes }
   GetItem(1,b);               { enforced = 00, not enforced = 01 }
   Restrictions:= b = 00
  End
End;


{  Die NetWare-Messagefunktionen  }


{ Abfrage des Broadcast-Modus }
Function GetBroadcastMode: Byte;
Var
 Regs: Registers;
Begin
 With Regs do
  Begin
   ah:= $DE;                           { Funktions-Nummer }
   dl:= $04;                           { Unterfunktion }
   Intr(NetWareIntr,Regs);             { NetWare-Funktion ausfhren }
   NetWareResult:= al;
   GetBroadcastMode:= al
  End;
End;

{ Setzen des Broadcast-Modus }
Function SetBroadcastMode(Mode: Byte): Byte;
Var
 Regs: Registers;
Begin
 With Regs do
  Begin
   ah:= $DE;
   dl:= Mode;
   Intr(NetWareIntr,Regs);             { NetWare-Funktion ausfhren }
   NetWareResult:= al;
   SetBroadCastMode:= al
  End
End;

{ Diese Funktion ergnzt den Anfrage-Puffer mit der Sende-Liste
  der Verbindungs-Nummern, Rckgabe: Anzahl der Eintrge in der Liste }
Function SendListToReqBuff(Var SendList: TSendList): Byte;
Var
 Cnt,i: Byte;
Begin
 Cnt:= 0;
 For i:= 1 to MaxReceiver do           { Anzahl Empfnger ermitteln }
  If i in SendList
   then Inc(Cnt);
 PutItem(1,Cnt);                 { Anzahl eintragen }

 For i:= 1 to MaxReceiver do           { Empfngerliste aufbauen }
  If i in SendList
   then PutItem(1,i);

 SendListToReqBuff:= Cnt
End;

{ Sendet eine Message an alle Empfnger einer Sendeliste }
Function SendBroadcastMessage(SendList: TSendList; Message: String): Byte;
Var
 Regs: Registers;
 Cnt : Byte;
Begin
 SendBroadcastMessage:= $FF;
 If (SendList = []) or (Message = '') then Exit;

 With Regs do
  Begin
   ah:= $E1;
   al:= $15;                           { 15h = VLM Funktionsnr. }
   PutInit($00);                       { 00h = Subfunktion Send }
   Cnt:= SendListToReqBuff(SendList);  { Sende-Liste bertragen }
   PutItem(0,Message);                 { Message-String bertragen }
   GetInit(103);                       { Antwort-Puffer initialisieren }
   NetWareCall(Regs);                  { Absenden der Message }

   SendBroadcastMessage:= al
  End
End;

{ Lesen einer Boradcast-Message }
Function GetBroadcastMessage(Var Message: String): Byte;
Var
 Regs: Registers;
Begin
 With Regs do
  Begin
   ah:= $E1;                           { E1h Funktions-Nummer }
   al:= $15;                           { 15h = VLM Funktionsnr. }
   PutInit($01);                       { 01h Unterfunktion Get }
   GetInit(58);                        { 58d max. Gre der Antwort }
   NetWareCall(Regs);                  { Nachricht abfragen }

   GetBroadcastMessage:= al;           { Nachricht vorhanden? }

   If al = cc_Success                  { Falls ja, dann }
    then GetItem(0,Message)            { Nachricht bertragen }
    else FillChar(Message,SizeOf(Message),0)
  End
End;


{  Die NetWare-Laufwerksfunktionen  }


{ Ermittlung der Laufwerks-Handles fr jeden Laufwerksbuchstaben }
Procedure GetDrvHandleTable(Var DrvHandleTable: TDrvHandleTable);
Var
 Regs: Registers;
 i: Byte;
Begin
 With Regs do
  Begin
   ah:= $EF;                           { EFh = Funktionsnummer }
   al:= $00;                           { 00h = Unterfunktion }
   Intr(NetWareIntr,Regs);             { NetWare-Funktion ausfhren }
   NetWareResult:= al;
   For i:= 1 to 26 do                  { Handles fr alle 26 Laufwerke }
    Begin                              { in den Parameter bertragen }
     DrvHandleTable[i]:= Mem[es:si];
     Inc(si)
    End
  End
End;

{ Ermittlung der Laufwerksflags aus den Laufwerksbuchstaben }
Procedure GetDrvFlagTable(Var DrvFlagTable: TDrvFlagTable);
Var
 Regs: Registers;
 i: Byte;
Begin
 With Regs do
  Begin
   ah:= $EF;                           { EFh = Funktionsnummer }
   al:= $01;                           { 01h = Unterfunktion }
   Intr(NetWareIntr,Regs);             { NetWare-Funktion ausfhren }
   NetWareResult:= al;
   For i:= 1 to 26 do                  { Flags fr alle Laufwerke }
    Begin                              { in den Parameter }
     DrvFlagTable[i]:= Mem[es:si];     { bertragen }
     Inc(si)
    End
  End
End;

{ Registration, welche Laufwerke an welche(n) Server ge'map't sind }
Procedure GetDrvConnectIDTable(Var DrvConTable: TDrvConnectIDTable);
Var
 Regs: Registers;
 i: Byte;
Begin
 With Regs do
  Begin
   ah:= $EF;                           { EFh = Funktionsnummer }
   al:= $02;                           { 02h = Unterfunktion }
   Intr(NetWareIntr,Regs);             { NetWare-Funktion ausfhren }
   NetWareResult:= al;
   For i:= 1 to 26 do                  { Fr alle Laufwerke }
    Begin                              { Server-ID in den Parameter }
     DrvConTable[i]:= Mem[es:si];      { bergeben }
     Inc(si)
    End
  End
End;

{ Ermittlung der ID des aktuellen Servers }
Function GetPreferredConnectionID: Byte;
Var
 Regs: Registers;
Begin
 With Regs do
  Begin
   ah:= $F0;
   al:= $01;
   Intr(NetWareIntr,Regs);             { NetWare-Funktion ausfhren }
   NetWareResult:= al;
   GetPreferredConnectionID:= al
  End
End;

Function GetDefaultConnectionID: Byte;
Var
 Regs: Registers;
Begin
 With Regs do
  Begin
   ah:= $F0;
   al:= $02;
   Intr(NetWareIntr,Regs);             { NetWare-Funktion ausfhren }
   NetWareResult:= al;
   GetDefaultConnectionID:= al
  End
End;

Function GetPrimaryConnectionID: Byte;
Var
 Regs: Registers;
Begin
 With Regs do
  Begin
   ah:= $F0;
   al:= $05;
   Intr(NetWareIntr,Regs);             { NetWare-Funktion ausfhren }
   NetWareResult:= al;
   GetPrimaryConnectionID:= al
  End
End;

{ Liefert die ID des Servers zurck mit dem die Station aktuell verbunden
  ist. Weitere Informationen in TConnectInfo (siehe Typendefinition) }
Function GetConnectionID(Var ConnectInfo: TConnectInfo): Byte;
Var
 Regs: Registers;
Begin
 With Regs do
  Begin
   ah:= $EF;
   al:= $03;
   Intr(NetWareIntr,Regs);             { NetWare-Funktion ausfhren }
   NetWareResult:= al;
   Move(Mem[es:si],ConnectInfo,SizeOf(TConnectInfo));
   GetConnectionID:= ConnectInfo.ConnectNo
  End
End;

{ Ermittlung der Namen aller File-Server im Netzwerk
  Ergebnis ist die gefundene Anzahl von Fileservern }
Function GetFileServerNameTable(Var FSNameTable: TFSNameTable): Byte;
Var
 Regs : Registers;
 i,Cnt: Byte;
Begin
 FSNameTable[0]:= '';
 With Regs do
  Begin
   ah:= $EF;
   al:= $04;
   Intr(NetWareIntr,Regs);             { NetWare-Funktion ausfhren }
   NetWareResult:= al;
   Cnt:= 0;
   For i:= 1 to MaxServer do
    Begin
     FSNameTable[i]:= PStr(Mem[es:si]);
     Inc(si,48);
     If FSNameTable[i] <> '' then Inc(Cnt)
    End;
   GetFileServerNameTable:= Cnt
  End
End;

{ Namen des Servers mit der bergebenen ID ermitteln }
Function GetFileServerName(ConnectID: Byte): String;
Var
 FSNameTable: TFSNameTable;
Begin
 GetFileServerNameTable(FSNameTable);  { Servernamen-Tabelle laden }
 GetFileServerName:=                   { und gewnschten Namen bertragen }
  FSNameTable[ConnectID]
End;

{ Abfragen des Namens vom aktuellen Server }
Function ActualServerName: String;
Begin
 ActualServerName:=
  GetFileServerName
   (GetPreferredConnectionID)
End;

{ Setzen des aktuellen Servers }
Procedure SetPreferredConnectionID(ConnectID: Byte);
Var
 Regs: Registers;
Begin
 With Regs do
  Begin
   ah:= $F0;                           { F0h = Funktions-Nummer }
   al:= $00;                           { 00h = Unterfunktion }
   dl:= ConnectID;                     { ServerID bergeben }
   Intr(NetWareIntr,Regs);             { NetWare-Funktion ausfhren }
   NetWareResult:= al
  End
End;

Procedure SetPrimaryConnectionID(ConnectID: Byte);
Var
 Regs: Registers;
Begin
 With Regs do
  Begin
   ah:= $F0;
   al:= $04;
   dl:= ConnectID;
   Intr(NetWareIntr,Regs);
   NetWareResult:= al
  End
End;

Function DrvFlagStr(DrvFlag: Byte): String;
Begin
 Case DrvFlag of
   df_NotAllocated          :
    DrvFlagStr:= 'not mapped';
   df_PermanentNetworkDrv :
    DrvFlagStr:= 'mapped permanently';
   df_TemporaryNetworkDrv :
    DrvFlagStr:= 'mapped temporary';
   df_LocalDrv            :
    DrvFlagStr:= 'local Drv';
   df_LocalAllocToPermNWDrv :
    DrvFlagStr:= 'local mapped permanent';
   df_LocalAllocToTempNWDrv :
    DrvFlagStr:= 'local mapped temporary'
   else
    DrvFlagStr:= 'Drv flag is unknown'
  End
End;

Function
 GetVolumeInformation
  (VolumeNo: Byte;
   Var VolumeInfo: TVolumeInfo): Word;
Var
 Regs: Registers;
Begin
 With Regs do
  Begin
   ah:= $E3;                           { E3h = Funktions-Nr. }
   al:= $17;                           { 17h = VLM Funktionsnr. }
   PutInit($E9);                       { E9h = Unterfunktion }
   PutItem(1,VolumeNo);                { Nr. des gew. Volumes bergeben }
   GetInit(SizeOf(VolumeInfo));        { Lnge des Antwort-Puffers }
   NetWareCall(Regs);                  { Volume-Namen holen }
   GetVolumeInformation:= ax;          { Aktion erfolgreich? }
   If ax = cc_Success                  { Dann Satz bertragen }
    then
     With VolumeInfo do
      Begin
       GetItem(SizeOf(TVolumeInfo),VolumeInfo);

       { Alle Daten-Worte vom NetWare- ins Intel-Format "swappen" }
       SystemElapsedTimed := Swap(SystemElapsedTimed);
       SectorsPerBlock    := Swap(SectorsPerBlock);
       StartingBlock      := Swap(StartingBlock);
       TotalBlocks        := Swap(TotalBlocks);
       AvailableBlocks    := Swap(AvailableBlocks);
       TotalDirSlots      := Swap(TotalDirSlots);
       AvailableDirSlots  := Swap(AvailableDirSlots);
       MaxUsedDirEntries  := Swap(MaxUsedDirEntries);

       { Boolean-Werte anpassen }
       VolumeIsHashed     := Byte(VolumeIsHashed   ) <> 0;
       VolumeIsCached     := Byte(VolumeIsCached   ) <> 0;
       VolumeIsRemovable  := Byte(VolumeIsRemovable) <> 0;
       VolumeIsMounted    := Byte(VolumeIsMounted  ) <> 0;

       { und den Namen umwandeln }
       VolumeName:= PStr(VolumeName)
      End
  End
End;

Function
 GetVolumeInfoWithNumber
  (VolumeNo: Byte;
   Var VolumeInfo: TVolumeInfo): Word;
Var
 Regs: Registers;
 Xfr : Word;
Begin
 With Regs do
  Begin
   FillChar(VolumeInfo,SizeOf(VolumeInfo),0);
   ah:= $DA;                           { DAh = Funktions-Nr. }
   al:= $12;                           { 12h = VLM Funktionsnr. }
   If useVLM
    then
     Begin
      PutInit(0);
      Req[0]:= VolumeNo;
      Req[1]:= 1
     End
    else
     dl:= VolumeNo;                    { Volumen-Nr nach Register DL }
   GetInit(28);

   NetWareCall(Regs);                  { Volume-Informationen holen }
   GetVolumeInfoWithNumber:= al;       { Aktion erfolgreich? }
   If al = cc_Success                  { Dann Satz bertragen }
    then
     With VolumeInfo do
      Begin
       Move(Rep[00],SectorsPerBlock,2);
       SectorsPerBlock    := Swap(SectorsPerBlock);
       Move(Rep[02],TotalBlocks,2);
       TotalBlocks        := Swap(TotalBlocks);
       Move(Rep[04],AvailableBlocks,2);
       AvailableBlocks    := Swap(AvailableBlocks);
       Move(Rep[06],TotalDirSlots,2);
       TotalDirSlots      := Swap(TotalDirSlots);
       Move(Rep[08],AvailableDirSlots,2);
       AvailableDirSlots  := Swap(AvailableDirSlots);
       Move(Rep[10],VolumeName,16);
       VolumeName:= PStr(VolumeName);
       If VolumeName = ''
        then GetVolumeInfoWithNumber:= $98; { 98h = Volume not exist }
       Move(Rep[26],Xfr,2);
       VolumeIsRemovable  := Xfr <> 0;
      End
  End
End;

{ Holt den durch Volume-Nr. gekennzeichneten Eintrag
  aus der Volume-Namen-Tabelle des aktuellen File-Servers }
Function GetVolumeName(VolumeNo: Byte): String;
Var
 Regs: Registers;
 Name: String[16];
Begin
 With Regs do
  Begin
   ah:= $E2;                           { E2h = Funktions-Nr. }
   al:= $16;                           { 16h = VLM Funktionsnr. }
   PutInit($06);                       { 06h = Unterfunktion }
   PutItem(1,VolumeNo);                { Nr. des gew. Volumes bergeben }
   GetInit(19);                        { Lnge des Antwort-Puffers }
   NetWareCall(Regs);                  { Volume-Namen holen }
   If al = cc_Success                  { Aktion erfolgreich? }
    then
     Begin
      GetItem(17,Name);
      GetVolumeName:= Name             { ..dann Ergebnis bertragen }
     End
    else GetVolumeName:= ''            { ..sonst nichts gefunden }
  End
End;


{  Die NetWare-Directoryfunktionen  }


{ Ldt das Verzeichnis-Handle eines laufwerks
  A: = 1, B: = 2, etc. }
Function GetDirectoryHandle(DrvNo: Byte; Var DrvFlags: Byte): Byte;
Var
 Regs: Registers;
Begin
 GetDirectoryHandle:= 0;               { initialisieren }
 DrvFlags:= 0;

 If DrvNo < 1
  then Exit;

 With Regs do
  Begin
   ah:= $E9;
   al:= $00;
   dx:= Pred(DrvNo);
   Intr(NetWareIntr,Regs);             { NetWare-Funktion ausfhren }
   NetWareResult:= al;
   GetDirectoryHandle:= al;
   DrvFlags:= ah
  End
End;

{ Gibt den einem Handle zugeordneten Server-Pfad zurck }
Function GetDirectoryPath(DirHandle: Byte): String;
Var
 Regs: Registers;
 Path: String;
Begin
 With Regs do
  Begin
   ah:= $E2;                           { E2h = Funktionsnummer }
   al:= $16;                           { 16h = VLM Funktionsnr. }

   PutInit($01);                       { 01h = Unterfunktion }
   PutItem(1,DirHandle);               { Handle an Funktion betragen }
   GetInit(258);
   NetWareCall(Regs);
   GetItem(0,Path);
   GetDirectoryPath:= Path
  End
End;

{ Lscht ein Drv-Mapping er das Verz.-Handle am aktuellen Server }
Function DeallocateDirectoryHandle(DirHandle: Byte): Byte;
Var
 Regs: Registers;
Begin
 With Regs do
  Begin
   ah:= $E2;                           { E2h = Funktionsnummer }
   al:= $16;                           { 16h = VLM Funktionsnr. }
   PutInit($14);                       { 14h = Unterfunktion }
   PutItem(1,DirHandle);               { Handle an Funktion betragen }
   NetXCall(Regs);                     { Nur dieser entfernt das Mapping }
   DeallocateDirectoryHandle:= al
  End
End;

{ Setzt den einem Handle zugeordneten Server-Pfad neu.
  Falls bereits eine Zuordnung erfolgte wird diese gendert,
  andernfalls eine neue eingerichtet. Laufwerk als Zeichen(!) A - Z.
  Funktionsergebnis ist die NetWare-Rckmeldung
  Das neue Verzeichnis-Handle ist der Parameter DirHandle }
Function
 AllocPermanentDirectoryHandle
  (Drv: Char; Var DirHandle: Byte; Path: String): Byte;
Var
 Regs: Registers;
Begin
 With Regs do
  Begin
   ah:= $E2;                           { E2h = Funktionsnummer }
   al:= $16;                           { 16h = VLM Funktionsnr. }
   PutInit($12);                       { 12h = Unterfunktion }
   PutItem(1,DirHandle);               { Handle an Funktion betragen }
   PutItem(1,Drv);                     { Laufwerksbuchstaben bertragen }
   PutItem(0,Path);                    { Pfad bertragen }
   GetInit(4);                         { 04 = Lnge der Ergebnisdaten }
   NetXCall(Regs);                     { Setzen des Verzeichnisses }
   AllocPermanentDirectoryHandle:= al; { NetWare-Rckmeldung => Ergebnis }
   GetItem(1,DirHandle)                { Laden des neuen Handles }
  End
End;


{  Die NetWare-Druckfunktionen  }


{ Starten einer Umlenkung der aktuellen parallelen Schnittstelle }
Function StartLPTCapture: Byte;
Var
 Regs: Registers;
Begin
 With Regs do
  Begin
   ah:= $DF;
   dl:= $00;
   Intr(NetWareIntr,Regs);             { NetWare-Funktion ausfhren }
   NetWareResult:= al;
   StartLPTCapture:= al
  End
End;

{ Beenden der Umlenkung der aktuellen parallelen Schnittstelle }
Function EndLPTCapture: Byte;
Var
 Regs: Registers;
Begin
 With Regs do
  Begin
   ah:= $DF;
   dl:= $01;
   Intr(NetWareIntr,Regs);             { NetWare-Funktion ausfhren }
   NetWareResult:= al;
   EndLPTCapture:= al
  End
End;

{ Abbrechen eines Captures }
Function CancelLPTCapture: Byte;
Var
 Regs: Registers;
Begin
 With Regs do
  Begin
   ah:= $DF;
   dl:= $02;
   Intr(NetWareIntr,Regs);             { NetWare-Funktion ausfhren }
   NetWareResult:= al;
   CancelLPTCapture:= al
  End
End;

{ Schreiben des Capture-Puffers zum Drucker und lschen des Puffers }
Function FlushLPTCapture: Byte;
Var
 Regs: Registers;
Begin
 With Regs do
  Begin
   ah:= $DF;
   dl:= $03;
   Intr(NetWareIntr,Regs);             { NetWare-Funktion ausfhren }
   NetWareResult:= al;
   FlushLPTCapture:= al
  End
End;

{ Ermittelt den aktuellen lokalen Drucker }
Function GetDefaultLocalPrinter: Byte;
Var
 Regs: Registers;
Begin
 With Regs do
  Begin
   ah:= $B8;
   al:= $04;
   Intr(NetWareIntr,Regs);             { NetWare-Funktion ausfhren }
   NetWareResult:= al;
   GetDefaultLocalPrinter:= dh
  End
End;

{ Setzt den aktuellen lokalen Drucker }
Function SetDefaultLocalPrinter(LPTDevice: Byte): Byte;
Var
 Regs: Registers;
Begin
 With Regs do
  Begin
   ah:= $B8;
   al:= $05;
   dh:= LPTDevice;
   Intr(NetWareIntr,Regs);             { NetWare-Funktion ausfhren }
   NetWareResult:= al;
   SetDefaultLocalPrinter:= al
  End
End;

{ Status des aktuellen Captures
  cs_Active = aktiv, cs_NotActive = inaktiv }
Function GetLPTCaptureStatus(Var ConnectID: Byte): Byte;
Var
 Regs: Registers;
Begin
 With Regs do
  Begin
   ah:= $F0;
   al:= $03;
   Intr(NetWareIntr,Regs);             { NetWare-Funktion ausfhren }
   NetWareResult:= al;
   ConnectID:= al;
   GetLPTCaptureStatus:= ah
  End
End;

{ Ermittelt die Capture-Flags am aktuellen Printer-Port }
Function GetDefaultCaptureFlags(Var CaptureFlags: TCaptureFlags): Byte;
Var
 Regs: Registers;
Begin
 With Regs do
  Begin
   ah:= $B8;
   al:= $00;
   cx:= SizeOf(CaptureFlags);
   es:= Seg(CaptureFlags);
   bx:= Ofs(CaptureFlags);
   Intr(NetWareIntr,Regs);             { NetWare-Funktion ausfhren }
   NetWareResult:= al;
   Move(Mem[es:bx],CaptureFlags,SizeOf(CaptureFlags));
   GetDefaultCaptureFlags:= al
  End;
End;

{ Setzt die Capture-Flags am aktuellen Printer-Port }
Function SetDefaultCaptureFlags(Var CaptureFlags: TCaptureFlags): Byte;
Var
 Regs: Registers;
Begin
 With Regs do
  Begin
   ah:= $B8;
   al:= $01;
   cx:= 7; {SizeOf(CaptureFlags);}
   es:= Seg(CaptureFlags);
   bx:= Ofs(CaptureFlags);
   Intr(NetWareIntr,Regs);             { NetWare-Funktion ausfhren }
   NetWareResult:= al;
   SetDefaultCaptureFlags:= al
  End
End;

Function SetCapturePrintQueue(LPTDevice: Byte; QueueID: LongInt): Byte;
Var
 Regs: Registers;
Begin
 With Regs do
  Begin
   ah:= $B8;                           { Funktions-Nummer }
   al:= $06;                           { Sub-Funktion }
   dh:= LPTDevice;                     { Port-Nummer 0-2 }
   bx:= QueueID and $FFFF;             { erstes Wort (hi-lo-Format!) nach bx }
   cx:= QueueID shr 16;                { zweites nach cx }
   Intr(NetWareIntr,Regs);             { NetWare-Funktion ausfhren }
   NetWareResult:= al;
   SetCapturePrintQueue:= al           { alles erfolgreich? }
  End
End;

Function PSUserBannerName: String;
Type
 TRepBannerUserName =
  Record
   BannerUserName : Array[0..11] of Char;
  End;
Var
 Regs: Registers;
 s: String;
Begin
 With Regs do
  Begin
   ah:= $B8;
   al:= $08;
   ds:= Seg(PReq^);
   si:= Ofs(PReq^);
   es:= Seg(PRep^);
   bx:= Ofs(PRep^);
   Intr(NetWareIntr,Regs);             { NetWare-Funktion ausfhren }
   NetWareResult:= al;
   PSUserBannerName:= PStr(TRepBannerUserName(PRep^).BannerUserName)
  End;
End;


{  Die NetWare-Queuefunktionen  }


Function
 GetQueueID
  (QueueTyp: Word;
   QueueName: TQueueStr;
   Var QueueID: LongInt): Boolean;
Var
 BinderyObject: TBinderyObject;
 Ok: Boolean;
Begin
 Ok:= ScanBinderyObjectFirst(BinderyObject,QueueTyp,QueueName);
 GetQueueID:= Ok;
 If Ok then QueueID:= BinderyObject.bo_ID
End;

Function GetQueueJobList(QueueID: LongInt; Var QueueJobList: TQueueJobList): Byte;
Var
 Regs: Registers;
Begin
 With Regs do
  Begin
   ah:= $E3;                           { E3h = Funktion }
   al:= $17;                           { 17h = VLM Funktionsnr. }

   PutInit($6B);                       { 6Bh = Unterfunktion }
   PutItem(4,QueueID);                 { QueueID in den Puffer bertragen }
   GetInit(504);                       { 504 maximale Ergebnislnge }
   NetWareCall(Regs);                  { Job-Liste holen }

   GetQueueJobList:= al;               { Ergebnis }
   FillChar(QueueJobList,SizeOf(QueueJobList),0);
   Move(TRep(PRep^)[RepPos],QueueJobList,SizeOf(TQueueJobList));
   QueueJobList[0]:= Swap(QueueJobList[0])
  End
End;

Function
 ReadQueueJobEntry
  (QueueID: LongInt;
   JobNo: Word;
   Var QueueJobEntry: TQueueJobEntry): Byte;
Var
 Regs: Registers;
Begin
 With Regs do
  Begin
   ah:= $E3;
   al:= $17;                           { 17h = VLM Funktionsnr. }
   PutInit($6C);                       { 6Ch = Kommando }
   PutItem(4,QueueID);                 { QueueID in den Puffer bertragen }
   PutItem(2,JobNo);                   { Job-Nummer bertragen }
   GetInit(258);                       { 258 maximale Ergebnislnge }
   NetWareCall(Regs);                  { Job-Liste holen }
   If al = 0                           { alles O.k. ? }
    then Move(TRep(PRep^)[RepPos],QueueJobEntry,SizeOf(TQueueJobEntry))
    else FillChar(QueueJobEntry,SizeOf(TQueueJobEntry),0);
   ReadQueueJobEntry:= al              { Ergebnis (Completion-Code) }
  End
End;

Function
 ReadQueueCurrentStatus
  (QueueID: LongInt;
   Var QueueStatus: TQueueStatus): Byte;
Var
 Regs: Registers;
Begin
 With Regs do
  Begin
   ah:= $E3;
   al:= $17;                           { 17h = VLM Funktionsnr. }
   PutInit($66);                       { 66h = Kommando }
   PutItem(4,QueueID);                 { QueueID in den Puffer bertragen }
   GetInit(134);                       { 134 maximale Ergebnislnge }
   NetWareCall(Regs);                  { Job-Liste holen }

   If al = cc_Success                  { alles O.k. ? }
    then Move(TRep(PRep^)[RepPos],QueueStatus,SizeOf(QueueStatus))
    else FillChar(QueueStatus,SizeOf(QueueStatus),0);
   ReadQueueCurrentStatus:= al         { Ergebnis (Completion-Code) }
  End
End;

Procedure InitNetWareCalls;            { Initialisierung fr Netware-Aufrufe }
Var
 ConInfo: TConnectInfo;
Begin
 If GetPreferredConnectionID = 0       { Falls der Preferred Server }
  then                                 { noch nicht bestimmt ist, }
   SetPreferredConnectionID            { dann tun wir's hier }
    (GetConnectionID(ConInfo));

 useVLM:= VLMInstalled(VLMFarCallPtr); { Ist VLM-Manager installiert? }

 If useVLM                             { falls ja, dann Handle der }
  then
   ClientHandle:= _ConnLookUpHandle(0) { aktuellen Verbindung holen }
  else
   ClientHandle:= 0                    { sonst definiert zu 0 setzen }
End;

Begin                                  { Init darf nicht entfallen, da }
 InitNetWareCalls                      { sonst ntige Adressen nicht }
End.                                   { korrekt belegt werden. }