/* pm_fonts.c : Hilfsfunktionen fr die benutzung der PM-Zeichenstze */ 

#define INCL_PM  /* Window Standard Font Functions     */
#include <os2.h>
#include <string.h>
#include <memory.h>
#include <malloc.h>
 

#include "pm_fonts.h"
#include "pm_print.h"



/*****************************************************************************/
/* Erzeugt einen logischen Font fr einen Courier Bold outlined Font ohne    */
/* lMatch */
/* parameter : Handle zum PS */
/* Rckgabe  : Set ID des neuen Fonts oder GPI_ERROR                         */
/*****************************************************************************/
LONG CreateOutlineFont(HPS hps, PSZ pszFacename, PSTR8 pstr8Fontname)
{

  PFONTMETRICS afmMetrics = NULL;
  LONG lNumFonts;
  LONG lReqFonts;
  LONG lRemFonts = GPI_ALTERROR;
  BOOL fRet = FALSE;
  LONG lLcid = GPI_ERROR;
  INT i;
  USHORT usCodePage = GPI_ERROR;
  FATTRS fatAttrs;

  lReqFonts = 0L;
  lNumFonts = GpiQueryFonts(hps,
			    QF_PUBLIC,
			    pszFacename,
			    &lReqFonts,
			    0L,
			    NULL);

  if ((lNumFonts!=GPI_ALTERROR) && (lNumFonts!=0L))
    afmMetrics  = malloc(lNumFonts*sizeof(FONTMETRICS));

  if (afmMetrics != NULL)
    lRemFonts = GpiQueryFonts(hps,
			      QF_PUBLIC,
			      pszFacename,
			      &lNumFonts,
			      (LONG)sizeof(FONTMETRICS),
			      afmMetrics);

  if (lRemFonts != GPI_ALTERROR) {
    for (i=0; i< (INT) lNumFonts; i++)  {
      if ((afmMetrics[i].fsDefn & FM_DEFN_OUTLINE)
	  && !(strcmp(afmMetrics[i].szFacename,pszFacename)))  {

	lLcid = AllocateSetID(hps);
	
	if (lLcid != GPI_ERROR)
	  usCodePage = GpiQueryCp(hps);

	fatAttrs.usRecordLength = sizeof(FATTRS);
	fatAttrs.fsSelection    = 0;
	fatAttrs.lMatch         = afmMetrics[i].lMatch;
	strcpy(fatAttrs.szFacename, afmMetrics[i].szFacename);
	fatAttrs.idRegistry     = afmMetrics[i].idRegistry;
	fatAttrs.usCodePage     = usCodePage;
	fatAttrs.lMaxBaselineExt = 0L;
	fatAttrs.lAveCharWidth  = 0L;
	fatAttrs.fsType         = 0;
	fatAttrs.fsFontUse      = (FATTR_FONTUSE_OUTLINE |
				   FATTR_FONTUSE_TRANSFORMABLE);
	
	if (usCodePage != GPI_ERROR)
	  fRet = GpiCreateLogFont(hps,
				  pstr8Fontname,
				  lLcid,
				  &fatAttrs) != GPI_ERROR;

	break;
      }
    }
  }

  free(afmMetrics);

  if (!fRet || usCodePage==GPI_ERROR)
    lLcid = GPI_ERROR;

  return(lLcid);
}


/***************************************************************************/
/* Besorgt eine noch nicht benutzte ID fr einen Font                      */
/***************************************************************************/
LONG AllocateSetID (HPS hps)
{
#define MAXSETID 254L

  INT i;
  LONG lLcid = GPI_ERROR;
  LONG lCount;
  BOOL fRet = FALSE;
  PLONG alLcids = NULL;
  PLONG alTypes;
  PSTR8 aNames;

  lCount = GpiQueryNumberSetIds(hps);

  if (lCount == 0)
    return 1L;

  if (lCount!=GPI_ALTERROR) {
    alLcids = malloc((SHORT)((sizeof(LONG)*2 + sizeof(STR8))*lCount));
    alTypes = (PLONG)(alLcids + lCount);
    aNames  = (PSTR8)(alTypes + lCount);

    if (alLcids!=NULL)
      fRet = GpiQuerySetIds(hps,
			    lCount,
			    alTypes,
			    aNames,
			    alLcids);

    if (fRet) {       /* Korrekte Nummern 1 - 254 */
      for (lLcid=1; lLcid<255; lLcid++) {  /* 255 Fehlermeldung !!! */
	for (i=0;i < (int)lCount && alLcids[i]!=lLcid; i++);
	if (i==(INT )lCount)  break;
      }
      if (lLcid==255)
	lLcid = GPI_ERROR;
    }
    free(alLcids);
  }
  return lLcid;
}







/*********************************************************************
 *  Name: ShowFontDialog
 *
 *  Description : Allows the user to select a font for the text
 *                displayed in the MLE.
 *
 *  Concepts : Routine is called each time the user selects the
 *             Font menu item from the Options menu.  The
 *             standard font dialog is called with the current
 *             available fonts.  If the user selects one, then
 *             the MLM_SETFONT message is sent to the MLE to
 *             display its text to the font chosen.
 *
 *  API's : WinSendMsg
 *          GpiCreateLogFont
 *          GpiSetCharSet
 *          GpiQueryFontMetrics
 *          GpiDeleteSetId
 *          WinGetPS
 *          WinReleasePS
 *          WinLoadString
 *          WinFontDlg
 *
 *  Parameters :  None
 *
 *  Returns: TRUE : Alles geklappt, FALSE Fehler bei fontbox
 *           pbReturn : TRUE-> Font gewhlt, FALSE -> Wahl verworfen 
 *
 ****************************************************************/
BOOL ShowFontDialog(HAB hab, HWND hwndClient, HPS hpsScreen,  HPS hpsPrinter,
		    PFONTMETRICS pfmFont, USHORT *pusPtSize, BOOL *pbReturn)
{
  FONTDLG fontDlg;
  CHAR szTitle[30];
  CHAR pszFamilyname[FACESIZE];

  memset(&fontDlg, 0, sizeof(fontDlg));            /* initialize all fields */
  
  /*------------------- alles klar fr Ausgabe -------------------------*/
  fontDlg.cbSize     = sizeof(FONTDLG);               /* sizeof(FONTDLG) */
  fontDlg.hpsScreen  = hpsScreen;  /* Screen PS */
  fontDlg.hpsPrinter = hpsPrinter;      /* Printer presentation space */
    
  strcpy(szTitle,"Fontbox");
  fontDlg.pszTitle      = szTitle;    /* Application supplied title      */
  strncpy(pszFamilyname, pfmFont->szFamilyname,sizeof(pszFamilyname));
  fontDlg.pszFamilyname = pszFamilyname;
                                           /* point to Family name of font */
  fontDlg.fxPointSize = MAKEFIXED(*pusPtSize/10,0);
                                           /* Point size the user selected */
  fontDlg.fl           = FNTS_CENTER | FNTS_INITFROMFATTRS;
                                           /* FNTS_* flags - dialog styles */
  fontDlg.clrFore      = CLR_BLACK; /* Selected foreground color    */
  fontDlg.clrBack      = CLR_WHITE; /* Selected background color       */
                                        /* Nominal Point Size of font      */
  fontDlg.sNominalPointSize = pfmFont->sNominalPointSize;
  fontDlg.usWeight = pfmFont->usWeightClass; /* boldness of the font */
  fontDlg.usWidth = pfmFont->usWidthClass;  /* The width of the font */
  fontDlg.usFamilyBufLen = sizeof(pszFamilyname); 
                                        /*Length family name buffer */
  strcpy(fontDlg.fAttrs.szFacename,pfmFont->szFacename);

  /*--------------- Bring up the standard Font Dialog -------------------*/
  if(!WinFontDlg(HWND_DESKTOP,hwndClient, &fontDlg)) 
    return FALSE;

  /******** ------ gewhlte Einstellung Speichern ----------- ************/
  strncpy(pfmFont->szFamilyname, fontDlg.pszFamilyname, sizeof(pszFamilyname));
  strcpy(pfmFont->szFacename,fontDlg.fAttrs.szFacename);
  pfmFont->sNominalPointSize = fontDlg.sNominalPointSize;
  pfmFont->usWeightClass = fontDlg.usWeight ; /* boldness of the font */
  pfmFont->usWidthClass = fontDlg.usWidth;  /* The width of the font */
  *pusPtSize = FIXEDINT(fontDlg.fxPointSize)*10;
  
  if (fontDlg.lReturn == DID_OK) 
    *pbReturn = TRUE;
  else 
    *pbReturn = FALSE;

  return TRUE;
}   /* End of ShowFontDialog() */







