(* kooperative Delay-Funktion fuer Borland Pascal fuer Windows   *)
(* Jeroen W. Pluimers / c't 1/95 / TPW 1.0 - BP7, OWL und WinCrt *)
unit WinDelay;
(*$IFNDEF Windows *) Achtung: nur fuer Windows! (*$ENDIF*)
interface

function Delay(ms: word): word;
         (* ersetzt Crt.Delay unter Windows *)
function SafeYield(WaitForMessage: Boolean): Boolean;
         (* ersetzt Yield *)

implementation
  {$ifdef ver10} {$define tpw} {$endif ver10} (* beruecksichtigt *)
  {$ifdef ver15} {$define tpw} {$endif ver15} (* unterschiedliche *)
  {$ifndef tpw}  {$define bpw} {$endif tpw}   (* Compilerversionen *)
uses
  oWindows, (* Klasse TApplication + glob. Variable Application *)
  WinTypes, (* Typ TMsg *)
  WinCrt,   (* emuliert Unit Crt im Windows-Fenster *)
  WinProcs, (* xxxMessage-Rountinen, Yield *)
  mmSystem; (* timeGetTime *)

function SafeYield(WaitForMessage: Boolean): Boolean;
(* ersetzt Windows-Yield *)
(* gibt die Kontrolle an andere Programme ab *)
(* Parameter WaitForMessage:                                        *)
(*    true  - Abgabe der Kontrolle, bis eine Nachricht eintrifft    *)
(*    false - Abgabe der Kontrolle nur einmal                       *)
(* Rueckgabe:                                                       *)
(*    true  - Kontrolle "normal" abgegeben                          *)
(*    false - wm_Quit-Nachricht gefunden                            *)

var Msg: TMsg;
begin
  SafeYield := False;
  if PeekMessage(Msg, 0,0,0, pm_Remove)
  then begin (* Nachricht in der Queue? *)
    if Msg.Message = wm_Quit then begin
      PostQuitMessage(Msg.wParam); (* wm_Quit erneut senden *)
      exit
    end
     else (* wenn Application existiert, ProcessAppMsg aufrufen *)
        (* schlaegt ProcessAppMsg fehl oder Application=nil *)
        (* dann Nachricht "uebersetzen" und "verteilen" *)
      if (Application = nil) or
        ((Application <> nil) and (not Application^.ProcessAppMsg(Msg)))
      then begin
        TranslateMessage(Msg);
        DispatchMessage(Msg)
      end
  end
  else (* keine Nachricht vorhanden *)
  {$ifdef bpw} (* Idle in Gang setzen *)
    if (Application = nil) or (not Application^.IdleAction)
    then
  {$endif bpw}
      if WaitForMessage then WaitMessage (* auf Nachricht warten *)
      else Yield; (* Kontrolle "normal" abgeben *)
  SafeYield := True;
end; { function SafeYield }

function Delay(ms: word): word;
(* Nachbildung von Crt.Delay: gibt Kontrolle wiederholt ab, bis *)
(* ms Millisekunden vergangen sind *)
(* Rueckgabe: tatsaechliche Wartezeit *)
var StartTime: longint;
begin
  StartTime := timeGetTime;
  (* unbedingt SafeYield VOR dem Zeitvergleiche aufrufen *)
  while SafeYield(false) and (StartTime + ms > timeGetTime) do;
  Delay := timeGetTime - StartTime;
end;

begin
end.
