 // WPolynom.c
 // Nullstellenberechnung des Wilkinson-Polynoms
 // (c) Rainer Walden & c't
  
  
 #include <stdio.h>
 #include <stdlib.h>
 #include <math.h>
  
 typedef struct {
         int grad;
         long double koeff[30];
 } Poly;
 
 void SetPoly ( Poly *a ) {
 // a(x) = (x-1)*...*(x-20)
     a->grad = 20;
     a->koeff[0]= +0.243290200817664E19;
     a->koeff[1]= -0.87529480367616E19;
     a->koeff[2]=  0.138037597536407E20;
     a->koeff[3]= -0.1287093124515099E20;
     a->koeff[4]= +0.8037811822645052E19;
     a->koeff[5]= -0.3599979517947607E19;
     a->koeff[6]= +0.1206647803780373E19;
     a->koeff[7]= -0.3113336431613906E18;
     a->koeff[8]=  0.630308120992949E17;
     a->koeff[9]= -0.1014229986551145E17;
     a->koeff[10]= 0.1307535010540395E16;
     a->koeff[11]= -135585182899530.0;
     a->koeff[12]=  11310276995381.0;
     a->koeff[13]= -756111184500.0;
     a->koeff[14]=  40171771630.0;
     a->koeff[15]= -1672280820.0;
     a->koeff[16]= +53327946.0;
     a->koeff[17]= -1256850.0;
     a->koeff[18]= +20615.0;
     a->koeff[19]=   -210.0;
     a->koeff[20]=   1.0;
 };

 long double Horner1(Poly *a, long double x) {
     int k,n;
     Poly b;
     n = a->grad;
     b.koeff[n]=0;
     for (k=n-1;k >=0; k--) b.koeff[k] = a->koeff[k+1]+x*b.koeff[k+1];
     return(a->koeff[0]+x*b.koeff[0]);
 } 

 void Horner2(Poly *a, long double x, long double *y, long double *dy) {
     int k,n;
     Poly b,c;
     n = a->grad;
     b.koeff[n]=0;
     c.koeff[n]=0;
     for (k=(n-1);k>=0; k--) {
         c.koeff[k] = b.koeff[k+1] + x*c.koeff[k+1];
         b.koeff[k] = a->koeff[k+1] + x*b.koeff[k+1];
     }     
     *y  = a->koeff[0]+x*b.koeff[0];
     *dy = b.koeff[0]+x*c.koeff[0];
 }    
 
 void RegulaFalsi(Poly *a) {
     int i=0,  Iter=100;
     long double ax, y1, y2, x1, x2, xx, yy;
     long double eps = 1e-10;
     double ox,oy;

     x1 = 3.5;    //<------ linker Startwert der Iteration
     x2 = 4.5;    //<------ rechter Startwert der Iteration
     printf("\n REGULA FALSI \n");
     for (i=1;i<=Iter;i++) {         
         y1 = Horner1(a,x1);  
         y2 = Horner1(a,x2);
         ax = (x2-x1)/(y2-y1)*y1;
         xx = x1-ax;
         yy  = Horner1(a,xx);
 
         if(fabsl(ax) < eps) goto ende;
         if (yy<0)   x1 = xx;
         if (yy>0)   x2 = xx;
    }
    ende:;
    if (i>=Iter)
        printf("\n Warnung: Iteration ohne Lsung abgelaufen\n");
    ox = (double)xx; oy = (double)yy;
    printf("i=%4d  x = %.15e  p(x) = %.15e \n",i,ox,oy);
 }

 void Newton(Poly *a) {
     int i, Iter=50;
     long double ax,x,y,dy;
     long double eps = 1e-10;
     double ox,oy;
     printf("\n NEWTON-VERFAHREN \n");
     x=3.5;        // <------ Startwert der Iteration
     for (i=0; i <Iter; i++) {                                                     
         Horner2(a,x,&y,&dy);
         ax = y/dy;
         if(fabsl(ax) < eps) break;
         x = x - ax;
     }
     if (i>=Iter)
     printf("\n Warnung: Iteration ohne Lsung abgelaufen\n");
     y = Horner1(a,x);
     ox = (double)x; oy = (double)y;
     printf("i=%4d  x = %.15e    p(x) = %.15e \n",i,ox,oy);
  }

  void main() {
         long double x,y;
         double dx,dy;
         int i;
         Poly a;

     SetPoly(&a);
     for (i=1;i<=20;i++) {
     x =i;
     y = Horner1(&a,x);
     dx = (double)x; dy = (double)y;
     printf(" x= %.5f   p(x)= %.15e  \n",dx,dy);
     }
     RegulaFalsi(&a);
     Newton(&a);
  }

