Unit uSample;
{ Datei  : uSample.PAS
  Autoren: Gemkow, Doering, Woog
  Datum  : 10.09.94              }

{ Diese Unit stellt die Funktionen und Prozeduren
  der SAMPLEW.DLL (Windows) bzw. SAMPLEP.DLL (DPMI)
  zur Verfuegung.                                       }

{$IFDEF MSDOS}
  Nicht fuer den Realmode compilierbar!
{$ENDIF}

Interface

Type
  pDArr5 = ^tDArr5;
  tDArr5 = Array [0..4] Of Double;

  pSampleRec = ^tSampleRec;
  tSampleRec = Record
                 i  : Integer;
                 d  : Double;
                 pad: pDArr5;
                 cd : Integer;
                 sz : Array [0..64] Of char;
               End;

  tWriteFn= Procedure(d: Double; bValid: Boolean);

Function AddInteger(iValueA, iValueB: Integer): Integer;
{ Die DLL addiert beide Werte und gibt das Ergebnis
  zurueck.                                               }

Function AppendString(pszA, pszB: pChar): pChar;
{ Die Zeichenkette pszB wird an pszA angehaengt.
  Dabei ist der Bereich fuer pszA vom aufrufenden
  Programm ausreichend zu dimensionieren.                }

Procedure UniFunc(dValue: Double; iMode: Integer;
                  fnWriteResult: tWriteFn);
{ Diese Prozedur vereint unterschiedliche mathematische
  Funktionen. Ueber den Parameter iMode wird festgelegt,
  welche mathematische Funktion benutzt werden soll.
  iMode = 0 : Quadrat
          1 : Quadratwurzel
          2 : Sinus
          3 : natuerlicher Logarithmus
  Mit dem Ergebnis wird die uebergebene Prozedur
  fnWriteResult aufgerufen. Konnte die Berechnung nicht
  ausgefuehrt werden (kein Coproz. gefunden), so ist der
  zweite Parameter von fnWriteResult FALSE.              }

Function EvalPoly(iGrade: Integer; padA: Pointer;
                  dX: Double): Double;
{ Berechnung eines Polynomwertes.

  y = a[n]*x^n + a[n-1]*x^(n-1) + ... + a[1]*x + a[0]

  Es werden der Grad n des Polynoms, die Koeffizienten
  a[0..n] und der x-Wert uebergeben.
  Die Koeffizienten a[0..n] werden in ein Array von
  Double-Werten kopiert und ein Zeiger auf dieses
  Array weitergereicht. Der Koeffizient zu x^0 steht
  im Arrayfeld 0, zu x^1 im Feld 1, ... .               }

Procedure GetRecord(psr: pSampleRec);
{ Fuellt den uebergebenern Record mit Daten.            }

Implementation

Const
  LibName = {$IFDEF Windows}  { Weil unter Windows und  }
              'SampleW'       { DPMI unterschiedliche   }
            {$ELSE}           { DLL-Versionen verwendet }
              'SampleP'       { werden, sind auch zwei  }
            {$ENDIF};         { Namen noetig.           }

Function  AddInteger(iValueA, iValueB: Integer): Integer;
            External LibName;
Function  AppendString(pszA, pszB: pChar): pChar;
            External LibName;
Procedure UniFunc(dValue: Double; iMode: Integer;
            fnWriteResult: tWriteFn);   External LibName;
Function  EvalPoly(iGrade: Integer; padA: Pointer;
                   dX: Double): Double; External LibName;
Procedure GetRecord(psr: pSampleRec);   External LibName;

End.
