/* Kleiner Testtreiber fuer Optimal-Mismatch-Algorithmus
   Unter DOS nur fuer Dateien bis 64 KByte
   (c) c't & Guido Gronek                                      */

#include <stdio.h>
#include <stdlib.h>
#include <alloc.h>
#include "omsearch.h"

#define ERR(a) { fprintf(stderr, "%s\n", a); return 1; }

int main(int  argc, char *argv[])
{ char *t,*p;
  size_t length;
  PAT *pat;
  FILE *datei;

  if(argc!=3) ERR("Usage: om file pattern");
  if(!(t=(char *)malloc(MAXTEXT))) ERR("Not enough memory");
  if(!(datei=fopen(argv[1], "rb")))
  { free(t); ERR("Can't open file"); }
  length=fread(t, 1, MAXTEXT, datei); fclose(datei);
  *(t+length)=0; pat=init_omsearch(argv[2]);
  if(p=omsearch(t,pat,length)) printf("pattern start:\n%s\n", p);
  else printf("pattern not found\n");
  free(t); return(0);
}
