#include <AppleEvents.h>
#include <Folders.h>
#include "globals.h"
#include "util.h"
#include "win.h"
#include "io.h"
#include "print.h"

/*  prfen, ob ein Fehler aufgetreten ist; Information */
Boolean ioCheckOK (OSErr theError) {
	Boolean isNotOK;
	Str255  why;
	
	isNotOK = (theError != noErr);
	if (isNotOK) {
		NumToString (theError, why);
		ParamText (why,"\p","\p","\p"); 
		StopAlert (kFileErrorAlert, NIL);
	}
	return isNotOK;
} /* ioCheckOK */

/* ffne die angegebene Textdatei */
void ioOpenTextFSSpec (FSSpec theFile) {
	OSErr     err;
	short     textFile; /* Dateinummer*/
	long      dataSize; /* Gre der Datei */
	Handle    tHandle; /* hier wird der Text zunchst landen */
	WindowPtr oldFront, newFront;

	if (ioCheckOK (FSpOpenDF (&theFile, fsCurPerm, &textFile)))
		return;
	if (ioCheckOK(GetEOF(textFile, &dataSize))) { /* Dateigre */
		FSClose(textFile);
		return;
	}	
	if (dataSize > kMaxTELength) { /* zu gro */
		errorHandler (kDocumentTooLarge, false);
		FSClose(textFile);
		return;
	} /* if */
	tHandle = NewHandleClear (dataSize); /* Puffer bereitstellen */
	if (tHandle == NIL) {
		errorHandler (kNotEnoughMemory, false);
		FSClose(textFile);
		return;
	} /* if */
	if (ioCheckOK (FSRead (textFile, &dataSize, *tHandle))) {
		FSClose(textFile);
		DisposeHandle (tHandle); /* Puffer lschen */
		return;
	}
	err = FSClose (textFile); /* Datei wieder schlieen */
	oldFront = FrontWindow ();
	winDoNew (); /* neues Fenster erzeugen */
	newFront = FrontWindow (); /* das ist das neue Fenster */
	if (oldFront != newFront) { /* hat geklappt */
		SetPort (newFront);
		HLock (tHandle); /* im Speicher festsetzen */
		TESetText(*tHandle,dataSize,((documentPeek)newFront)->docTE);
		SetWTitle (newFront, theFile.name);
		winResizeScrolls (newFront); /* Scrollbalken anpassen */
		winUpdateScrolls (newFront);
		((documentPeek) newFront)->isSaved = true; /* haben Datei */
		((documentPeek) newFront)->savedFileSpec = theFile;
	} /* if */
	DisposeHandle (tHandle); /* Puffer lschen */
} /* ioOpenTextFSSpec */

/* ffne eine vom Benutzer ausgewhlte Textdatei */
void ioOpenTextFile (void) {
	SFTypeList        theTypes;
	StandardFileReply answer;				

	theTypes [0] = 'TEXT'; /* nur TEXT-Dateien ffnen */
	StandardGetFile (NIL, 1, theTypes, &answer); /* Auswahldialog */
	if (answer.sfGood)	/*  Benutzer hat nicht abgebrochen  */
		ioOpenTextFSSpec (answer.sfFile);
} /* ioOpenTextFile */

/* speichere den Inhalt des Textfensters in eine Datei */
void ioSaveTextFile (WindowPtr theWindow) {
	documentPeek doc;
	FSSpec       myFileSpec;
	short        textFile;
	Handle       tHandle;
	long         dataSize;
	OSErr        err;
	
	doc = (documentPeek) theWindow;
	if (!doc->isSaved ) /* Hat noch keinen Pfad! */
		ioSaveAsTextFile (theWindow);
	else {
		myFileSpec = doc->savedFileSpec;
		if (noErr != FSpOpenDF (&myFileSpec, fsCurPerm, &textFile)) {
		           /* alte Datei konnte nicht mehr geffnet werden */
		 	ioSaveAsTextFile (theWindow);
		 	return;
		 } /* if */
		tHandle=(Handle)TEGetText(((documentPeek)theWindow)->docTE);
		dataSize = GetHandleSize (tHandle);
		if (ioCheckOK (FSWrite (textFile, &dataSize, *tHandle))) {
			FSClose(textFile);
			return;
		}
		err = SetEOF (fsFromStart, dataSize); /* Lnge anpassen */
		err = FSClose (textFile);
		((documentPeek) theWindow)->needSave = false;
	} /* else */
} /* ioSaveTextFile */

/* speichere den Inhalt des Textfensters in eine Datei */
void ioSaveAsTextFile (WindowPtr theWindow) {
	StandardFileReply answer;
	Str255            prompt, name;
	OSErr             err;
	short             textFile;
	Handle            tHandle;
	long              dataSize;
	
	GetIndString(prompt, kIOStrings, kSavePrompt);
	GetWTitle (theWindow, name); /* Vorgabe fr den Dateinamen */
	StandardPutFile(prompt, name, &answer);
	if (answer.sfGood) { /* auf "Sichern" geklickt */
		if (answer.sfReplacing) /* wir ersetzen */
			err = FSpDelete(&answer.sfFile); /* alte Datei lschen */
		if (ioCheckOK (FSpCreate(&answer.sfFile, kCreator, kTextType,
		                                           answer.sfScript)))
			return;
		if (ioCheckOK(FSpOpenDF(&answer.sfFile,fsCurPerm,&textFile)))
		 	return;	
		tHandle=(Handle)TEGetText(((documentPeek)theWindow)->docTE);
		dataSize = GetHandleSize (tHandle);
		if (ioCheckOK (FSWrite (textFile, &dataSize, *tHandle))) {
			FSClose(textFile);
			return;
		}
		err = FSClose (textFile);
		SetWTitle (theWindow, answer.sfFile.name);
		/* Fenstername = Dateiname */
		((documentPeek) theWindow)->needSave = false;
		((documentPeek) theWindow)->isSaved = true;
		((documentPeek) theWindow)->savedFileSpec = answer.sfFile;
	} /* if */
} /* ioSaveAsTextFile */

/*  Haben wir Textdatei? */
Boolean ioIsTextFile (FSSpec theFile) {
	FInfo   fileInfo;
	
	return (noErr == FSpGetFInfo (&theFile, &fileInfo)) &&
		                              (fileInfo.fdType == kTextType);
} /* ioIsTextFile */

/* ffne die Datei(en), die der Finder ber AppleEvents angibt */
OSErr ioOpenDocs (AppleEvent messageIn) {
	OSErr      result, myErr;
	AEDescList docList;
	long       numItems, index;
	Size       actualSize;
	AEKeyword  keywd;
	FSSpec     myFSS;
	DescType   returnedType;
	
	result = noErr;
	if (noErr==AEGetParamDesc(&messageIn,keyDirectObject,typeAEList,
	                  &docList)) { /* hole die Liste der Parameter */
		myErr = AECountItems (&docList, &numItems);
		for (index = 1; index <= numItems; index++) {
				myErr = AEGetNthPtr(&docList, index, typeFSS, &keywd,
			     &returnedType, &myFSS, sizeof (myFSS), &actualSize);
			if ((myErr == noErr) && ioIsTextFile (myFSS))
				ioOpenTextFSSpec (myFSS);
			else result = myErr;
		} /* for */
		myErr = AEDisposeDesc (&docList);
	} /* if */
	return result;
} /* ioOpenDocs */

/* drucke die Datei(en), die der Finder ber AppleEvents angibt */
OSErr ioPrintDocs (AppleEvent messageIn) {
	OSErr      result, myErr;
	AEDescList docList;
	long       numItems, index;
	Size       actualSize;
	AEKeyword  keywd;
	FSSpec     myFSS;
	DescType   returnedType;
	
	result = noErr;
	if (noErr == AEGetParamDesc (&messageIn, keyDirectObject,
	                                         typeAEList, &docList)) {
		myErr = AECountItems (&docList, &numItems);
		for (index = 1; index <= numItems; index++)
		{
			myErr = AEGetNthPtr (&docList, index, typeFSS, &keywd,
				 &returnedType, &myFSS, sizeof (myFSS), &actualSize);
			if ((myErr == noErr) && ioIsTextFile (myFSS))
			{
				ioOpenTextFSSpec (myFSS);
				prPrintWin ();
				winDoClose (FrontWindow ());
			} /* if */
			else result = myErr;
		} /* for */
		myErr = AEDisposeDesc (&docList);
	} /* if */
	return result;
} /* ioPrintDocs */

void ioSaveAddresses (addrRecord *theAddrs, short number) {
	Str255 fileName;
	short  fRefNum;	/* Reference Number des Volumes */
	long   fldDirID; /* Directory ID des Ordners */
	short  theFile; /* Dateinummer */
	OSErr  err;
	long   amount;
	
	GetIndString(fileName, kIOStrings, kAddressFile); /* Dateiname */
	if (noErr == FindFolder (kOnSystemDisk, kPreferencesFolderType,
	                           kCreateFolder, &fRefNum, &fldDirID)) {
		err = HOpen (fRefNum,fldDirID,fileName,fsRdWrPerm,&theFile);
		if (err == fnfErr) { /* nicht gefunden, also erzeugen */
			if (ioCheckOK (HCreate (fRefNum, fldDirID, fileName,
			                                   kCreator, kAddrType)))
				return;
			err=HOpen(fRefNum,fldDirID,fileName,fsRdWrPerm,&theFile);
		} /* if */
		amount = sizeof (addrRecord) * number;
		if (ioCheckOK (FSWrite (theFile, &amount, (Ptr) theAddrs))) {
			FSClose (theFile);
			return;
		}
		err = SetEOF (theFile, amount);	/* Gre anpassen */
		err = FSClose (theFile); /* Datei schlieen */
		err = FlushVol (nil, fRefNum); /* Cache auf die Platte */
	} /* if */
} /* ioSaveAddresses */

/* Adressen aus der Adredatei laden, falls vorhanden */
void ioLoadAddresses (addrRecord **theAddrs, short *number,
                                                  short *addrAlloc) {
	Str255 fileName;
	short  fRefNum;	/* Reference Number des Volumes */
	long   fldDirID; /* Directory ID des Ordners */
	short  theFile; /* Dateinummer */
	OSErr  err;
	long   amount;
	
	GetIndString(fileName, kIOStrings, kAddressFile); /* Dateiname */
	*number = 0;
	if (noErr == FindFolder (kOnSystemDisk, kPreferencesFolderType,
	                           kCreateFolder, &fRefNum, &fldDirID)) {
		err = HOpen (fRefNum,fldDirID,fileName,fsRdWrPerm,&theFile);
		if (err == fnfErr) { /* nicht gefunden */
			*number = 0;
			return;
		} /* if */
		err = GetEOF (theFile, &amount); /* Dateigre */
		*number = amount / sizeof (addrRecord);	/* Eintrge */
		if (*number > *addrAlloc) /* genug Platz? */
		{
			SetHandleSize ((Handle) theAddrs,
							   (*number + 10) * sizeof (addrRecord));
			if (MemError () != noErr) /* Nicht genug Speicher? */
				errorHandler (kNotEnoughMemory, true);
			*addrAlloc = *number + 10;
		} /* if */
		ioCheckOK (FSRead (theFile, &amount, (Ptr) *theAddrs));
		err = FSClose (theFile);
	} /* if */
} /* ioLoadAddresses */