#define INCL_DOS
#define INCL_WIN
#include <os2.h>                /* System Include File      */
#include <stdio.h>
#include "infodlg.h"

MRESULT EXPENTRY dlgProc( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
BOOL _System POSTHOOK(HAB h, PQMSG pq, ULONG flag);
HAB   hab;                      /* Handle Anchor Block          */

int main()
  {
  QMSG  qmsg;                   /* Message Queue                */
  HMQ   hmq;                    /* Handle to Queue              */
  ULONG flCreate;               /* Frame creation flags         */
  HWND  hwndDlg;

  hab=WinInitialize(0);

  hmq=WinCreateMsgQueue(hab, 0);

  WinLoadDlg(HWND_DESKTOP,
             HWND_DESKTOP,
             dlgProc,
             0,
             ID_DIALOG,
             0);

  /* Message Loop */
  if (hwndDlg)
     {
     while (WinGetMsg(hab, (PQMSG) &qmsg, 0,0,0))
         WinDispatchMsg(hab, (PQMSG) &qmsg);
     }

  /* Destroy the window */
  WinDestroyWindow(hwndDlg);

  /* Destroy the message queue */
  WinDestroyMsgQueue(hmq);

  /* Terminate and release resources */
  WinTerminate( hab );
  return(0);
  }

void setTextHwnd(HWND hwnd, ULONG id, HWND h)
  {
  char buffer[10];

  sprintf(buffer, "%x", h);
  hwnd=WinWindowFromID(hwnd, id);
  WinSetWindowText(hwnd, buffer);
  }

void setText(HWND hwnd, ULONG id, char *s)
  {
  hwnd=WinWindowFromID(hwnd, id);
  WinSetWindowText(hwnd, s);
  }


MRESULT EXPENTRY dlgProc( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
  {
  HWND h, h1, h2;
  static char errname[128];
  char buffer[128];
  HMODULE mod;
  PFN p;
  APIRET rc;
  POINTL pt;
  PID pid;
  TID tid;
  SWP swp;

  switch (msg)
     {
     case WM_INITDLG:
        WinStartTimer(hab, hwnd, 1, 1000);
        DosLoadModule((PSZ)errname, sizeof(errname), (PSZ)"PMINFOD", &mod);
        DosQueryProcAddr(mod, 0, (PSZ)"POSTHOOK", &p);
        WinSetHook(hab, (HMQ)0, HK_INPUT, p, mod);
        init(hwnd);
        /*WinPostMsg(hwnd, WM_USER, 0,0);*/
        break;
     case WM_COMMAND:
        break;
     case WM_TIMER:
        h=WinQueryActiveWindow(HWND_DESKTOP);
        setTextHwnd(hwnd, ID_ACTIVE, h);
        h=WinQueryDesktopWindow(hab, 0);
        setTextHwnd(hwnd, ID_DESKTOPHANDLE, h);
        h=WinQueryWindow(h, QW_BOTTOM);
        h=WinWindowFromID(h, FID_CLIENT);
        setTextHwnd(hwnd, ID_WPSHANDLE, h);
        h=WinQueryFocus(HWND_DESKTOP);
        setTextHwnd(hwnd, ID_FOCUS, h);
        break;
     case WM_CLOSE:
        WinPostMsg(hwnd, WM_QUIT, 0,0);
        break;
     case WM_USER:
        pt.x=(int)mp1;
        pt.y=(int)mp2;
        h=WinWindowFromPoint(HWND_DESKTOP, &pt, TRUE);
        setTextHwnd(hwnd, ID_CURRENT, h);
        h1=WinQueryWindow(h, QW_PARENT);
        setTextHwnd(hwnd, ID_PCURRENT, h1);
        h1=WinQueryWindow(h1, QW_PARENT);
        setTextHwnd(hwnd, ID_PPCURRENT, h1);
        WinQueryClassName(h, 128, buffer);
        setText(hwnd, ID_CLASSNAME, buffer);
        WinQueryWindowText(h, 128, buffer);
        setText(hwnd, ID_WINDOWTEXT, buffer);
        h1=WinQueryWindow(h, QW_OWNER);
        setTextHwnd(hwnd, ID_OWNER, h1);
        WinQueryWindowProcess(h, &pid, &tid);
        setTextHwnd(hwnd, ID_PID, pid);
        setTextHwnd(hwnd, ID_TID, tid);
        sprintf(buffer, "(%i,%i)", pt.x, pt.y);
        setText(hwnd, ID_DESKTOPXY, buffer);

        WinQueryWindowPos(h, &swp);
        sprintf(buffer, "(%i,%i)", swp.x, swp.y);
        setText(hwnd, ID_XY, buffer);
        sprintf(buffer, "(%i,%i)", swp.cx, swp.cy);
        setText(hwnd, ID_CXCY, buffer);
        break;
     default:
        return(WinDefDlgProc(hwnd,msg,mp1,mp2));
     }
  }
