#ifndef _ACTION_H_
#define _ACTION_H_

#include "string.h"
#include "dlist.h"
#include "generic.h"

typedef int (* _System ActionFnPtr)(HWND frame);

struct ActionInit
  {
  ActionFnPtr action;
  char       *entry;
  char       *helptext;
  unsigned    id;
  HMODULE     hmod;
  unsigned    resid;
  };

struct Action
  {
    ActionFnPtr action;
    EString     entry;
    EString     helptext;
    unsigned    id;
    HMODULE     hmod;
    unsigned    resid;
  public:
    Action(ActionFnPtr p, char *s1, char *s2,
           int i=0, HMODULE h=0, unsigned r=0) :
        action(p), entry(s1), helptext(s2), id(i), hmod(h), resid(r) {}
    Action(Action& x) : action(x.action), entry(x.entry),
        helptext(x.helptext), id(x.id), hmod(x.hmod), resid(x.resid) {}
    Action(ActionInit& x) : action(x.action), entry(x.entry),
        helptext(x.helptext), id(x.id), hmod(x.hmod), resid(x.resid) {}
  };

typedef Action *PAction;

class ActionList
  {
    Dlist<PAction> alist;
  public:
    void append(Action *p);
    PAction operator[](int id);
  };

#endif
