#define INCL_DOS
#define INCL_WIN
#include <os2.h>
#include <stdio.h>
#include "toolbar.h"
#include "action.h"
#include "debug.h"
#include "statbar.h"
#include "edit.h"

MRESULT EXPENTRY wndProcToolbar(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
extern "C" void ctSetHelptext(HWND frame, ULONG msg, MPARAM mp1, MPARAM mp2);
PFNWP bpfn;
HPOINTER hHand=0;
HWND lastButton=0;

void registerToolbar(HAB hab)
  {
  static BOOL registered=FALSE;

  if (!registered)
      WinRegisterClass(hab, "ctToolbar", wndProcToolbar, 0, 4);
  }

MRESULT EXPENTRY newButtonProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
  {
  switch (msg)
     {
     case WM_MOUSEMOVE:
      if (!hHand)
           hHand=WinLoadPointer(HWND_DESKTOP, 0, 3000);
        WinSetPointer(HWND_DESKTOP, hHand);
        WinSendMsg(WinQueryWindow(hwnd, QW_OWNER), TB_SETMSG, (MPARAM)hwnd, 0);
        return (MPARAM)TRUE;
     }
  return (*bpfn)(hwnd, msg, mp1, mp2);
  }

MRESULT EXPENTRY wndProcToolbar(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
  {
  HENUM henum;
  HWND hwndNext, hwndButton;
  RECTL rect;
  int i;
  HPS hps;
  static int id=100;
  int height;
  ToolbarButtonData *pt;

  switch(msg)
    {
    case WM_CREATE:  break;
    case WM_DESTROY: break;
    case WM_COMMAND:
        WinSendMsg(WinQueryWindow(hwnd, QW_OWNER), msg, mp1, mp2);
        break;
    case WM_SIZE:
        break;
    case TB_REDRAW:
        WinQueryWindowRect(hwnd, &rect);
        height=rect.yTop-rect.yBottom;
        henum=WinBeginEnumWindows(hwnd);
        i=0;
        while(hwndNext=WinGetNextWindow(henum))
           {
           WinSetWindowPos(hwndNext,0,i*height,0,height, height,SWP_SIZE|SWP_MOVE);
           i++;
           }
        WinEndEnumWindows(henum);
        break;
    case TB_ADDBUTTON:
        {
        Action *action=(Action *)mp1;
        char title[256];
      typedef struct _FORECOLORPARAM
      {
          ULONG   id;
          ULONG   cb;

          ULONG   ulColor;
      } FORECOLORPARAM;
      typedef struct _FONTPARAM
      {
          ULONG   id;
          ULONG   cb;
          CHAR    szFontNameSize[20];
      } FONTPARAM;

      struct  _PRES                           // pres. params
      {
          ULONG   cb;                         // length
          FORECOLORPARAM fcparam;             // foreground color
          FONTPARAM      fntparam;            // font name & size
      }   pres;

        sprintf(title, "#%i", action->resid);
        sprintf(title, "%s", (char *)action->entry);
        sprintf(title, "#%i\t%s", action->resid,(char *)action->entry);
              pres.fcparam.id = PP_FOREGROUNDCOLORINDEX;
              pres.fcparam.cb = sizeof ( pres.fcparam.ulColor );

            pres.fcparam.ulColor = CLR_BLUE;
              pres.fntparam.id = PP_FONTNAMESIZE;
              pres.fntparam.cb = 20;
              strcpy ( pres.fntparam.szFontNameSize, "7.Helv" );

              pres.cb = sizeof ( pres.fcparam ) + sizeof ( pres.fntparam );
        hwndButton=WinCreateWindow(hwnd,
                        WC_BUTTON,
                        title,
                        WS_VISIBLE|BS_PUSHBUTTON|BS_ICON,
/*                      WS_VISIBLE|BS_TEXT|BS_MINIICON|BS_PUSHBUTTON, */
                        0,0,0,0,
                        hwnd,
                        HWND_BOTTOM,
                        action->id,0,&pres);
        bpfn=WinSubclassWindow(hwndButton, newButtonProc);
        WinPostMsg(hwnd, WM_USER, 0,0);
        WinSetWindowPtr(hwndButton, QWL_USER, (PVOID)mp1);
        break;
        }
    case TB_REMOVEBUTTONID:
        hwndButton=WinWindowFromID(hwnd, (USHORT)(ULONG)mp1);
        if (hwndButton)
           WinDestroyWindow(hwndButton);
        break;
    case TB_HWNDFROMID:
       return (MPARAM)WinWindowFromID(hwnd, (USHORT)(ULONG)mp1);
    case TB_SETMSG:
        if (lastButton!=(HWND)mp1)
           {
           HWND frame=WinQueryWindow(hwnd, QW_OWNER);
           lastButton=(HWND)mp1;
           ctSetHelptext(frame, 0, MPFROM2SHORT(WinQueryWindowUShort((HWND)mp1, QWS_ID),0), 0);
           }
        break;
    case WM_PAINT:
       hps = WinBeginPaint( hwnd, 0, (PRECTL)&rect);
       WinFillRect( hps, (PRECTL)&rect,SYSCLR_BUTTONMIDDLE);
       WinEndPaint( hps );
       break;
    default:
       return WinDefWindowProc(hwnd,msg,mp1,mp2);
    }
  return FALSE;
  }
