/******************************************************************************\
*                                                                              *
*  c't OS/2 Editor v0.7                                                        *
*                                                                              *
*  Modul:     toolbar.cpp                                                      *
*  Aufgabe:   einfacher Toolbar, der dynamisch zur Laufzeit aufgebaut          *
*             werden kann.                                                     *
*                                                                              *
\******************************************************************************/
#include "common.h"
#pragma hdrstop
#include <stdio.h>
#include "toolbar.h"
#include "action.h"
#include "debug.h"
#include "statbar.h"
#include "edit.h"

MRESULT EXPENTRY wndProcToolbar(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
extern "C" void ctSetHelptext(HWND frame, ULONG msg, MPARAM mp1, MPARAM mp2);

PFNWP bpfn;                     /* Zeiger auf die Subclass-Prozedur  */
HPOINTER hHand=0;               /* Handle fr den Hand-Pointer       */
HWND lastButton=0;              /* Falls die Hand (Zeiger) auf einen */
                                /* neuen Button bewegt wird, mu     */
                                /* der Statusbar aktualisiert werden */

/* Die folgenden Deklarationen der Strukturen werden fr die kleine  */
/* Schrift in Buttons bentigt.                                      */

typedef struct _FORECOLORPARAM
  {
  ULONG   id;
  ULONG   cb;
  ULONG   ulColor;
  } FORECOLORPARAM;
typedef struct _FONTPARAM
  {
  ULONG   id;
  ULONG   cb;
  CHAR    szFontNameSize[20];
  } FONTPARAM;

typedef struct  _PRES
  {
  ULONG   cb;
  FORECOLORPARAM fcparam;
  FONTPARAM      fntparam;
  } PRES;

/* Name     : registerToolbar
** Aufgabe  : Registrieren des Toolbars (so noch nicht geschehen)
** Parameter: HAB hab                   -  Handle Anchor Block
*/
void registerToolbar(HAB hab)
  {
  static BOOL registered=FALSE;

  if (!registered)
      WinRegisterClass(hab, "ctToolbar", wndProcToolbar, 0, 4);
  } /* registerToolbar */

/* Name     : newButtonProc
** Aufgabe  : Hand anzeigen, merken, ob Hand auf neuem Button
** Parameter: HWND hwnd                 - Button window handle
              ULONG msg                 - Message
              MPARAM mp1                - Parameter 1
              MPARAM mp2                - Parameter 2
** Ausgabe  : gem window procedure
*/
MRESULT EXPENTRY newButtonProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
  {
  switch (msg)
     {
     /* WM_MOUSEMOVE wird geschickt, wenn der Benutzer die Maus bewegt */
     case WM_MOUSEMOVE:
        /* Wenn der Pointer fr die Hand noch nicht geladen ist -> laden */
        if (!hHand)
           hHand=WinLoadPointer(HWND_DESKTOP, 0, 3000);

        /* Setze aktuelle Pointer */
        WinSetPointer(HWND_DESKTOP, hHand);

        /* An den Owner (Toolbar) eine Message senden, da Maus bewegt */
        WinSendMsg(WinQueryWindow(hwnd, QW_OWNER), TB_SETMSG, (MPARAM)hwnd, 0);

        /* nicht weiterbeatbeiten */
        return (MPARAM)TRUE;
     } /* endswitch: msg */

  /* Standar-Prozedur in allen anderen Fllen */
  return (*bpfn)(hwnd, msg, mp1, mp2);
  } /* newButtonProc */



/* Name     : wndProcToolbar
** Aufgabe  : Toolbar window procedure
** Eingabe  : HWND hwnd                 - toolbar window handle
              ULONG msg                 - Message
              MPARAM mp1                - Parameter 1
              MPARAM mp2                - Parameter 2
** Ausgabe  : gem window procedure
*/
MRESULT EXPENTRY wndProcToolbar(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
  {
  HENUM  henum;
  HWND   hwndNext, hwndButton;
  RECTL  rect;
  int    i;
  HPS    hps;
  static int id=100;
  int    height;

  switch(msg)
    {
    /* WM_COMMAND wird geschickt, wenn einer der Toolbar Buttons */
    /* gedrckt wird -> delegieren an Owner des Toolbars         */
    case WM_COMMAND:
        WinSendMsg(WinQueryWindow(hwnd, QW_OWNER), msg, mp1, mp2);
        break;

    /* interne Message: Neu-Zeichnen des Toolbars */
    case TB_REDRAW:
        /* Gre des Toolbars ermitteln */
        WinQueryWindowRect(hwnd, &rect);
        height=rect.yTop-rect.yBottom;

        /* Aufzhlen aller Childs (so kann man sich sparen, */
        /* alle Buttons zu "merken"                          */
        henum=WinBeginEnumWindows(hwnd);
        i=0;
        /* Solange noch Childs da sind ... */
        while ((hwndNext=WinGetNextWindow(henum))!=0)
           {
           /* ... setze diese auf die berechnete Position und Gre */
           WinSetWindowPos(hwndNext,0,i*height,0,height, height,SWP_SIZE|SWP_MOVE);
           i++;
           } /* endwhile: hwndNext=WinGetNextWindow(henum) */
        /* deinit des enumerierens */
        WinEndEnumWindows(henum);
        break;

    /* interne Message: hinzufgen eines Knopfes */
    case TB_ADDBUTTON:
        {
        PRES   pres;
        Action *action=(Action *)mp1;
        char   title[256];

        /* Wird ein Button mit Title gewnscht, so mu der Name */
        /* wie folgt aufgebut werden: */
        sprintf(title, "#%i\t%s", action->resid,(char *)action->entry);

        /* Die folgenden Zeilen setze ndie Presentation Parameter */
        /* des Buttons (kleine, blaue Schrift)                    */
        pres.fcparam.id = PP_FOREGROUNDCOLORINDEX;
        pres.fcparam.cb = sizeof ( pres.fcparam.ulColor );
        pres.fcparam.ulColor = CLR_BLUE;
        pres.fntparam.id = PP_FONTNAMESIZE;
        pres.fntparam.cb = 20;
        strcpy ( pres.fntparam.szFontNameSize, "7.Helv" );
        pres.cb = sizeof ( pres.fcparam ) + sizeof ( pres.fntparam );

        /* Nun den Button herstellen */
        hwndButton=WinCreateWindow(hwnd,
                        WC_BUTTON,
                        title,
                        WS_VISIBLE|BS_PUSHBUTTON|BS_ICON,
                        /* die folgende Zeile stdessen, falls Title erwnscht */
/*                      WS_VISIBLE|BS_TEXT|BS_MINIICON|BS_PUSHBUTTON, */
                        0,0,0,0,
                        hwnd,
                        HWND_BOTTOM,
                        action->id,
                        0,
                        &pres);                /* Achtung: PresParam explizit */

        /* Ok, nun subclassen, damit die Hand angezeigt werden kann */
        bpfn=WinSubclassWindow(hwndButton, newButtonProc);

        /* Alle Buttons neu positionieren */
        WinPostMsg(hwnd, TB_REDRAW, 0,0);

        /* Als window word zeiger auf Action setzen (wird z.Zt. nicht gebraucht */
        WinSetWindowPtr(hwndButton, QWL_USER, (PVOID)mp1);
        break;
        } /* endswitch: msg */

    /* interne Message: TB_REMOVEBUTTONID, lscht button mit bestimmter id */
    case TB_REMOVEBUTTONID:
        /* welcher ist es? */
        hwndButton=WinWindowFromID(hwnd, (USHORT)(ULONG)mp1);

        if (hwndButton)
           WinDestroyWindow(hwndButton);

        /* Alle Buttons neu positionieren */
        WinPostMsg(hwnd, TB_REDRAW, 0,0);
        break;
    case TB_REMOVEUSERBUTTONS:
        /* Aufzhlen aller Childs  */
        henum=WinBeginEnumWindows(hwnd);
        /* Solange noch Childs da sind ... */
        while((hwndNext=WinGetNextWindow(henum))!=0)
           {
           /* ... setze diese auf die berechnete Position und Gre */
           if (WinQueryWindowUShort(hwndNext, QWS_ID)>=(USHORT)(ULONG)mp1)
              WinDestroyWindow(hwndNext);
           } /* endwhile: hwndNext=WinGetNextWindow(henum) */
        /* deinit des enumerierens */
        WinEndEnumWindows(henum);
        WinPostMsg(hwnd, TB_REDRAW, 0,0);
        break;

    /* interne Message: TB_HWNDFROMID, bestimme button window handle von der id */
    case TB_HWNDFROMID:
       return (MPARAM)WinWindowFromID(hwnd, (USHORT)(ULONG)mp1);

    /* interne Message: TB_SETMSG, wird vom Button geschickt. Ist es ein  */
    /* neuer Button, auf dem die Maus bewegt wurde, so mu der Statustext */
    /* upgedated werden */
    case TB_SETMSG:
        if (lastButton!=(HWND)mp1)
           {
           HWND frame=WinQueryWindow(hwnd, QW_OWNER);
           lastButton=(HWND)mp1;
           ctSetHelptext(frame, 0, MPFROM2SHORT(WinQueryWindowUShort((HWND)mp1, QWS_ID),0), 0);
           } /* endif: lastButton!=(HWND)mp1 */
        break;

    /* diese Message wird geschickt, wenn Teile eines Fensters neu gezeichnet */
    /* werden sollen. In diesem fall wird einfach der Hintergrund mit einem   */
    /* hellen Grau gefllt                                                    */
    case WM_PAINT:
       hps = WinBeginPaint( hwnd, 0, (PRECTL)&rect);
       WinFillRect( hps, (PRECTL)&rect,SYSCLR_BUTTONMIDDLE);
       WinEndPaint( hps );
       break;
    /* Standard-Behandlung */
    default:
       return WinDefWindowProc(hwnd,msg,mp1,mp2);
    }
  return FALSE;
  } /* wndProcToolbar */
