/*
**  Diese DLL fgt - wie im PL/I Beispiel - einen Knopf in den Toolbar ein,
**  falls keine Datei editiert wird. Damit kann man die config.sys laden
**
**  Alle Ed*-Funktionen gehren zum Editor-API (ca. 50 Funktionen)
**  (Diese stehen in einem Feld von funktions-Zeigern. Um die Benutzung
**  zu erleichtern, werden diese durch die Ed*-Funktionen gekapselt.
**  Daher mit editapi.c oder editapi.lib (wg. DLL) linken.
**  Nur ein Beispiel! Parameter, Initialisierung, ... gem Artikel
**
*/
#define INCL_DOS
#define INCL_WIN
#include <os2.h>
#include <string.h>
#include "editapi.h"
#include "public.h"

/*
** loadFile - die "Aktions"funktion, falls der Benutzer auf load config klickt
*/

void APIENTRY loadFile(void *e)
  {
  char config[16];
  ULONG drive;

  /* Pfad hat folgende Form */
  strcpy(config, "x:\\config.sys");
  /* Frage OS/2 nach Boot-Laufwerk */
  DosQuerySysInfo(QSV_BOOT_DRIVE,QSV_BOOT_DRIVE, &drive, sizeof(drive));
  /* Setze Laufwerk */
  config[0]=drive+64;

  /* Editor-API */
  EdLoadFile(e, config);
  }

/*
** Die Initialisierung ist notwendig & sieht immer wie folgt aus:
*/
void APIENTRY ctEditInit(void *p)
  {
  EdInitialize(p);
  }

void APIENTRY ctNewName(void *e, char *name)
  {
  if (strcmp(name, "")==0)
     {
     EdAddToolbarButton(e, (ActionFnPtr)loadFile,
                   "config.sys ffnen", "Systemdatei config.sys ffnen",
                   MENU_TEMPITEM|MENU_SYNCHRON,0,2006,0);
     EdAddMenuItem(e, 100, (ActionFnPtr)loadFile,
                   "", "",
                   MENU_SEPARATOR,0,2006,0);
     EdAddMenuItem(e, 100, (ActionFnPtr)loadFile,
                   "config.sys ffnen", "Systemdatei Config.sys laden",
                   MENU_TEMPITEM|MENU_SYNCHRON,0,2006,0);
     }
  }
