/* BIN2C: Bin"arfile in C-Array verwandeln */
/* --------------------------------------- */
/* Autor: Harald Amschler, f"ur c't        */
/* V1.00: 01. August 1995                  */

#include <stdio.h>

int main(int argc, char *argv[])
{
	   FILE *binfile,*cfile;
       long int p = 0;
  unsigned char c;

  printf("BIN2C V1.00 (01.08.1995)\n"
	 "Author: Harald Amschler\n\n");
  if (argc!=4)
  {
    printf("Usage : BIN2C <binaryfile> <cfile> <arrayname>\n");
    return 0;
  }
  if ((binfile = fopen(argv[1],"rb"))==NULL)
    printf("!!! Source \"%s\" not found!\n",argv[1]);
  else
  {
    if ((cfile = fopen(argv[2],"wt"))==NULL)
      printf("!!! Destination \"%s\" not found!\n",argv[2]);
    else
    {
      fprintf(cfile,"unsigned char %s[] = {",argv[3]);
      while (fread(&c,sizeof(char),1,binfile)==1)
      {
	if (p!=0) fprintf(cfile,",");
	if (((p++) & 0x0F)==0) fprintf(cfile,"\n  ");
	fprintf(cfile,"%3i",(int)c);
      }
      fprintf(cfile,"\n};");
      fclose(cfile);
      fclose(binfile);
      return 0;  // OK.
    }
  }
  return 1;  // Fehler!
}