/******************************************************************************\
*                                                                              *
*  c't OS/2 Editor v0.7                                                        *
*                                                                              *
*  Modul:     editor.cpp                                                       *
*  Aufgabe:   einfaches Modell: pro Fenster ein Objekt, Methoden               *
*             werden in Messages an Fenster umgesetzt.                         *
*                                                                              *
\******************************************************************************/
#include "common.h"
#pragma hdrstop

#include "debug.h"
#include "editor.h"
#include "api.h"
#include "mle.h"
#include "enhframe.h"
#include "srchdlg.h"
#include "action2.h"

HMODULE module=0;

void cleanUpMenu(HWND hwnd, int userid);
MRESULT EXPENTRY SearchDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
BOOL fontDlg(HWND hwnd, FATTRS *fAttrs, BOOL monospaced);
int load(HWND hwnd, char *name);

inline void MsgBox(char *headline, char *text)
  {
  ensure(validread(headline) && validread(text));
  WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, (PSZ)text, (PSZ)headline, 0,
               MB_OK|MB_MOVEABLE);
  }

AppEditor::AppEditor() : name("")
   {
   initDefaultAction(actionlist);
   current_uid=USER_OFFSET_ID;
   current_id=PERMUSER_OFFSET_ID;
   current_cid=10000;

   /* Standardschrift fr monospaced */
   memset(&mfont, 0, sizeof(FATTRS));
   mfont.usRecordLength  = sizeof(FATTRS);
   strcpy(mfont.szFacename,"Courier");
   mfont.lMaxBaselineExt = 20;
   mfont.lAveCharWidth   = 8;

   /* Standardschrift fr proportional */
   memset(&pfont, 0, sizeof(FATTRS));
   pfont.usRecordLength  = sizeof(FATTRS);
   strcpy(pfont.szFacename,"System Proportional");
   pfont.lMaxBaselineExt = 20;
   pfont.lAveCharWidth   = 8;

   showToolbar=TRUE;
   indent=TRUE;
   quickmark=TRUE;

   contextMenu=0;
   }



/* Name     : *AppEditor::queryHelptext
** Task     : gib den Hilftext fr den Statusbar
** Input    : unsigned id               - id des Men/Toolbarknopfes
** Output   : String
*/
char *AppEditor::queryHelptext(unsigned id)
  {
  ActionBase *action=&actionlist[id];

  if (action)
     return (char *)action->helptext;
  else
    return "";
  } /* *AppEditor::queryHelptext */



/* Name     : AppEditor::updateStatusline
** Task     : update die Statuszeile
** Input    : int force                 - TRUE: unbedingt updaten
** State    : under construction
*/
void AppEditor::updateStatusline(int force)
  {
  if (updateStatus || force)
     {
     char buffer[256];
     char *s1="geaendert", *s2="nicht geaendert";
     sprintf(buffer, "Zeile %u (von %u), Spalte %i, %s", curline+1, maxline, curcol,
                      modified ? "gendert" : "nicht gendert");
     setStatusText(buffer);
     } /* endif: updateStatus || force */
  updateStatus=FALSE;
  } /* AppEditor::updateStatusline */



/* Name     : *AppEditor::setName
** Aufgabe  :
** Parameter: char *x                   -
** Rckgabe :
*/
char *AppEditor::setName(char *x)
  {
  ensure(validread(x));

  name=x;

  initDefaultAction(actionlist);
  WinPostMsg(toolbar, TB_REMOVEUSERBUTTONS, (MPARAM)USER_OFFSET_ID,0);
  WinPostMsg(frame, UM_REMOVEUSERITEMS, (MPARAM)USER_OFFSET_ID, 0);

  CallChangeName(this);

  if (name=="")
     WinSetWindowText(frame, "c't Editor");
  else
     WinSetWindowText(frame, queryName());

  return queryName();
  } /* *AppEditor::setName */



/* Name     : AppEditor::load
** Aufgabe  :
** Parameter: char *s                   -
** Rckgabe :
*/
void AppEditor::load(char *s)
  {
  ensure(validread(s));
  if (::loadMLE(queryMle(), s))
     setName(s);
  } /* AppEditor::load */

/* Name     : AppEditor::save
** Aufgabe  :
** Parameter: char *s                   -
** Rckgabe :
*/
void AppEditor::save(char *s)
  {
  ensure(validread(s));

  char buffer[CCHMAXPATH];

  if (!s)
     strcpy(buffer, queryName());
  else
     strcpy(buffer, s);


  ::save(queryMle(), buffer);

  setName(buffer);
  } /* AppEditor::save */


/* Name     : AppEditor::addToolbarButton
** Task     : fge einen neuen Knopf hinzu
** Input    : ActionFnPtr p             -  Zeiger auf ActionFn
              char *s1                  -  Meneintrag
              char *s2                  -  Hilfetext
*/
ActionFnPtr AppEditor::addToolbarButton(ActionFnPtr p, char *s1, char *s2,
                             int flag, HMODULE h, unsigned r, int *ret_id)
  {
  ensure (validread(p) && validread(s1) && validread(s2));
  ActionBase *action;
  ActionFnPtr oldFn=0;
  int id=(flag & MENU_PERMITEM) ? ++current_id : ++current_uid;
  if (ret_id) *ret_id=id;

  if (!(flag & MENU_OVERRIDEITEM))
     {
     action=new Action(p,s1,s2,id,h,r);
     if (flag & MENU_ASYNCHRON) action->setAsync(TRUE);
     ensure(action!=0);
     actionlist.append(action);
     /* Poste Message zum Hinzufgen an Toolbar */
     WinPostMsg(toolbar, TB_ADDBUTTON,(MPARAM)action,0);
     } /* !(flag & MENU_OVERRIDEITEM) */
  else
     {
     Action *a=(Action *)actionlist.queryAction(id);
     if (a)
        {
        ensure(validread(a));
        oldFn=a->do_action;
        a->do_action=p;
        a->entry=s1;
        a->helptext=s2;
        a->hmod=h;
        a->resid=r;
        action=&actionlist[id];
        if (flag & MENU_ASYNCHRON) action->setAsync(TRUE);
        }
     } /* endelse */

  return oldFn;
  } /* AppEditor::addToolbarButton */



/* Name     : AppEditor::addMenuItem
** Aufgabe  :
** Parameter: ActionFnPtr p             -
              int mainmenu              -
              char *s1                  -
              char *s2                  -
** Rckgabe :
*/
ActionFnPtr AppEditor::addMenuItem(ActionFnPtr p, int mainmenu, char *s1, char *s2,
                        int flag, HMODULE h, unsigned r, int *ret_id)
  {
  ensure (validread(p) && validread(s1) && validread(s2));
  ActionBase *action;
  ActionFnPtr oldFn;
  int id=(flag & MENU_PERMITEM) ? ++current_id : ++current_uid;
  if (ret_id) *ret_id=id;

  if (flag & MENU_SEPARATOR)
     {
     action=new Action(p,s1,s2,-1,h,r);
     if (flag & MENU_ASYNCHRON) action->setAsync(TRUE);
     WinPostMsg(frame, UM_ADDMENU, (MPARAM)action, (MPARAM)mainmenu);
     }
  else
     {
     Action *a=(Action *)actionlist.queryAction(id);
     if (!a)
        {
        action=new Action(p,s1,s2,id,h,r);
        if (flag & MENU_ASYNCHRON) action->setAsync(TRUE);
        ensure(action!=0);
        actionlist.append(action);

        WinPostMsg(frame, UM_ADDMENU, (MPARAM)action, (MPARAM)mainmenu);
        }
     else
        {
        ensure(validread(a));

        oldFn=a->do_action;
        a->do_action=p;
        a->entry=s1;
        a->helptext=s2;
        a->hmod=h;
        a->resid=r;
        action=&actionlist[id];
        if (flag & MENU_ASYNCHRON) action->setAsync(TRUE);
        }
     } /* endelse */
  return oldFn;
  } /* AppEditor::addMenuItem */

#ifdef DTS_EDITDLL


/* Name     : AppEditor::addToolbarButton
** Aufgabe  :
** Parameter: ActionMemberFnPtr p       -
              char *s1                  -
              char *s2                  -
** Rckgabe :
*/
ActionFnPtr AppEditor::addToolbarButton(ActionMemberFnPtr p, char *s1, char *s2,
                             int flag, HMODULE h, unsigned r, int *ret_id)
  {
  ensure (validread(p) && validread(s1) && validread(s2));
  ActionBase *action;
  ActionFnPtr oldFn=0;
  int id=(flag & MENU_PERMITEM) ? ++current_id : ++current_uid;
  if (ret_id) *ret_id=id;

  if (!(flag & MENU_OVERRIDEITEM))
     {
     action=new ActionMember(p,s1,s2,id,h,r);
     ensure(action!=0);
     if (flag & MENU_ASYNCHRON) action.setAsync(TRUE);
     actionlist.append(action);
     /* Poste Message zum Hinzufgen an Toolbar */
     WinPostMsg(toolbar, TB_ADDBUTTON,(MPARAM)action,0);
     } /* !(flag & MENU_OVERRIDEITEM) */
  return 0;
  } /* AppEditor::addToolbarButton */
#endif

#ifdef DTS_EDITDLL


/* Name     : AppEditor::addMenuItem
** Aufgabe  :
** Parameter: ActionMemberFnPtr p       -
              int mainmenu              -
              char *s1                  -
              char *s2                  -
** Rckgabe :
*/
ActionFnPtr AppEditor::addMenuItem(ActionMemberFnPtr p, int mainmenu, char *s1, char *s2,
                        int flag, HMODULE h, unsigned r, int *ret_id)
  {
  ensure (validread(p) && validread(s1) && validread(s2));
  ActionBase *action;
  ActionFnPtr oldFn;
  int id=(flag & MENU_PERMITEM) ? ++current_id : ++current_uid;
  if (ret_id) *ret_id=id;

  if (flag & MENU_SEPARATOR)
     {
     action=new ActionMember(p,s1,s2,-1,h,r);
     if (flag & MENU_ASYNCHRON) action.setAsync(TRUE);
     WinPostMsg(frame, UM_ADDMENU, (MPARAM)action, (MPARAM)mainmenu);
     }
  else if (!(flag & MENU_OVERRIDEITEM))
     {
     action=new ActionMember(p,s1,s2,id,h,r);
     ensure(action!=0);
     if (flag & MENU_ASYNCHRON) action.setAsync(TRUE);
     actionlist.append(action);

     WinPostMsg(frame, UM_ADDMENU, (MPARAM)action, (MPARAM)mainmenu);
     } /* endif: !(flag & MENU_OVERRIDEITEM) */
  return 0;
  } /* AppEditor::addMenuItem */
#endif



/* Name     : AppEditor::cleanContextMenu
** Aufgabe  :
** Rckgabe :
*/
void AppEditor::cleanContextMenu()
  {
  if (!contextMenu)
     contextMenu=WinCreateWindow(frame,
                                 WC_MENU,
                                 (PSZ)"SubMenu",
                                 WS_VISIBLE,
                                 0,0,0,0,
                                 frame,
                                 HWND_TOP,
                                 999,
                                 0,0);
  ensure(validwin(contextMenu));
  /* Zuerst alle Eintrge des Mens lschen */
  cleanUpMenu(contextMenu, 0);
  } /* AppEditor::cleanContextMenu */



/* Name     : AppEditor::addContextMenu
** Aufgabe  :
** Parameter: ActionFnPtr p             -
              int mainmenu              -
              char *s1                  -
              char *s2                  -
** Rckgabe :
*/
int AppEditor::addContextMenu(ActionFnPtr p, int mainmenu, char *s1, char *s2, int *ret_id)
  {
  ensure (validread(p) && validread(s1) && validread(s2));
  MENUITEM menuitem, mi;
  int id=++current_id;
  if (ret_id) *ret_id=id;

  Action *action=new Action(p,s1,s2,id,0,0);
  ensure(action!=0 && validread(action));
  actionlist.append(action);

  ensure(validwin(contextMenu));
  WinSendMsg(contextMenu, MM_QUERYITEM,
             MPFROM2SHORT((SHORT)(ULONG)mainmenu, TRUE),
             MPFROMP(&menuitem));

  mi.iPosition=MIT_END;
  mi.afStyle=MIS_TEXT;
  mi.afAttribute=0;
  mi.id=action->id;
  mi.hwndSubMenu=0;
  mi.hItem=0;

  if (mainmenu==0)
     {
     WinSendMsg(contextMenu, MM_INSERTITEM, &mi, (MPARAM)(char *)action->entry);
     } /* endif: mainmenu==0 */
  else
     {
     if (menuitem.hwndSubMenu==0)
        {
        menuitem.hwndSubMenu= WinCreateWindow(frame,
                                              WC_MENU,
                                              (PSZ)"SubMenu",
                                              WS_VISIBLE,
                                              0,0,0,0,
                                              frame,
                                              HWND_TOP,
                                              id++,
                                              0,0);
        ensure(validwin(menuitem.hwndSubMenu));
        WinSendMsg(contextMenu, MM_SETITEM, (MPFROM2SHORT(0,TRUE)), (MPARAM)&menuitem);
        } /* endif: menuitem.hwndSubMenu==0 */
     WinSendMsg(menuitem.hwndSubMenu, MM_INSERTITEM, &mi, (MPARAM)(char *)action->entry);
     } /* endelse */
  return id;
  } /* AppEditor::addContextMenu */

#ifdef DTS_EDITDLL


/* Name     : AppEditor::addContextMenu
** Aufgabe  :
** Parameter: ActionMemberFnPtr p       -
              int mainmenu              -
              char *s1                  -
              char *s2                  -
** Rckgabe :
*/
int AppEditor::addContextMenu(ActionMemberFnPtr p, int mainmenu, char *s1, char *s2, int *ret_id)
  {
  ensure (validread(p) && validread(s1) && validread(s2));
  MENUITEM menuitem, mi;
  int id=++current_id;
  if (ret_id) *ret_id=id;

  ActionBase *action=new ActionMember(p,s1,s2,id,0,0);
  ensure(action!=0 && validread(action));
  actionlist.append(action);

  ensure(validwin(contextMenu));
  WinSendMsg(contextMenu, MM_QUERYITEM,
             MPFROM2SHORT((SHORT)(ULONG)mainmenu, TRUE),
             MPFROMP(&menuitem));

  mi.iPosition=MIT_END;
  mi.afStyle=MIS_TEXT;
  mi.afAttribute=0;
  mi.id=action->id;
  mi.hwndSubMenu=0;
  mi.hItem=0;

  if (mainmenu==0)
     {
     WinSendMsg(contextMenu, MM_INSERTITEM, &mi, (MPARAM)(char *)action->entry);
     } /* endif: mainmenu==0 */
  else
     {
     if (menuitem.hwndSubMenu==0)
        {
        menuitem.hwndSubMenu= WinCreateWindow(frame,
                                              WC_MENU,
                                              (PSZ)"SubMenu",
                                              WS_VISIBLE,
                                              0,0,0,0,
                                              frame,
                                              HWND_TOP,
                                              id++,
                                              0,0);
        ensure(validwin(menuitem.hwndSubMenu));
        WinSendMsg(contextMenu, MM_SETITEM, (MPFROM2SHORT(0,TRUE)), (MPARAM)&menuitem);
        } /* endif: menuitem.hwndSubMenu==0 */
     WinSendMsg(menuitem.hwndSubMenu, MM_INSERTITEM, &mi, (MPARAM)(char *)action->entry);
     } /* endelse */
  return id;
  } /* AppEditor::addContextMenu */
#endif

/* Name     : AppEditor::loadini
** Task     : lade die Standard-Einstellungen aus den INIs
** State    : under construction
*/
void AppEditor::loadini()
  {
  Ini ini;
  ULONG sz;
  BOOL value;
  BOOL rc;

  sz=sizeof(ini);
  if (!PrfQueryProfileData(HINI_USERPROFILE, "c't Editor", "Settings",
                      &ini, &sz))
     {
     setFont(0,0,0);
     hideToolbar(FALSE);
     setQuickmark(FALSE);
     setIndent(FALSE);
     setWordWrap(FALSE);
     return;
     }
  mfont=ini.mfont;
  pfont=ini.pfont;
  setFont(0,0,!ini.type);
  hideToolbar(ini.toolbar);
  setQuickmark(ini.quickmark);
  setIndent(ini.indent);
  setWordWrap(ini.wrap);
  setBkColor(ini.bkColor);
  setFgColor(ini.fgColor);
  WinRestoreWindowPos("c't Editor", "Window Pos", queryFrame());
  } /* AppEditor::loadini */

/* Name     : AppEditor::saveini
** Task     : speichere die Grundeinstellungen in den INIs
*/
void AppEditor::saveini()
  {
  Ini ini;

/*
  memcpy((void *)ini.mfont, (void *)mfont, sizeof(mfont));
  memcpy((void +)ini.pfont, (void *)pfont, sizeof(pfont));
*/
  ini.mfont=mfont;
  ini.pfont=pfont;
  ini.type=font;
  ini.toolbar=queryHideToolbar();
  ini.quickmark=quickmark;
  ini.indent=indent;
  ini.wrap=queryWordWrap();
  ini.bkColor=queryBkColor();
  ini.fgColor=queryFgColor();

  PrfWriteProfileData(HINI_USERPROFILE, "c't Editor", "Settings",
                      &ini, sizeof(ini));
  WinStoreWindowPos("c't Editor", "Window Pos", queryFrame());
  } /* AppEditor::saveini */



/* Name     : AppEditor::add
** Aufgabe  :
** Parameter: char *text                -
              BOOL changeCurPos         -
              int offset                -
** Rckgabe :
*/
void AppEditor::add(char *text, BOOL changeCurPos, int offset)
  {
  ensure(validread(text));
  IPT ipt=offset==-1 ? queryCurrentCurPos() : offset;

  WinSendMsg(mle, MLM_INSERT, (MPARAM)text, 0);
  } /* AppEditor::add */



/* Name     : AppEditor::addLine
** Aufgabe  :
** Parameter: char *text                -
              BOOL changeCurPos         -
              int offset                -
** Rckgabe :
*/
void AppEditor::addLine(char *text, BOOL changeCurPos, int offset)
  {
  ensure(validread(text));
  } /* AppEditor::addLine */



/* Name     : AppEditor::setBkColor
** Aufgabe  :
** Parameter: unsigned color            -
** Rckgabe :
*/
void AppEditor::setBkColor(unsigned color)
  {
  WinSendMsg(mle, MLM_SETBACKCOLOR, (MPARAM)color, 0);
  } /* AppEditor::setBkColor */



/* Name     : AppEditor::queryBkColor
** Aufgabe  :
** Parameter: unsigned color            -
** Rckgabe :
*/
unsigned AppEditor::queryBkColor()
  {
  return (unsigned)WinSendMsg(mle, MLM_QUERYBACKCOLOR, 0, 0);
  } /* AppEditor::queryBkColor */



/* Name     : AppEditor::setFgColor
** Aufgabe  :
** Parameter: unsigned color            -
** Rckgabe :
*/
void AppEditor::setFgColor(unsigned color)
  {
  WinSendMsg(mle, MLM_SETTEXTCOLOR, (MPARAM)color, 0);
  } /* AppEditor::setFgColor */



/* Name     : AppEditor::queryFgColor
** Aufgabe  :
** Parameter: unsigned color            -
** Rckgabe :
*/
unsigned AppEditor::queryFgColor()
  {
  return (unsigned)WinSendMsg(mle, MLM_QUERYTEXTCOLOR, 0, 0);
  } /* AppEditor::queryFgColor */



/* Name     : AppEditor::isChanged
** Aufgabe  :
** Rckgabe :
*/
BOOL AppEditor::isChanged()
  {
  return (BOOL)WinSendMsg(mle, MLM_QUERYCHANGED, 0, 0);
  } /* AppEditor::isChanged */



/* Name     : AppEditor::clear
** Aufgabe  :
** Rckgabe :
*/
void AppEditor::clear()
  {
  WinSendMsg(mle, MLM_CLEAR, 0, 0);
  } /* AppEditor::clear */



/* Name     : AppEditor::copy
** Aufgabe  :
** Rckgabe :
*/
void AppEditor::copy()
  {
  WinSendMsg(mle, MLM_COPY, 0, 0);
  } /* AppEditor::copy */



/* Name     : AppEditor::cut
** Aufgabe  :
** Rckgabe :
*/
void AppEditor::cut()
  {
  WinSendMsg(mle, MLM_CUT, 0, 0);
  } /* AppEditor::cut */



/* Name     : AppEditor::paste
** Aufgabe  :
** Rckgabe :
*/
void AppEditor::paste()
  {
  WinSendMsg(mle, MLM_PASTE, 0, 0);
  } /* AppEditor::paste */



/* Name     : AppEditor::insert
** Aufgabe  :
** Parameter: char *text                -
** Rckgabe :
*/
void AppEditor::insert(char *text)
  {
  WinSendMsg(mle, MLM_INSERT, (MPARAM)text, 0);
  } /* AppEditor::insert */



/* Name     : AppEditor::discard
** Aufgabe  :
** Rckgabe :
*/
void AppEditor::discard()
  {
  WinSetWindowText(mle, "");
  setName("");
  } /* AppEditor::discard */



/* Name     : AppEditor::undo
** Aufgabe  :
** Rckgabe :
*/
void AppEditor::undo()
  {
  WinSendMsg(mle, MLM_UNDO, 0, 0);
  } /* AppEditor::undo */



/* Name     : AppEditor::queryCurrentLine
** Aufgabe  :
** Rckgabe :
*/
int AppEditor::queryCurrentLine()
  {
  int pos=(int)WinSendMsg(mle, MLM_QUERYSEL, (MPARAM)MLFQS_CURSORSEL, 0);
  ensure(pos>=0);
  return (int)(WinSendMsg(mle, MLM_LINEFROMCHAR, (MPARAM)-1, 0))+1;
  } /* AppEditor::queryCurrentLine */



/* Name     : AppEditor::queryCurrentCol
** Aufgabe  :
** Rckgabe :
*/
int AppEditor::queryCurrentCol()
  {
  int pos=(int)WinSendMsg(mle, MLM_QUERYSEL, (MPARAM)MLFQS_CURSORSEL, 0);
  int line=(int)WinSendMsg(mle, MLM_LINEFROMCHAR, (MPARAM)-1, 0);
  return pos-(ULONG)WinSendMsg(mle, MLM_CHARFROMLINE, (MPARAM)line, 0)+1;
  } /* AppEditor::queryCurrentCol */



/* Name     : AppEditor::queryCurrentCurPos
** Aufgabe  :
** Rckgabe :
*/
int AppEditor::queryCurrentCurPos()
  {
  return (int)WinSendMsg(mle, MLM_QUERYSEL, (MPARAM)MLFQS_CURSORSEL, 0);
  } /* AppEditor::queryCurrentCurPos */



/* Name     : AppEditor::setCurrentLine
** Aufgabe  :
** Parameter: int line                  -
** Rckgabe :
*/
void AppEditor::setCurrentLine(int line)
  {
  ensure(line>=1);
  IPT ipt=(IPT)WinSendMsg(mle, MLM_CHARFROMLINE, (MPARAM)(line-1), 0);
  WinSendMsg(mle, MLM_SETSEL, (MPARAM)ipt, (MPARAM)ipt);
  setCurLine(line); updateStatusline();

  } /* AppEditor::setCurrentLine */



/* Name     : AppEditor::setCurrentCol
** Aufgabe  :
** Parameter: int col                   -
** Rckgabe :
*/
void AppEditor::setCurrentCol(int col)
  {
  ensure(col>=1);
  int pos=(int)WinSendMsg(mle, MLM_QUERYSEL, (MPARAM)MLFQS_CURSORSEL, 0);
  int line=(int)WinSendMsg(mle, MLM_LINEFROMCHAR, (MPARAM)-1, 0);
  IPT ipt=(IPT)WinSendMsg(mle, MLM_CHARFROMLINE, (MPARAM)(line-1), 0);
  --col;
  WinSendMsg(mle, MLM_SETSEL, (MPARAM)(ipt+col), (MPARAM)(ipt+col));
  setCurColumn(col+1); updateStatusline();
  } /* AppEditor::setCurrentCol */



/* Name     : AppEditor::setCurrentCurPos
** Aufgabe  :
** Parameter: int pos                   -
** Rckgabe :
*/
void AppEditor::setCurrentCurPos(int pos)
  {
  ensure(pos>=0);
  WinSendMsg(mle, MLM_SETSEL, (MPARAM)pos, (MPARAM)pos);
  } /* AppEditor::setCurrentCurPos */



/* Name     : AppEditor::disableUpdate
** Aufgabe  :
** Rckgabe :
*/
void AppEditor::disableUpdate()
  {
  WinSendMsg(mle, MLM_DISABLEREFRESH, 0, 0);
  } /* AppEditor::disableUpdate */



/* Name     : AppEditor::enableUpdate
** Aufgabe  :
** Rckgabe :
*/
void AppEditor::enableUpdate()
  {
  WinSendMsg(mle, MLM_ENABLEREFRESH, 0, 0);
  } /* AppEditor::enableUpdate */



/* Name     : AppEditor::setWordWrap
** Aufgabe  :
** Parameter: BOOL w                    -
** Rckgabe :
*/
void AppEditor::setWordWrap(BOOL w)
  {
  ensure(w==TRUE || w==FALSE);
  WinSendMsg(mle, MLM_SETWRAP, (MPARAM)w, 0);
  } /* AppEditor::setWordWrap */



/* Name     : AppEditor::queryWordWrap
** Aufgabe  :
** Rckgabe :
*/
BOOL AppEditor::queryWordWrap()
  {
  return (BOOL)WinSendMsg(mle, MLM_QUERYWRAP, 0, 0);
  } /* AppEditor::queryWordWrap */



/* Name     : AppEditor::setReadOnly
** Aufgabe  :
** Parameter: BOOL b                    -
** Rckgabe :
*/
void AppEditor::setReadOnly(BOOL b)
  {
  WinSendMsg(mle, MLM_SETREADONLY, (MPARAM)b, 0);
  } /* AppEditor::setReadOnly */



/* Name     : AppEditor::queryReadOnly
** Aufgabe  :
** Rckgabe :
*/
BOOL AppEditor::queryReadOnly()
  {
  return (BOOL)WinSendMsg(mle, MLM_QUERYREADONLY, 0, 0);
  } /* AppEditor::queryReadOnly */



/* Name     : AppEditor::queryNrOfLines
** Aufgabe  :
** Rckgabe :
*/
int AppEditor::queryNrOfLines()
  {
  int pos=(int)WinSendMsg(mle, MLM_QUERYSEL, (MPARAM)MLFQS_CURSORSEL, 0);
  return (int)WinSendMsg(mle, MLM_QUERYLINECOUNT, 0, 0);
  } /* AppEditor::queryNrOfLines */



/* Name     : AppEditor::setChangedFlag
** Aufgabe  :
** Parameter: BOOL c                    -
** Rckgabe :
*/
void AppEditor::setChangedFlag(BOOL c)
  {
  ensure(c==TRUE || c==FALSE);
  WinSendMsg(mle, MLM_SETCHANGED, (MPARAM)c, 0);
  setModified(c); updateStatusline();
  } /* AppEditor::setChangedFlag */



/* Name     : AppEditor::removeLine
** Aufgabe  :
** Parameter: int line                  -
** Rckgabe :
*/
void AppEditor::removeLine(int line)
  {
  ensure(line>=1);
  IPT ipt1=(IPT)WinSendMsg(mle, MLM_CHARFROMLINE, (MPARAM)(line-1), 0);
  IPT ipt2=(IPT)WinSendMsg(mle, MLM_CHARFROMLINE, (MPARAM)(line), 0);
  WinSendMsg(mle, MLM_DELETE, (MPARAM)ipt1, (MPARAM)(ipt2-ipt1));
  } /* AppEditor::removeLine */



/* Name     : AppEditor::setFont
** Aufgabe  :
** Parameter: char *name                -
              int size                  -
              int monospaced            -
** Rckgabe :
*/
void AppEditor::setFont(char *name, int size, int monospaced)
  {
  if (monospaced==-1)
     monospaced=queryFonttype();

  if (monospaced)
     {
     if (name)
        {
        ensure (validread(name));
        strcpy(mfont.szFacename, name);
        }
     if (size)
        {
        ensure(size>=1 && size<=100);
        mfont.lAveCharWidth   = size;
        }
     WinSendMsg(mle, MLM_SETFONT, (MPARAM)&mfont, 0);
     setFonttype(0);
     } /* endif: monospaced */
  else
     {
     if (name)
        {
        ensure (validread(name));
        strcpy(pfont.szFacename, name);
        }
     if (size)
        {
        ensure(size>=1 && size<=100);
        pfont.lAveCharWidth   = size;
        }
     WinSendMsg(mle, MLM_SETFONT, (MPARAM)&pfont, 0);
     setFonttype(1);
     } /* endelse */
  } /* AppEditor::setFont */



/* Name     : AppEditor::setFont
** Aufgabe  :
** Parameter: FATTRS& f                 -
** Rckgabe :
*/
void AppEditor::setFont(FATTRS& f)
  {
  ensure(validread(&f));
  WinSendMsg(mle, MLM_SETFONT, (MPARAM)&f, 0);
  } /* AppEditor::setFont */



/* Name     : AppEditor::setText
** Aufgabe  :
** Parameter: char *s                   -
** Rckgabe :
*/
void AppEditor::setText(char *s)
  {
  ensure(validread(s));
  WinSetWindowText(mle, s);
  } /* AppEditor::setText */



/* Name     : AppEditor::queryTextLength
** Aufgabe  :
** Rckgabe :
*/
int AppEditor::queryTextLength()
  {
  return (int)WinSendMsg(mle, MLM_QUERYTEXTLENGTH, 0, 0);
  } /* AppEditor::queryTextLength */



/* Name     : AppEditor::getText
** Aufgabe  :
** Parameter: char *buffer              -
              int length                -
              int pos                   -
** Rckgabe :
*/
BOOL AppEditor::getText(char *buffer, int length, int pos)
  {
  ensure(validptr(buffer) && validptr(buffer+length-1) && pos>=0);

  WinSendMsg(mle, MLM_SETIMPORTEXPORT, MPFROMP((PBYTE)buffer), (MPARAM)length);

  IPT ipt1=pos;
  IPT ipt2=queryTextLength();

  if (ipt2>length-1) ipt2=length-1;

  return (BOOL)WinSendMsg(mle, MLM_EXPORT, (MPARAM)&ipt1, (MPARAM)&ipt2);
  } /* AppEditor::getText */



/* Name     : AppEditor::getTextLine
** Aufgabe  :
** Parameter: char *buffer              -
              int length                -
              int line                  -
** Rckgabe :
*/
BOOL AppEditor::getTextLine(char *buffer, int length, int line)
  {
  ensure(validptr(buffer) && validptr(buffer+length-1) && line>=1);

  int len;

  WinSendMsg(mle, MLM_SETIMPORTEXPORT, MPFROMP((PBYTE)buffer), (MPARAM)length);

  IPT ipt1=(IPT)WinSendMsg(mle, MLM_CHARFROMLINE, (MPARAM)(line), 0);
  IPT ipt2;

  if (line+1<=(int)WinSendMsg(mle, MLM_QUERYLINECOUNT, 0, 0))
     ipt2=(IPT)WinSendMsg(mle, MLM_CHARFROMLINE, (MPARAM)(line+1), 0);
  else
     ipt2=-1;

  if (ipt2>length-1) ipt2=length-1;

  len=(int)WinSendMsg(mle, MLM_EXPORT, (MPARAM)&ipt1, (MPARAM)&ipt2);

  buffer[len]=0;

  char *p=strchr(buffer, '\n');
  if (p)
     *p=0;
  p=strchr(buffer, '\r');
  if (p)
     *p=0;

  return TRUE;
  } /* AppEditor::getTextLine */



/* Name     : AppEditor::doAction
** Aufgabe  :
** Parameter: int id                    -
** Rckgabe :
*/
BOOL AppEditor::doAction(int id)
  {
  ensure(id>=0);

  ActionBase *action=queryAction(id);
  if (action)
     action->action(this);

  return action!=0;
  } /* AppEditor::doAction */



/* Name     : AppEditor::search
** Aufgabe  :
** Parameter: char *s                   -
              int offset                -
** Rckgabe :
*/
BOOL AppEditor::search(char *s, int offset)
  {
  // ...
  return FALSE;
  } /* AppEditor::search */



/* Name     : AppEditor::markall
** Aufgabe  :
** Rckgabe :
*/
void AppEditor::markall()
  {
  int count=(int)WinSendMsg(mle, MLM_QUERYFORMATTEXTLENGTH,0,(MPARAM)-1);
  WinSendMsg(mle, MLM_SETSEL, 0, (MPARAM)count);
  } /* AppEditor::markall */



/* Name     : AppEditor::queryHideToolbar
** Aufgabe  :
** Rckgabe :
*/
BOOL AppEditor::queryHideToolbar()
  {
  SWP swp;

  WinQueryWindowPos(toolbar, &swp);
  return swp.cy==0;
  } /* AppEditor::queryHideToolbar */



/* Name     : AppEditor::hideToolbar
** Aufgabe  :
** Parameter: BOOL b                    -
** Rckgabe :
*/
void AppEditor::hideToolbar(BOOL b)
  {
  ensure(b==TRUE || b==FALSE);
  SWP swp;

  WinQueryWindowPos(toolbar, &swp);
  WinSetWindowPos(toolbar, 0, swp.x, swp.y, swp.cy, b ? 0 : 50, SWP_SIZE);

  WinSendMsg(frame, WM_UPDATEFRAME,
     (MPARAM)( FCF_MINMAX | FCF_SIZEBORDER | FCF_SYSMENU
     | FCF_TITLEBAR | FCF_SHELLPOSITION | FCF_TASKLIST
     | FCF_MENU | FCF_ICON),0);

  WinShowWindow(toolbar, TRUE);
  WinPostMsg(toolbar, TB_REDRAW, 0,0);

  setMenuChecked(ID_MENUITEM_TOOLBAR, !b);
  } /* AppEditor::hideToolbar */



/* Name     : AppEditor::setIndent
** Aufgabe  :
** Parameter: BOOL b                    -
** Rckgabe :
*/
void AppEditor::setIndent(BOOL b)
  {
  ensure(b==TRUE || b==FALSE);

  indent=b;
  setMenuChecked(ID_MENUITEM_INDENT, b);
  WinSendMsg(mle, ED_AUTOINDENT, (MPARAM)b, 0);
  } /* AppEditor::setIndent */



/* Name     : AppEditor::setQuickmark
** Aufgabe  :
** Parameter: BOOL b                    -
** Rckgabe :
*/
void AppEditor::setQuickmark(BOOL b)
  {
  ensure(b==TRUE || b==FALSE);

  quickmark=b;
  WinSendMsg(mle, ED_QUICKCUTPASTE, (MPARAM)b, 0);
  setMenuChecked(ID_MENUITEM_QUICKMARK, b);
  } /* AppEditor::setQuickmark */



/* Name     : AppEditor::process
** Aufgabe  :
** Parameter: Editor *thisEditor        -
** Rckgabe :
*/
void AppEditor::process(Editor *thisEditor)
  {
  ensure(validread(thisEditor));
  int   i;
  HMQ   hmq;
  QMSG  qmsg;
  HWND  hwndToolbar, hwndFrame, hwndClient;
  ULONG flCreate;
  HAB   hab;

  /* Initialisieren */
  hab=WinInitialize(0);
  ensure(hab!=0);

  /* Message Queue */
  hmq=WinCreateMsgQueue(hab,500);
  ensure(hmq!=0);

  /* Toolbar & Statusbar registieren */
  registerToolbar(hab);
  registerStatusbar(hab);

  /* Flags */
  flCreate  = FCF_MINMAX | FCF_SIZEBORDER | FCF_SYSMENU
            | FCF_TITLEBAR | FCF_SHELLPOSITION | FCF_TASKLIST
            | FCF_MENU | FCF_ICON | FCF_ACCELTABLE;

  /* Mache ein Frame mit den entsprechenden Frame controls */
  hwndFrame = EnhWinCreateStdWindow(HWND_DESKTOP,
                                 0,
                                 &flCreate,
                                 WC_MLE,
                                 (PSZ)"c't Editor",
                                 0,
                                 module,
                                 ID_EDITOR,
                                 (PHWND) &hwndClient,
                                 this
                                 );
  ensure(hwndFrame!=0);
  ensure(hwndClient!=0);

  /* Subclasse den Client (= erweitertes MLE) */
  SubClassMle(hwndClient);

  setMle(WinWindowFromID(hwndFrame, FID_CLIENT));
  setColor(CLR_WHITE);

  /* Derzeit wird der Toolbar noch im Hauptprogramm aufgebaut */
  Action *action;

  hwndToolbar=WinWindowFromID(hwndFrame, FID_TOOLBAR);
  action=new Action((ActionFnPtr)0, "Laden", "Laden", ID_MENUITEM_OPEN, 0, 2001);
  WinSendMsg(hwndToolbar, TB_ADDBUTTON,(MPARAM)action,0);
  action=new Action((ActionFnPtr)0, "Speichern", "Speichern", ID_MENUITEM_SAVE, 0, 2002);
  WinSendMsg(hwndToolbar, TB_ADDBUTTON,(MPARAM)action,0);
  action=new Action((ActionFnPtr)0, "Drucken", "Drucken", ID_MENUITEM_PRINT, 0, 2003);
  WinSendMsg(hwndToolbar, TB_ADDBUTTON,(MPARAM)action,0);
  action=new Action((ActionFnPtr)0, "Suchen", "Suchen", ID_MENUITEM_SEARCH, 0, 2004);
  WinSendMsg(hwndToolbar, TB_ADDBUTTON,(MPARAM)action,0);
  action=new Action((ActionFnPtr)0, "Schrift", "Schrift", ID_MENUITEM_FONTTOGGLE, 0, 2005);
  WinSendMsg(hwndToolbar, TB_ADDBUTTON,(MPARAM)action,0);

  /* Einige Initialisierungen */
  setFrame(hwndFrame);
  setToolbar(WinWindowFromID(hwndFrame, FID_TOOLBAR));
  setStatusbar(WinWindowFromID(hwndFrame, FID_STATUSBAR));
  setMenuChecked(ID_MENUITEM_TOOLBAR);
  setConditionalMenu(ID_MENUITEM_FONTM, ID_MENUITEM_FONTMSET);
  setConditionalMenu(ID_MENUITEM_FONTP, ID_MENUITEM_FONTPSET);

  /* Lade Standard-Einstellungen */
  loadini();

  if (name=="")
     setName("");
  else
     load((char *)name);

  /* message loop */
  WinSendMsg(mle, MLM_FORMAT, (MPARAM)MLFIE_CFTEXT, 0);

  HELPINIT helpData;
  HWND helpInstance;

  memset((void *)&helpData, 0, sizeof(HELPINIT));
  helpData.cb=sizeof(HELPINIT);
  helpData.phtHelpTable=(HELPTABLE*)(0xffff0000|MAIN_HELPTABLE);
  helpData.pszHelpWindowTitle=(PSZ)"Editor help";
  helpData.pszHelpLibraryName="edit.hlp";

  helpInstance=WinCreateHelpInstance(hab, &helpData);
  if (helpInstance)
     WinAssociateHelpInstance(helpInstance, frame);

  WinSetWindowPtr(frame, QWL_USER, thisEditor);

  CallInitWindow(thisEditor);

  WinSetWindowPos(hwndFrame, HWND_TOP, 0, 0, 0, 0, SWP_ZORDER);
  WinShowWindow(hwndFrame, TRUE);
  while (WinGetMsg(hab, (PQMSG) &qmsg, 0, 0, 0) || TRUE)
     {
     if (qmsg.msg==WM_QUIT)
        qmsg.msg=UM_USERQUIT;
     if (qmsg.msg==UM_REALQUIT)
        break;
     WinDispatchMsg(hab, (PQMSG) &qmsg );
     }

  CallDeInitWindow(thisEditor);

  if (helpInstance)
     WinDestroyHelpInstance(helpInstance);

  /* Fenster zerstren */
  WinDestroyWindow(hwndFrame);

  /* destroy message queue */
  WinDestroyMsgQueue(hmq);

  /* Ressourcen freigeben */
  WinTerminate(hab);
  } /* AppEditor::process */



/* Name     : *AppEditor::queryAction
** Aufgabe  :
** Parameter: unsigned id               -
** Rckgabe :
*/
ActionBase *AppEditor::queryAction(unsigned id)
  {
  ensure(id>=0);
  return &actionlist[id];
  } /* *AppEditor::queryAction */

int AppEditor::open()
  {
  if (WinSendMsg(queryMle(), MLM_QUERYCHANGED, 0, 0))
     {
     if (WinMessageBox(HWND_DESKTOP, HWND_DESKTOP,
         (PSZ)"Achtung, die Datei wurde gendert. Wollen Sie "
              "die Datei speichern?", "Achung",
              0, MB_YESNO) ==MBID_YES)
        {
        save();
        } /* endif: WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, */
     } /* endif: WinSendMsg(hwndMle, MLM_QUERYCHANGED, 0, 0) */

  char buffer[CCHMAXPATH];
  if (::load(queryMle(), buffer))
     setName(buffer);

  return 0;
  }

int AppEditor::print()
  {
  MsgBox("Funktion nicht vorhanden", "Das Drucken ist noch nicht vorhanden");
  return 0;
  }

int AppEditor::dlgSearch()
  {
  if (!WinDlgBox(HWND_DESKTOP, queryMle(), SearchDlgProc, module, ID_DLG_SEARCH, this))
     MsgBox("Suchen", "Der Suchbegriff wurde nicht gefunden");

  return 0;
  }

int AppEditor::setMonoFont()
  {
  fontDlg(frame, &queryMonoFont(), TRUE);
  setFont(queryMonoFont());
  return 0;
  }

int AppEditor::setPropFont()
  {
  fontDlg(frame, &queryMonoFont(), FALSE);
  setFont(queryMonoFont());
  return 0;
  }

int AppEditor::fontToggle()
  {
  if (!queryFonttype())
     setFont(queryPropFont());
  else
     setFont(queryMonoFont());
  setFonttype(!queryFonttype());

  return 0;
  }

int AppEditor::colorPalette()
  {
  HOBJECT h=WinQueryObject("<WP_LORESCLRPAL>");
  ensure(h!=0);
  WinSetObjectData(h, "OPEN=DEFAULT");
  return 0;
  }

int AppEditor::about()
  {
  MsgBox("Produktinformation", "c't Editor");
  return 0;
  }
