/******************************************************************************\
*                                                                              *
*  c't OS/2 Editor v0.7                                                        *
*                                                                              *
*  Modul:     mle.cpp                                                          *
*  Aufgabe:   ein MLE, das (per Subclassing) um einige einfache Funktionen     *
*             erweitert wird.                                                  *
*                                                                              *
\******************************************************************************/
#include "common.h"
#pragma hdrstop
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include "debug.h"
#include "Editor.h"
#include "ctedit.h"
#include "statbar.h"
#include "mle.h"

// alte MLE-Prozedur
PFNWP pfn;


/* Name     : queryCursor
** Aufgabe  : Cursor, Zeile usw. ermitteln
** Parameter: HWND hwndMLE              - MLE window handle
              int *curline              - Zeile
              int *curcol               - Spalte
              int *maxline              - Letzte Zeile
              int *modified             - MLE modifiziert
*/
void queryCursor(HWND hwndMLE, int *curline, int *curcol, int *maxline, int *modified)
  {
  ensure(validwin(hwndMLE) && validptr(curline) && validptr(curcol) && validptr(maxline) && validptr(modified));

  int pos=(int)WinSendMsg(hwndMLE, MLM_QUERYSEL, (MPARAM)MLFQS_CURSORSEL, 0);
  *maxline=(int)WinSendMsg(hwndMLE, MLM_QUERYLINECOUNT, 0, 0);
  *curline=(int)WinSendMsg(hwndMLE, MLM_LINEFROMCHAR, (MPARAM)-1, 0);
  *curcol=pos-(ULONG)WinSendMsg(hwndMLE, MLM_CHARFROMLINE, (MPARAM)*curline, 0)+1;
  *modified=(BOOL)WinSendMsg(hwndMLE, MLM_QUERYCHANGED, 0 ,0);
  ensure(*modified==TRUE || *modified==FALSE);
  } /* queryCursor */



/* Name     : is_ger_alpha
** Aufgabe  : Zeichen gem deutschen Alphabet
** Parameter: char c                    - das Zeichen
*/
int is_ger_alpha(char c)
  {
  return (isalpha(c)) || isdigit(c) || strchr("", c);
  } /* is_ger_alpha */


/* Name     : extMleProc
** Aufgabe  : erweiterte MLE-Funktion
** Parameter: gem window procedure
*/
extern "C" MRESULT EXPENTRY extMleProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
  {
  int line;
  IPT pos;
  HWND hwndParent;
  MRESULT ret;
  BOOL indent, quickmark;
  ULONG style;
  BOOL vk_down;
  int vk;
  int curcol;
  int curline;
  int maxline;
  int modified;

  // Editorobjekt ermitteln
  hwndParent=WinQueryWindow(hwnd, QW_PARENT);
  Editor *edit=(Editor *)WinQueryWindowPtr(hwndParent, QWL_USER);
  ensure(validread(edit));

  // edit==0: Fehler
  if (!edit)
     return 0;

  // MLE handle ermitteln
  HWND hwndMLE=edit->queryMle();

  // Im window word vom MLE steht Quick marking, Auto-Indent
  style=WinQueryWindowULong(hwnd, QWL_USER);

  switch(msg)
     {
     /* interne Message: Schalte Auto-indent an/aus */
     case ED_AUTOINDENT:
          WinSetWindowBits(hwnd, QWL_USER, (ULONG)mp1 ? 0xffff : 0, EXTMLE_AUTOINDENT);
          break;
     /* Intere Message: Schalte Quick cut&paste an/aus */
     case ED_QUICKCUTPASTE:
          WinSetWindowBits(hwnd, QWL_USER, (ULONG)mp1 ? 0xffff : 0, EXTMLE_QUICKCUTPASTE);
          break;

     case WM_ACTIVATE:
     case WM_BUTTON1DOWN:
          // linker Button: update der Statuszeile
          ret=(*pfn)(hwnd, msg, mp1, mp2);
          queryCursor(hwndMLE, &curline, &curcol, &maxline, &modified);
          edit->setMaxLine(maxline);
          edit->setCurLine(curline);
          edit->setCurColumn(curcol);
          edit->setModified(modified);
          edit->updateStatusline();
          return ret;

     case WM_CHAR:
          // Abfangen der Tasten
          indent=style&EXTMLE_AUTOINDENT;

          vk_down=(SHORT1FROMMP(mp1)&KC_VIRTUALKEY) && ((SHORT1FROMMP(mp1) & KC_KEYUP) != KC_KEYUP);
          vk=SHORT2FROMMP(mp2);
          if (indent && vk_down)
             {
             // Enter && Auto-Indent
             if (vk==VK_NEWLINE)
                {
                 char *buffer;
                 MRESULT ret;
                 IPT ipt, cpos;
                 int col, bytes;
                 int pline, count;
                 char *p, i;

                 queryCursor(hwndMLE, &curline, &curcol, &maxline, &modified);
                 pline= (int)WinSendMsg(hwnd, MLM_LINEFROMCHAR, (MPARAM)(curline-1), 0);

                 pos = (IPT)WinSendMsg(hwnd, MLM_CHARFROMLINE, (MPARAM)curline, 0);
                 cpos= (IPT)WinSendMsg(hwnd, MLM_QUERYSEL, (MPARAM)MLFQS_CURSORSEL, 0);

                 buffer=(char *)malloc(4096);
                 WinSendMsg(hwnd, MLM_SETIMPORTEXPORT, MPFROMP((PBYTE)buffer), (MPARAM)(4096));

                 count=cpos-pos;
                 WinSendMsg(hwnd, MLM_EXPORT, &pos, &cpos);

                 for (col=0; buffer[col]; col++)
                   if (buffer[col]!=' ')
                      break;

                 ret=(*pfn)(hwnd, msg, mp1, mp2);

                 for (i=0; i<col; i++)
                    ret=(*pfn)(hwnd, WM_CHAR, (MPARAM)0x39011007,
                                              (MPARAM)0x100020);
                 return ret;
                 } /* endfor: buffer[col] */
             } /* endif: vk==VK_NEWLINE */

             // Statuszeile updaten
             queryCursor(hwndMLE, &curline, &curcol, &maxline, &modified);
             edit->setMaxLine(maxline);
             edit->setCurLine(curline);
             edit->setCurColumn(curcol);
             edit->setModified(modified);
             edit->updateStatusline();

             // Nicht mit Piepsen nerven, falls am Ende, Anfang mit Cursor
             if (vk_down)
                {
                if (curline<=0)
                   {
                   if (vk==VK_UP || vk==VK_PAGEUP || (curcol<=1 && vk==VK_LEFT))
                      return 0;
                   } /* endif: curline<=0 */
                if (curline>=(maxline-1))
                   {
                   if (vk==VK_DOWN || vk==VK_PAGEDOWN|| (vk==VK_RIGHT && (pos==(int)WinSendMsg(hwndMLE, MLM_QUERYTEXTLENGTH, 0,0))))
                      return 0;
                   } /* endif: curline>=(maxline-1) */
                } /* endif: vk_down */
             break;
     case WM_ENDSELECT:
             // Bei Quickmark automatisch ins Clipboard
             quickmark=style&EXTMLE_QUICKCUTPASTE;
             if (quickmark)
                {
                ret=(*pfn)(hwnd, msg, mp1, mp2);
                WinSendMsg(hwnd,MLM_COPY,0,0);
                return ret;
                } /* endif: quickmark */
             break;
     case WM_BUTTON3CLICK:
             // Button 3 (mittlere Taste) == pasten (wie X)
             quickmark=style&EXTMLE_QUICKCUTPASTE;
             if (quickmark)
                 WinSendMsg(hwnd,MLM_PASTE,0,0);
             break;
     case WM_BUTTON2CLICK:
             {
             // Kontextmen
             char *buffer;
             MRESULT ret;
             IPT ipt, cpos;
             int col, bytes;
             int pline, count;
             char *p, *pp, i;
             char word[256];
             int left;

             (*pfn)(hwnd, WM_BUTTON1DOWN, mp1, mp2);
             (*pfn)(hwnd, WM_BUTTON1UP, mp1, mp2);

             line= (int)WinSendMsg(hwnd, MLM_LINEFROMCHAR, (MPARAM)-1, 0);
             pos = (IPT)WinSendMsg(hwnd, MLM_CHARFROMLINE, (MPARAM)line, 0);
             cpos=(IPT)WinSendMsg(hwnd, MLM_QUERYSEL, (MPARAM)MLFQS_CURSORSEL, 0);
             count=cpos-pos;
             left=pos;

             buffer=new char [4096];
             ensure(validptr(buffer));
             if (!buffer)
                return 0;

             cpos=100;
             WinSendMsg(hwnd, MLM_SETIMPORTEXPORT, MPFROMP((PBYTE)buffer), (MPARAM)(4096));
             WinSendMsg(hwnd, MLM_EXPORT, &pos, &cpos);
             p=buffer+count;
             left+=count;

             while (p>buffer && p<buffer+4096 && is_ger_alpha(*p))
                {
                p--;
                left--;
                } /* endwhile: p>buffer && p<buffer+4096 && is_ger_alpha(*p) */
             if (p>buffer)
                {
                left++;
                p++;
                } /* endif: p>buffer */

             for (pp=word; is_ger_alpha(*p); p++, pp++)
                *pp=*p;
             *pp++=0;

             WinSendMsg(hwnd, MLM_SETSEL,
                (MPARAM)left, (MPARAM)(left+strlen(word)));

             edit->cleanContextMenu();
             CallContextMenu(edit, edit->queryName(), word);

             POINTL pt;
             WinQueryPointerPos(HWND_DESKTOP, &pt);
             WinPopupMenu(HWND_DESKTOP,
                          edit->queryFrame(),
                          edit->queryContextMenu(),
                          pt.x,pt.y,0,PU_HCONSTRAIN|PU_VCONSTRAIN|
                          PU_KEYBOARD|
                          PU_MOUSEBUTTON1|
                          PU_MOUSEBUTTON2|
                          PU_MOUSEBUTTON3
                          );

             delete[] buffer;
             break;
             } /* endif: indent && vk_down */
     default:
        return (*pfn)(hwnd, msg, mp1, mp2);
     } /* endswitch: msg */
  return (*pfn)(hwnd, msg, mp1, mp2);
  }
