/*
**  Diese DLL fgt - wie im PL/I Beispiel - einen Knopf in den Toolbar ein,
**  falls keine Datei editiert wird. Damit kann man die config.sys laden
**
**  Alle Ed*-Funktionen gehren zum Editor-API (ca. 50 Funktionen)
**  (Diese stehen in einem Feld von funktions-Zeigern. Um die Benutzung
**  zu erleichtern, werden diese durch die Ed*-Funktionen gekapselt.
**  Daher mit editapi.c oder editapi.lib (wg. DLL) linken.
**  Nur ein Beispiel! Parameter, Initialisierung, ... gem Artikel
**
*/
#define INCL_DOS
#define INCL_WIN
#include <os2.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "editapi.h"
#include "public.h"

char buffer[4096];

struct Table
  {
  char *keyword;
  char *help;
  char *def;
  };

struct Table table[]= {
  "Threads", "Maximale Anzahl der Threads\nGltige Werte: 64-4095", "THREADS=256\n",
  "Files",   "Anzahl der offenen Dateien (nur DOS)", "FILES=20\n",
  "Break",   "Ctrl-Break prfen (nur DOS)", "BREAK=ON\n",
  "Device",  "Einbinden eines Einheitentreibers", "DEVICE=???\n",
  "DiskCache", "Einrichten eines Plattenpuffers\n"
               "DISKCACHE=n,LW,T,AC:x", "DISKCACHE=128\n",
  "PATH",    "SuchPfad fr Programme", "PATH=???\n",
  "LIBPATH", "SuchPfad fr Dynamic Link Libraries", "LIBPATH=???\n",
  "DPATH", "SuchPfad fr Daten", "DPATH=???\n",

  0,0,0 };

char *lookupHelp(char *s)
  {
  int i;
  for (i=0;table[i].keyword;i++)
     if (!stricmp(s, table[i].keyword))
        return table[i].help;
  return 0;
  }

char *lookupDefault(char *s)
  {
  int i;
  for (i=0;table[i].keyword;i++)
     if (!stricmp(s, table[i].keyword))
        return table[i].def;
  return 0;
  }

int APIENTRY help1(PEditor e)
  {
  static char b[4096];
  sprintf(b, "view cmdref %s", buffer);
  system(b);
  return 0;
  }

int APIENTRY help2(PEditor e)
  {
  char *s=lookupHelp(buffer);
  if (s)
     WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, s, "Hilfe", 100,
                   MB_OK|MB_MOVEABLE);
  return 0;
  }

int APIENTRY help3(PEditor e)
  {
  int line, pos;
  char *s=lookupDefault(buffer);

  if (s)
     {
     line=EdQueryCurrentLine(e);
     EdRemoveLine(e, line);
     pos=EdQueryCurrentCurPos(e);
     EdAddTextOffset(e, s, pos);
     }

  return 0;
  }

/*
** Die Initialisierung ist notwendig & sieht immer wie folgt aus:
*/
void APIENTRY ctEditInit(void *p)
  {
  EdInitialize(p);
  }

void APIENTRY ctContextMenu(void *e, char *name, char *selection)
  {
  int id;
  char filename[CCHMAXPATH];
  strcpy(filename, name);
  strlwr(filename);

  if (strstr(filename, "config.sys"))
     {
     static char b[1024], *s;
     strcpy(buffer, selection);

     sprintf(b, "Zeigt die Online Dokumentation zum Thema \"%s\"", selection);
     EdAddContextMenu(e, 0, help1, "OS/2 Hilfe", b, 0);
     if (s=lookupHelp(selection))
        {
        EdAddContextMenu(e, 0, help2, "Kurzhilfe", s, 0);
        EdAddContextMenu(e, 0, help3, "Standardwert",
                    "Ersetzen der aktuellen Zeile durch einen Standardwert", 0);
        }
     }
  }
