{ Routinen fr MacInterface-Projekt,  C.Meyer 8/94. berarbeitet 6/95 }
{ ADBs-Resource mit PostEvent-Routine nicht vergessen! }

unit MacInterface;

interface

	uses
		DeskBus, Traps;

	const
{ Applikationsspezifische Konstanten }
		kADBDeviceInitial = $7;
		kADBListen = $8;					{ ADB-Befehlskonstanten }
		kADBTalk = $C;
		kADBFlush = $1;
		kADBReset = 0;
		kADBcmdmsk = $FC;				{ Maske fr ADB-Befehl, filtert Register aus }
		kADBregmsk = $03;				{ Maske fr ADB-Register, filtert Befehl aus }
 { wird eigentlich von Apple zugeteilt, hier vorlufig: }
		kADBhdlID = $09;
 { Flags fr Host- und Device-Service-Flagregister }
		kP0fc = $1;         					{ PortSelectBits/PortServFlags-Konstanten }
		kP1fc = $2;
		kSerfc = $4;
		kBdfc = $8;
		kDispfc = $10;
		kCdRdfc = $20;        				{ Befehl zum Auslesen der T-Karte }
		kDevConfc = $80; 					{ Konfiguration (Display-Debug-Mode) setzen }
		kAllOff = $F0 + 8;					{ fr Kartenleseroutine }
{ Konfigurationen MacInterface }
		kDevCdebug = 1; 					{ Debug-Monitor Display }
		kDevConf1 = 2; 						{ weitere Konfigurationen (reserviert) }
		kDevConf2 = 4;
		kDevConf3 = 8;
		kDevConf4 = 16;
		kDevConf5 = 32;
		kDevConf6 = 64;
		kDevConf7 = 128;

	var
{ globale Variablen fr MacInterface }
		gADBDevice: byte;				{ enthlt nach InitADB Device-Nummer von MacInterface }
		gADBServRoutinePtr: Ptr; { enthlt nach InitADB Ptr auf EventPost-Routine }

{ High-Level-Routinen: }

	function InitADB: OSErr;
{ holt EventPost-Routine, initialisiert Ports und ADBSetInfoBlock. }
{ Liefert noErr wenn erfolgreich }

	procedure TerminateADB;
{ entsorgt EventPost-Routine, deinitialisiert ADBSetInfoBlock fr MacInterface }

	procedure SetPort0 (pVal: byte);		{ wie der Name schon sagt...}
	procedure SetPort1 (pVal: byte);
	function GetPort0: byte;
	function GetPort1: byte;
	procedure SetBd (bVal: byte);				{ bVal enthlt Baudrate/100 }
	procedure SetDebugOn;
	procedure SetDebugOff;
	procedure SendSer (dChar: Char);		{ dChar enthlt seriell zu sendendes Zeichen }
	procedure SendDisp (dChar: char);	{ dChar enthlt anzuzeigendes Zeichen }
	procedure ReadCd;								{ Befehl zum Lesen der T-Karte }

{ Low-Level-Routinen hnlich ADBOp, selten gebraucht: }
	function sendADB (cmdbyte: byte; byte1: byte; byte2: byte): osErr;
	function recvADB (cmdbyte: byte; byte1: byte; byte2: byte): osErr;

implementation
	var
		gADBSetInfoBlock: ADBSetInfoBlock;
		gADBServCode: Handle;
		gADBopBuf: packed array[0..7] of byte;
		aLong: LongInt;

	function sendADB (cmdbyte: byte; byte1: byte; byte2: byte): osErr;
{ Senden eines ADB-Kommandos ohne Completion-Routine }
	begin
		gADBopBuf[0] := 2;
		gADBopBuf[1] := byte1;
		gADBopBuf[2] := byte2;
		sendADB := ADBOp(nil, nil, @gADBopBuf, cmdbyte);
	end;


	function recvADB (cmdbyte: byte; byte1: byte; byte2: byte): osErr;
{ Senden eines ADB-Kommandos, Completion-Routine liefert App1Evt }
	begin
		gADBopBuf[0] := 2;
		gADBopBuf[1] := byte1;
		gADBopBuf[2] := byte2;
		recvADB := ADBOp(nil, gADBServRoutinePtr, @gADBopBuf, cmdbyte);
	end;

	procedure SetPort0 (pVal: byte);
	begin
		if sendADB(gADBDevice * 16 + kADBListen, kP0fc, pval) = noErr then
			delay(1, aLong);
	end;

	procedure SetPort1 (pVal: byte);
	begin
		if sendADB(gADBDevice * 16 + kADBListen, kP1fc, pval) = noErr then
			delay(1, aLong);
	end;

	function GetPort0: byte;						{ wie der Name schon sagt...}
		var
			gotEvent: BOOLEAN;
			theEvent: EventRecord;
	begin
{ ADBOp mit Service-Routine aufrufen. Nach Erhalt des Wertes liefert letztere }
{ einen Event, auf den die Schleife wartet. Kann einige ms dauern }
		gADBopBuf[0] := 0;
		if ADBOp(nil, gADBServRoutinePtr, @gADBopBuf, gADBDevice * 16 + kADBTalk + 1) = noErr then
			repeat
				repeat
					delay(2, aLong);
				until waitnextevent(app1Mask, theEvent, 30, nil);
{ Warten, bis App1Evt mit gegebenen Kommando im obersten Byte zurckkommt }
			until BSR(BAND(theEvent.message, $FF000000), 24) = gADBDevice * 16 + kADBTalk + 1;
{ Port 0 im untersten Byte der Event-Message }
		GetPort0 := BAND(theEvent.message, $000000FF);
	end;

	function GetPort1: byte;
		var
			gotEvent: BOOLEAN;
			theEvent: EventRecord;
	begin
		gADBopBuf[0] := 0;
		if ADBOp(nil, gADBServRoutinePtr, @gADBopBuf, gADBDevice * 16 + kADBTalk + 1) = noErr then
			repeat
				repeat
					delay(2, aLong);
				until waitnextevent(app1Mask, theEvent, 30, nil);
			until BSR(BAND(theEvent.message, $FF000000), 24) = gADBDevice * 16 + kADBTalk + 1;
{ Port 1 im zweiten Byte der Event-Message }
		GetPort1 := BSR(BAND(theEvent.message, $0000FF00), 8);
	end;

	procedure SetBd (bVal: byte);
	begin
		if sendADB(gADBDevice * 16 + kADBListen, kBdfc, bVal) = noErr then
			delay(1, aLong);
	end;

	procedure SetDebugOn;
	begin
		if sendADB(gADBDevice * 16 + kADBListen, kDevConfc, 1) = noErr then
			delay(1, aLong);
	end;

	procedure SetDebugOff;
	begin
		if sendADB(gADBDevice * 16 + kADBListen, kDevConfc, 0) = noErr then
			delay(1, aLong);
	end;

	procedure SendSer (dChar: Char);
	begin
		if sendADB(gADBDevice * 16 + kADBListen, kSerfc, byte(dChar)) = noErr then
			delay(1, aLong);
	end;

	procedure SendDisp (dChar: char);
	begin
		if sendADB(gADBDevice * 16 + kADBListen, kDispfc, byte(dChar)) = noErr then
			delay(1, aLong);
	end;

	procedure ReadCd;
	begin
		if sendADB(gADBDevice * 16 + kADBListen, kCdRdfc, 0) = noErr then
			delay(1, aLong);
	end;

	function InitADB: OSErr;
		var
			aLong: LongInt;
{ holt EventPost-Routine, initialisiert Ports und ADBSetInfoBlock. Liefert noErr wenn erfolgreich }
	begin
		gADBServCode := GetResource('ADBs', 128);
		if (gADBServCode <> nil) then
			HLock(gADBServCode);
		gADBServRoutinePtr := gADBServCode^;
		gADBDevice := kADBDeviceInitial;
		gADBSetInfoBlock.siServiceRtPtr := gADBServRoutinePtr;
		gADBSetInfoBlock.siDataAreaAddr := nil;
		InitADB := SetADBInfo(gADBSetInfoBlock, gADBDevice);
		if (gADBServCode = nil) then
			InitADB := InitADB + 1;
		if sendADB(gADBDevice * 16 + kADBFlush, 0, 0) = 0 then
			;
		delay(1, aLong);
	end;

	procedure TerminateADB;
{ entsorgt EventPost-Routine, deinitialisiert ADBSetInfoBlock fr MacInterface }
		var
			error: OSErr;
	begin
		gADBSetInfoBlock.siServiceRtPtr := nil;
		gADBSetInfoBlock.siDataAreaAddr := nil;
		Error := SetADBInfo(gADBSetInfoBlock, kADBDeviceInitial);
		if gADBServCode <> nil then
			begin
				HUnLock(gADBServCode);
				ReleaseResource(gADBServCode);
			end;
	end;
end.